/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.lib.macro.declaration.MutableAnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableEnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableInterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.services.TypeLookup;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.lib.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeLookupImpl
implements TypeLookup {
    @Extension
    private CompilationUnitImpl compilationUnit;

    public TypeLookupImpl(CompilationUnitImpl compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public MutableAnnotationTypeDeclaration findAnnotationType(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableAnnotationTypeDeclaration _switchResult = null;
        boolean _matched = false;
        if (!_matched && type instanceof MutableAnnotationTypeDeclaration) {
            _matched = true;
            _switchResult = (MutableAnnotationTypeDeclaration)type;
        }
        return _switchResult;
    }

    public MutableClassDeclaration findClass(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableClassDeclaration _switchResult = null;
        boolean _matched = false;
        if (!_matched && type instanceof MutableClassDeclaration) {
            _matched = true;
            _switchResult = (MutableClassDeclaration)type;
        }
        return _switchResult;
    }

    public MutableEnumerationTypeDeclaration findEnumerationType(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableEnumerationTypeDeclaration _switchResult = null;
        boolean _matched = false;
        if (!_matched && type instanceof MutableEnumerationTypeDeclaration) {
            _matched = true;
            _switchResult = (MutableEnumerationTypeDeclaration)type;
        }
        return _switchResult;
    }

    public MutableInterfaceDeclaration findInterface(String qualifiedName) {
        Type type = this.findType(qualifiedName);
        MutableInterfaceDeclaration _switchResult = null;
        boolean _matched = false;
        if (!_matched && type instanceof MutableInterfaceDeclaration) {
            _matched = true;
            _switchResult = (MutableInterfaceDeclaration)type;
        }
        return _switchResult;
    }

    private Type findType(String qualifiedName) {
        boolean _notEquals;
        XtendFile _xtendFile = this.compilationUnit.getXtendFile();
        Resource _eResource = _xtendFile.eResource();
        EList _contents = _eResource.getContents();
        Iterable _filter = Iterables.filter((Iterable)_contents, JvmDeclaredType.class);
        JvmDeclaredType result = this.recursiveFindType(qualifiedName, _filter);
        Type _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)result, null);
        if (_notEquals) {
            _xifexpression = this.compilationUnit.toType((JvmType)result);
        }
        return _xifexpression;
    }

    private JvmDeclaredType recursiveFindType(String qualifiedName, Iterable<? extends JvmDeclaredType> typeDeclarations) {
        int dot = 46;
        for (JvmDeclaredType jvmDeclaredType : typeDeclarations) {
            int _length;
            char _charAt;
            boolean _equals_1;
            String name = jvmDeclaredType.getQualifiedName('.');
            boolean _equals = Objects.equal((Object)qualifiedName, (Object)name);
            if (_equals) {
                return jvmDeclaredType;
            }
            boolean _and = false;
            boolean _startsWith = qualifiedName.startsWith(name);
            _and = !_startsWith ? false : (_equals_1 = (_charAt = qualifiedName.charAt(_length = name.length())) == '.');
            if (!_and) continue;
            EList _members = jvmDeclaredType.getMembers();
            Iterable _filter = Iterables.filter((Iterable)_members, JvmDeclaredType.class);
            return this.recursiveFindType(qualifiedName, _filter);
        }
        return null;
    }

    public Type findTypeGlobally(Class<?> clazz) {
        String _canonicalName = clazz.getCanonicalName();
        return this.findTypeGlobally(_canonicalName);
    }

    public Type findTypeGlobally(String typeName) {
        Type _elvis = null;
        Type _findType = this.findType(typeName);
        if (_findType != null) {
            _elvis = _findType;
        } else {
            Type _xblockexpression = null;
            TypeReferences _typeReferences = this.compilationUnit.getTypeReferences();
            XtendFile _xtendFile = this.compilationUnit.getXtendFile();
            JvmType result = _typeReferences.findDeclaredType(typeName, (Notifier)_xtendFile);
            Type _xifexpression = null;
            boolean _equals = Objects.equal((Object)result, null);
            _xifexpression = _equals ? null : this.compilationUnit.toType(result);
            _elvis = _xblockexpression = _xifexpression;
        }
        return _elvis;
    }
}

