/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.scoping.AbstractKnownTypesScope;
import org.eclipse.xtend.core.scoping.AbstractScope;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedTypesScope
extends AbstractKnownTypesScope {
    private JvmDeclaredType innermost;

    public NestedTypesScope(JvmDeclaredType innermost, AbstractScope parent) {
        super(parent);
        this.innermost = innermost;
    }

    @Override
    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        IEObjectDescription result = this.doGetSingleElement(name);
        if (result != null) {
            return Collections.singletonList(result);
        }
        return super.getElements(name);
    }

    @Override
    protected void doGetElements(JvmType type, List<IEObjectDescription> result) {
        if (type instanceof JvmDeclaredType) {
            JvmDeclaredType declarator = this.innermost;
            while (declarator != null) {
                if (declarator != type && EcoreUtil.isAncestor((EObject)declarator, (EObject)type)) {
                    this.doGetDescriptions(type, (JvmType)declarator, 0, result);
                }
                declarator = (JvmDeclaredType)EcoreUtil2.getContainerOfType((EObject)declarator.eContainer(), JvmDeclaredType.class);
            }
        }
        super.doGetElements(type, result);
    }

    @Override
    protected void doGetDescriptions(JvmType type, JvmType declarator, int index, List<IEObjectDescription> result) {
        String typeName = type.getQualifiedName('.');
        String declaratorName = declarator.getQualifiedName('.');
        int declaratorLength = declaratorName.length();
        String subName = typeName.substring(declaratorLength + 1);
        List segments = Strings.split((String)subName, (char)'.');
        result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((List)segments), (EObject)type));
        result.add(EObjectDescription.create((String)subName.replace('.', '$'), (EObject)type));
    }

    @Override
    protected IEObjectDescription doGetSingleElement(QualifiedName name, String firstSegment, int dollarIndex) {
        QualifiedName splitted;
        IEObjectDescription result;
        JvmDeclaredType declarator = this.innermost;
        while (declarator != null) {
            Iterable nestedTypes = declarator.findAllNestedTypesByName(firstSegment);
            for (JvmDeclaredType nested : nestedTypes) {
                JvmType nestedType = this.findNestedType((JvmType)nested, 0, name);
                if (nestedType == null) continue;
                return this.toDescription(name, nestedType, dollarIndex, 0);
            }
            declarator = (JvmDeclaredType)EcoreUtil2.getContainerOfType((EObject)declarator.eContainer(), JvmDeclaredType.class);
        }
        if (dollarIndex > 0 && name.getSegmentCount() == 1 && (result = this.doGetSingleElement(splitted = QualifiedName.create((List)Strings.split((String)name.getFirstSegment(), (char)'$')))) != null) {
            return new AliasedEObjectDescription(name, result);
        }
        return null;
    }
}

