/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.typesystem;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.jvmmodel.AnonymousClassUtil;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.typesystem.DispatchOperationBodyComputationState;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.CreateExtensionInfo;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.InferredTypeIndicator;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.internal.LogicalContainerAwareReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractReentrantTypeReferenceProvider;
import org.eclipse.xtext.xbase.typing.IJvmTypeReferenceProvider;
import org.eclipse.xtext.xtype.XComputedTypeReference;
import org.eclipse.xtext.xtype.impl.XComputedTypeReferenceImplCustom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendReentrantTypeResolver
extends LogicalContainerAwareReentrantTypeResolver {
    @Inject
    private DispatchHelper dispatchHelper;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private IJvmModelAssociator associator;
    @Inject
    private AnonymousClassUtil anonymousClassUtil;
    @Inject
    private JvmTypesBuilder typesBuilder;

    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession session) {
        EObject root = this.getRoot();
        if (root instanceof XtendTypeDeclaration) {
            this.computeTypes(resolvedTypes, session, root);
        } else {
            super.computeTypes(resolvedTypes, session);
        }
    }

    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, EObject element) {
        if (element instanceof XtendTypeDeclaration) {
            XtendTypeDeclaration typeDeclaration = (XtendTypeDeclaration)element;
            this.computeXtendAnnotationTypes(resolvedTypes, featureScopeSession, (List<XAnnotation>)((XtendTypeDeclaration)element).getAnnotations());
            for (XtendMember member : typeDeclaration.getMembers()) {
                this.computeTypes(resolvedTypes, featureScopeSession, member);
            }
        } else if (element instanceof XtendMember) {
            XtendMember member = (XtendMember)element;
            XExpression expression = null;
            if (member instanceof XtendFunction) {
                XtendFunction function = (XtendFunction)member;
                expression = function.getExpression();
                CreateExtensionInfo createInfo = function.getCreateExtensionInfo();
                if (createInfo != null) {
                    IFeatureScopeSession session = function.isStatic() ? featureScopeSession : featureScopeSession.toInstanceContext();
                    this.computeTypes(resolvedTypes, session, (EObject)createInfo.getCreateExpression());
                }
                for (XtendParameter parameter : function.getParameters()) {
                    this.computeXtendAnnotationTypes(resolvedTypes, featureScopeSession, (List<XAnnotation>)parameter.getAnnotations());
                }
            } else if (member instanceof XtendConstructor) {
                XtendConstructor constructor = (XtendConstructor)member;
                expression = constructor.getExpression();
                for (XtendParameter parameter : constructor.getParameters()) {
                    this.computeXtendAnnotationTypes(resolvedTypes, featureScopeSession, (List<XAnnotation>)parameter.getAnnotations());
                }
            } else if (member instanceof XtendField) {
                expression = ((XtendField)member).getInitialValue();
            }
            if (expression != null) {
                if (this.getInferredElements(member).isEmpty()) {
                    this.computeTypes(resolvedTypes, featureScopeSession, (EObject)expression);
                } else {
                    TreeIterator iterator = EcoreUtil2.getAllNonDerivedContents((EObject)expression);
                    while (iterator.hasNext()) {
                        EObject next = (EObject)iterator.next();
                        if (!(next instanceof AnonymousClass)) continue;
                        this.computeTypes(resolvedTypes, featureScopeSession, next);
                        iterator.prune();
                    }
                }
            }
            this.computeXtendAnnotationTypes(resolvedTypes, featureScopeSession, (List<XAnnotation>)member.getAnnotations());
        } else {
            super.computeTypes(resolvedTypes, featureScopeSession, element);
        }
    }

    protected boolean isHandled(XExpression expression) {
        if (this.getRoot() instanceof XtendTypeDeclaration) {
            XtendMember member = (XtendMember)EcoreUtil2.getContainerOfType((EObject)expression, XtendMember.class);
            if (member != null) {
                if (this.getInferredElements(member).isEmpty()) {
                    boolean result = EcoreUtil.isAncestor((EObject)this.getRoot(), (EObject)expression);
                    return result;
                }
                XAnnotation annotation = this.getOutermostAnnotation(expression);
                return annotation != null && this.getInferredElements((EObject)annotation).isEmpty();
            }
        } else {
            XtendMember member;
            XAnnotation annotation = this.getOutermostAnnotation(expression);
            if (annotation != null ? this.getInferredElements((EObject)annotation).isEmpty() : ((member = (XtendMember)EcoreUtil2.getContainerOfType((EObject)expression, XtendMember.class)) instanceof XtendField || member instanceof XtendFunction) && this.getInferredElements(member).isEmpty()) {
                return false;
            }
        }
        return super.isHandled(expression);
    }

    protected XAnnotation getOutermostAnnotation(XExpression expression) {
        XAnnotation annotation = (XAnnotation)EcoreUtil2.getContainerOfType((EObject)expression, XAnnotation.class);
        while (annotation != null) {
            XAnnotation parent = (XAnnotation)EcoreUtil2.getContainerOfType((EObject)annotation.eContainer(), XAnnotation.class);
            if (parent == null) break;
            annotation = parent;
        }
        return annotation;
    }

    protected boolean isHandled(JvmIdentifiableElement identifiableElement) {
        XtendMember member;
        if (this.getRoot() instanceof XtendTypeDeclaration) {
            boolean result = EcoreUtil.isAncestor((EObject)this.getRoot(), (EObject)identifiableElement);
            return result;
        }
        if (identifiableElement instanceof JvmFormalParameter && (identifiableElement.eContainingFeature() == XbasePackage.Literals.XCLOSURE__IMPLICIT_PARAMETER || identifiableElement.eContainingFeature() == XbasePackage.Literals.XCLOSURE__DECLARED_FORMAL_PARAMETERS) && (member = (XtendMember)EcoreUtil2.getContainerOfType((EObject)identifiableElement, XtendMember.class)) != null && this.getInferredElements(member).isEmpty()) {
            return false;
        }
        return super.isHandled(identifiableElement);
    }

    protected boolean isAnnotationHolder(XtendMember member) {
        return member.eClass() == XtendPackage.Literals.XTEND_MEMBER || member.eClass() == XtendPackage.Literals.XTEND_TYPE_DECLARATION;
    }

    protected void _computeTypes(Map<JvmIdentifiableElement, ResolvedTypes> preparedResolvedTypes, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmOperation operation) {
        ResolvedTypes childResolvedTypes = preparedResolvedTypes.get(operation);
        if (childResolvedTypes == null) {
            if (preparedResolvedTypes.containsKey(operation)) {
                return;
            }
            throw new IllegalStateException("No resolved type found. Type was: " + operation.getIdentifier());
        }
        if (this.dispatchHelper.isDispatcherFunction(operation)) {
            preparedResolvedTypes.put((JvmIdentifiableElement)operation, null);
            this.computeAnnotationTypes(childResolvedTypes, featureScopeSession, (JvmExecutable)operation);
            this.mergeChildTypes(childResolvedTypes);
        } else if (this.dispatchHelper.isDispatchFunction(operation) && InferredTypeIndicator.isInferred((JvmTypeReference)operation.getReturnType())) {
            LightweightTypeReference commonDispatchType;
            JvmOperation dispatcher = this.dispatchHelper.getDispatcherOperation(operation);
            if (dispatcher == null) {
                super._computeTypes(preparedResolvedTypes, resolvedTypes, featureScopeSession, operation);
                return;
            }
            LightweightTypeReference declaredDispatcherType = this.getReturnTypeOfOverriddenOperation(dispatcher, childResolvedTypes, featureScopeSession);
            List<JvmOperation> dispatchCases = this.dispatchHelper.getLocalDispatchCases(dispatcher);
            ArrayList dispatchCaseResults = Lists.newArrayListWithCapacity((int)dispatchCases.size());
            boolean hasInferredCase = false;
            LightweightTypeReference implicitVoid = null;
            LightweightTypeReference thrownVoid = null;
            for (JvmOperation dispatchCase : dispatchCases) {
                this.markComputing(dispatchCase.getReturnType());
            }
            for (JvmOperation dispatchCase : dispatchCases) {
                ResolvedTypes dispatchCaseResolvedTypes;
                ResolvedTypes resolvedTypes2 = dispatchCaseResolvedTypes = dispatchCase == operation ? childResolvedTypes : preparedResolvedTypes.get(dispatchCase);
                if (dispatchCaseResolvedTypes == null) {
                    if (preparedResolvedTypes.containsKey(dispatchCase)) {
                        if (InferredTypeIndicator.isInferred((JvmTypeReference)dispatchCase.getReturnType())) {
                            if (declaredDispatcherType == null) {
                                dispatchCaseResults.add(childResolvedTypes.getActualType((JvmIdentifiableElement)dispatchCase));
                            }
                            hasInferredCase = true;
                            continue;
                        }
                        dispatchCaseResults.add(childResolvedTypes.getActualType((JvmIdentifiableElement)dispatchCase));
                        continue;
                    }
                    throw new IllegalStateException("No resolved type found. Type was: " + dispatchCase.getIdentifier());
                }
                preparedResolvedTypes.put((JvmIdentifiableElement)dispatchCase, null);
                DispatchOperationBodyComputationState state = new DispatchOperationBodyComputationState(dispatchCaseResolvedTypes, dispatchCase.isStatic() ? featureScopeSession : featureScopeSession.toInstanceContext(), dispatchCase, dispatcher, declaredDispatcherType);
                this.addExtensionProviders((ITypeComputationState)state, (List)dispatchCase.getParameters());
                ITypeComputationResult dispatchCaseResult = state.computeTypes();
                this.unmarkComputing(dispatchCase.getReturnType());
                if (InferredTypeIndicator.isInferred((JvmTypeReference)dispatchCase.getReturnType())) {
                    LightweightTypeReference returnType;
                    if (declaredDispatcherType == null && (returnType = dispatchCaseResult.getReturnType()) != null) {
                        if (returnType.isPrimitiveVoid()) {
                            EnumSet conformanceHints = dispatchCaseResult.getConformanceHints();
                            if (!conformanceHints.contains(ConformanceHint.THROWN_EXCEPTION)) {
                                if (conformanceHints.contains(ConformanceHint.NO_IMPLICIT_RETURN)) {
                                    dispatchCaseResults.add(returnType);
                                } else {
                                    implicitVoid = returnType;
                                }
                            } else {
                                thrownVoid = returnType;
                            }
                        } else {
                            dispatchCaseResults.add(returnType);
                        }
                    }
                    hasInferredCase = true;
                } else {
                    LightweightTypeReference explicitType = dispatchCaseResolvedTypes.getActualType((JvmIdentifiableElement)dispatchCase);
                    dispatchCaseResults.add(explicitType);
                }
                this.computeAnnotationTypes(dispatchCaseResolvedTypes, featureScopeSession, (JvmExecutable)dispatchCase);
                this.computeLocalTypes(preparedResolvedTypes, dispatchCaseResolvedTypes, featureScopeSession, (JvmFeature)dispatchCase);
                this.mergeChildTypes(dispatchCaseResolvedTypes);
            }
            if (hasInferredCase && (commonDispatchType = this.normalizeDispatchReturnType(declaredDispatcherType, dispatchCaseResults, implicitVoid, thrownVoid, childResolvedTypes)) != null) {
                this.resolveDispatchCaseTypes(dispatchCases, commonDispatchType, featureScopeSession);
            }
        } else {
            super._computeTypes(preparedResolvedTypes, resolvedTypes, featureScopeSession, operation);
        }
    }

    protected void resolveDispatchCaseTypes(List<JvmOperation> dispatchCases, LightweightTypeReference type, IFeatureScopeSession featureScopeSession) {
        for (JvmOperation dispatchCase : dispatchCases) {
            JvmTypeReference returnType = dispatchCase.getReturnType();
            if (!InferredTypeIndicator.isInferred((JvmTypeReference)returnType)) continue;
            InferredTypeIndicator.resolveTo((JvmTypeReference)returnType, (JvmTypeReference)this.toJavaCompliantTypeReference(type, featureScopeSession));
        }
    }

    protected LightweightTypeReference normalizeDispatchReturnType(LightweightTypeReference declaredType, List<LightweightTypeReference> computedTypes, LightweightTypeReference implicitVoidOrNull, LightweightTypeReference thrownVoidOrNull, ResolvedTypes resolvedTypes) {
        LightweightTypeReference result = null;
        if (declaredType != null) {
            result = declaredType;
        } else {
            if (implicitVoidOrNull != null && !computedTypes.isEmpty()) {
                ArrayList wrapped = Lists.newArrayListWithCapacity((int)computedTypes.size());
                int i = 0;
                while (i < computedTypes.size()) {
                    wrapped.add(((LightweightTypeReference)computedTypes.get(i)).getWrapperTypeIfPrimitive());
                    ++i;
                }
                computedTypes = wrapped;
            }
            if (computedTypes.isEmpty() && implicitVoidOrNull != null) {
                result = implicitVoidOrNull;
            } else if (computedTypes.isEmpty()) {
                if (thrownVoidOrNull == null) {
                    throw new IllegalStateException("thrownVoidOrNull may not be null in this situation");
                }
                result = thrownVoidOrNull;
            } else {
                result = this.getServices().getTypeConformanceComputer().getCommonSuperType(computedTypes, resolvedTypes.getReferenceOwner());
            }
        }
        return result;
    }

    protected void computeXtendAnnotationTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, List<XAnnotation> annotations) {
        for (XAnnotation annotation : annotations) {
            if (!this.getInferredElements((EObject)annotation).isEmpty()) continue;
            this.computeTypes(resolvedTypes, featureScopeSession, (EObject)annotation);
        }
    }

    protected void _doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmField field, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext) {
        JvmTypeReference knownType = field.getType();
        if (InferredTypeIndicator.isInferred((JvmTypeReference)knownType)) {
            XtendFunction function;
            XComputedTypeReference castedKnownType = (XComputedTypeReference)knownType;
            EObject sourceElement = this.associations.getPrimarySourceElement((EObject)field);
            if (sourceElement instanceof XtendFunction && (function = (XtendFunction)sourceElement).getCreateExtensionInfo() != null) {
                JvmOperation operation = this.associations.getDirectlyInferredOperation(function);
                this.declareTypeParameters(resolvedTypes, (JvmIdentifiableElement)field, resolvedTypesByContext);
                XComputedTypeReference fieldType = this.getServices().getXtypeFactory().createXComputedTypeReference();
                fieldType.setTypeProvider((IJvmTypeReferenceProvider)new CreateCacheFieldTypeReferenceProvider(operation, resolvedTypes, featureScopeSession));
                castedKnownType.setEquivalent((JvmTypeReference)fieldType);
                return;
            }
        }
        super._doPrepare(resolvedTypes, featureScopeSession, field, resolvedTypesByContext);
        this.doPrepareLocalTypes(resolvedTypes, featureScopeSession, (JvmFeature)field, resolvedTypesByContext);
    }

    protected void _doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmConstructor constructor, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext) {
        super._doPrepare(resolvedTypes, featureScopeSession, constructor, resolvedTypesByContext);
        this.doPrepareLocalTypes(resolvedTypes, featureScopeSession, (JvmFeature)constructor, resolvedTypesByContext);
    }

    protected IFeatureScopeSession addThisTypeToStaticScope(IFeatureScopeSession session, JvmDeclaredType type) {
        return session.addTypesToStaticScope(Collections.singletonList(type), Collections.singletonList(type));
    }

    protected void _doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmOperation operation, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext) {
        JvmFormalParameter firstParameter;
        JvmTypeReference parameterType;
        XtendFunction function;
        EObject sourceElement;
        super._doPrepare(resolvedTypes, featureScopeSession, operation, resolvedTypesByContext);
        resolvedTypes = resolvedTypesByContext.get(operation);
        if (this.dispatchHelper.isDispatcherFunction(operation)) {
            EList parameters = operation.getParameters();
            int i = 0;
            while (i < parameters.size()) {
                JvmFormalParameter parameter = (JvmFormalParameter)parameters.get(i);
                JvmTypeReference parameterType2 = parameter.getParameterType();
                if (InferredTypeIndicator.isInferred((JvmTypeReference)parameterType2)) {
                    XComputedTypeReference casted = (XComputedTypeReference)parameterType2;
                    XComputedTypeReference computedParameterType = this.getServices().getXtypeFactory().createXComputedTypeReference();
                    computedParameterType.setTypeProvider((IJvmTypeReferenceProvider)new DispatchParameterTypeReferenceProvider(operation, i, resolvedTypes, featureScopeSession, this));
                    casted.setEquivalent((JvmTypeReference)computedParameterType);
                } else if (parameterType2 == null) {
                    XComputedTypeReference computedParameterType = this.getServices().getXtypeFactory().createXComputedTypeReference();
                    computedParameterType.setTypeProvider((IJvmTypeReferenceProvider)new DispatchParameterTypeReferenceProvider(operation, i, resolvedTypes, featureScopeSession, this));
                    parameter.setParameterType((JvmTypeReference)computedParameterType);
                }
                ++i;
            }
        } else if (operation.getParameters().size() >= 1 && (sourceElement = this.associations.getPrimarySourceElement((EObject)operation)) instanceof XtendFunction && (function = (XtendFunction)sourceElement).getCreateExtensionInfo() != null && InferredTypeIndicator.isInferred((JvmTypeReference)(parameterType = (firstParameter = (JvmFormalParameter)operation.getParameters().get(0)).getParameterType()))) {
            XComputedTypeReference casted = (XComputedTypeReference)parameterType;
            XComputedTypeReference computedParameterType = this.getServices().getXtypeFactory().createXComputedTypeReference();
            computedParameterType.setTypeProvider((IJvmTypeReferenceProvider)new InitializerParameterTypeReferenceProvider(function, resolvedTypesByContext, resolvedTypes, featureScopeSession, this));
            casted.setEquivalent((JvmTypeReference)computedParameterType);
        }
        this.doPrepareLocalTypes(resolvedTypes, featureScopeSession, (JvmFeature)operation, resolvedTypesByContext);
    }

    protected void doPrepareLocalTypes(final ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmFeature container, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext) {
        EList localClasses = container.getLocalClasses();
        for (final JvmGenericType localClass : localClasses) {
            XConstructorCall constructorCall;
            IScope typeScope;
            JvmTypeReference superType = (JvmTypeReference)localClass.getSuperTypes().get(0);
            final IFeatureScopeSession nestedSession = featureScopeSession;
            if (!InferredTypeIndicator.isInferred((JvmTypeReference)superType)) continue;
            final XComputedTypeReference casted = (XComputedTypeReference)superType;
            InferredTypeIndicator typeProvider = (InferredTypeIndicator)casted.getTypeProvider();
            final AnonymousClass anonymousClass = (AnonymousClass)typeProvider.getExpression();
            final JvmDeclaredType type = this.anonymousClassUtil.getSuperTypeNonResolving(anonymousClass, typeScope = featureScopeSession.getScope((EObject)(constructorCall = anonymousClass.getConstructorCall()), TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, (IResolvedTypes)resolvedTypes));
            if (type == null) break;
            final JvmParameterizedTypeReference superTypeReference = this.createSuperTypeReference((JvmType)type, constructorCall);
            this.requestCapturedLocalVariables((JvmTypeReference)superTypeReference, (JvmDeclaredType)localClass, resolvedTypes, resolvedTypesByContext, (IAcceptor)new IAcceptor<JvmTypeReference>(){

                public void accept(JvmTypeReference capturingTypeReference) {
                    casted.setEquivalent(capturingTypeReference);
                    IFeatureScopeSession mySession = XtendReentrantTypeResolver.this.addThisAndSuper(nestedSession, resolvedTypes.getReferenceOwner(), (JvmDeclaredType)localClass, (JvmTypeReference)superTypeReference, false);
                    if (type.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && ((JvmGenericType)type).isInterface()) {
                        XtendReentrantTypeResolver.this.inferAnonymousClassConstructor(anonymousClass, localClass, type);
                    } else {
                        for (JvmMember superMember : type.getMembers()) {
                            if (!(superMember instanceof JvmConstructor)) continue;
                            JvmConstructor superTypeConstructor = (JvmConstructor)superMember;
                            boolean visible = mySession.isVisible((JvmMember)superTypeConstructor);
                            XtendReentrantTypeResolver.this.inferAnonymousClassConstructor(anonymousClass, localClass, superTypeConstructor, visible);
                        }
                    }
                }
            });
        }
    }

    protected JvmParameterizedTypeReference createSuperTypeReference(JvmType superType, XConstructorCall constructorCall) {
        JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        result.setType(superType);
        for (JvmTypeReference typeReference : constructorCall.getTypeArguments()) {
            result.getArguments().add((Object)this.typesBuilder.cloneWithProxies(typeReference));
        }
        return result;
    }

    protected JvmConstructor inferAnonymousClassConstructor(AnonymousClass anonymousClass, JvmGenericType inferredLocalClass, JvmConstructor superConstructor, boolean visible) {
        JvmConstructor constructor = TypesFactory.eINSTANCE.createJvmConstructor();
        inferredLocalClass.getMembers().add((Object)constructor);
        this.associator.associatePrimary((EObject)anonymousClass.getConstructorCall(), (EObject)constructor);
        if (visible) {
            constructor.setVisibility(JvmVisibility.DEFAULT);
        } else {
            constructor.setVisibility(JvmVisibility.PRIVATE);
        }
        constructor.setSimpleName(inferredLocalClass.getSimpleName());
        EList parameters = superConstructor.getParameters();
        for (JvmFormalParameter parameter : parameters) {
            constructor.getParameters().add((Object)((JvmFormalParameter)this.typesBuilder.cloneWithProxies((JvmIdentifiableElement)parameter)));
        }
        for (JvmTypeReference exception : superConstructor.getExceptions()) {
            constructor.getExceptions().add((Object)this.typesBuilder.cloneWithProxies(exception));
        }
        if (!parameters.isEmpty()) {
            this.typesBuilder.setBody((JvmExecutable)constructor, (Procedures.Procedure1)new Procedures.Procedure1<ITreeAppendable>((List)parameters){
                private final /* synthetic */ List val$parameters;
                {
                    this.val$parameters = list;
                }

                public void apply(ITreeAppendable a) {
                    a.append((CharSequence)"super(");
                    int i = 0;
                    while (i < this.val$parameters.size()) {
                        if (i != 0) {
                            a.append((CharSequence)", ");
                        }
                        a.append((CharSequence)((JvmFormalParameter)this.val$parameters.get(i)).getSimpleName());
                        ++i;
                    }
                    a.append((CharSequence)");");
                }
            });
        }
        return constructor;
    }

    protected JvmConstructor inferAnonymousClassConstructor(AnonymousClass anonymousClass, JvmGenericType inferredLocalClass, JvmDeclaredType superInterface) {
        XConstructorCall constructorCall = anonymousClass.getConstructorCall();
        JvmConstructor constructor = TypesFactory.eINSTANCE.createJvmConstructor();
        inferredLocalClass.getMembers().add((Object)constructor);
        this.associator.associatePrimary((EObject)constructorCall, (EObject)constructor);
        constructor.setVisibility(JvmVisibility.DEFAULT);
        constructor.setSimpleName(inferredLocalClass.getSimpleName());
        return constructor;
    }

    protected AbstractReentrantTypeReferenceProvider createTypeProvider(Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmMember member, boolean returnType) {
        JvmOperation operation;
        if (member instanceof JvmOperation && this.dispatchHelper.isDispatcherFunction(operation = (JvmOperation)member)) {
            return new DispatchReturnTypeReferenceProvider(operation, resolvedTypes, featureScopeSession, this);
        }
        return super.createTypeProvider(resolvedTypesByContext, resolvedTypes, featureScopeSession, member, returnType);
    }

    protected String getInvalidWritableVariableAccessMessage(XVariableDeclaration variable, XAbstractFeatureCall featureCall) {
        EObject containingStructure = this.getNearestClosureOrTypeDeclaration((EObject)featureCall);
        if (containingStructure != null && !EcoreUtil.isAncestor((EObject)containingStructure, (EObject)variable)) {
            if (containingStructure instanceof XClosure) {
                return String.format("Cannot refer to the non-final variable %s inside a lambda expression", variable.getSimpleName());
            }
            return String.format("Cannot refer to the non-final variable %s inside a local class", variable.getSimpleName());
        }
        return null;
    }

    private EObject getNearestClosureOrTypeDeclaration(EObject object) {
        while (object != null) {
            if (object instanceof XClosure) {
                return object;
            }
            if (object instanceof XtendTypeDeclaration) {
                return object;
            }
            object = object.eContainer();
        }
        return null;
    }

    public class CreateCacheFieldTypeReferenceProvider
    extends AbstractReentrantTypeReferenceProvider {
        private final JvmOperation createOperation;
        private final ResolvedTypes resolvedTypes;
        private final IFeatureScopeSession session;

        public CreateCacheFieldTypeReferenceProvider(JvmOperation createOperation, ResolvedTypes resolvedTypes, IFeatureScopeSession session) {
            this.createOperation = createOperation;
            this.resolvedTypes = resolvedTypes;
            this.session = session;
        }

        protected JvmTypeReference doGetTypeReference(XComputedTypeReferenceImplCustom context) {
            JvmTypeReference declaredReturnType = this.createOperation.getReturnType();
            TypeReferences typeReferences = this.resolvedTypes.getServices().getTypeReferences();
            ITypeReferenceOwner owner = this.resolvedTypes.getReferenceOwner();
            JvmType arrayList = typeReferences.findDeclaredType(ArrayList.class, (Notifier)this.createOperation);
            ParameterizedTypeReference arrayListReference = new ParameterizedTypeReference(owner, arrayList);
            JvmType objectType = typeReferences.findDeclaredType(Object.class, (Notifier)this.createOperation);
            WildcardTypeReference wildcard = new WildcardTypeReference(owner);
            wildcard.addUpperBound((LightweightTypeReference)new ParameterizedTypeReference(owner, objectType));
            arrayListReference.addTypeArgument((LightweightTypeReference)wildcard);
            JvmType hashMap = typeReferences.findDeclaredType(HashMap.class, (Notifier)this.createOperation);
            ParameterizedTypeReference hashMapReference = new ParameterizedTypeReference(owner, hashMap);
            hashMapReference.addTypeArgument((LightweightTypeReference)arrayListReference);
            hashMapReference.addTypeArgument(new OwnedConverter(owner).toLightweightReference(declaredReturnType));
            return XtendReentrantTypeResolver.this.toJavaCompliantTypeReference((LightweightTypeReference)hashMapReference, this.session);
        }
    }

    public static class DispatchParameterTypeReferenceProvider
    extends AbstractReentrantTypeReferenceProvider {
        private final JvmOperation operation;
        private final ResolvedTypes resolvedTypes;
        private final int idx;
        private final IFeatureScopeSession session;
        private final XtendReentrantTypeResolver typeResolver;

        public DispatchParameterTypeReferenceProvider(JvmOperation operation, int idx, ResolvedTypes resolvedTypes, IFeatureScopeSession session, XtendReentrantTypeResolver typeResolver) {
            this.idx = idx;
            this.operation = operation;
            this.resolvedTypes = resolvedTypes;
            this.session = session;
            this.typeResolver = typeResolver;
        }

        protected JvmTypeReference doGetTypeReference(XComputedTypeReferenceImplCustom context) {
            try {
                List<JvmOperation> cases = this.typeResolver.dispatchHelper.getAllDispatchCases(this.operation);
                TypeConformanceComputer conformanceComputer = this.typeResolver.getServices().getTypeConformanceComputer();
                ArrayList parameterTypes = Lists.newArrayListWithCapacity((int)cases.size());
                JvmOperation inheritedDispatcher = null;
                LightweightTypeReference inheritedParameterType = null;
                for (JvmOperation caseOperation : cases) {
                    if (caseOperation.eContainer() == this.operation.eContainer() || (inheritedDispatcher = this.typeResolver.dispatchHelper.getDispatcherOperation(caseOperation)) == null) continue;
                    JvmFormalParameter inheritedParameter = (JvmFormalParameter)inheritedDispatcher.getParameters().get(this.idx);
                    inheritedParameterType = this.resolvedTypes.getActualType((JvmIdentifiableElement)inheritedParameter);
                    break;
                }
                for (JvmOperation caseOperation : cases) {
                    JvmFormalParameter parameter = (JvmFormalParameter)caseOperation.getParameters().get(this.idx);
                    LightweightTypeReference parameterType = this.resolvedTypes.getActualType((JvmIdentifiableElement)parameter);
                    if (parameterType == null || parameterType.isType(Void.class)) continue;
                    if (inheritedParameterType != null) {
                        if (caseOperation.eContainer() != this.operation.eContainer() || inheritedParameterType.isAssignableFrom(parameterType)) continue;
                        XtendParameter xtendParameter = (XtendParameter)this.typeResolver.getSourceElement((EObject)parameter);
                        this.resolvedTypes.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "dispatch_functions_may_not_widen_inherited_signature", "Dispatch function cannot widen inherited parameter type " + inheritedParameterType.getHumanReadableName(), (EObject)xtendParameter.getParameterType(), null, -1, null));
                        continue;
                    }
                    parameterTypes.add(parameterType);
                }
                if (parameterTypes.isEmpty()) {
                    if (inheritedParameterType != null) {
                        JvmTypeReference jvmTypeReference = this.typeResolver.toJavaCompliantTypeReference(inheritedParameterType, this.session);
                        return jvmTypeReference;
                    }
                    JvmTypeReference jvmTypeReference = this.typeResolver.getServices().getTypeReferences().getTypeForName(Object.class, (Notifier)this.operation, new JvmTypeReference[0]);
                    return jvmTypeReference;
                }
                LightweightTypeReference parameterType = conformanceComputer.getCommonSuperType((List)parameterTypes, this.resolvedTypes.getReferenceOwner());
                if (parameterType == null) {
                    throw new IllegalStateException("TODO: handle broken models properly");
                }
                JvmTypeReference jvmTypeReference = this.typeResolver.toJavaCompliantTypeReference(parameterType, this.session);
                return jvmTypeReference;
            }
            finally {
                context.setTypeProvider(null);
            }
        }
    }

    public static class DispatchReturnTypeReferenceProvider
    extends AbstractReentrantTypeReferenceProvider {
        private final JvmOperation operation;
        private final ResolvedTypes resolvedTypes;
        private final IFeatureScopeSession session;
        private final XtendReentrantTypeResolver typeResolver;

        public DispatchReturnTypeReferenceProvider(JvmOperation operation, ResolvedTypes resolvedTypes, IFeatureScopeSession session, XtendReentrantTypeResolver typeResolver) {
            this.operation = operation;
            this.resolvedTypes = resolvedTypes;
            this.session = session;
            this.typeResolver = typeResolver;
        }

        protected JvmTypeReference doGetTypeReference(XComputedTypeReferenceImplCustom context) {
            try {
                LightweightTypeReference expectedType = this.typeResolver.getReturnTypeOfOverriddenOperation(this.operation, this.resolvedTypes, this.session);
                if (expectedType != null) {
                    JvmTypeReference jvmTypeReference = this.typeResolver.toJavaCompliantTypeReference(expectedType, this.session);
                    return jvmTypeReference;
                }
                List<JvmOperation> cases = this.typeResolver.dispatchHelper.getAllDispatchCases(this.operation);
                ArrayList types = Lists.newArrayListWithCapacity((int)cases.size());
                for (JvmOperation operation : cases) {
                    LightweightTypeReference caseType = this.resolvedTypes.getActualType((JvmIdentifiableElement)operation);
                    types.add(caseType);
                }
                TypeConformanceComputer conformanceComputer = this.typeResolver.getServices().getTypeConformanceComputer();
                if (types.isEmpty()) {
                    return null;
                }
                LightweightTypeReference result = conformanceComputer.getCommonSuperType((List)types, this.resolvedTypes.getReferenceOwner());
                if (result == null) {
                    Iterator iterator = types.iterator();
                    while (iterator.hasNext()) {
                        if (!((LightweightTypeReference)iterator.next()).isPrimitiveVoid()) continue;
                        iterator.remove();
                    }
                    result = conformanceComputer.getCommonSuperType((List)types, this.resolvedTypes.getReferenceOwner());
                    if (result == null) {
                        throw new UnsupportedOperationException("Cannot determine common super type of: " + types);
                    }
                }
                JvmTypeReference jvmTypeReference = this.typeResolver.toJavaCompliantTypeReference(result, this.session);
                return jvmTypeReference;
            }
            finally {
                context.setTypeProvider(null);
            }
        }

        protected JvmTypeReference handleReentrantInvocation(XComputedTypeReferenceImplCustom context) {
            this.resolvedTypes.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.WARNING, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", "Cannot infer type from recursive usage. Type 'Object' is used.", this.typeResolver.getSourceElement((EObject)this.operation), null, -1, null));
            AnyTypeReference result = new AnyTypeReference(this.resolvedTypes.getReferenceOwner());
            return this.typeResolver.toJavaCompliantTypeReference((LightweightTypeReference)result, this.session);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InitializerParameterTypeReferenceProvider
    extends AbstractReentrantTypeReferenceProvider {
        private final ResolvedTypes resolvedTypes;
        private final XtendFunction createFunction;
        private final IFeatureScopeSession featureScopeSession;
        private final Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext;
        private final XtendReentrantTypeResolver typeResolver;

        public InitializerParameterTypeReferenceProvider(XtendFunction createFunction, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, XtendReentrantTypeResolver typeResolver) {
            this.createFunction = createFunction;
            this.resolvedTypesByContext = resolvedTypesByContext;
            this.resolvedTypes = resolvedTypes;
            this.featureScopeSession = featureScopeSession;
            this.typeResolver = typeResolver;
        }

        protected JvmTypeReference doGetTypeReference(XComputedTypeReferenceImplCustom context) {
            try {
                CreateExtensionInfo createExtensionInfo = this.createFunction.getCreateExtensionInfo();
                XExpression expression = createExtensionInfo.getCreateExpression();
                LightweightTypeReference actualType = this.resolvedTypes.getReturnType(expression);
                if (actualType == null) {
                    JvmOperation operation = this.typeResolver.associations.getDirectlyInferredOperation(this.createFunction);
                    IFeatureScopeSession session = operation.isStatic() ? this.featureScopeSession : this.featureScopeSession.toInstanceContext();
                    this.typeResolver.computeTypes(this.resolvedTypesByContext, this.resolvedTypes, session, (EObject)operation);
                    actualType = this.resolvedTypes.getReturnType(expression);
                }
                if (actualType == null) {
                    return null;
                }
                JvmTypeReference jvmTypeReference = this.typeResolver.toJavaCompliantTypeReference(actualType, this.featureScopeSession);
                return jvmTypeReference;
            }
            finally {
                context.setTypeProvider(null);
            }
        }
    }
}

