/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.impl.Messages;
import org.eclipse.xtext.builder.internal.Activator;
import org.eclipse.xtext.resource.IResourceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class RegistryBuilderParticipant
implements IXtextBuilderParticipant {
    private static final String PARTICIPANT = "participant";
    private static final String EXTENSION_POINT_ID = "participant";
    private static final String ATT_CLASS = "class";
    private static final String ATT_FILE_EXTENSIONS = "fileExtensions";
    private static final Splitter FILE_EXTENSION_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static final Logger readerLog = Logger.getLogger(BuilderParticipantReader.class);
    @Inject
    private IExtensionRegistry extensionRegistry;
    private volatile ImmutableList<IXtextBuilderParticipant> participants;
    private Map<String, IXtextBuilderParticipant> classToParticipant;

    @Override
    public void build(IXtextBuilderParticipant.IBuildContext buildContext, IProgressMonitor monitor) throws CoreException {
        ImmutableList<IXtextBuilderParticipant> participants = this.getParticipants();
        if (participants.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)participants.size());
        progress.subTask(Messages.RegistryBuilderParticipant_InvokingBuildParticipants);
        for (IXtextBuilderParticipant participant : participants) {
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            participant.build(buildContext, (IProgressMonitor)progress.newChild(1));
        }
    }

    public ImmutableList<IXtextBuilderParticipant> getParticipants() {
        ImmutableList<IXtextBuilderParticipant> result = this.participants;
        if (this.participants == null) {
            result = this.initParticipants();
        }
        return result;
    }

    protected synchronized ImmutableList<IXtextBuilderParticipant> initParticipants() {
        ImmutableList result = this.participants;
        if (result == null) {
            if (this.classToParticipant == null) {
                this.classToParticipant = Maps.newHashMap();
                Activator activator = Activator.getDefault();
                if (activator != null) {
                    String pluginID = activator.getBundle().getSymbolicName();
                    String extensionPointID = "participant";
                    BuilderParticipantReader reader = new BuilderParticipantReader(this.extensionRegistry, pluginID, extensionPointID);
                    reader.readRegistry();
                }
            }
            this.participants = result = ImmutableList.copyOf(this.classToParticipant.values());
        }
        return result;
    }

    public class BuilderParticipantReader
    extends RegistryReader {
        public BuilderParticipantReader(IExtensionRegistry pluginRegistry, String pluginID, String extensionPointID) {
            super(pluginRegistry, pluginID, extensionPointID);
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            if (element.getName().equals("participant")) {
                String className = element.getAttribute(RegistryBuilderParticipant.ATT_CLASS);
                if (className == null) {
                    this.logMissingAttribute(element, RegistryBuilderParticipant.ATT_CLASS);
                } else {
                    if (add) {
                        DeferredBuilderParticipant participant = new DeferredBuilderParticipant(element);
                        if (RegistryBuilderParticipant.this.classToParticipant.containsKey(className)) {
                            readerLog.warn((Object)("The builder participant '" + className + "' was registered twice."));
                        }
                        RegistryBuilderParticipant.this.classToParticipant.put(className, participant);
                        RegistryBuilderParticipant.this.participants = null;
                        return true;
                    }
                    RegistryBuilderParticipant.this.classToParticipant.remove(className);
                    RegistryBuilderParticipant.this.participants = null;
                    return true;
                }
            }
            return false;
        }

        protected void logError(IConfigurationElement element, String text) {
            IExtension extension = element.getDeclaringExtension();
            readerLog.error((Object)("Plugin " + extension.getContributor().getName() + ", extension " + extension.getExtensionPointUniqueIdentifier()));
            readerLog.error((Object)text);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class DeferredBuilderParticipant
        implements IXtextBuilderParticipant {
            private IConfigurationElement element;
            private IXtextBuilderParticipant delegate;
            private ImmutableList<String> handledFileExtensions;

            public DeferredBuilderParticipant(IConfigurationElement element) {
                this.element = element;
            }

            @Override
            public void build(IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
                this.getDelegate(context).build(context, monitor);
            }

            private IXtextBuilderParticipant getDelegate(IXtextBuilderParticipant.IBuildContext context) {
                if (!this.interestedIn(context)) {
                    return new NoOpBuilderParticipant();
                }
                if (this.delegate == null) {
                    this.initDelegate();
                }
                return this.delegate;
            }

            private synchronized void initDelegate() {
                if (this.delegate != null) {
                    return;
                }
                try {
                    Object participant = this.element.createExecutableExtension(RegistryBuilderParticipant.ATT_CLASS);
                    if (participant instanceof IXtextBuilderParticipant) {
                        this.delegate = (IXtextBuilderParticipant)participant;
                    } else {
                        BuilderParticipantReader.this.logError(this.element, String.valueOf(this.element.getAttribute(RegistryBuilderParticipant.ATT_CLASS)) + " did not yield an instance of IXtextBuilderParticipant but " + participant.getClass().getName());
                    }
                }
                catch (CoreException e) {
                    BuilderParticipantReader.this.logError(this.element, e.getMessage());
                }
                catch (NoClassDefFoundError e) {
                    BuilderParticipantReader.this.logError(this.element, e.getMessage());
                }
                if (this.delegate == null) {
                    this.delegate = new NoOpBuilderParticipant();
                }
            }

            private boolean interestedIn(IXtextBuilderParticipant.IBuildContext context) {
                if (this.getHandledFileExtensions().isEmpty()) {
                    return true;
                }
                for (IResourceDescription.Delta change : context.getDeltas()) {
                    String fileExtension = change.getUri().fileExtension();
                    if (!this.getHandledFileExtensions().contains(fileExtension)) continue;
                    return true;
                }
                return false;
            }

            private List<String> getHandledFileExtensions() {
                if (this.handledFileExtensions == null) {
                    this.initHandledFileExtensions();
                }
                return this.handledFileExtensions;
            }

            private synchronized void initHandledFileExtensions() {
                if (this.handledFileExtensions != null) {
                    return;
                }
                String fileExtensionsAtt = Strings.nullToEmpty((String)this.element.getAttribute(RegistryBuilderParticipant.ATT_FILE_EXTENSIONS));
                this.handledFileExtensions = ImmutableList.copyOf((Iterable)FILE_EXTENSION_SPLITTER.split((CharSequence)fileExtensionsAtt));
            }
        }
    }

    private static class NoOpBuilderParticipant
    implements IXtextBuilderParticipant {
        private NoOpBuilderParticipant() {
        }

        public void build(IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        }
    }
}

