/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.shared.jdt38;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IEditorAssociationOverride;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.xtext.builder.trace.ITraceForTypeRootProvider;
import org.eclipse.xtext.common.types.shared.jdt38.DebugPluginListener;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.XtextEditorInfo;
import org.eclipse.xtext.xbase.ui.editor.StacktraceBasedEditorDecider;

public class OriginalEditorSelector
implements IEditorAssociationOverride {
    private static final Logger logger = Logger.getLogger(OriginalEditorSelector.class);
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private ITraceForStorageProvider traceInformation;
    @Inject
    private IWorkbench workbench;
    @Inject
    private StacktraceBasedEditorDecider decisions;
    @Inject
    private DebugPluginListener debugPluginListener;
    @Inject
    private ITraceForTypeRootProvider traceForTypeRootProvider;

    public IEditorDescriptor[] overrideEditors(IEditorInput editorInput, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        IEditorDescriptor xbaseEditor = this.findXbaseEditor(editorInput, true);
        if (xbaseEditor != null) {
            List result = Lists.asList((Object)xbaseEditor, (Object[])editorDescriptors);
            return result.toArray(new IEditorDescriptor[result.size()]);
        }
        return editorDescriptors;
    }

    public IEditorDescriptor[] overrideEditors(String fileName, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        IEditorDescriptor xbaseEditor = this.findXbaseEditor(fileName, true);
        if (xbaseEditor != null) {
            List result = Lists.asList((Object)xbaseEditor, (Object[])editorDescriptors);
            return result.toArray(new IEditorDescriptor[result.size()]);
        }
        return editorDescriptors;
    }

    public IEditorDescriptor overrideDefaultEditor(IEditorInput editorInput, IContentType contentType, IEditorDescriptor editorDescriptor) {
        IEditorDescriptor result = this.findXbaseEditor(editorInput, false);
        if (result != null) {
            return result;
        }
        return editorDescriptor;
    }

    public IEditorDescriptor overrideDefaultEditor(String fileName, IContentType contentType, IEditorDescriptor editorDescriptor) {
        IEditorDescriptor result = this.findXbaseEditor(fileName, false);
        if (result != null) {
            return result;
        }
        return editorDescriptor;
    }

    protected IEditorDescriptor findXbaseEditor(String fileName, boolean ignorePreference) {
        String file;
        if (this.decisions.isJDI() && (file = this.debugPluginListener.findXtextSourceFileNameForClassFile(fileName)) != null) {
            return this.getXtextEditor(URI.createURI((String)file));
        }
        if (this.decisions.decideAccordingToCallerForSimpleFileName() == StacktraceBasedEditorDecider.Decision.FORCE_JAVA) {
            return null;
        }
        IType type = this.findJavaTypeForSimpleFileName(fileName);
        if (type != null) {
            IResource resource;
            if (!ignorePreference && (resource = type.getResource()) != null) {
                try {
                    String favoriteEditor = resource.getPersistentProperty(IDE.EDITOR_KEY);
                    if (favoriteEditor != null) {
                        return null;
                    }
                }
                catch (CoreException e) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            ITrace trace = this.traceForTypeRootProvider.getTraceToSource(type.getTypeRoot());
            return this.getXtextEditor(trace);
        }
        return null;
    }

    public IEditorDescriptor findXbaseEditor(IEditorInput editorInput, boolean ignorePreference) {
        StacktraceBasedEditorDecider.Decision decision;
        IFile file = ResourceUtil.getFile((IEditorInput)editorInput);
        if (file == null) {
            return null;
        }
        if (!ignorePreference && file.exists()) {
            try {
                String favoriteEditor = file.getPersistentProperty(IDE.EDITOR_KEY);
                if (favoriteEditor != null) {
                    return null;
                }
            }
            catch (CoreException e) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        if ((decision = this.decisions.decideAccordingToCaller()) == StacktraceBasedEditorDecider.Decision.FORCE_JAVA) {
            return null;
        }
        ITrace traceToSource = this.traceInformation.getTraceToSource((IStorage)file);
        return this.getXtextEditor(traceToSource);
    }

    protected IEditorDescriptor getXtextEditor(ITrace traceToSource) {
        Iterator sourceInformationIterator;
        if (traceToSource != null && (sourceInformationIterator = traceToSource.getAllAssociatedLocations().iterator()).hasNext()) {
            URI uri = ((ILocationInResource)sourceInformationIterator.next()).getAbsoluteResourceURI();
            return this.getXtextEditor(uri);
        }
        return null;
    }

    protected IType findJavaTypeForSimpleFileName(String name) {
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        String typeName = name.substring(0, index);
        String ext = name.substring(index + 1).toLowerCase();
        if (!ext.equals("class") && !ext.equals("java")) {
            return null;
        }
        final IType[] foundLocalType = new IType[1];
        final IType[] foundLibraryType = new IType[1];
        try {
            new SearchEngine().searchAllTypeNames(null, 0, typeName.toCharArray(), 8, 0, SearchEngine.createWorkspaceScope(), new TypeNameMatchRequestor(){

                public void acceptTypeNameMatch(TypeNameMatch match) {
                    IPackageFragmentRoot fragmentRoot = match.getPackageFragmentRoot();
                    if (fragmentRoot.isArchive() || fragmentRoot.isExternal()) {
                        foundLibraryType[0] = match.getType();
                    } else {
                        foundLocalType[0] = match.getType();
                    }
                }
            }, 3, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            logger.error((Object)e);
        }
        if (this.decisions.isJavaStackTraceHyperlink()) {
            return foundLocalType[0] != null ? foundLocalType[0] : foundLibraryType[0];
        }
        return foundLibraryType[0] != null ? foundLibraryType[0] : foundLocalType[0];
    }

    protected IEditorDescriptor getXtextEditor(URI uri) {
        XtextEditorInfo editorInfo;
        IResourceServiceProvider serviceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(uri);
        if (serviceProvider != null && (editorInfo = (XtextEditorInfo)serviceProvider.get(XtextEditorInfo.class)) != null) {
            IEditorRegistry editorRegistry = this.workbench.getEditorRegistry();
            IEditorDescriptor result = editorRegistry.findEditor(editorInfo.getEditorId());
            return result;
        }
        return null;
    }
}

