/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.query;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.search.ui.text.Match;
import org.eclipse.xtext.common.types.ui.query.IJavaSearchParticipation;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;

public class JavaSearchHelper {
    private ISearchRequestor requestor;
    private IResourceDescriptions resourceDescriptions;
    private final Map<IProject, ResourceSet> projectToResourceSet = Maps.newHashMap();
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private IExternalContentSupport externalContentSupport;
    @Inject
    private IDirtyStateManager dirtyStateManager;
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;

    public void init(ISearchRequestor requestor, IResourceDescriptions resourceDescriptions) {
        this.requestor = requestor;
        this.resourceDescriptions = resourceDescriptions;
    }

    public void search(URI uri, IProgressMonitor monitor) {
        int numResources = Iterables.size((Iterable)this.resourceDescriptions.getAllResourceDescriptions());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)numResources);
        subMonitor.subTask("Find references in EMF resources");
        try {
            for (IResourceDescription resourceDescription : this.resourceDescriptions.getAllResourceDescriptions()) {
                IJavaSearchParticipation javaSearchParticipation;
                URI resourceURI = resourceDescription.getURI();
                IResourceServiceProvider resourceServiceProvider = this.serviceProviderRegistry.getResourceServiceProvider(resourceURI);
                if (resourceServiceProvider != null && ((javaSearchParticipation = (IJavaSearchParticipation)resourceServiceProvider.get(IJavaSearchParticipation.class)) == null || javaSearchParticipation.canContainJvmReferences(resourceURI))) {
                    this.searchIn(uri, resourceDescription);
                }
                if (subMonitor.isCanceled()) {
                    return;
                }
                subMonitor.worked(1);
            }
            for (ResourceSet resourceSet : this.projectToResourceSet.values()) {
                resourceSet.getResources().clear();
                resourceSet.eAdapters().clear();
            }
        }
        finally {
            subMonitor.done();
        }
    }

    protected void searchIn(final URI uri, IResourceDescription resourceDescription) {
        Iterable matchingReferenceDescriptors = Iterables.filter((Iterable)resourceDescription.getReferenceDescriptions(), (Predicate)new Predicate<IReferenceDescription>(){

            public boolean apply(IReferenceDescription input) {
                return uri.equals(input.getTargetEObjectUri());
            }
        });
        for (IReferenceDescription matchingReferenceDescription : matchingReferenceDescriptors) {
            this.accept(matchingReferenceDescription);
        }
    }

    protected void accept(IReferenceDescription referenceDescription) {
        URI sourceResourceURI = referenceDescription.getSourceEObjectUri().trimFragment();
        Iterable storages = this.storage2UriMapper.getStorages(sourceResourceURI);
        for (Pair pair : storages) {
            IStorage storage = (IStorage)pair.getFirst();
            IProject project = (IProject)pair.getSecond();
            if (project == null || project.isHidden()) continue;
            ResourceSet resourceSet = this.getResourceSet(project);
            EObject sourceEObject = resourceSet.getEObject(referenceDescription.getSourceEObjectUri(), true);
            if (sourceEObject != null) {
                ITextRegion region = this.getLocation(sourceEObject, referenceDescription.getEReference(), referenceDescription.getIndexInList());
                this.acceptMatch(storage, region);
                continue;
            }
            this.acceptMatch(referenceDescription, null);
        }
    }

    protected ITextRegion getLocation(EObject sourceEObject, EReference eReference, int indexInList) {
        List result = NodeModelUtils.findNodesForFeature((EObject)sourceEObject, (EStructuralFeature)eReference);
        if (result.isEmpty()) {
            return ITextRegion.EMPTY_REGION;
        }
        if (result.size() == 1) {
            INode node = (INode)result.get(0);
            return node.getTextRegion();
        }
        if (indexInList == -1 || indexInList > result.size()) {
            return ITextRegion.EMPTY_REGION;
        }
        INode node = (INode)result.get(indexInList);
        return node.getTextRegion();
    }

    protected ResourceSet getResourceSet(IProject project) {
        ResourceSet resourceSet = this.projectToResourceSet.get(project);
        if (resourceSet == null) {
            resourceSet = this.createResourceSet(project);
            this.projectToResourceSet.put(project, resourceSet);
        }
        return resourceSet;
    }

    protected void acceptMatch(Object element, ITextRegion region) {
        if (region != null) {
            this.requestor.reportMatch(new Match(element, region.getOffset(), region.getLength()));
        } else {
            this.requestor.reportMatch(new Match(element, 0, 0));
        }
    }

    protected ResourceSet createResourceSet(IProject project) {
        ResourceSet result = this.resourceSetProvider.get(project);
        this.externalContentSupport.configureResourceSet(result, (IExternalContentSupport.IExternalContentProvider)this.dirtyStateManager);
        return result;
    }
}

