/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmCompoundTypeReference;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;
import org.eclipse.xtext.common.types.util.AbstractTypeReferenceVisitorWithParameter;
import org.eclipse.xtext.common.types.util.IRawTypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class RawTypeHelper
implements IRawTypeHelper {
    private final RawTypeImplementation typeImplementation;
    private final RawTypeReferenceImplementation typeReferenceImplementation;

    @Inject
    public RawTypeHelper(RawTypeImplementation typeImplementation, RawTypeReferenceImplementation typeReferenceImplementation) {
        this.typeImplementation = typeImplementation;
        this.typeReferenceImplementation = typeReferenceImplementation;
    }

    @Override
    public List<JvmType> getAllRawTypes(JvmTypeReference reference, Resource resource) {
        List<JvmType> result = this.typeImplementation.getAllRawTypes(reference, resource);
        return result;
    }

    @Override
    public JvmTypeReference getRawTypeReference(JvmTypeReference reference, Resource resource) {
        JvmTypeReference result = this.typeReferenceImplementation.getRawTypeReference(reference, resource);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RawTypeImplementation
    extends AbstractTypeReferenceVisitorWithParameter.InheritanceAware<Resource, List<JvmType>> {
        private final TypesFactory factory;

        @Inject
        public RawTypeImplementation(TypesFactory factory) {
            this.factory = factory;
        }

        public List<JvmType> getAllRawTypes(JvmTypeReference reference, Resource resource) {
            List result = (List)this.visit(reference, resource);
            return result;
        }

        @Override
        public List<JvmType> doVisitTypeReference(JvmTypeReference reference, Resource resource) {
            return Collections.emptyList();
        }

        @Override
        protected List<JvmType> handleNullReference(Resource parameter) {
            return Collections.emptyList();
        }

        @Override
        public List<JvmType> doVisitCompoundTypeReference(JvmCompoundTypeReference reference, Resource resource) {
            EList<JvmTypeReference> references = reference.getReferences();
            if (references.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList result = Lists.newArrayList();
            for (JvmTypeReference contained : references) {
                result.addAll((Collection)this.visit(contained, resource));
            }
            return result;
        }

        @Override
        public List<JvmType> doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference, Resource resource) {
            JvmTypeReference componentType = reference.getComponentType();
            List rawComponentTypes = (List)this.visit(componentType, resource);
            ArrayList result = Lists.newArrayListWithCapacity((int)rawComponentTypes.size());
            for (JvmType rawComponentType : rawComponentTypes) {
                if (rawComponentType.eIsProxy() || !(rawComponentType instanceof JvmComponentType)) continue;
                JvmArrayType arrayType = ((JvmComponentType)rawComponentType).getArrayType();
                result.add(arrayType);
            }
            return result;
        }

        @Override
        public List<JvmType> doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, Resource resource) {
            JvmType type = reference.getType();
            if (type != null && !type.eIsProxy()) {
                if (type instanceof JvmTypeParameter) {
                    return this.getRawTypesFromConstraints((List<JvmTypeConstraint>)((JvmTypeParameter)type).getConstraints(), resource);
                }
                return Collections.singletonList(type);
            }
            return Collections.emptyList();
        }

        @Override
        public List<JvmType> doVisitWildcardTypeReference(JvmWildcardTypeReference reference, Resource resource) {
            return this.getRawTypesFromConstraints((List<JvmTypeConstraint>)reference.getConstraints(), resource);
        }

        protected List<JvmType> getRawTypesFromConstraints(List<JvmTypeConstraint> constraints, Resource resource) {
            if (!constraints.isEmpty()) {
                ArrayList result = Lists.newArrayList();
                for (JvmTypeConstraint constraint : constraints) {
                    if (!(constraint instanceof JvmUpperBound)) continue;
                    result.addAll((Collection)this.visit(constraint.getTypeReference(), resource));
                }
                if (!result.isEmpty()) {
                    return result;
                }
            }
            return this.createObjectReference(resource);
        }

        protected List<JvmType> createObjectReference(Resource resource) {
            if (resource != null) {
                JvmType objectType = this.factory.createJvmGenericType();
                String objectClassName = Object.class.getName();
                ((InternalEObject)objectType).eSetProxyURI(URIHelperConstants.OBJECTS_URI.appendSegment(objectClassName).appendFragment(objectClassName));
                objectType = (JvmType)EcoreUtil.resolve((EObject)objectType, (Resource)resource);
                return Collections.singletonList(objectType);
            }
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RawTypeReferenceImplementation
    extends AbstractTypeReferenceVisitorWithParameter.InheritanceAware<Resource, JvmTypeReference> {
        private final TypesFactory factory;

        @Inject
        public RawTypeReferenceImplementation(TypesFactory factory) {
            this.factory = factory;
        }

        public JvmTypeReference getRawTypeReference(JvmTypeReference reference, Resource resource) {
            JvmTypeReference result = (JvmTypeReference)this.visit(reference, resource);
            return result;
        }

        @Override
        public JvmTypeReference doVisitTypeReference(JvmTypeReference reference, Resource resource) {
            return reference;
        }

        @Override
        protected JvmTypeReference handleNullReference(Resource parameter) {
            return null;
        }

        @Override
        public JvmTypeReference doVisitCompoundTypeReference(JvmCompoundTypeReference reference, Resource resource) {
            JvmCompoundTypeReference result = null;
            EList<JvmTypeReference> components = reference.getReferences();
            int recent = -1;
            int i = 0;
            while (i < components.size()) {
                JvmTypeReference component = (JvmTypeReference)components.get(i);
                JvmTypeReference rawType = (JvmTypeReference)this.visit(component, resource);
                if (rawType != null && component != rawType) {
                    if (result == null) {
                        result = (JvmCompoundTypeReference)EcoreUtil.create((EClass)reference.eClass());
                    }
                    int j = recent + 1;
                    while (j < i) {
                        result.getReferences().add((Object)((JvmTypeReference)components.get(j)));
                        ++j;
                    }
                    result.getReferences().add((Object)rawType);
                    recent = i;
                }
                ++i;
            }
            if (result != null) {
                return result;
            }
            return reference;
        }

        @Override
        public JvmTypeReference doVisitDelegateTypeReference(JvmDelegateTypeReference reference, Resource parameter) {
            JvmTypeReference result = (JvmTypeReference)super.doVisitDelegateTypeReference(reference, parameter);
            if (result == reference.getDelegate()) {
                return reference;
            }
            return result;
        }

        @Override
        public JvmTypeReference doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference, Resource resource) {
            JvmTypeReference rawComponentType;
            JvmTypeReference componentType = reference.getComponentType();
            if (componentType != (rawComponentType = (JvmTypeReference)this.visit(componentType, resource))) {
                JvmGenericArrayTypeReference result = this.factory.createJvmGenericArrayTypeReference();
                result.setComponentType(rawComponentType);
                return result;
            }
            return reference;
        }

        @Override
        public JvmTypeReference doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, Resource resource) {
            JvmType type = reference.getType();
            if (type != null && !type.eIsProxy()) {
                if (type instanceof JvmTypeParameterDeclarator) {
                    if (!((JvmTypeParameterDeclarator)((Object)type)).getTypeParameters().isEmpty()) {
                        JvmParameterizedTypeReference result = this.factory.createJvmParameterizedTypeReference();
                        result.setType(type);
                        return result;
                    }
                } else if (type instanceof JvmTypeParameter) {
                    return this.getRawTypeFromConstraints((List<JvmTypeConstraint>)((JvmTypeParameter)type).getConstraints(), resource);
                }
            }
            return reference;
        }

        @Override
        public JvmTypeReference doVisitWildcardTypeReference(JvmWildcardTypeReference reference, Resource resource) {
            return this.getRawTypeFromConstraints((List<JvmTypeConstraint>)reference.getConstraints(), resource);
        }

        protected JvmTypeReference getRawTypeFromConstraints(List<JvmTypeConstraint> constraints, Resource resource) {
            if (!constraints.isEmpty()) {
                JvmTypeReference result = null;
                for (JvmTypeConstraint constraint : constraints) {
                    JvmDelegateTypeReference delegate;
                    JvmSynonymTypeReference synonym;
                    if (!(constraint instanceof JvmUpperBound)) continue;
                    JvmTypeReference rawType = (JvmTypeReference)this.visit(constraint.getTypeReference(), resource);
                    if (result == null) {
                        if (rawType != null && rawType.eContainer() != null) {
                            JvmDelegateTypeReference delegate2 = this.factory.createJvmDelegateTypeReference();
                            delegate2.setDelegate(rawType);
                            rawType = delegate2;
                        }
                        result = rawType;
                        continue;
                    }
                    if (!(result instanceof JvmSynonymTypeReference)) {
                        synonym = this.factory.createJvmSynonymTypeReference();
                        synonym.getReferences().add((Object)result);
                        if (rawType.eContainer() != null) {
                            delegate = this.factory.createJvmDelegateTypeReference();
                            delegate.setDelegate(rawType);
                            rawType = delegate;
                        }
                        synonym.getReferences().add((Object)rawType);
                        result = synonym;
                        continue;
                    }
                    synonym = (JvmSynonymTypeReference)result;
                    if (rawType.eContainer() != null) {
                        delegate = this.factory.createJvmDelegateTypeReference();
                        delegate.setDelegate(rawType);
                        rawType = delegate;
                    }
                    synonym.getReferences().add((Object)rawType);
                }
                if (result != null) {
                    return result;
                }
            }
            return this.createObjectReference(resource);
        }

        protected JvmTypeReference createObjectReference(Resource resource) {
            JvmType objectType = this.factory.createJvmGenericType();
            String objectClassName = Object.class.getName();
            ((InternalEObject)objectType).eSetProxyURI(URIHelperConstants.OBJECTS_URI.appendSegment(objectClassName).appendFragment(objectClassName));
            if (resource != null) {
                objectType = (JvmType)EcoreUtil.resolve((EObject)objectType, (Resource)resource);
            }
            JvmParameterizedTypeReference result = this.factory.createJvmParameterizedTypeReference();
            result.setType(objectType);
            return result;
        }
    }
}

