/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import org.openqa.selenium.internal.BuildInfo;

public class WebDriverException
extends RuntimeException {
    private String sessionId;

    public WebDriverException() {
    }

    public WebDriverException(String message) {
        super(message);
    }

    public WebDriverException(Throwable cause) {
        super(cause);
    }

    public WebDriverException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public String getMessage() {
        return this.createMessage(super.getMessage());
    }

    private String createMessage(String originalMessageString) {
        String supportMessage = this.getSupportUrl() == null ? "" : "For documentation on this error, please visit: " + this.getSupportUrl() + "\n";
        return String.format("%s%s%s\nSystem info: %s\nDriver info: %s", originalMessageString == null ? "" : String.valueOf(originalMessageString) + "\n", supportMessage, this.getBuildInformation(), this.getSystemInformation(), this.getDriverInformation());
    }

    public String getSystemInformation() {
        return String.format("os.name: '%s', os.arch: '%s', os.version: '%s', java.version: '%s'", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.version"));
    }

    public String getSupportUrl() {
        return null;
    }

    public BuildInfo getBuildInformation() {
        return new BuildInfo();
    }

    public String getDriverInformation() {
        String driverInformation = "driver.version: " + WebDriverException.getDriverName(this.getStackTrace());
        if (this.sessionId != null) {
            driverInformation = String.valueOf(driverInformation) + "\nSession ID: " + this.sessionId;
        }
        return driverInformation;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public static String getDriverName(StackTraceElement[] stackTraceElements) {
        String driverName = "unknown";
        StackTraceElement[] stackTraceElementArray = stackTraceElements;
        int n = stackTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            if (e.getClassName().endsWith("Driver")) {
                String[] bits = e.getClassName().split("\\.");
                driverName = bits[bits.length - 1];
            }
            ++n2;
        }
        return driverName;
    }
}

