/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.visualization.blind.IBlindVisualizer;
import org.eclipse.actf.visualization.blind.ui.internal.Messages;
import org.eclipse.actf.visualization.engines.blind.BlindVizResourceUtil;
import org.eclipse.actf.visualization.engines.blind.eval.EvaluationResultBlind;
import org.eclipse.actf.visualization.eval.EvaluationUtil;
import org.eclipse.actf.visualization.eval.IChecker;
import org.eclipse.actf.visualization.eval.IEvaluationResult;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.ui.IVisualizationView;
import org.w3c.dom.Document;

public abstract class BlindVisualizerBase
implements IBlindVisualizer {
    protected IChecker[] checkers = EvaluationUtil.getCheckers();
    protected String tmpDirS = String.valueOf(BlindVizResourceUtil.getTempDirectory().getAbsolutePath()) + File.separator;
    protected String targetUrl = "";
    protected IModelService modelService;
    protected IEvaluationResult checkResult = new EvaluationResultBlind();
    protected Document resultDocument;
    protected PageData pageData;
    protected int maxReachingTime = 0;
    protected File resultFile;
    protected File variantFile;
    private IVisualizationView vizView;

    protected abstract boolean isTarget(IModelService var1);

    public boolean setModelService(IModelService iModelService) {
        this.modelService = null;
        this.targetUrl = "";
        if (!this.isTarget(iModelService)) {
            return false;
        }
        this.modelService = iModelService;
        this.targetUrl = iModelService.getURL();
        if (this.targetUrl == null) {
            this.targetUrl = "";
        }
        return true;
    }

    public void setVisualizationView(IVisualizationView iVisualizationView) {
        this.vizView = iVisualizationView;
    }

    public String getMaxReachingTime() {
        return MessageFormat.format((String)Messages.BlindView_Maximum_Time, (Object[])new Object[]{this.maxReachingTime});
    }

    public IEvaluationResult getEvaluationResult() {
        return this.checkResult;
    }

    public PageData getPageData() {
        return this.pageData;
    }

    public Document getResultDocument() {
        return this.resultDocument;
    }

    public File getResultFile() {
        return this.resultFile;
    }

    protected void setStatusMessage(String string) {
        if (this.vizView != null) {
            this.vizView.setStatusMessage(string);
        }
    }

    protected void setInfoMessage(String string) {
        if (this.vizView != null) {
            this.vizView.setInfoMessage(string);
        }
    }
}

