/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ExpressionPropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ExpressionSection
extends Section {
    protected ExpressionPropertyDescriptor expression;
    IDescriptorProvider provider;
    private int width = -1;
    boolean fillColor = false;
    boolean multi = true;

    public ExpressionSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    public void createSection() {
        this.getLabelControl(this.parent);
        this.getExpressionControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    protected Label getLabelControl(Composite parent) {
        Label label = super.getLabelControl(parent);
        if (this.multi) {
            GridData gd = new GridData(34);
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
        }
        return label;
    }

    protected ExpressionPropertyDescriptor getExpressionControl(Composite parent) {
        if (this.expression == null) {
            this.expression = DescriptorToolkit.createExpressionPropertyDescriptor(true);
            this.expression.setMulti(this.multi);
            if (this.getProvider() != null) {
                this.expression.setDescriptorProvider(this.getProvider());
            }
            this.expression.createControl(parent);
            this.expression.getControl().setLayoutData((Object)new GridData());
            this.expression.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ExpressionSection.this.expression = null;
                }
            });
        } else {
            this.checkParent(this.expression.getControl(), parent);
        }
        return this.expression;
    }

    public ExpressionPropertyDescriptor getExpressionControl() {
        return this.expression;
    }

    public void layout() {
        GridData gd = (GridData)this.expression.getControl().getLayoutData();
        if (this.getLayoutNum() > 1 + this.placeholder) {
            gd.horizontalSpan = this.getLayoutNum() - 1 - this.placeholder;
        } else if (((GridLayout)this.parent.getLayout()).numColumns > -1 - this.placeholder) {
            gd.horizontalSpan = ((GridLayout)this.parent.getLayout()).numColumns - this.placeholder;
        }
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillColor;
        }
        if (this.multi) {
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
        }
    }

    public void load() {
        if (this.expression != null && !this.expression.getControl().isDisposed()) {
            this.expression.load();
        }
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.expression != null) {
            this.expression.setDescriptorProvider(provider);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setInput(Object input) {
        assert (input != null);
        this.expression.setInput(input);
    }

    public boolean isFillColor() {
        return this.fillColor;
    }

    public void setFillColor(boolean fillColor) {
        this.fillColor = fillColor;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.expression != null) {
            this.expression.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.expression != null) {
            this.expression.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }
}

