/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.wizards;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class WizardCSSSettingPage
extends WizardPage {
    String[] CSS_FILE_EXTENSIONS = new String[]{"*.css;*.CSS"};
    String[] CSS_FILE_END = new String[]{"css", "CSS"};
    private static String LABEL_FILE_NAME = Messages.getString((String)"PublishCSSDialog.Label.FileName");
    private static String LABEL_SOURCE_FILE_NAME = Messages.getString((String)"PublishCSSDialog.Label.SourceFileName");
    private static String LABEL_FOLDER = Messages.getString((String)"PublishCSSDialog.Label.Folder");
    private static String BUTTON_BROWSE = Messages.getString((String)"PublishCSSDialog.Label.Browse");
    private static String BUTTON_BROWSE2 = Messages.getString((String)"PublishCSSDialog.Label.Browse2");
    private static final String PLUGIN_ID = "org.eclipse.birt.report.designer.ui.actions.AddCSSFileAction";
    private String fileDialogTitle = Messages.getString((String)"PublishCSSDialog.Dialog.FileSeclect.Tilte");
    private File selectedFolder;
    private Status pageStatus;
    private String fileName;
    private String folder;
    private Text nameText;
    private Text folderText;
    private Text sourceFileText;
    private Status OKStatus = new Status(0, "org.eclipse.birt.report.designer.ui", 0, "", null);
    private Status ErrorStatus = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)"WPublishCSSDialog.ErrorMessage.SelectFolder"), null);
    private String pageDefaultDesc;

    public String getSourceFileName() {
        if (this.sourceFileText != null) {
            return this.sourceFileText.getText();
        }
        return null;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setfolderName(String folder) {
        this.folder = folder;
    }

    public String getFolder() {
        this.folder = this.folderText.getText();
        return this.folder;
    }

    public String getFileName() {
        this.fileName = this.nameText.getText();
        return this.fileName;
    }

    public WizardCSSSettingPage(String pageTitle, String pageDesc) {
        super("");
        this.setTitle(pageTitle);
        this.setMessage(pageDesc);
        this.pageStatus = new Status(0, PLUGIN_ID, 0, pageDesc, null);
        this.pageDefaultDesc = pageDesc;
    }

    public WizardCSSSettingPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.AddCSSDialog_ID");
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        gd.heightHint = 350;
        container.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        new Label(container, 0).setText(LABEL_SOURCE_FILE_NAME);
        int style = 2052;
        this.sourceFileText = this.createText(container, 1, style);
        this.sourceFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardCSSSettingPage.this.checkStatus();
            }
        });
        Button chooseBtn = new Button(container, 0);
        chooseBtn.setText(BUTTON_BROWSE2);
        chooseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String sourceFileName = WizardCSSSettingPage.this.getFilePath();
                if (sourceFileName != null) {
                    WizardCSSSettingPage.this.sourceFileText.setText(sourceFileName);
                    WizardCSSSettingPage.this.nameText.setText(sourceFileName.substring(sourceFileName.lastIndexOf(File.separator) + 1));
                    WizardCSSSettingPage.this.nameText.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(container, 0).setText(LABEL_FILE_NAME);
        style = 2052;
        this.nameText = this.createText(container, 1, style);
        new Label(container, 0);
        if (this.fileName != null) {
            this.nameText.setText(this.fileName);
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardCSSSettingPage.this.checkStatus();
            }
        });
        new Label(container, 0).setText(LABEL_FOLDER);
        style = 2060;
        this.folderText = this.createText(container, 1, style);
        if (this.folder != null) {
            this.folderText.setText(this.folder);
        }
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardCSSSettingPage.this.checkStatus();
            }
        });
        chooseBtn = new Button(container, 0);
        chooseBtn.setText(BUTTON_BROWSE);
        chooseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selected;
                ResourceFileFolderSelectionDialog dialog = new ResourceFileFolderSelectionDialog(false);
                dialog.setAllowMultiple(false);
                dialog.setTitle(Messages.getString((String)"WizardCSSSettingPage.Resourcefile.Dialog.Title"));
                dialog.setMessage(Messages.getString((String)"WizardCSSSettingPage.Resourcefile.Dialog.Message"));
                dialog.setValidator(new Validator());
                if (dialog.open() == 0 && (selected = dialog.getResult()).length > 0) {
                    ResourceEntry file = (ResourceEntry)selected[0];
                    WizardCSSSettingPage.this.folderText.setText(new File(file.getURL().getPath()).getAbsolutePath());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.nameText.forceFocus();
        this.setControl((Control)container);
    }

    public void checkStatus() {
        Status status = null;
        status = new Status(0, PLUGIN_ID, 0, this.pageDefaultDesc, null);
        if (WizardCSSSettingPage.isTextEmpty(this.sourceFileText)) {
            status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"PublishCSSDialog.Message.SourceFileEmpty"), null);
        } else if (new File(this.sourceFileText.getText()).isDirectory() || !new File(this.sourceFileText.getText()).exists()) {
            status = new Status(4, PLUGIN_ID, 0, Messages.getFormattedString((String)"PublishCSSDialog.Error.FileNotFound", (Object[])new String[]{this.sourceFileText.getText()}), null);
        } else if (WizardCSSSettingPage.isTextEmpty(this.nameText)) {
            status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"PublishCSSDialog.Message.FileNameEmpty"), null);
        } else if (!this.isCSSFile(this.nameText.getText())) {
            status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"PublishCSSDialog.Message.FileNameError"), null);
        } else if (WizardCSSSettingPage.isTextEmpty(this.folderText)) {
            status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"PublishCSSDialog.Message.FolderEmpty"), null);
        }
        this.pageStatus = status;
        this.applyToStatusLine((IStatus)this.pageStatus);
        this.getWizard().getContainer().updateButtons();
    }

    private void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        if (message.length() == 0) {
            message = this.pageDefaultDesc;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(message);
                break;
            }
            case 4: {
                this.setErrorMessage(message);
                this.setMessage(message, 3);
                break;
            }
            default: {
                this.setErrorMessage(message);
                this.setMessage(null);
            }
        }
    }

    private static boolean isTextEmpty(Text text) {
        String s = text.getText();
        return s == null || s.trim().length() <= 0;
    }

    private Text createText(Composite container, int column, int style) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = column;
        Text text = new Text(container, style);
        text.setLayoutData((Object)gridData);
        return text;
    }

    public boolean canFinish() {
        return !WizardCSSSettingPage.isTextEmpty(this.nameText) && !WizardCSSSettingPage.isTextEmpty(this.folderText) && this.pageStatus.isOK();
    }

    private boolean isFileExists(String filePath) {
        String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
        try {
            return new File(this.selectedFolder, fileName).exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String getFilePath() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        dialog.setFilterExtensions(this.CSS_FILE_EXTENSIONS);
        dialog.setText(this.fileDialogTitle);
        String fileName = dialog.open();
        if (fileName != null) {
            if (!new File(fileName).exists()) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishCSSDialog.Exception.Error.Title"), Messages.getFormattedString((String)"PublishCSSDialog.Error.FileNotFound", (Object[])new String[]{fileName}));
                return this.getFilePath();
            }
            if (!this.isCSSFile(fileName)) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishCSSDialog.Exception.Error.Title"), Messages.getFormattedString((String)"PublishCSSDialog.Error.FileIsNotCSSFile", (Object[])new String[]{fileName, this.CSS_FILE_END[0]}));
                return this.getFilePath();
            }
            if (this.isFileExists(fileName)) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishCSSDialog.Exception.Error.Title"), Messages.getString((String)"PublishCSSDialog.Error.FileExist"));
                return this.getFilePath();
            }
            return fileName;
        }
        return null;
    }

    private boolean isCSSFile(String fileName) {
        assert (fileName != null);
        int i = 0;
        while (i < this.CSS_FILE_END.length) {
            if (fileName.endsWith(this.CSS_FILE_END[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class Validator
    implements ISelectionStatusValidator {
        private Validator() {
        }

        public IStatus validate(Object[] selection) {
            int nSelected = selection.length;
            if (nSelected == 0 || nSelected > 1) {
                return WizardCSSSettingPage.this.ErrorStatus;
            }
            return WizardCSSSettingPage.this.OKStatus;
        }
    }
}

