/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.di;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.ConversationLink;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataStoreReference;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.SubChoreography;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.BpmnDiFactory;
import org.eclipse.bpmn2.modeler.core.di.DIGenerator;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.di.ImportDiagnostics;
import org.eclipse.bpmn2.modeler.core.di.Messages;
import org.eclipse.bpmn2.modeler.core.model.ModelHandler;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.Point;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.AreaContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.ui.editor.DiagramEditor;

public class DIImport {
    private DiagramEditor editor;
    private TransactionalEditingDomain domain;
    private ModelHandler modelHandler;
    private IFeatureProvider featureProvider;
    private LinkedHashMap<BaseElement, PictogramElement> elements;
    private Bpmn2Preferences preferences;
    private ImportDiagnostics diagnostics;
    private final IGaService gaService = Graphiti.getGaService();

    public DIImport(DiagramEditor editor) {
        this.editor = editor;
        this.domain = editor.getEditingDomain();
        this.featureProvider = editor.getDiagramTypeProvider().getFeatureProvider();
    }

    public void generateFromDI() {
        final List<BPMNDiagram> bpmnDiagrams = this.modelHandler.getAll(BPMNDiagram.class);
        this.diagnostics = new ImportDiagnostics((Resource)this.modelHandler.getResource());
        this.preferences = (Bpmn2Preferences)this.editor.getAdapter(Bpmn2Preferences.class);
        this.elements = new LinkedHashMap();
        Bpmn2Preferences prefs = Bpmn2Preferences.getInstance((Resource)this.modelHandler.getResource());
        prefs.setEnableConnectionRouting(false);
        try {
            this.domain.getCommandStack().execute((Command)new RecordingCommand(this.domain){

                protected void doExecute() {
                    Diagram diagram = DIImport.this.editor.getDiagramTypeProvider().getDiagram();
                    Definitions definitions = DIImport.this.modelHandler.getDefinitions();
                    if (bpmnDiagrams.size() == 0) {
                        BPMNPlane plane = BpmnDiFactory.eINSTANCE.createBPMNPlane();
                        plane.setBpmnElement(ModelUtil.getDefaultBPMNPlaneReference((EObject)definitions));
                        BPMNDiagram d = BpmnDiFactory.eINSTANCE.createBPMNDiagram();
                        d.setPlane(plane);
                        DIImport.this.modelHandler.getDefinitions().getDiagrams().add(d);
                        bpmnDiagrams.add(d);
                    }
                    DIImport.this.featureProvider.link((PictogramElement)diagram, bpmnDiagrams.get(0));
                    TreeIterator iter = definitions.eAllContents();
                    while (iter.hasNext()) {
                        ModelUtil.addID((EObject)iter.next());
                    }
                    for (BPMNDiagram d : bpmnDiagrams) {
                        diagram = DIUtils.getOrCreateDiagram((IDiagramBehavior)DIImport.this.editor.getDiagramBehavior(), d);
                    }
                    for (BPMNDiagram d : bpmnDiagrams) {
                        diagram = DIUtils.findDiagram((IDiagramBehavior)DIImport.this.editor.getDiagramBehavior(), d);
                        DIImport.this.editor.getDiagramTypeProvider().init(diagram, (IDiagramEditor)DIImport.this.editor);
                        BPMNPlane plane = d.getPlane();
                        if (plane.getBpmnElement() == null) {
                            plane.setBpmnElement(ModelUtil.getDefaultBPMNPlaneReference((EObject)definitions));
                        }
                        DIImport.this.elements.put(plane.getBpmnElement(), diagram);
                        List ownedElement = plane.getPlaneElement();
                        DIImport.this.importShapes(ownedElement);
                        DIImport.this.importConnections(ownedElement);
                    }
                    DIGenerator generator = new DIGenerator(DIImport.this);
                    generator.generateMissingDIElements();
                    DIImport.this.layoutAll();
                }
            });
        }
        finally {
            prefs.setEnableConnectionRouting(true);
        }
        this.diagnostics.report();
    }

    public HashMap<BaseElement, PictogramElement> getImportedElements() {
        return this.elements;
    }

    public ImportDiagnostics getDiagnostics() {
        return this.diagnostics;
    }

    public DiagramEditor getEditor() {
        return this.editor;
    }

    private void layoutAll() {
        this.modelHandler.getAll(BPMNDiagram.class);
        for (BaseElement be : this.elements.keySet()) {
            PictogramElement pe = this.elements.get(be);
            if (!(be instanceof SubProcess)) continue;
            UpdateContext context = new UpdateContext(pe);
            context.putProperty((Object)"force.update.all", (Object)Boolean.TRUE);
            IUpdateFeature feature = this.featureProvider.getUpdateFeature((IUpdateContext)context);
            if (feature == null) continue;
            feature.update((IUpdateContext)context);
        }
    }

    public void setModelHandler(ModelHandler modelHandler) {
        this.modelHandler = modelHandler;
    }

    public void importShape(BPMNShape bpmnShape) {
        if (!this.elements.containsKey(bpmnShape.getBpmnElement())) {
            ArrayList<DiagramElement> newElements = new ArrayList<DiagramElement>();
            newElements.add((DiagramElement)bpmnShape);
            this.importShapes(newElements);
        }
    }

    private void importShapes(List<DiagramElement> ownedElement) {
        ConcurrentLinkedQueue<BPMNShape> shapeQueue = new ConcurrentLinkedQueue<BPMNShape>();
        for (DiagramElement diagramElement : ownedElement) {
            BPMNShape diShape;
            if (!(diagramElement instanceof BPMNShape) || (diShape = (BPMNShape)diagramElement).getBpmnElement() == null) continue;
            shapeQueue.offer(diShape);
        }
        int queueLength = shapeQueue.size();
        int pass = 0;
        while (pass <= 1) {
            int requeueCount = 0;
            while (!shapeQueue.isEmpty() && requeueCount < queueLength) {
                Lane lane;
                EObject container;
                BPMNShape currentShape = (BPMNShape)shapeQueue.remove();
                BaseElement bpmnElement = currentShape.getBpmnElement();
                boolean postpone = false;
                if (bpmnElement instanceof BoundaryEvent && !this.elements.containsKey(((BoundaryEvent)bpmnElement).getAttachedToRef())) {
                    postpone = true;
                } else if (bpmnElement instanceof FlowNode) {
                    container = bpmnElement.eContainer();
                    if ((container instanceof SubProcess || container instanceof SubChoreography) && !this.elements.containsKey(container)) {
                        postpone = true;
                    } else if (!((FlowNode)bpmnElement).getLanes().isEmpty()) {
                        List lanes = ((FlowNode)bpmnElement).getLanes();
                        if (pass == 0) {
                            for (Lane lane2 : lanes) {
                                if (this.elements.containsKey(lane2)) continue;
                                postpone = true;
                                break;
                            }
                        } else {
                            for (Lane lane2 : lanes) {
                                this.synthesizeLane(lane2);
                            }
                        }
                    }
                } else if (bpmnElement instanceof DataObject || bpmnElement instanceof DataObjectReference || bpmnElement instanceof DataStoreReference) {
                    container = bpmnElement.eContainer();
                    if ((container instanceof SubProcess || container instanceof SubChoreography) && !this.elements.containsKey(container)) {
                        postpone = true;
                    }
                } else if (bpmnElement instanceof Lane && (lane = (Lane)bpmnElement).eContainer() instanceof LaneSet) {
                    LaneSet ls = (LaneSet)lane.eContainer();
                    if (ls.eContainer() instanceof Lane) {
                        Lane parentLane = (Lane)ls.eContainer();
                        if (!this.elements.containsKey(parentLane)) {
                            postpone = true;
                        }
                    } else if (ls.eContainer() instanceof Process) {
                        Process process = (Process)ls.eContainer();
                        Definitions definitions = this.modelHandler.getDefinitions();
                        TreeIterator iter = definitions.eAllContents();
                        while (iter.hasNext()) {
                            Participant participant;
                            EObject next = (EObject)iter.next();
                            if (!(next instanceof Participant) || (participant = (Participant)next).getProcessRef() != process || this.elements.containsKey(participant)) continue;
                            postpone = true;
                            break;
                        }
                    }
                }
                if (postpone) {
                    shapeQueue.offer(currentShape);
                    ++requeueCount;
                    continue;
                }
                this.createShape(currentShape);
                requeueCount = 0;
            }
            ++pass;
        }
        if (shapeQueue.size() != 0) {
            for (BPMNShape currentShape : shapeQueue) {
                BaseElement bpmnElement = currentShape.getBpmnElement();
                if (bpmnElement == null) continue;
                this.diagnostics.add(2, (EObject)bpmnElement, Messages.DIImport_Dependency_not_found);
            }
        }
    }

    private void synthesizeLane(Lane lane) {
        if (!this.elements.containsKey(lane)) {
            List<BPMNDiagram> diagrams = this.modelHandler.getAll(BPMNDiagram.class);
            int xMin = Integer.MAX_VALUE;
            int yMin = Integer.MAX_VALUE;
            int width = 0;
            int height = 0;
            for (FlowNode flowNode : lane.getFlowNodeRefs()) {
                BPMNShape flowNodeBPMNShape = (BPMNShape)DIUtils.findDiagramElement(diagrams, (BaseElement)flowNode);
                if (flowNodeBPMNShape == null) continue;
                Bounds bounds = flowNodeBPMNShape.getBounds();
                int x = (int)bounds.getX();
                int y = (int)bounds.getY();
                int w = (int)bounds.getWidth();
                int h = (int)bounds.getHeight();
                if (x < xMin) {
                    xMin = x;
                }
                if (y < yMin) {
                    yMin = y;
                }
                if (xMin + width < x + w) {
                    width = x - xMin + w;
                }
                if (yMin + height >= y + h) continue;
                height = y - yMin + h;
            }
            if (width > 0 && height > 0) {
                AddContext context = new AddContext((IAreaContext)new AreaContext(), (Object)lane);
                context.setX(xMin - 10);
                context.setY(yMin - 10);
                context.setWidth(width + 20);
                context.setHeight(height + 20);
                context.putProperty((Object)"is.importing", (Object)true);
                this.handleLane(lane, context, null);
                ContainerShape newContainer = (ContainerShape)this.featureProvider.addIfPossible((IAddContext)context);
                newContainer.getGraphicsAlgorithm().setTransparency(Double.valueOf(0.5));
                Graphiti.getPeService().sendToBack((Shape)newContainer);
                this.elements.put((BaseElement)lane, (PictogramElement)newContainer);
            }
        }
    }

    public void importConnection(BPMNEdge bpmnEdge) {
        if (!this.elements.containsKey(bpmnEdge.getBpmnElement())) {
            ArrayList<DiagramElement> newElements = new ArrayList<DiagramElement>();
            newElements.add((DiagramElement)bpmnEdge);
            this.importConnections(newElements);
        }
    }

    private void importConnections(List<DiagramElement> ownedElement) {
        for (DiagramElement diagramElement : ownedElement) {
            if (!(diagramElement instanceof BPMNEdge) || ((BPMNEdge)diagramElement).getBpmnElement() instanceof Association) continue;
            this.createEdge((BPMNEdge)diagramElement);
        }
        for (DiagramElement diagramElement : ownedElement) {
            if (!(diagramElement instanceof BPMNEdge) || !(((BPMNEdge)diagramElement).getBpmnElement() instanceof Association)) continue;
            this.createEdge((BPMNEdge)diagramElement);
        }
    }

    private Diagram getDiagram(EObject object) {
        while (object != null && !(object instanceof BPMNDiagram)) {
            object = object.eContainer();
        }
        return DIUtils.getOrCreateDiagram((IDiagramBehavior)this.editor.getDiagramBehavior(), (BPMNDiagram)object);
    }

    private void createShape(BPMNShape shape) {
        PictogramElement newContainer;
        BaseElement bpmnElement = shape.getBpmnElement();
        if (bpmnElement == null) {
            this.diagnostics.add(4, (EObject)shape, Messages.DIImport_Reference_not_found);
            return;
        }
        if (shape.getChoreographyActivityShape() != null) {
            return;
        }
        AddContext context = new AddContext((IAreaContext)new AreaContext(), (Object)bpmnElement);
        IAddFeature addFeature = this.featureProvider.getAddFeature((IAddContext)context);
        if (addFeature == null) {
            this.diagnostics.add(2, (EObject)bpmnElement, Messages.DIImport_No_Add_Feature);
            return;
        }
        Diagram diagram = this.getDiagram((EObject)shape);
        context.putProperty((Object)"is.importing", (Object)true);
        context.setNewObject((Object)bpmnElement);
        context.setLocation((int)shape.getBounds().getX(), (int)shape.getBounds().getY());
        context.setSize((int)shape.getBounds().getWidth(), (int)shape.getBounds().getHeight());
        if (bpmnElement instanceof Lane) {
            this.handleLane((Lane)bpmnElement, context, shape);
        } else if (bpmnElement instanceof FlowNode) {
            this.handleFlowElement((FlowElement)bpmnElement, context, shape);
        } else if (bpmnElement instanceof Participant) {
            this.handleParticipant((Participant)bpmnElement, context, shape);
        } else if (bpmnElement instanceof DataInput || bpmnElement instanceof DataOutput || bpmnElement instanceof DataObject || bpmnElement instanceof DataObjectReference || bpmnElement instanceof DataStoreReference) {
            this.handleItemAwareElement((ItemAwareElement)bpmnElement, context, shape);
        } else {
            context.setTargetContainer((ContainerShape)diagram);
        }
        ShapeStyle ss = this.preferences.getShapeStyle((EObject)bpmnElement);
        if (ss != null && ss.getUseDefaultSize()) {
            int x = context.getX();
            int y = context.getY();
            int w = context.getWidth();
            int h = context.getHeight();
            int dw = w - ss.getDefaultWidth();
            int dh = h - ss.getDefaultHeight();
            context.setSize(ss.getDefaultWidth(), ss.getDefaultHeight());
            context.setLocation(x += dw / 2, y += dh / 2);
        }
        if ((newContainer = this.featureProvider.addIfPossible((IAddContext)context)) != null) {
            this.featureProvider.link(newContainer, new Object[]{bpmnElement, shape});
            if (bpmnElement instanceof Participant) {
                Process process = ((Participant)bpmnElement).getProcessRef();
                if (process != null) {
                    this.elements.put((BaseElement)process, newContainer);
                }
            } else if (bpmnElement instanceof ChoreographyActivity) {
                ChoreographyActivity cfr_ignored_0 = (ChoreographyActivity)bpmnElement;
                for (PictogramElement pe : ((ContainerShape)newContainer).getChildren()) {
                    EObject o = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                    if (!(o instanceof Participant)) continue;
                    this.elements.put((BaseElement)((Participant)o), pe);
                }
            }
            this.elements.put(bpmnElement, newContainer);
            this.handleEvents(bpmnElement, newContainer);
        }
        ModelUtil.addID((EObject)bpmnElement);
    }

    private void handleEvents(BaseElement bpmnElement, PictogramElement newContainer) {
        if (bpmnElement instanceof Event) {
            EList contents = bpmnElement.eContents();
            for (EObject obj : contents) {
                AddContext context = new AddContext();
                context.setTargetContainer((ContainerShape)newContainer);
                context.setNewObject((Object)obj);
                this.featureProvider.addIfPossible((IAddContext)context);
            }
        }
    }

    private void handleParticipant(Participant participant, AddContext context, BPMNShape shape) {
        Diagram diagram = this.getDiagram((EObject)shape);
        context.setTargetContainer((ContainerShape)diagram);
        context.setLocation((int)shape.getBounds().getX(), (int)shape.getBounds().getY());
        FeatureSupport.setHorizontal((IContext)context, shape.isIsHorizontal());
    }

    private void handleLane(Lane lane, AddContext context, BPMNShape shape) {
        BaseElement parent = (BaseElement)lane.eContainer().eContainer();
        Diagram targetContainer = null;
        for (BaseElement be : this.elements.keySet()) {
            if (be instanceof Participant) {
                Process processRef = ((Participant)be).getProcessRef();
                if (processRef == null || !parent.getId().equals(processRef.getId())) continue;
                targetContainer = (ContainerShape)this.elements.get(be);
                break;
            }
            if (be instanceof Process) {
                if (!be.getId().equals(parent.getId())) continue;
                targetContainer = (ContainerShape)this.elements.get(be);
                break;
            }
            if (!(be instanceof Lane) || !be.getId().equals(parent.getId())) continue;
            targetContainer = (ContainerShape)this.elements.get(be);
            break;
        }
        if (targetContainer == null) {
            targetContainer = this.getDiagram((EObject)shape);
        }
        context.setTargetContainer(targetContainer);
        if (shape != null) {
            int x = (int)shape.getBounds().getX();
            int y = (int)shape.getBounds().getY();
            ILocation loc = Graphiti.getPeLayoutService().getLocationRelativeToDiagram((Shape)targetContainer);
            context.setLocation(x -= loc.getX(), y -= loc.getY());
            FeatureSupport.setHorizontal((IContext)context, shape.isIsHorizontal());
        }
    }

    private void handleFlowElement(FlowElement element, AddContext context, BPMNShape shape) {
        int y;
        int x;
        Diagram targetContainer;
        block6: {
            List lanes;
            block5: {
                BPMNDiagram childDiagram;
                EObject parent;
                Diagram diagram;
                targetContainer = diagram = this.getDiagram((EObject)shape);
                x = (int)shape.getBounds().getX();
                y = (int)shape.getBounds().getY();
                int w = (int)shape.getBounds().getWidth();
                int h = (int)shape.getBounds().getHeight();
                lanes = null;
                if (element instanceof FlowNode) {
                    lanes = ((FlowNode)element).getLanes();
                }
                if (!((parent = element.eContainer()) instanceof SubProcess) && !(parent instanceof Process) && !(parent instanceof SubChoreography) || lanes != null && !lanes.isEmpty()) break block5;
                targetContainer = (ContainerShape)this.elements.get(parent);
                if (targetContainer == null && (childDiagram = DIUtils.findBPMNDiagram((BaseElement)element, true)) != null) {
                    targetContainer = DIUtils.findDiagram((IDiagramBehavior)this.editor.getDiagramBehavior(), childDiagram);
                }
                if (targetContainer instanceof Diagram) break block6;
                ILocation loc = Graphiti.getPeLayoutService().getLocationRelativeToDiagram((Shape)targetContainer);
                if (element instanceof ItemAwareElement && !GraphicsUtil.intersects((Shape)targetContainer, x, y, w, h)) {
                    targetContainer = diagram;
                }
                if (targetContainer == diagram) break block6;
                x -= loc.getX();
                y -= loc.getY();
                break block6;
            }
            if (lanes != null && !lanes.isEmpty()) {
                for (Lane lane : lanes) {
                    targetContainer = (ContainerShape)this.elements.get(lane);
                    ILocation loc = Graphiti.getPeLayoutService().getLocationRelativeToDiagram((Shape)targetContainer);
                    x -= loc.getX();
                    y -= loc.getY();
                }
            }
        }
        context.setTargetContainer((ContainerShape)targetContainer);
        context.setLocation(x, y);
    }

    private void handleItemAwareElement(ItemAwareElement element, AddContext context, BPMNShape shape) {
        Diagram targetContainer = null;
        int x = (int)shape.getBounds().getX();
        int y = (int)shape.getBounds().getY();
        int w = (int)shape.getBounds().getWidth();
        int h = (int)shape.getBounds().getHeight();
        ArrayList<Map.Entry<BaseElement, PictogramElement>> entries = new ArrayList<Map.Entry<BaseElement, PictogramElement>>(this.elements.entrySet());
        int i = entries.size() - 1;
        while (i >= 0) {
            ContainerShape value;
            Map.Entry<BaseElement, PictogramElement> entry = entries.get(i);
            BaseElement be = entry.getKey();
            PictogramElement pe = entry.getValue();
            if ((be instanceof Lane && FeatureSupport.isLaneOnTop((Lane)be) || be instanceof Participant && !FeatureSupport.isChoreographyParticipantBand(pe) || be instanceof FlowElementsContainer) && GraphicsUtil.intersects((Shape)(value = (ContainerShape)entry.getValue()), x, y, w, h)) {
                targetContainer = value;
                ILocation loc = Graphiti.getPeLayoutService().getLocationRelativeToDiagram((Shape)targetContainer);
                x -= loc.getX();
                y -= loc.getY();
                break;
            }
            --i;
        }
        if (targetContainer == null) {
            if (element instanceof FlowElement) {
                this.handleFlowElement((FlowElement)element, context, shape);
                return;
            }
            targetContainer = this.getDiagram((EObject)shape);
        }
        context.setTargetContainer(targetContainer);
        context.setLocation(x, y);
    }

    private void createEdge(BPMNEdge bpmnEdge) {
        BaseElement bpmnElement = bpmnEdge.getBpmnElement();
        InteractionNode source = null;
        InteractionNode target = null;
        PictogramElement se = null;
        PictogramElement te = null;
        if (bpmnElement instanceof MessageFlow) {
            source = ((MessageFlow)bpmnElement).getSourceRef();
            target = ((MessageFlow)bpmnElement).getTargetRef();
            se = this.elements.get(source);
            te = this.elements.get(target);
        } else if (bpmnElement instanceof SequenceFlow) {
            source = ((SequenceFlow)bpmnElement).getSourceRef();
            target = ((SequenceFlow)bpmnElement).getTargetRef();
            se = this.elements.get(source);
            te = this.elements.get(target);
        } else if (bpmnElement instanceof Association) {
            source = ((Association)bpmnElement).getSourceRef();
            target = ((Association)bpmnElement).getTargetRef();
            se = this.elements.get(source);
            te = this.elements.get(target);
        } else if (bpmnElement instanceof ConversationLink) {
            source = ((ConversationLink)bpmnElement).getSourceRef();
            target = ((ConversationLink)bpmnElement).getTargetRef();
            se = this.elements.get(source);
            te = this.elements.get(target);
        } else if (bpmnElement instanceof DataAssociation) {
            List sourceRef = ((DataAssociation)bpmnElement).getSourceRef();
            ItemAwareElement targetRef = ((DataAssociation)bpmnElement).getTargetRef();
            if (sourceRef != null && sourceRef.size() > 0) {
                source = (EObject)sourceRef.get(0);
            }
            target = targetRef;
            if (source != null) {
                do {
                    se = this.elements.get(source);
                    source = source.eContainer();
                } while (se == null && source.eContainer() != null);
            }
            if (target != null) {
                do {
                    te = this.elements.get(target);
                    target = target.eContainer();
                } while (te == null && target.eContainer() != null);
            }
        } else {
            if (bpmnElement == null) {
                this.diagnostics.add(4, (EObject)bpmnEdge, Messages.DIImport_Reference_not_found);
                return;
            }
            EStructuralFeature sf = bpmnElement.eClass().getEStructuralFeature("sourceRef");
            EStructuralFeature tf = bpmnElement.eClass().getEStructuralFeature("targetRef");
            if (sf != null && tf != null) {
                source = (EObject)bpmnElement.eGet(sf);
                target = (EObject)bpmnElement.eGet(tf);
                se = this.elements.get(source);
                te = this.elements.get(target);
            }
        }
        ModelUtil.addID((EObject)bpmnElement);
        if (se != null && te != null) {
            if (source != null && target != null) {
                this.addSourceAndTargetToEdge(bpmnEdge, (EObject)source, (EObject)target);
            }
            Connection conn = this.createConnectionAndSetBendpoints(bpmnEdge, se, te);
            this.elements.put(bpmnElement, (PictogramElement)conn);
        } else {
            String message = se == null && te == null ? Messages.DIImport_No_Source_or_Target : (se == null ? Messages.DIImport_No_Source : Messages.DIImport_No_Target);
            this.diagnostics.add(2, (EObject)bpmnElement, message);
        }
    }

    private void addSourceAndTargetToEdge(BPMNEdge bpmnEdge, EObject source, EObject target) {
        DiagramElement sourceElement = null;
        DiagramElement targetElement = null;
        try {
            sourceElement = bpmnEdge.getSourceElement();
            targetElement = bpmnEdge.getTargetElement();
        }
        catch (ClassCastException classCastException) {}
        if (sourceElement == null) {
            bpmnEdge.setSourceElement((DiagramElement)DIUtils.findBPMNShape((BaseElement)source));
        }
        if (targetElement == null) {
            bpmnEdge.setTargetElement((DiagramElement)DIUtils.findBPMNShape((BaseElement)target));
        }
    }

    private Connection createConnectionAndSetBendpoints(BPMNEdge bpmnEdge, PictogramElement sourcePE, PictogramElement targetPE) {
        FixPointAnchor sourceAnchor = this.createAnchor(sourcePE, bpmnEdge, true);
        FixPointAnchor targetAnchor = this.createAnchor(targetPE, bpmnEdge, false);
        AddConnectionContext context = new AddConnectionContext((Anchor)sourceAnchor, (Anchor)targetAnchor);
        BaseElement bpmnElement = bpmnEdge.getBpmnElement();
        context.setNewObject((Object)bpmnElement);
        IAddFeature addFeature = this.featureProvider.getAddFeature((IAddContext)context);
        if (this.canAdd(addFeature, (AddContext)context)) {
            context.putProperty((Object)"is.importing", (Object)true);
            ArrayList<org.eclipse.graphiti.mm.algorithms.styles.Point> bendpoints = new ArrayList<org.eclipse.graphiti.mm.algorithms.styles.Point>();
            List waypoints = bpmnEdge.getWaypoint();
            int i = 1;
            while (i < waypoints.size() - 1) {
                Point p = (Point)waypoints.get(i);
                bendpoints.add(Graphiti.getCreateService().createPoint((int)p.getX(), (int)p.getY()));
                ++i;
            }
            context.putProperty((Object)"connection.bendpoints", bendpoints);
            Connection connection = (Connection)this.featureProvider.addIfPossible((IAddContext)context);
            this.featureProvider.link((PictogramElement)connection, new Object[]{bpmnElement, bpmnEdge});
            return connection;
        }
        this.diagnostics.add(2, (EObject)bpmnElement, Messages.DIImport_No_Create_Feature);
        return null;
    }

    private FixPointAnchor createAnchor(PictogramElement pictogramElement, BPMNEdge bpmnEdge, boolean isSource) {
        Point waypoint = null;
        waypoint = isSource ? (Point)bpmnEdge.getWaypoint().get(0) : (Point)bpmnEdge.getWaypoint().get(bpmnEdge.getWaypoint().size() - 1);
        int x = (int)waypoint.getX();
        int y = (int)waypoint.getY();
        org.eclipse.graphiti.mm.algorithms.styles.Point anchorPoint = this.gaService.createPoint(x, y);
        if (pictogramElement instanceof Shape && GraphicsUtil.contains((Shape)pictogramElement, anchorPoint)) {
            IDimension size = GraphicsUtil.calculateSize((PictogramElement)((Shape)pictogramElement));
            double d = 0.75 * (double)Math.min(size.getWidth(), size.getHeight());
            org.eclipse.graphiti.mm.algorithms.styles.Point c = GraphicsUtil.getShapeCenter((AnchorContainer)((Shape)pictogramElement));
            double dd = GraphicsUtil.getLength(anchorPoint, c);
            if (dd < d) {
                waypoint = isSource ? (Point)bpmnEdge.getWaypoint().get(1) : (Point)bpmnEdge.getWaypoint().get(bpmnEdge.getWaypoint().size() - 2);
                x = (int)waypoint.getX();
                y = (int)waypoint.getY();
                anchorPoint = this.gaService.createPoint(x, y);
            }
        }
        FixPointAnchor anchor = AnchorUtil.createAnchor((AnchorContainer)pictogramElement, anchorPoint);
        return anchor;
    }

    private boolean canAdd(IAddFeature addFeature, AddContext context) {
        Diagram diagram;
        if (addFeature == null) {
            return false;
        }
        if (context.getTargetContainer() instanceof Diagram && (diagram = (Diagram)context.getTargetContainer()) != this.featureProvider.getDiagramTypeProvider().getDiagram()) {
            this.featureProvider.getDiagramTypeProvider().init(diagram, (IDiagramEditor)this.editor);
        }
        return addFeature.canAdd((IAddContext)context);
    }

    public static boolean isImporting(IContext context) {
        Object o = context.getProperty((Object)"is.importing");
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }
}

