/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ObjectEditor;
import org.eclipse.bpmn2.modeler.core.utils.ErrorUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BooleanObjectEditor
extends ObjectEditor {
    protected Button button;

    public BooleanObjectEditor(AbstractDetailComposite parent, EObject obj, EStructuralFeature feat) {
        super(parent, obj, feat);
    }

    @Override
    protected Control createControl(Composite composite, String label, int style) {
        this.createLabel(composite, label);
        this.button = this.getToolkit().createButton(composite, "", 32);
        this.button.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.button.setSelection(this.getValue().booleanValue());
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!BooleanObjectEditor.this.isWidgetUpdating) {
                    boolean checked = BooleanObjectEditor.this.button.getSelection();
                    BooleanObjectEditor.this.setValue(new Boolean(checked));
                    BooleanObjectEditor.this.button.setSelection(BooleanObjectEditor.this.getValue().booleanValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.button.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ErrorUtils.showErrorMessage(null);
            }
        });
        return this.button;
    }

    @Override
    public Boolean getValue() {
        Object v = this.getBusinessObjectDelegate().getValue(this.object, this.feature);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            if ("true".equalsIgnoreCase((String)v)) {
                return Boolean.TRUE;
            }
            try {
                if (Integer.parseInt((String)v) != 0) {
                    return Boolean.TRUE;
                }
            }
            catch (Exception exception) {}
        }
        if (v instanceof Integer && (Integer)v != 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.getEventType() == -1 || this.object == notification.getNotifier() && this.feature == notification.getFeature()) {
            Object value = this.getBusinessObjectDelegate().getValue(this.object, this.feature);
            value = value == null ? Boolean.FALSE : Boolean.valueOf(Boolean.parseBoolean(value.toString()));
            this.button.setSelection(((Boolean)value).booleanValue());
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.button.setVisible(visible);
        GridData data = (GridData)this.button.getLayoutData();
        data.exclude = !visible;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.button != null && !this.button.isDisposed()) {
            this.button.dispose();
            this.button = null;
        }
    }

    @Override
    public Control getControl() {
        return this.button;
    }
}

