/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import java.util.Date;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ReadonlyTextObjectEditor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DateTimeObjectEditor
extends ReadonlyTextObjectEditor {
    public DateTimeObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        super(parent, object, feature);
    }

    @Override
    protected Control createControl(Composite composite, String label, int style) {
        return super.createControl(composite, label, style);
    }

    @Override
    protected void buttonClicked(int buttonId) {
        Object value = this.object.eGet(this.feature);
        if (value == null) {
            value = new Date();
        }
        if (!(value instanceof Date)) {
            value = new Date();
        }
        String title = "Select " + this.getLabel().getText();
        DateTimeDialog dialog = new DateTimeDialog(this.getControl().getShell(), title, this.style);
        dialog.setDate((Date)value);
        if (dialog.open() == 0) {
            super.setValue(dialog.getDate());
        }
    }

    public static class DateTimeDialog
    extends Dialog {
        private Button okButton;
        String title;
        private Date result;
        private DateTime calendar;
        private DateTime date;
        private DateTime time;
        private int style = 1152;

        protected DateTimeDialog(Shell parentShell, String title, int syle) {
            super(parentShell);
            this.title = title;
        }

        public void setDate(Date date) {
            this.result = date == null ? new Date() : date;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = this.createMyComposite(parent);
            if ((this.style & 0x4A0) == 0) {
                this.style = 1152;
            }
            if ((this.style & 0x400) != 0) {
                this.calendar = new DateTime(composite, 1024);
                this.calendar.setDate(this.result.getYear(), this.result.getMonth(), this.result.getDay());
            } else if ((this.style & 0x20) != 0) {
                this.date = new DateTime(composite, 32);
                this.date.setDate(this.result.getYear(), this.result.getMonth(), this.result.getDay());
            }
            if ((this.style & 0x80) != 0) {
                this.time = new DateTime(composite, 128);
                this.time.setTime(this.result.getHours(), this.result.getMinutes(), this.result.getSeconds());
            }
            return composite;
        }

        private Composite createMyComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            DateTimeDialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            if (this.title != null) {
                shell.setText(this.title);
            } else {
                shell.setText("Select Date/Time");
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.result = new Date();
                if (this.calendar != null) {
                    this.result.setYear(this.calendar.getYear() - 1900);
                    this.result.setMonth(this.calendar.getMonth());
                    this.result.setDate(this.calendar.getDay());
                }
                if (this.date != null) {
                    this.result.setYear(this.date.getYear() - 1900);
                    this.result.setMonth(this.date.getMonth());
                    this.result.setDate(this.date.getDay());
                }
                if (this.time != null) {
                    this.result.setHours(this.time.getHours());
                    this.result.setMinutes(this.time.getMinutes());
                    this.result.setSeconds(this.time.getSeconds());
                }
            } else {
                this.result = null;
            }
            super.buttonPressed(buttonId);
        }

        public Date getDate() {
            return this.result;
        }
    }
}

