/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNLabel;
import org.eclipse.bpmn2.di.BPMNLabelStyle;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.BpmnDiPackage;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.IExtensionValueAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectPropertyProvider;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerResourceSetImpl;
import org.eclipse.bpmn2.modeler.core.model.DIZorderComparator;
import org.eclipse.bpmn2.modeler.core.model.Messages;
import org.eclipse.bpmn2.modeler.core.model.ModelDecorator;
import org.eclipse.bpmn2.modeler.core.model.RootElementComparator;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.runtime.TypeLanguageDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.ImportUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.NamespaceUtil;
import org.eclipse.bpmn2.util.Bpmn2ResourceImpl;
import org.eclipse.bpmn2.util.ImportHelper;
import org.eclipse.bpmn2.util.OnlyContainmentTypeInfo;
import org.eclipse.bpmn2.util.QNameURIHandler;
import org.eclipse.bpmn2.util.XmlExtendedMetadata;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.DcFactory;
import org.eclipse.dd.dc.DcPackage;
import org.eclipse.dd.dc.Point;
import org.eclipse.dd.di.DiPackage;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EObjectWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.ElementHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLString;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.xml.sax.helpers.DefaultHandler;

public class Bpmn2ModelerResourceImpl
extends Bpmn2ResourceImpl {
    public static final String BPMN2_CONTENT_TYPE_ID = "org.eclipse.bpmn2.content-type.xml";
    protected Bpmn2ResourceImpl.BpmnXmlHelper xmlHelper;
    protected QNameURIHandler uriHandler;
    public HashMap xmlNameToFeatureMap = new HashMap();
    protected static HashSet<EStructuralFeature> qnameMap = new HashSet();

    static {
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getExtension_Definition());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getRelationship_Sources());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getRelationship_Targets());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getAssociation_SourceRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getAssociation_TargetRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getGroup_CategoryValueRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getCorrelationKey_CorrelationPropertyRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getCorrelationProperty_Type());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getCorrelationPropertyBinding_CorrelationPropertyRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getCorrelationPropertyRetrievalExpression_MessageRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getCorrelationSubscription_CorrelationPropertyBinding());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getError_StructureRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getEscalation_StructureRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getFlowElement_CategoryValueRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getFlowNode_Incoming());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getFlowNode_Outgoing());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getFormalExpression_EvaluatesToTypeRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getInputOutputBinding_OperationRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getItemDefinition_StructureRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getMessage_ItemRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getResourceParameter_Type());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getInterface_ImplementationRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getOperation_InMessageRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getOperation_OutMessageRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getOperation_ErrorRefs());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getOperation_ImplementationRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getCallConversation_CalledCollaborationRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getConversationAssociation_InnerConversationNodeRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getConversationAssociation_OuterConversationNodeRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getConversationLink_SourceRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getConversationLink_TargetRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getConversationNode_MessageFlowRefs());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getConversationNode_ParticipantRefs());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getConversationNode_CorrelationKeys());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getMessageFlow_SourceRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getMessageFlow_TargetRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getMessageFlow_MessageRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getMessageFlowAssociation_InnerMessageFlowRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getMessageFlowAssociation_OuterMessageFlowRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getParticipant_InterfaceRefs());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getParticipant_EndPointRefs());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getParticipant_ProcessRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getParticipantAssociation_InnerParticipantRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getParticipantAssociation_OuterParticipantRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getCallableElement_SupportedInterfaceRefs());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getCallActivity_CalledElementRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getMultiInstanceLoopCharacteristics_LoopDataInputRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getMultiInstanceLoopCharacteristics_LoopDataOutputRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getMultiInstanceLoopCharacteristics_OneBehaviorEventRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getMultiInstanceLoopCharacteristics_NoneBehaviorEventRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getReceiveTask_MessageRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getReceiveTask_OperationRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getResourceRole_ResourceRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getSendTask_MessageRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getSendTask_OperationRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getServiceTask_OperationRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getItemAwareElement_ItemSubjectRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getBoundaryEvent_AttachedToRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getCatchEvent_EventDefinitionRefs());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getCompensateEventDefinition_ActivityRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getErrorEventDefinition_ErrorRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getEscalationEventDefinition_EscalationRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getLinkEventDefinition_Source());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getLinkEventDefinition_Target());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getMessageEventDefinition_OperationRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getMessageEventDefinition_MessageRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getSignal_StructureRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getSignalEventDefinition_SignalRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getThrowEvent_EventDefinitionRefs());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getProcess_Supports());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getProcess_DefinitionalCollaborationRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getLane_PartitionElementRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getGlobalChoreographyTask_InitiatingParticipantRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getChoreographyActivity_ParticipantRefs());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getChoreographyActivity_InitiatingParticipantRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getChoreographyTask_MessageFlowRef());
        qnameMap.add((EStructuralFeature)Bpmn2Package.eINSTANCE.getCallChoreography_CalledChoreographyRef());
        qnameMap.add((EStructuralFeature)BpmnDiPackage.eINSTANCE.getBPMNPlane_BpmnElement());
        qnameMap.add((EStructuralFeature)BpmnDiPackage.eINSTANCE.getBPMNShape_BpmnElement());
        qnameMap.add((EStructuralFeature)BpmnDiPackage.eINSTANCE.getBPMNShape_ChoreographyActivityShape());
        qnameMap.add((EStructuralFeature)BpmnDiPackage.eINSTANCE.getBPMNEdge_BpmnElement());
        qnameMap.add((EStructuralFeature)BpmnDiPackage.eINSTANCE.getBPMNEdge_SourceElement());
        qnameMap.add((EStructuralFeature)BpmnDiPackage.eINSTANCE.getBPMNEdge_TargetElement());
        qnameMap.add((EStructuralFeature)BpmnDiPackage.eINSTANCE.getBPMNLabel_LabelStyle());
    }

    public Bpmn2ModelerResourceImpl(URI uri) {
        super(uri);
        this.xmlHelper = (Bpmn2ResourceImpl.BpmnXmlHelper)this.createXMLHelper();
        this.uriHandler = new FragmentQNameURIHandler(this.xmlHelper);
        this.uriHandler.setBaseURI(uri);
        this.getDefaultLoadOptions().put("URI_HANDLER", this.uriHandler);
        this.getDefaultLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
        this.getDefaultLoadOptions().put("DISABLE_NOTIFY", true);
        this.getDefaultSaveOptions().put("URI_HANDLER", this.uriHandler);
        XmlExtendedMetadata extendedMetadata = new XmlExtendedMetadata();
        this.getDefaultSaveOptions().put("EXTENDED_META_DATA", extendedMetadata);
        this.getDefaultLoadOptions().put("EXTENDED_META_DATA", extendedMetadata);
        this.getDefaultSaveOptions().put("SAVE_TYPE_INFORMATION", new OnlyNamedContainmentTypeInfo());
        this.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        this.getDefaultLoadOptions().put("USE_LEXICAL_HANDLER", Boolean.TRUE);
        this.getDefaultSaveOptions().put("ELEMENT_HANDLER", new ElementHandlerImpl(true));
        this.getDefaultSaveOptions().put("ENCODING", "UTF-8");
        this.getDefaultSaveOptions().put("USE_CACHED_LOOKUP_TABLE", new ArrayList());
        this.getDefaultLoadOptions().put("USE_XML_NAME_TO_FEATURE_MAP", this.xmlNameToFeatureMap);
        this.eAdapters().add((Object)this.oppositeReferenceAdapter);
    }

    public void save(Map<?, ?> options) throws IOException {
        this.uriHandler.setBaseURI(this.getURI());
        this.xmlHelper.setResource((XMLResource)this);
        super.save(options);
    }

    protected XMLHelper createXMLHelper() {
        if (this.xmlHelper != null) {
            return this.xmlHelper;
        }
        return new Bpmn2ModelerXmlHelper(this);
    }

    protected XMLLoad createXMLLoad() {
        return new XMLLoadImpl(this.createXMLHelper()){
            Bpmn2ModelerXmlHandler handler;

            protected DefaultHandler makeDefaultHandler() {
                this.handler = new Bpmn2ModelerXmlHandler(this.resource, this.helper, this.options);
                return this.handler;
            }

            public void load(XMLResource resource, InputStream inputStream, Map<?, ?> options) throws IOException {
                try {
                    super.load(resource, inputStream, options);
                }
                catch (Exception e) {
                    BPMNDiagnostic error = new BPMNDiagnostic(e.getMessage());
                    error.setLine(this.handler.getLineNumber());
                    error.setColumn(this.handler.getColumnNumber());
                    error.setLocation(this.handler.getLocation());
                    if (!resource.getErrors().contains((Object)error)) {
                        resource.getErrors().add((Object)error);
                    }
                    throw new IOException(e);
                }
            }
        };
    }

    protected XMLSave createXMLSave() {
        this.prepareSave();
        return new Bpmn2ModelerXMLSave(this.createXMLHelper()){};
    }

    protected void prepareSave() {
        TreeIterator iter = this.getAllContents();
        while (iter.hasNext()) {
            EObject cur = (EObject)iter.next();
            this.setDefaultId(cur);
        }
    }

    private void setDefaultId(EObject obj) {
        EAttribute idAttr;
        if (obj.eClass() != null && (idAttr = obj.eClass().getEIDAttribute()) != null && !obj.eIsSet((EStructuralFeature)idAttr)) {
            obj.eSetDeliver(false);
            ModelUtil.setID(obj);
            obj.eSetDeliver(true);
        }
    }

    public void setURI(URI uri) {
        super.setURI(uri);
        this.xmlHelper.setResource((XMLResource)this);
        this.uriHandler.setBaseURI(uri);
    }

    static class BPMNDiagnostic
    implements Resource.Diagnostic {
        private String message;
        private String location;
        private int column;
        private int line;

        public BPMNDiagnostic(String message) {
            this.message = message;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public String getLocation() {
            return this.location;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public int getColumn() {
            return this.column;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public int getLine() {
            return this.line;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BPMNDiagnostic) {
                BPMNDiagnostic that = (BPMNDiagnostic)obj;
                return this.message != null && this.message.equals(that.message) && this.line == that.line && this.column == that.column;
            }
            if (obj instanceof Exception) {
                String message = ((Exception)obj).getMessage();
                return this.message.equals(message);
            }
            return super.equals(obj);
        }
    }

    public class Bpmn2ModelerXMLSave
    extends XMLSaveImpl {
        protected float minX;
        protected float minY;
        protected int lineNum;
        protected int lineOffset;
        protected Bpmn2Preferences preferences;

        public Bpmn2ModelerXMLSave(XMLHelper helper) {
            super(helper);
            this.minX = Float.MAX_VALUE;
            this.minY = Float.MAX_VALUE;
            this.lineNum = 1;
            this.lineOffset = 0;
            helper.getPrefixToNamespaceMap().clear();
            this.preferences = Bpmn2Preferences.getInstance((Resource)helper.getResource());
        }

        protected void addNamespaceDeclarations() {
            Definitions definitions;
            String typeLanguage;
            EMap map = this.helper.getPrefixToNamespaceMap();
            if (!map.containsValue((Object)(typeLanguage = (definitions = ModelUtil.getDefinitions(this.helper.getResource())).getTypeLanguage()))) {
                String prefix = "tl";
                TargetRuntime rt = TargetRuntime.getCurrentRuntime();
                TypeLanguageDescriptor tld = rt.getTypeLanguageDescriptor(typeLanguage);
                if (tld != null) {
                    prefix = tld.getPrefix();
                }
                this.doc.addAttributeNS("xmlns", prefix, typeLanguage);
            }
            super.addNamespaceDeclarations();
        }

        protected void init(XMLResource resource, Map<?, ?> options) {
            super.init(resource, options);
            this.featureTable = new Bpmn2Lookup(this.map, this.extendedMetaData, this.elementHandler);
            List<BPMNDiagram> diagrams = this.getAll(BPMNDiagram.class, (Resource)resource);
            for (BPMNDiagram bpmnDiagram : diagrams) {
                this.findMinXY(bpmnDiagram);
            }
            this.doc = this.createXMLString();
            if (Bpmn2ModelerResourceImpl.this.contents.size() > 0 && Bpmn2ModelerResourceImpl.this.contents.get(0) instanceof Bpmn2ModelerFactory.Bpmn2ModelerDocumentRootImpl) {
                Bpmn2ModelerFactory.Bpmn2ModelerDocumentRootImpl documentRoot = (Bpmn2ModelerFactory.Bpmn2ModelerDocumentRootImpl)((Object)Bpmn2ModelerResourceImpl.this.contents.get(0));
                Definitions definitions = ModelUtil.getDefinitions(this.helper.getResource());
                try {
                    documentRoot.setDeliver(false);
                    documentRoot.eSetDeliver(false);
                    FeatureMap featureMap = documentRoot.getMixed();
                    if (featureMap.size() > 0) {
                        String comment = " origin at X=" + (this.minX < 0.0f ? this.minX : 0.0f) + " Y=" + (this.minY < 0.0f ? this.minY : 0.0f) + " ";
                        if (((FeatureMap.Entry)featureMap.get(0)).getEStructuralFeature() != XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__COMMENT) {
                            featureMap.add(0, (EStructuralFeature)XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__COMMENT, (Object)comment);
                        } else {
                            FeatureMap.Entry e = FeatureMapUtil.createEntry((EStructuralFeature)XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__COMMENT, (Object)comment);
                            featureMap.set(0, (Object)e);
                        }
                    }
                    definitions.eSetDeliver(false);
                    definitions.setExporter("org.eclipse.bpmn2.modeler.core");
                    String version = (String)Platform.getBundle((String)"org.eclipse.bpmn2.modeler.core").getHeaders().get("Bundle-Version");
                    version = version.replaceAll(".qualifier", "");
                    definitions.setExporterVersion(version);
                }
                finally {
                    documentRoot.setDeliver(true);
                    documentRoot.eSetDeliver(true);
                    definitions.eSetDeliver(true);
                }
            }
        }

        protected XMLString createXMLString() {
            return new Bpmn2ModelerXMLString(Bpmn2ModelerResourceImpl.this.publicId, Bpmn2ModelerResourceImpl.this.systemId);
        }

        protected Bpmn2ModelerXMLString getXMLString() {
            if (this.doc == null) {
                this.createXMLString();
            }
            return (Bpmn2ModelerXMLString)this.doc;
        }

        protected void endSave(List<? extends EObject> contents) throws IOException {
            Bpmn2ModelerFactory.Bpmn2ModelerDocumentRootImpl documentRoot = null;
            if (contents.size() > 0 && contents.get(0) instanceof Bpmn2ModelerFactory.Bpmn2ModelerDocumentRootImpl) {
                documentRoot = (Bpmn2ModelerFactory.Bpmn2ModelerDocumentRootImpl)contents.get(0);
                documentRoot.setDeliver(false);
                documentRoot.eSetDeliver(false);
            }
            try {
                super.endSave(contents);
            }
            finally {
                if (documentRoot != null) {
                    documentRoot.setDeliver(true);
                    documentRoot.eSetDeliver(true);
                }
            }
        }

        protected boolean shouldSaveFeature(EObject o, EStructuralFeature f) {
            Documentation doc;
            BPMNShape s;
            if (o instanceof BPMNShape && f == BpmnDiPackage.eINSTANCE.getBPMNShape_IsHorizontal() && ((s = (BPMNShape)o).getBpmnElement() instanceof Lane || s.getBpmnElement() instanceof Participant)) {
                return true;
            }
            if (o instanceof Bounds || o instanceof Point) {
                return true;
            }
            if (f != null && (f.getEType() == Bpmn2Package.eINSTANCE.getExpression() || f.getEType() == Bpmn2Package.eINSTANCE.getFormalExpression())) {
                FormalExpression formalExpression;
                String body;
                Expression expression = (Expression)o.eGet(f);
                if (expression == null) {
                    return false;
                }
                if (expression instanceof FormalExpression && (body = ModelUtil.getExpressionBody(formalExpression = (FormalExpression)expression)) == null) {
                    return false;
                }
            }
            if (o != null && o instanceof Documentation && ((doc = (Documentation)o).getText() == null || doc.getText().isEmpty())) {
                return false;
            }
            if (f != null && f.getEType() == Bpmn2Package.eINSTANCE.getDocumentation()) {
                EList docList = (EList)o.eGet(f);
                if (docList.isEmpty()) {
                    return false;
                }
                int empty = 0;
                for (Documentation doc2 : docList) {
                    if (doc2.getText() != null && !doc2.getText().isEmpty()) continue;
                    ++empty;
                }
                if (empty == docList.size()) {
                    return false;
                }
            }
            if (Bpmn2Package.eINSTANCE.getFormalExpression_Body().equals(f) || Bpmn2Package.eINSTANCE.getDocumentation_Text().equals(f)) {
                return false;
            }
            if (o instanceof DataAssociation && "assignment".equals(f.getName())) {
                DataAssociation da = (DataAssociation)o;
                for (Adapter a : da.getAssignment()) {
                    String body;
                    String body2;
                    Expression from = a.getFrom();
                    if (from instanceof FormalExpression && ((body2 = ModelUtil.getExpressionBody((FormalExpression)from)) == null || body2.isEmpty())) {
                        return false;
                    }
                    Expression to = a.getTo();
                    if (!(to instanceof FormalExpression) || (body = ModelUtil.getExpressionBody((FormalExpression)to)) != null && !body.isEmpty()) continue;
                    return false;
                }
            }
            if (f == Bpmn2Package.eINSTANCE.getBaseElement_ExtensionValues()) {
                boolean shouldSave = true;
                for (ExtensionAttributeValue ev : (EList)o.eGet(f)) {
                    BasicFeatureMap map = (BasicFeatureMap)ev.getValue();
                    block3: for (FeatureMap.Entry entry : map) {
                        Object v = entry.getValue();
                        if (!(v instanceof EObject)) continue;
                        for (Adapter a : ((EObject)v).eAdapters()) {
                            if (!(a instanceof IExtensionValueAdapter) || ((IExtensionValueAdapter)a).shouldSaveElement((EObject)v)) continue;
                            shouldSave = false;
                            continue block3;
                        }
                    }
                }
                return shouldSave;
            }
            for (Adapter a : o.eAdapters()) {
                if (!(a instanceof IExtensionValueAdapter) || ((IExtensionValueAdapter)a).shouldSaveFeature(o, f)) continue;
                return false;
            }
            return super.shouldSaveFeature(o, f);
        }

        protected <T> List<T> getAll(Class<T> class1, Resource resource) {
            ArrayList<Object> l = new ArrayList<Object>();
            TreeIterator contents = resource.getAllContents();
            while (contents.hasNext()) {
                Object t = contents.next();
                if (!class1.isInstance(t)) continue;
                l.add(t);
            }
            return l;
        }

        protected void findMinXY(BPMNDiagram bpmnDiagram) {
            EList elements = (EList)bpmnDiagram.getPlane().getPlaneElement();
            for (DiagramElement e : elements) {
                Bounds b;
                if (e instanceof BPMNShape) {
                    b = ((BPMNShape)e).getBounds();
                    this.minX = Math.min(this.minX, b.getX());
                    this.minY = Math.min(this.minY, b.getY());
                    continue;
                }
                if (e instanceof BPMNEdge) {
                    List points = ((BPMNEdge)e).getWaypoint();
                    for (Point p : points) {
                        this.minX = Math.min(this.minX, p.getX());
                        this.minY = Math.min(this.minY, p.getY());
                    }
                    continue;
                }
                if (!(e instanceof BPMNLabel)) continue;
                b = ((BPMNLabel)e).getBounds();
                this.minX = Math.min(this.minX, b.getX());
                this.minY = Math.min(this.minY, b.getY());
            }
        }

        protected void saveContainedMany(EObject o, EStructuralFeature f) {
            if (o instanceof BPMNPlane && f == DiPackage.eINSTANCE.getPlane_PlaneElement()) {
                BPMNPlane plane = (BPMNPlane)o;
                BasicEList originalList = new BasicEList();
                originalList.addAll((Collection)plane.getPlaneElement());
                plane.eSetDeliver(false);
                ECollections.sort((EList)((EList)plane.getPlaneElement()), (Comparator)new DIZorderComparator());
                super.saveContainedMany(o, f);
                ECollections.setEList((EList)((EList)plane.getPlaneElement()), (List)originalList);
                plane.eSetDeliver(true);
            } else if (o instanceof Definitions && f == Bpmn2Package.eINSTANCE.getDefinitions_RootElements()) {
                Definitions definitions = (Definitions)o;
                BasicEList originalList = new BasicEList();
                originalList.addAll((Collection)definitions.getRootElements());
                definitions.eSetDeliver(false);
                ECollections.sort((EList)((EList)definitions.getRootElements()), (Comparator)new RootElementComparator());
                super.saveContainedMany(o, f);
                ECollections.setEList((EList)((EList)definitions.getRootElements()), (List)originalList);
                definitions.eSetDeliver(true);
            } else {
                super.saveContainedMany(o, f);
            }
        }

        protected void saveElement(EObject o, EStructuralFeature f) {
            List points;
            Bounds b;
            for (Adapter a : o.eAdapters()) {
                if (!(a instanceof IExtensionValueAdapter) || ((IExtensionValueAdapter)a).shouldSaveElement(o)) continue;
                return;
            }
            if (o instanceof BPMNLabel && !this.preferences.getSaveBPMNLabels()) {
                return;
            }
            if (o instanceof BPMNLabelStyle) {
                boolean save = false;
                if (this.preferences.getSaveBPMNLabels()) {
                    Definitions definitions = ModelUtil.getDefinitions(o);
                    TreeIterator iter = definitions.eAllContents();
                    while (iter.hasNext()) {
                        EObject eo = (EObject)iter.next();
                        if (!(eo instanceof BPMNLabel) || ((BPMNLabel)eo).getLabelStyle() != o) continue;
                        save = true;
                    }
                }
                if (!save) {
                    return;
                }
            }
            float oldX = 0.0f;
            float oldY = 0.0f;
            ArrayList<Point> oldPoints = null;
            if (this.minX < 0.0f || this.minY < 0.0f) {
                if (o instanceof BPMNShape) {
                    b = ((BPMNShape)o).getBounds();
                    b.eSetDeliver(false);
                    if (this.minX < 0.0f) {
                        oldX = b.getX();
                        b.setX(oldX - this.minX);
                    }
                    if (this.minY < 0.0f) {
                        oldY = b.getY();
                        b.setY(oldY - this.minY);
                    }
                } else if (o instanceof BPMNEdge) {
                    points = ((BPMNEdge)o).getWaypoint();
                    oldPoints = new ArrayList<Point>();
                    for (Point p : points) {
                        p.eSetDeliver(false);
                        Point oldPoint = DcFactory.eINSTANCE.createPoint();
                        oldPoint.setX(p.getX());
                        oldPoint.setY(p.getY());
                        oldPoints.add(oldPoint);
                        if (this.minX < 0.0f) {
                            p.setX(p.getX() - this.minX);
                        }
                        if (!(this.minY < 0.0f)) continue;
                        p.setY(p.getY() - this.minY);
                    }
                } else if (o instanceof BPMNLabel && (b = ((BPMNLabel)o).getBounds()) != null) {
                    b.eSetDeliver(false);
                    if (this.minX < 0.0f) {
                        oldX = b.getX();
                        b.setX(oldX - this.minX);
                    }
                    if (this.minY < 0.0f) {
                        oldY = b.getY();
                        b.setY(oldY - this.minY);
                    }
                }
            }
            super.saveElement(o, f);
            if (this.minX < 0.0f || this.minY < 0.0f) {
                if (o instanceof BPMNShape) {
                    b = ((BPMNShape)o).getBounds();
                    if (this.minX < 0.0f) {
                        b.setX(oldX);
                    }
                    if (this.minY < 0.0f) {
                        b.setY(oldY);
                    }
                    b.eSetDeliver(true);
                } else if (o instanceof BPMNEdge) {
                    points = ((BPMNEdge)o).getWaypoint();
                    int index = 0;
                    for (Point p : points) {
                        if (this.minX < 0.0f) {
                            p.setX(((Point)oldPoints.get(index)).getX());
                        }
                        if (this.minY < 0.0f) {
                            p.setY(((Point)oldPoints.get(index)).getY());
                        }
                        p.eSetDeliver(true);
                        ++index;
                    }
                } else if (o instanceof BPMNLabel && (b = ((BPMNLabel)o).getBounds()) != null) {
                    if (this.minX < 0.0f) {
                        b.setX(oldX);
                    }
                    if (this.minY < 0.0f) {
                        b.setY(oldY);
                    }
                    b.eSetDeliver(true);
                }
            }
        }

        protected String convertURI(String s) {
            URI uri = this.helper.deresolve(URI.createURI((String)s));
            return uri.toString();
        }

        public void traverse(List<? extends EObject> contents) {
            for (EObject eObject : contents) {
                if (!(eObject instanceof Definitions)) continue;
                List roots = ((Definitions)eObject).getRootElements();
                Process p = null;
                for (RootElement root : roots) {
                    if (!(root instanceof Process)) continue;
                    p = (Process)root;
                }
                if (p == null) continue;
                ((Definitions)eObject).getRootElements().remove(p);
                ((Definitions)eObject).getRootElements().add((RootElement)p);
            }
            super.traverse(contents);
        }

        public class Bpmn2Lookup
        extends XMLSaveImpl.Lookup {
            public Bpmn2Lookup(XMLResource.XMLMap map, ExtendedMetaData extendedMetaData, XMLResource.ElementHandler elementHandler) {
                super(map, extendedMetaData, elementHandler);
            }

            public EStructuralFeature[] getFeatures(EClass cls) {
                EStructuralFeature[] featureList;
                int index = this.getIndex(cls);
                EClass c = this.classes[index];
                if (c == cls) {
                    return this.features[index];
                }
                EStructuralFeature[] newFeatureList = featureList = this.listFeatures(cls);
                if (c == null) {
                    newFeatureList = this.reorderFeatureList(cls, featureList);
                    this.classes[index] = cls;
                    this.features[index] = newFeatureList;
                    this.featureKinds[index] = this.listKinds(newFeatureList);
                }
                return newFeatureList;
            }

            protected EStructuralFeature[] reorderFeatureList(EClass cls, EStructuralFeature[] featureList) {
                return featureList;
            }

            protected EStructuralFeature[] reorderFeatureList(EClass cls, EStructuralFeature[] featureList, String[] featureNames) {
                EStructuralFeature[] newFeatureList = new EStructuralFeature[featureList.length];
                int[] indexMap = new int[featureList.length];
                int i = 0;
                while (i < indexMap.length) {
                    indexMap[i] = -1;
                    ++i;
                }
                int startIndex = Integer.MAX_VALUE;
                int i2 = 0;
                while (i2 < featureList.length) {
                    int j = 0;
                    while (j < featureNames.length) {
                        if (featureList[i2].getName().equals(featureNames[j]) && i2 < startIndex) {
                            startIndex = i2;
                            break;
                        }
                        ++j;
                    }
                    ++i2;
                }
                int newIndex = 0;
                while (newIndex < featureNames.length) {
                    String fn = featureNames[newIndex];
                    int oldIndex = 0;
                    while (oldIndex < featureList.length) {
                        EStructuralFeature f = featureList[oldIndex];
                        if (f.getName().equalsIgnoreCase(fn)) {
                            indexMap[oldIndex] = newIndex + startIndex;
                            break;
                        }
                        ++oldIndex;
                    }
                    ++newIndex;
                }
                int oldIndex = 0;
                while (oldIndex < featureList.length) {
                    EStructuralFeature cfr_ignored_0 = featureList[oldIndex];
                    int newIndex2 = indexMap[oldIndex];
                    if (newIndex2 >= 0) {
                        newFeatureList[newIndex2] = featureList[oldIndex];
                    } else {
                        newFeatureList[oldIndex] = featureList[oldIndex];
                    }
                    ++oldIndex;
                }
                return newFeatureList;
            }
        }

        protected class Bpmn2ModelerXMLString
        extends XMLString {
            public Bpmn2ModelerXMLString(String publicId, String systemId) {
                super(Integer.MAX_VALUE, publicId, systemId, null);
            }

            public void addAttribute(String name, String value) {
                int i;
                String prefix;
                if ("http://www.w3.org/2001/XMLSchema-instance".equals(value) && name.startsWith("xmlns:") && !"xsi".equals(prefix = name.substring((i = name.indexOf(":")) + 1))) {
                    return;
                }
                if (name.contains(":schemaLocation") && !"xsi:schemaLocation".equals(name)) {
                    return;
                }
                super.addAttribute(name, value);
            }

            public void addAttributeNS(String prefix, String localName, String value) {
                if ("http://www.w3.org/2001/XMLSchema-instance".equals(value) && !"xsi".equals(localName)) {
                    return;
                }
                super.addAttributeNS(prefix, localName, value);
            }

            public void addLine() {
                ++Bpmn2ModelerXMLSave.this.lineNum;
                super.addLine();
                Bpmn2ModelerXMLSave.this.lineOffset = this.getLength();
            }

            public int getLineNum() {
                return Bpmn2ModelerXMLSave.this.lineNum;
            }

            public int getColumnNum() {
                return this.getLength() - Bpmn2ModelerXMLSave.this.lineOffset + 1;
            }
        }
    }

    protected static class Bpmn2ModelerXmlHandler
    extends Bpmn2ResourceImpl.BpmnXmlHandler {
        Bpmn2Preferences preferences = null;
        ImportUtil importHandler = new ImportUtil();
        String targetNamespace = null;

        public Bpmn2ModelerXmlHandler(XMLResource xmiResource, XMLHelper helper, Map<?, ?> options) {
            super(xmiResource, helper, options);
        }

        public void startDocument() {
            super.startDocument();
            Bpmn2ModelerFactory.setEnableModelExtensions(false);
            this.preferences = Bpmn2Preferences.getInstance((Resource)this.xmlResource);
        }

        public void endDocument() {
            String prefix;
            super.endDocument();
            Definitions definitions = ModelUtil.getDefinitions(this.xmlResource);
            String typeLanguage = definitions.getTypeLanguage();
            if (typeLanguage != null && (prefix = NamespaceUtil.getPrefixForNamespace((Resource)this.helper.getResource(), typeLanguage)) == null) {
                TargetRuntime rt = TargetRuntime.getCurrentRuntime();
                TypeLanguageDescriptor tld = rt.getTypeLanguageDescriptor(typeLanguage);
                if (tld != null) {
                    prefix = tld.getPrefix();
                }
                NamespaceUtil.addNamespace((Resource)this.helper.getResource(), prefix, typeLanguage);
            }
            for (Import imp : definitions.getImports()) {
                try {
                    Object importObject = this.importHandler.loadImport(imp);
                    if (importObject == null) continue;
                    this.importHandler.addImportObjects(imp, importObject);
                }
                catch (Exception e) {
                    BPMNDiagnostic error = new BPMNDiagnostic(e.getMessage());
                    error.setLine(this.getLineNumber());
                    error.setColumn(this.getColumnNumber());
                    error.setLocation(this.getLocation());
                    this.xmlResource.getErrors().add((Object)error);
                }
            }
            for (BPMNDiagram d : definitions.getDiagrams()) {
                ExtendedPropertiesAdapter epa = ExtendedPropertiesAdapter.adapt(d);
                if (epa == null) continue;
                epa.setProperty("long.description", epa.getDescription((EObject)d));
            }
            Bpmn2ModelerFactory.setEnableModelExtensions(true);
        }

        protected void handleForwardReferences(boolean isEndDocument) {
            if (isEndDocument) {
                ArrayList<XMLHandler.SingleReference> resolved = new ArrayList<XMLHandler.SingleReference>();
                for (XMLHandler.SingleReference ref : this.forwardSingleReferences) {
                    String id;
                    EStructuralFeature referencingFeature;
                    EObject referencingObject;
                    EObject referencedObject = null;
                    try {
                        referencedObject = this.xmlResource.getEObject((String)ref.getValue());
                    }
                    catch (RuntimeException runtimeException) {}
                    if (referencedObject != null || (referencedObject = this.importHandler.resolveExternalReference(referencingObject = ref.getObject(), referencingFeature = ref.getFeature(), id = (String)ref.getValue())) == null) continue;
                    resolved.add(ref);
                    if (!this.shouldResolveExternals(referencingObject, referencedObject, id)) continue;
                    this.importHandler.addImport((Resource)this.xmlResource, (Object)ModelUtil.getDefinitions(referencedObject));
                    this.xmlResource.getResourceSet().getResources().add((Object)referencedObject.eResource());
                    this.setFeatureValue(referencingObject, referencingFeature, referencedObject, ref.getPosition());
                }
                if (!resolved.isEmpty()) {
                    this.forwardSingleReferences.removeAll(resolved);
                }
            }
            super.handleForwardReferences(isEndDocument);
        }

        private boolean shouldResolveExternals(EObject referencingObject, EObject referencedObject, String id) {
            if (this.preferences.getResolveExternals() == 0) {
                return false;
            }
            if (this.preferences.getResolveExternals() == 1) {
                return true;
            }
            try {
                Resource resource = referencedObject.eResource();
                Path path = new Path(resource.getURI().toPlatformString(true));
                boolean doit = MessageDialog.openQuestion((Shell)new Shell(), (String)Messages.Bpmn2ModelerResourceSetImpl_External_Reference_Found_Title, (String)NLS.bind((String)Messages.Bpmn2ModelerResourceSetImpl_External_Reference_Found_Message, (Object[])new Object[]{referencedObject.eClass().getName(), id, String.valueOf(ModelUtil.getLabel(referencingObject)) + " \"" + ModelUtil.getName((BaseElement)referencingObject) + "\"", path.toString()}));
                return doit;
            }
            catch (Exception exception) {
                return true;
            }
        }

        protected EStructuralFeature getFeature(EObject object, String prefix, String name, boolean isElement) {
            EStructuralFeature feature = null;
            String nsURI = prefix == null ? this.targetNamespace : this.helper.getURI(prefix);
            ModelDecorator md = ModelDecorator.getModelDecorator(nsURI);
            if (md != null && (feature = md.getEStructuralFeature(object, name)) != null) {
                return feature;
            }
            feature = super.getFeature(object, prefix, name, isElement);
            return feature;
        }

        protected EObject createObjectFromFeatureType(EObject peekObject, EStructuralFeature feature) {
            ExtendedPropertiesAdapter epa;
            int lineNumber = this.getLineNumber();
            EObject newObject = null;
            String nsURI = ExtendedMetaData.INSTANCE.getNamespace(feature);
            EPackage pkg = ModelDecorator.getEPackage(nsURI);
            if (pkg != null) {
                ExtendedPropertiesAdapter epa2;
                EClassifier eType = feature.getEType();
                newObject = pkg.getEFactoryInstance().create((EClass)eType);
                if (feature != null && (epa2 = ExtendedPropertiesAdapter.adapt(peekObject)) != null) {
                    epa2.getFeatureDescriptor(feature).setValue(newObject);
                    this.processObject(newObject);
                    this.handleObjectAttribs(newObject);
                }
            } else {
                newObject = super.createObjectFromFeatureType(peekObject, feature);
                TargetRuntime rt = TargetRuntime.getCurrentRuntime();
                String id = rt.getCustomTaskId(newObject);
                if (id != null) {
                    EFactory factory = newObject.eClass().getEPackage().getEFactoryInstance();
                    ObjectPropertyProvider adapter = ObjectPropertyProvider.adapt((EObject)factory, (Resource)this.xmlResource);
                    try {
                        this.objects.pop();
                        this.mixedTargets.pop();
                        this.types.pop();
                        EcoreUtil.delete((EObject)newObject);
                        adapter.setProperty("custom.element.id", id);
                        newObject = super.createObjectFromFeatureType(peekObject, feature);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (newObject != null && (epa = ExtendedPropertiesAdapter.adapt(newObject)) != null) {
                epa.setProperty("line.number", lineNumber);
            }
            return newObject;
        }

        protected void setFeatureValue(EObject object, EStructuralFeature feature, Object value, int position) {
            EStructuralFeature f;
            ModelDecorator md = ModelDecorator.getModelDecorator(feature);
            if (md != null && (f = md.getEStructuralFeature(object, feature.getName())) != null) {
                ExtendedPropertiesAdapter epa = ExtendedPropertiesAdapter.adapt(object);
                epa.getFeatureDescriptor(f).setValue(value, position);
                return;
            }
            super.setFeatureValue(object, feature, value, position);
        }

        protected void handleObjectAttribs(EObject obj) {
            super.handleObjectAttribs(obj);
            if (this.attribs != null) {
                int i = 0;
                int size = this.attribs.getLength();
                while (i < size) {
                    String name = this.attribs.getQName(i);
                    if (name.equals("xmlns")) {
                        String namespaceURI = this.attribs.getValue(i);
                        for (EStructuralFeature f : obj.eClass().getEAllStructuralFeatures()) {
                            String localpart;
                            Object value;
                            if (!qnameMap.contains(f) || !ModelUtil.isStringWrapper(value = obj.eGet(f)) || (localpart = ModelUtil.getStringWrapperValue(value)) == null || localpart.isEmpty() || localpart.contains(":")) continue;
                            String prefix = this.helper.getPrefix(namespaceURI);
                            if (prefix == null || prefix.isEmpty()) {
                                int index = 0;
                                while (true) {
                                    prefix = "ns" + index;
                                    String ns = (String)this.helper.getPrefixToNamespaceMap().get((Object)prefix);
                                    if (ns == null) break;
                                    ++index;
                                }
                                this.helper.addPrefix(prefix, namespaceURI);
                            }
                            ModelUtil.setStringWrapperValue(value, String.valueOf(prefix) + ":" + localpart);
                        }
                    } else if (name.startsWith("xmlns:")) {
                        String prefix = name.substring(name.indexOf(58) + 1);
                        String namespace = this.attribs.getValue(i);
                        NamespaceUtil.addNamespace((Resource)this.xmlResource, prefix, namespace);
                    }
                    ++i;
                }
            }
            if (obj instanceof BPMNShape) {
                BPMNShape bpmnShape = (BPMNShape)obj;
                Hashtable<String, String> map = new Hashtable<String, String>();
                if (this.attribs != null) {
                    int i = 0;
                    int size = this.attribs.getLength();
                    while (i < size) {
                        String key = this.attribs.getQName(i);
                        String value = this.attribs.getValue(i);
                        map.put(key, value);
                        ++i;
                    }
                    this.preferences.applyBPMNDIDefaults(bpmnShape, map);
                }
            } else if (obj instanceof ItemDefinition) {
                ItemDefinition itemDef = (ItemDefinition)obj;
                Definitions definitions = ModelUtil.getDefinitions(this.xmlResource);
                URI referencingURI = ImportHelper.makeURICanonical((URI)this.resourceURI);
                String location = ModelUtil.getStringWrapperValue(itemDef.getStructureRef());
                if (location != null) {
                    int i = location.indexOf("$");
                    if (i > 0) {
                        location = location.substring(0, i);
                    }
                    URI uri = URI.createURI((String)location).resolve(referencingURI);
                    uri = uri.trimFragment();
                    Import imp = ImportHelper.findImportForLocation((Definitions)definitions, (URI)uri);
                    itemDef.setImport(imp);
                }
            } else if (obj instanceof Definitions) {
                this.targetNamespace = ((Definitions)obj).getTargetNamespace();
            }
        }

        protected void setValueFromId(EObject object, EReference eReference, String ids) {
            Object value = null;
            if (qnameMap.contains(eReference)) {
                int i = ids.indexOf(":");
                if (i > 0) {
                    String prefix = ids.substring(0, i);
                    String localname = ids.substring(i + 1);
                    String namespace = this.helper.getNamespaceURI(prefix);
                    if (namespace != null && namespace.equals(this.targetNamespace)) {
                        ids = localname;
                    } else {
                        Import imp = this.importHandler.findImportForNamespace((Resource)this.helper.getResource(), namespace);
                        if (imp != null) {
                            value = this.importHandler.getObjectForId(imp, object, eReference, ids);
                        }
                    }
                }
                if (value == null) {
                    value = ModelUtil.createStringWrapper(ids);
                }
                if (value != null && eReference.getEType().isInstance(value)) {
                    try {
                        if (eReference.isMany()) {
                            ((EList)object.eGet((EStructuralFeature)eReference)).add(value);
                        } else {
                            object.eSet((EStructuralFeature)eReference, value);
                        }
                        return;
                    }
                    catch (Exception e) {
                        String msg = NLS.bind((String)Messages.Bpmn2ModelerResourceImpl_Invalid_Reference, (Object[])new Object[]{object, eReference, value});
                        Status s = new Status(4, "org.eclipse.bpmn2.modeler.core", msg, (Throwable)e);
                        Activator.getDefault();
                        Activator.logStatus((IStatus)s);
                    }
                }
            }
            if (ids.contains(":")) {
                String resolvedId = ((QNameURIHandler)this.uriHandler).convertQNameToUri(ids);
                URI resolvedURI = URI.createURI((String)resolvedId);
                URI resourceURI = this.xmlResource.getURI();
                if (resolvedURI.trimFragment().equals(resourceURI)) {
                    ids = resolvedURI.fragment();
                }
            }
            super.setValueFromId(object, eReference, ids);
        }

        public int getLineNumber() {
            return super.getLineNumber();
        }

        public int getColumnNumber() {
            return super.getColumnNumber();
        }

        public String getLocation() {
            return super.getLocation();
        }

        public void startElement(String uri, String localName, String name) {
            super.startElement(uri, localName, name);
            EObject peekObject = this.objects.peekEObject();
            if (peekObject != null && peekObject.getClass() == Expression.class) {
                this.text = new StringBuffer();
            }
        }

        public void endElement(String uri, String localName, String name) {
            EObject peekObject = (EObject)this.objects.peek();
            if (peekObject != null && peekObject.getClass() == Expression.class) {
                FormalExpression fe = Bpmn2Factory.eINSTANCE.createFormalExpression();
                EObject owner = peekObject.eContainer();
                if (owner != null) {
                    for (EStructuralFeature f : owner.eClass().getEAllStructuralFeatures()) {
                        if (owner.eGet(f) != peekObject) continue;
                        owner.eSet(f, (Object)fe);
                        break;
                    }
                    this.objects.pop();
                    this.objects.push((Object)fe);
                    this.types.pop();
                    this.types.push((Object)Bpmn2Package.eINSTANCE.getFormalExpression_Body());
                    EAttribute mixedFeature = this.extendedMetaData.getMixedFeature(fe.eClass());
                    if (mixedFeature != null) {
                        this.mixedTargets.push((Object)((FeatureMap)fe.eGet((EStructuralFeature)mixedFeature)));
                    } else {
                        this.mixedTargets.push(null);
                    }
                }
            }
            super.endElement(uri, localName, name);
        }
    }

    public static class Bpmn2ModelerXmlHelper
    extends Bpmn2ResourceImpl.BpmnXmlHelper {
        boolean isQNameFeature = false;
        ImportUtil importHandler = new ImportUtil();

        public Bpmn2ModelerXmlHelper(Bpmn2ResourceImpl resource) {
            super(resource);
        }

        public Object getValue(EObject eObject, EStructuralFeature eStructuralFeature) {
            List prefixes;
            Object o = super.getValue(eObject, eStructuralFeature);
            this.isQNameFeature = qnameMap.contains(eStructuralFeature) ? (prefixes = (List)this.urisToPrefixes.get(this.getTargetNamespace())) == null || !prefixes.contains("") : false;
            return o;
        }

        public String getHREF(EObject obj) {
            Import imp;
            String s = null;
            s = ModelUtil.isStringWrapper(obj) ? ModelUtil.getStringWrapperValue(obj) : super.getHREF(obj);
            if (this.isQNameFeature && s != null && s.contains("#") && (imp = this.importHandler.findImportForObject((Resource)this.resource, obj)) != null) {
                return this.importHandler.getQNameForObject((Resource)this.resource, obj);
            }
            return s;
        }

        public String getIDREF(EObject obj) {
            String s = super.getIDREF(obj);
            if (this.isQNameFeature && !ModelUtil.isStringWrapper(obj)) {
                s = this.convertToQName(s);
            }
            return s;
        }

        private String getTargetNamespace() {
            Definitions definitions = ModelUtil.getDefinitions(this.getResource());
            if (definitions == null) {
                return null;
            }
            return definitions.getTargetNamespace();
        }

        private String getTargetNamespacePrefix() {
            String targetNamespace = this.getTargetNamespace();
            if (targetNamespace != null && !targetNamespace.isEmpty()) {
                String prefix = this.getPrefix(targetNamespace);
                if (prefix == null || prefix.isEmpty()) {
                    for (Map.Entry e : this.getPrefixToNamespaceMap().entrySet()) {
                        if (!targetNamespace.equals(e.getValue()) || ((String)e.getKey()).isEmpty()) continue;
                        return (String)e.getKey();
                    }
                }
                return "";
            }
            return null;
        }

        private String convertToQName(String s) {
            String prefix;
            if (s != null && !s.contains(":") && (prefix = this.getTargetNamespacePrefix()) != null && !prefix.isEmpty()) {
                s = String.valueOf(prefix) + ":" + s;
            }
            return s;
        }

        public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
            EObjectWithInverseEList list;
            Object v;
            if (object != null && feature != null && object.eClass() != null && feature == object.eClass().getEStructuralFeature(feature.getFeatureID()) && (v = object.eGet(feature)) instanceof EObjectWithInverseEList && (list = (EObjectWithInverseEList)v).contains(value)) {
                return;
            }
            super.setValue(object, feature, value, position);
        }

        public EStructuralFeature getFeature(EClass eClass, String nsURI, String name, boolean isElement) {
            EStructuralFeature feature = null;
            EPackage pkg = eClass.getEPackage();
            if (pkg != Bpmn2Package.eINSTANCE && pkg != BpmnDiPackage.eINSTANCE && pkg != DcPackage.eINSTANCE && pkg != DiPackage.eINSTANCE && pkg != TargetRuntime.getCurrentRuntime().getModelDescriptor().getEPackage()) {
                feature = eClass.getEStructuralFeature(name);
            }
            if (feature == null) {
                feature = super.getFeature(eClass, nsURI, name, isElement);
            }
            return feature;
        }
    }

    public static class FragmentQNameURIHandler
    extends QNameURIHandler {
        protected Bpmn2ResourceImpl.BpmnXmlHelper xmlHelper;

        public FragmentQNameURIHandler(Bpmn2ResourceImpl.BpmnXmlHelper xmlHelper) {
            super(xmlHelper);
            this.xmlHelper = xmlHelper;
        }

        public URI resolve(URI uri) {
            URI resolvedUri = super.resolve(uri);
            if (resolvedUri.isRelative()) {
                resolvedUri = resolvedUri.resolve(this.baseURI);
            }
            return resolvedUri;
        }

        public URI deresolve(URI uri) {
            URI otherURI;
            String fragment = uri.fragment();
            if (fragment != null && !fragment.startsWith("/") && this.baseURI.equals(otherURI = uri.trimFragment())) {
                return URI.createURI((String)fragment);
            }
            if (uri.isPlatformResource() && this.baseURI.isPlatformResource() || uri.isFile() && this.baseURI.isFile()) {
                uri = uri.deresolve(this.baseURI, false, true, true);
                return uri;
            }
            return super.deresolve(uri);
        }

        public String convertQNameToUri(String qName) {
            String fragment;
            String prefix;
            if (qName.contains("#") || qName.contains("/")) {
                return qName;
            }
            String[] parts = qName.split(":");
            if (parts.length == 1) {
                prefix = null;
                fragment = qName;
            } else if (parts.length == 2) {
                prefix = parts[0];
                fragment = parts[1];
            } else {
                throw new IllegalArgumentException(String.valueOf(Messages.Bpmn2ModelerResourceImpl_Illegal_QName) + qName);
            }
            if (fragment.contains(".")) {
                return qName;
            }
            boolean isTargetNamespacePrefix = false;
            try {
                isTargetNamespacePrefix = this.xmlHelper.isTargetNamespace(prefix);
            }
            catch (Exception exception) {}
            if (!isTargetNamespacePrefix) {
                String uriString = this.xmlHelper.getPathForPrefix(prefix).appendFragment(fragment).toString();
                URI uri = URI.createURI((String)uriString);
                Bpmn2ModelerResourceSetImpl rs = ModelUtil.slightlyHackedResourceSet(this.xmlHelper.getResource().getResourceSet());
                Resource r = rs.getResource(uri, true, "wsdl");
                if (r instanceof WSDLResourceImpl) {
                    EObject o = (EObject)r.getContents().get(0);
                    Definition def = (Definition)o;
                    for (PortType pt : def.getEPortTypes()) {
                        Iterator iterator = pt.getEOperations().iterator();
                        while (iterator.hasNext()) {
                            Operation cfr_ignored_0 = (Operation)iterator.next();
                        }
                    }
                }
                return this.xmlHelper.getPathForPrefix(prefix).appendFragment(fragment).toString();
            }
            return URI.createURI((String)"").appendFragment(fragment).toString();
        }
    }

    public class OnlyNamedContainmentTypeInfo
    extends OnlyContainmentTypeInfo {
        public boolean shouldSaveType(EClass objectType, EClassifier featureType, EStructuralFeature feature) {
            String name = ExtendedMetaData.INSTANCE.getName((EClassifier)objectType);
            if (name == null || name.isEmpty()) {
                return false;
            }
            return super.shouldSaveType(objectType, featureType, feature);
        }

        public boolean shouldSaveType(EClass objectType, EClass featureType, EStructuralFeature feature) {
            String name = ExtendedMetaData.INSTANCE.getName((EClassifier)objectType);
            if (name == null || name.isEmpty()) {
                return false;
            }
            return super.shouldSaveType(objectType, featureType, feature);
        }
    }
}

