/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public enum AnchorType {
    ACTIVITY("activity"),
    POOL("pool"),
    GATEWAY("gateway"),
    MESSAGELINK("messagelink"),
    CONNECTION("connection");

    private final String key;

    private AnchorType(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public static AnchorType getType(String key) {
        AnchorType[] anchorTypeArray = AnchorType.values();
        int n = anchorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnchorType t = anchorTypeArray[n2];
            if (t.getKey().equals(key)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    public static AnchorType getType(AnchorContainer ac) {
        if (ac instanceof ConnectionDecorator) {
            return CONNECTION;
        }
        BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)ac);
        String property = Graphiti.getPeService().getPropertyValue((PropertyContainer)ac, "choreography.messageLink");
        if (Boolean.parseBoolean(property)) {
            return MESSAGELINK;
        }
        if (be instanceof Participant) {
            return POOL;
        }
        if (be instanceof Group) {
            return POOL;
        }
        if (be instanceof Gateway || be instanceof Event) {
            return GATEWAY;
        }
        if (be instanceof SequenceFlow) {
            return CONNECTION;
        }
        if (be != null) {
            return ACTIVITY;
        }
        throw new IllegalArgumentException("Cannot determine Anchor Type for business object " + be);
    }

    public static AnchorType getType(Anchor anchor) {
        return AnchorType.getType(Graphiti.getPeService().getPropertyValue((PropertyContainer)anchor, "anchor.type"));
    }

    public static void setType(Anchor anchor, AnchorType at) {
        Graphiti.getPeService().setPropertyValue((PropertyContainer)anchor, "anchor.type", at.getKey());
    }
}

