/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;

public class JavaProjectClassLoader {
    private IJavaProject javaProject;

    public JavaProjectClassLoader(IJavaProject project) {
        if (project == null || !project.exists()) {
            throw new IllegalArgumentException("Invalid javaProject");
        }
        this.javaProject = project;
    }

    public IType findClass(String className, IProject project) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            return javaProject.findType(className);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<IType> findClasses(String classNamePattern) {
        ArrayList<IType> results = new ArrayList<IType>();
        if (classNamePattern.endsWith(".java")) {
            classNamePattern = classNamePattern.substring(0, classNamePattern.lastIndexOf("."));
        }
        this.findClasses(classNamePattern, results);
        return results;
    }

    public void findClasses(String classNamePattern, final List<IType> results) {
        SearchEngine searchEngine = new SearchEngine();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{this.javaProject});
        char[] packageName = null;
        char[] typeName = null;
        int index = classNamePattern.lastIndexOf(46);
        int packageMatch = 0;
        int typeMatch = 1;
        if (index == -1) {
            typeName = classNamePattern.toCharArray();
        } else if (index + 1 == classNamePattern.length()) {
            typeName = "".toCharArray();
            packageName = classNamePattern.substring(0, index).toCharArray();
        } else {
            typeName = classNamePattern.substring(index + 1).toCharArray();
            packageName = classNamePattern.substring(0, index).toCharArray();
        }
        try {
            TypeNameMatchRequestor req = new TypeNameMatchRequestor(){

                public void acceptTypeNameMatch(TypeNameMatch match) {
                    results.add(match.getType());
                }
            };
            searchEngine.searchAllTypeNames(packageName, packageMatch, typeName, typeMatch, 10, scope, req, 3, null);
        }
        catch (CoreException coreException) {}
    }
}

