/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.examples.modelreader;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.impl.SequenceFlowImpl;
import org.eclipse.bpmn2.util.Bpmn2ResourceFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelReader {
    public static void main(String[] args) throws IOException {
        URI uri = URI.createURI((String)"SampleProcess.bpmn");
        Bpmn2ResourceFactoryImpl resFactory = new Bpmn2ResourceFactoryImpl();
        Resource resource = resFactory.createResource(uri);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("DEFER_IDREF_RESOLUTION", true);
        resource.load(options);
        Definitions d = ModelReader.getDefinitions(resource);
        List rootElements = d.getRootElements();
        for (RootElement re : rootElements) {
            if (!(re instanceof Process)) continue;
            Process process = (Process)re;
            System.out.println("Process: name=" + process.getName() + " ID=" + process.getId());
            for (FlowElement fe : process.getFlowElements()) {
                if (fe instanceof SequenceFlowImpl) {
                    SequenceFlow sf = (SequenceFlow)fe;
                    if (sf == null) continue;
                    String source = "";
                    String target = "";
                    if (sf.getSourceRef() != null) {
                        source = sf.getSourceRef().getId();
                    }
                    if (sf.getTargetRef() != null) {
                        target = sf.getTargetRef().getId();
                    }
                    System.out.println("Sequence Flow: " + source + " -> " + target);
                    continue;
                }
                System.out.println(String.valueOf(fe.eClass().getName()) + ": name=" + fe.getName() + " ID=" + fe.getId());
            }
        }
    }

    private static Definitions getDefinitions(Resource resource) {
        if (resource != null && !resource.getContents().isEmpty() && !((EObject)resource.getContents().get(0)).eContents().isEmpty()) {
            for (EObject e : resource.getContents()) {
                for (Object o : e.eContents()) {
                    if (!(o instanceof Definitions)) continue;
                    return (Definitions)o;
                }
            }
        }
        return null;
    }
}

