/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.util;

import java.util.ArrayList;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.util.Messages;
import org.eclipse.bpmn2.modeler.ui.property.dialogs.DefaultSchemaImportDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class JbpmInterfaceImportDialog
extends DefaultSchemaImportDialog {
    boolean createVariables = false;
    CheckboxTableViewer methodsTable;
    IMethod[] selectedMethods = new IMethod[0];

    public JbpmInterfaceImportDialog() {
        super(Display.getDefault().getActiveShell(), 8);
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        Composite tableComposite = new Composite(contents, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label label = new Label(tableComposite, 0);
        label.setText(Messages.JbpmInterfaceImportDialog_Available_Methods);
        label.setLayoutData((Object)new GridData(16384, 128, true, false, 1, 1));
        Button selectAllButton = new Button(tableComposite, 8);
        selectAllButton.setText(Messages.JbpmInterfaceImportDialog_Select_All);
        selectAllButton.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        Button selectNoneButton = new Button(tableComposite, 8);
        selectNoneButton.setText(Messages.JbpmInterfaceImportDialog_Select_None);
        selectNoneButton.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this.methodsTable = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)2080);
        this.methodsTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.methodsTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element.toString().replaceFirst("\\) \\[in .*", ")");
            }
        });
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JbpmInterfaceImportDialog.this.methodsTable.setAllChecked(true);
            }
        });
        selectNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JbpmInterfaceImportDialog.this.methodsTable.setAllChecked(false);
            }
        });
        final Button createVariablesbutton = new Button(contents, 32);
        createVariablesbutton.setText(Messages.JbpmImportDialog_Create_Process_Variables_Label);
        createVariablesbutton.setSelection(this.createVariables);
        createVariablesbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JbpmInterfaceImportDialog.this.createVariables = createVariablesbutton.getSelection();
            }
        });
        return contents;
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        if (status == Status.OK_STATUS && this.methodsTable != null) {
            Object[] methods = this.getAllMethods();
            this.methodsTable.getTable().removeAll();
            if (methods.length > 0) {
                this.methodsTable.add(methods);
            }
        }
    }

    public boolean isCreateVariables() {
        return this.createVariables;
    }

    public void setCreateVariables(boolean createVariables) {
        this.createVariables = createVariables;
    }

    public IType getIType() {
        Object[] result = this.getResult();
        if (result != null && result.length == 1 && result[0] instanceof IType) {
            return (IType)result[0];
        }
        return null;
    }

    protected void computeResult() {
        super.computeResult();
        if (this.methodsTable != null) {
            Object[] checked = this.methodsTable.getCheckedElements();
            this.selectedMethods = new IMethod[checked.length];
            int i = 0;
            while (i < checked.length) {
                this.selectedMethods[i] = (IMethod)checked[i];
                ++i;
            }
        } else {
            this.selectedMethods = new IMethod[0];
        }
    }

    public IMethod[] getAllMethods() {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        IType type = this.getIType();
        if (type != null) {
            try {
                IMethod[] iMethodArray = type.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    if (!method.isConstructor() && !method.getElementName().contains("<") && (method.getFlags() & 1) != 0 && method.getNumberOfParameters() == 1) {
                        methods.add(method);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    public IMethod[] getIMethods() {
        return this.selectedMethods;
    }
}

