/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.xml.sax.InputSource;

public class Bpmn2ContentDescriber
implements ITextContentDescriber {
    private static final String BPMN2_NAMESPACE = "http://www.omg.org/spec/BPMN/20100524/MODEL";
    private static final String ROOT_ELEMENT = "definitions";
    private RootElementParser parser;

    public int describe(Reader contents, IContentDescription description) throws IOException {
        return this.doDescribe(contents) == null ? 0 : 2;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        return this.describe(new InputStreamReader(contents), description);
    }

    /*
     * Loose catch block
     */
    private synchronized String doDescribe(Reader contents) throws IOException {
        try {
            try {
                InputSource source = new InputSource(contents);
                this.parser = new RootElementParser();
                this.parser.parse(source);
            }
            catch (AcceptedException e) {
                String string = e.acceptedRootElement;
                this.parser = null;
                return string;
            }
            catch (RejectedException rejectedException) {
                this.parser = null;
                return null;
            }
            catch (Exception exception) {
                this.parser = null;
                return null;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.parser = null;
        }
        return null;
    }

    public QualifiedName[] getSupportedOptions() {
        return null;
    }

    public static boolean isBPMN2File(IResource res) {
        try {
            IContentType type;
            IContentDescription desc;
            if (res.getType() == 1 && (desc = ((IFile)res).getContentDescription()) != null && (type = desc.getContentType()).getId().equals("org.eclipse.bpmn2.content-type.xml")) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private class AcceptedException
    extends RuntimeException {
        public String acceptedRootElement;
        private static final long serialVersionUID = 1L;

        public AcceptedException(String acceptedRootElement) {
            this.acceptedRootElement = acceptedRootElement;
        }
    }

    private class RejectedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private RejectedException() {
        }
    }

    private class RootElementParser
    extends SAXParser {
        private RootElementParser() {
        }

        public void startElement(QName qName, XMLAttributes attributes, Augmentations augmentations) throws XNIException {
            super.startElement(qName, attributes, augmentations);
            if (Bpmn2ContentDescriber.ROOT_ELEMENT.equals(qName.localpart)) {
                String namespace = this.fNamespaceContext.getURI(qName.prefix);
                if (Bpmn2ContentDescriber.BPMN2_NAMESPACE.equals(namespace)) {
                    throw new AcceptedException(qName.localpart);
                }
                throw new RejectedException();
            }
            throw new RejectedException();
        }
    }
}

