/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectPropertyProvider;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.NamespaceUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.Messages;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.wsdl.PortType;

public class InterfacePropertiesAdapter
extends ExtendedPropertiesAdapter<Interface> {
    public InterfacePropertiesAdapter(AdapterFactory adapterFactory, Interface object) {
        super(adapterFactory, (EObject)object);
        EReference ref = Bpmn2Package.eINSTANCE.getInterface_ImplementationRef();
        this.setFeatureDescriptor((EStructuralFeature)ref, new ImplementationRefFeatureDescriptor<Interface>(this, adapterFactory, object, (EStructuralFeature)ref));
        ref = Bpmn2Package.eINSTANCE.getInterface_Operations();
        this.setFeatureDescriptor((EStructuralFeature)ref, (FeatureDescriptor)new FeatureDescriptor<Interface>((ExtendedPropertiesAdapter)this, object, (EStructuralFeature)ref){

            public EObject createFeature(Resource resource, EClass eclass) {
                Operation operation = (Operation)Bpmn2ModelerFactory.create(Operation.class);
                ModelUtil.setID((EObject)operation, (Resource)resource);
                operation.setName(ModelUtil.toCanonicalString((String)operation.getId()));
                ((Interface)this.object).getOperations().add(operation);
                return operation;
            }

            public String getLabel() {
                return Messages.Interface_Operations_Label;
            }

            public String getTextValue() {
                String text = "";
                Iterator iter = ((Interface)this.object).getOperations().iterator();
                while (iter.hasNext()) {
                    Operation op = (Operation)iter.next();
                    String name = op.getName();
                    if (name == null || name.isEmpty()) {
                        name = op.getId();
                    }
                    text = String.valueOf(text) + name;
                    if (!iter.hasNext()) continue;
                    text = String.valueOf(text) + ", ";
                }
                return text;
            }
        });
    }

    public static class ImplementationRefFeatureDescriptor<T extends BaseElement>
    extends FeatureDescriptor<T> {
        public ImplementationRefFeatureDescriptor(ExtendedPropertiesAdapter<T> owner, AdapterFactory adapterFactory, T object, EStructuralFeature feature) {
            super(owner, object, feature);
            owner.setProperty(feature, "ui.is.multi.choice", (Object)Boolean.FALSE);
        }

        public String getTextValue() {
            Resource resource = ObjectPropertyProvider.getResource((EObject)this.object);
            String text = null;
            EObject value = (EObject)((BaseElement)this.object).eGet(this.feature);
            if (value != null) {
                if (ModelUtil.isStringWrapper((Object)value)) {
                    text = ModelUtil.getStringWrapperTextValue((Object)((BaseElement)this.object).eGet(this.feature));
                } else if (value instanceof PortType) {
                    PortType portType = (PortType)value;
                    text = NamespaceUtil.normalizeQName((Resource)resource, (QName)portType.getQName());
                } else if (value instanceof org.eclipse.wst.wsdl.Operation) {
                    org.eclipse.wst.wsdl.Operation operation = (org.eclipse.wst.wsdl.Operation)value;
                    String name = operation.getName();
                    String prefix = NamespaceUtil.getPrefixForObject((Resource)resource, (Object)operation);
                    text = prefix != null && !prefix.isEmpty() ? String.valueOf(prefix) + ":" + name : String.valueOf(text) + name;
                }
                if (text == null) {
                    return ModelUtil.getTextValue((Object)((BaseElement)this.object).eGet(this.feature));
                }
                return text;
            }
            text = ModelUtil.getName((BaseElement)((BaseElement)this.object));
            if (text == null || text.isEmpty()) {
                return ((BaseElement)this.object).getId();
            }
            return text;
        }

        public EObject createFeature(Resource resource, EClass eClass) {
            EObject impl = ModelUtil.createStringWrapper((String)"");
            ((BaseElement)this.object).eSet(this.feature, (Object)impl);
            return impl;
        }

        public Object getValue() {
            Object value = ((BaseElement)this.object).eGet(this.feature);
            if (value != null) {
                if (ModelUtil.isStringWrapper((Object)value)) {
                    return value;
                }
                return this.getTextValue();
            }
            return ModelUtil.createStringWrapper((String)"");
        }

        protected void internalSet(T object, EStructuralFeature feature, Object value, int index) {
            Process process;
            Resource resource = ObjectPropertyProvider.getResource(object);
            if (value instanceof PortType) {
                PortType portType = (PortType)value;
                value = NamespaceUtil.normalizeQName((Resource)resource, (QName)portType.getQName());
            } else if (value instanceof Process && (process = (Process)value).getSupportedInterfaceRefs().size() > 0) {
                value = ((Interface)process.getSupportedInterfaceRefs().get(0)).getImplementationRef();
            }
            if (value instanceof String) {
                value = ModelUtil.createStringWrapper((String)((String)value));
            } else if (!ModelUtil.isStringWrapper((Object)value)) {
                return;
            }
            super.internalSet(object, feature, value, index);
        }
    }
}

