/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.editor;

import org.eclipse.bpmn2.modeler.core.LifecycleEvent;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.transaction.ExceptionHandler;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListenerImpl;

public class BPMN2EditingDomainListener
extends TransactionalEditingDomainListenerImpl
implements ExceptionHandler {
    protected BPMN2Editor bpmn2Editor;
    protected BasicDiagnostic diagnostics;

    public BPMN2EditingDomainListener(BPMN2Editor bpmn2Editor) {
        this.bpmn2Editor = bpmn2Editor;
        TransactionalCommandStack stack = (TransactionalCommandStack)bpmn2Editor.getEditingDomain().getCommandStack();
        stack.setExceptionHandler((ExceptionHandler)this);
    }

    public void transactionStarting(TransactionalEditingDomainEvent event) {
        this.diagnostics = null;
        super.transactionStarting(event);
        TargetRuntime.getCurrentRuntime().notify(new LifecycleEvent(LifecycleEvent.EventType.TRANSACTION_STARTING, (Object)event.getTransaction()));
    }

    public void transactionClosed(TransactionalEditingDomainEvent event) {
        super.transactionClosed(event);
        TargetRuntime.getCurrentRuntime().notify(new LifecycleEvent(LifecycleEvent.EventType.TRANSACTION_CLOSED, (Object)event.getTransaction()));
    }

    public void transactionInterrupted(TransactionalEditingDomainEvent event) {
        super.transactionInterrupted(event);
        TargetRuntime.getCurrentRuntime().notify(new LifecycleEvent(LifecycleEvent.EventType.TRANSACTION_INTERRUPTED, (Object)event.getTransaction()));
    }

    public void handleException(Exception e) {
        String source = null;
        int code = 0;
        String message = e.getMessage();
        Object[] data = null;
        StackTraceElement[] trace = e.getStackTrace();
        if (trace != null && trace.length > 0) {
            source = trace[0].getMethodName();
        }
        if (this.diagnostics == null) {
            this.diagnostics = new BasicDiagnostic(source, code, message, data);
        } else {
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(source, code, message, data));
        }
    }

    public BasicDiagnostic getDiagnostics() {
        return this.diagnostics;
    }

    public IMarker createMarker(IResource resource, int severity, String msg) {
        try {
            IMarker m = resource.createMarker("org.eclipse.core.resources.problemmarker");
            m.setAttribute("message", (Object)msg);
            m.setAttribute("priority", 2);
            m.setAttribute("severity", severity);
            return m;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

