/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.editor;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.bpmn2.modeler.core.utils.FixDuplicateIdsDialog;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.editor.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DefaultPersistencyBehavior;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BPMN2PersistencyBehavior
extends DefaultPersistencyBehavior {
    BPMN2Editor editor;

    public BPMN2PersistencyBehavior(DiagramBehavior diagramBehavior) {
        super(diagramBehavior);
        this.editor = (BPMN2Editor)diagramBehavior.getDiagramContainer();
    }

    public Diagram loadDiagram(URI diagramUri) {
        Diagram diagram = super.loadDiagram(diagramUri);
        return diagram;
    }

    public void saveDiagram(IProgressMonitor monitor) {
        Resource resource = this.editor.getResource();
        List dups = ModelUtil.findDuplicateIds((Resource)resource);
        if (dups.size() > 0) {
            FixDuplicateIdsDialog dlg = new FixDuplicateIdsDialog(dups);
            dlg.open();
        }
        super.saveDiagram(monitor);
    }

    protected IRunnableWithProgress createOperation(final Set<Resource> savedResources, final Map<Resource, Map<?, ?>> saveOptions) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(final IProgressMonitor monitor) {
                try {
                    savedResources.addAll(BPMN2PersistencyBehavior.this.save(BPMN2PersistencyBehavior.this.diagramBehavior.getEditingDomain(), saveOptions, monitor));
                }
                catch (WrappedException e) {
                    String emsg = e.getMessage().replaceAll("\tat .*", "").replaceFirst(".*Exception: ", "").trim();
                    final String msg = emsg.replace("\r\n\r\n", "").replace("\n\n", "");
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.BPMN2PersistencyBehavior_Cannot_Save_Title, (String)msg);
                            monitor.setCanceled(true);
                        }
                    });
                    throw e;
                }
            }
        };
        return operation;
    }
}

