/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.ArrayList;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BpmnDiFactory;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.choreography.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.util.ui.PopupMenu;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class WhiteboxFeature
extends AbstractCustomFeature {
    protected boolean changesDone = false;
    private static ILabelProvider labelProvider = new ILabelProvider(){

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            return ModelUtil.getTextValue((Object)element);
        }

        public Image getImage(Object element) {
            return null;
        }
    };

    public WhiteboxFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return Messages.WhiteboxFeature_Name;
    }

    public String getDescription() {
        return Messages.WhiteboxFeature_Description;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_WHITEBOX;
    }

    public boolean isAvailable(IContext context) {
        PictogramElement pe;
        PictogramElement[] pes;
        return context instanceof ICustomContext && (pes = ((ICustomContext)context).getPictogramElements()) != null && pes.length == 1 && ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)(pe = pes[0]));
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement pe;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)(pe = pes[0]))) {
            Participant participant = (Participant)this.getBusinessObjectForPictogramElement(pe);
            Process process = participant.getProcessRef();
            if (process == null) {
                return true;
            }
            BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)process);
            return bpmnDiagram == null;
        }
        return false;
    }

    public void execute(ICustomContext context) {
        PictogramElement pe = context.getPictogramElements()[0];
        Participant participant = (Participant)this.getBusinessObjectForPictogramElement(pe);
        Definitions definitions = ModelUtil.getDefinitions((Object)participant);
        BPMNDiagram bpmnDiagram = this.selectBPMNDiagram(definitions, participant);
        if (bpmnDiagram != null && participant != null) {
            for (RootElement element : definitions.getRootElements()) {
                if (!(element instanceof Collaboration)) continue;
                ((Collaboration)element).getParticipants().add(participant);
                break;
            }
        }
    }

    public boolean hasDoneChanges() {
        return this.changesDone;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BPMNDiagram selectBPMNDiagram(Definitions definitions, Participant participant) {
        Resource resource = definitions.eResource();
        ArrayList<BPMNDiagram> diagramList = new ArrayList<BPMNDiagram>();
        BPMNDiagram newDiagram = BpmnDiFactory.eINSTANCE.createBPMNDiagram();
        ModelUtil.setID((EObject)newDiagram, (Resource)resource);
        newDiagram.setName(Messages.WhiteboxFeature_New_Process);
        BPMNPlane plane = BpmnDiFactory.eINSTANCE.createBPMNPlane();
        ModelUtil.setID((EObject)plane, (Resource)resource);
        Process process = (Process)Bpmn2ModelerFactory.create(Process.class);
        plane.setBpmnElement((BaseElement)process);
        newDiagram.setPlane(plane);
        diagramList.add(newDiagram);
        for (BPMNDiagram d : definitions.getDiagrams()) {
            BaseElement bpmnElement = d.getPlane().getBpmnElement();
            if (!(bpmnElement instanceof Process)) continue;
            diagramList.add(d);
        }
        BPMNDiagram result = newDiagram;
        if (diagramList.size() > 1) {
            PopupMenu popupMenu = new PopupMenu(diagramList, labelProvider);
            this.changesDone = popupMenu.show((Control)Display.getCurrent().getActiveShell());
            if (!this.changesDone) return null;
            result = (BPMNDiagram)popupMenu.getResult();
        } else {
            this.changesDone = true;
        }
        if (this.changesDone) {
            if (result == newDiagram) {
                String name = NLS.bind((String)Messages.WhiteboxFeature_Process_For, (Object)ExtendedPropertiesProvider.getTextValue((EObject)participant));
                process.setName(name);
                newDiagram.setName(name);
                definitions.getRootElements().add(process);
                definitions.getDiagrams().add(result);
            } else {
                process = (Process)result.getPlane().getBpmnElement();
            }
        }
        participant.setProcessRef(process);
        ModelUtil.setID((EObject)process);
        return result;
    }
}

