/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.data;

import java.util.ArrayList;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.modeler.core.features.AbstractCreateFlowElementFeature;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.data.AddDataFeature;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.model.ModelHandler;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.data.AbstractDataFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.data.Messages;
import org.eclipse.bpmn2.modeler.ui.features.data.UpdateItemAwareElementFeature;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.util.ui.PopupMenu;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class DataObjectFeatureContainer
extends AbstractDataFeatureContainer {
    public boolean canApplyTo(Object o) {
        return o instanceof DataObject;
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateDataObjectFeature(fp);
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddDataObjectFeature(fp);
    }

    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        MultiUpdateFeature multiUpdate = new MultiUpdateFeature(fp);
        multiUpdate.addFeature((IUpdateFeature)new UpdateItemAwareElementFeature<DataObject>(fp){

            @Override
            public boolean update(IUpdateContext context) {
                if (super.update(context)) {
                    Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                    Definitions definitions = ModelUtil.getDefinitions((Object)bo);
                    TreeIterator iter = definitions.eAllContents();
                    while (iter.hasNext()) {
                        EObject o = (EObject)iter.next();
                        if (!(o instanceof DataObjectReference)) continue;
                        for (PictogramElement pe : Graphiti.getLinkService().getPictogramElements(this.getDiagram(), o)) {
                            if (!(pe instanceof ContainerShape)) continue;
                            UpdateContext newContext = new UpdateContext(pe);
                            IUpdateFeature f = this.getFeatureProvider().getUpdateFeature((IUpdateContext)newContext);
                            f.update((IUpdateContext)newContext);
                        }
                    }
                    return true;
                }
                return false;
            }
        });
        multiUpdate.addFeature((IUpdateFeature)new UpdateLabelFeature(fp));
        return multiUpdate;
    }

    public class AddDataObjectFeature
    extends AddDataFeature<DataObject> {
        public AddDataObjectFeature(IFeatureProvider fp) {
            super(fp);
        }

        public String getName(DataObject t) {
            return t.getName();
        }

        public Class getBusinessObjectType() {
            return DataObject.class;
        }
    }

    public static class CreateDataObjectFeature
    extends AbstractCreateFlowElementFeature<FlowElement> {
        private static ILabelProvider labelProvider = new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                if (((DataObject)element).getId() == null) {
                    return ((DataObject)element).getName();
                }
                return NLS.bind((String)Messages.DataObjectFeatureContainer_Ref, (Object)((DataObject)element).getName());
            }

            public Image getImage(Object element) {
                return null;
            }
        };

        public CreateDataObjectFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canCreate(ICreateContext context) {
            return FeatureSupport.isValidDataTarget((ITargetContext)context);
        }

        public String getStencilImageId() {
            return ImageProvider.IMG_16_DATA_OBJECT;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getDataObject();
        }

        public FlowElement createBusinessObject(ICreateContext context) {
            this.changesDone = true;
            ModelHandler mh = ModelHandler.getInstance((EObject)this.getDiagram());
            DataObject flowElement = null;
            DataObjectReference dataObjectReference = (DataObjectReference)Bpmn2ModelerFactory.create(DataObjectReference.class);
            DataObject dataObject = (DataObject)Bpmn2ModelerFactory.create(DataObject.class);
            String oldName = dataObject.getName();
            dataObject.setName(Messages.DataObjectFeatureContainer_New);
            dataObject.setId(null);
            EObject targetBusinessObject = (EObject)this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
            ArrayList<DataObject> dataObjectList = new ArrayList<DataObject>();
            dataObjectList.add(dataObject);
            TreeIterator iter = ModelUtil.getDefinitions((Object)targetBusinessObject).eAllContents();
            while (iter.hasNext()) {
                EObject obj = (EObject)iter.next();
                if (!(obj instanceof DataObject)) continue;
                dataObjectList.add((DataObject)obj);
            }
            DataObject result = dataObject;
            if (dataObjectList.size() > 1) {
                PopupMenu popupMenu = new PopupMenu(dataObjectList, labelProvider);
                this.changesDone = popupMenu.show((Control)Display.getCurrent().getActiveShell());
                if (this.changesDone) {
                    result = (DataObject)popupMenu.getResult();
                } else {
                    EcoreUtil.delete((EObject)dataObject);
                    EcoreUtil.delete((EObject)dataObjectReference);
                }
            } else {
                this.changesDone = true;
            }
            if (this.changesDone) {
                if (result == dataObject) {
                    mh.addFlowElement((Object)targetBusinessObject, (FlowElement)dataObject);
                    ModelUtil.setID((EObject)dataObject);
                    dataObject.setIsCollection(false);
                    dataObject.setName(oldName);
                    flowElement = dataObject;
                } else {
                    mh.addFlowElement((Object)targetBusinessObject, (FlowElement)dataObjectReference);
                    ModelUtil.setID((EObject)dataObjectReference);
                    dataObjectReference.setName(NLS.bind((String)Messages.DataObjectFeatureContainer_Default_Name, (Object)result.getName()));
                    dataObjectReference.setDataObjectRef(result);
                    dataObject = result;
                    flowElement = dataObjectReference;
                }
                this.putBusinessObject(context, (BaseElement)flowElement);
            }
            return flowElement;
        }
    }
}

