/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.event;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.event.Messages;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.util.ui.PopupMenu;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class FollowLinkFeature
extends AbstractCustomFeature {
    ICustomContext context;
    private static ILabelProvider labelProvider = new ILabelProvider(){

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object object) {
            ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)object);
            return adapter.getObjectDescriptor().getTextValue();
        }

        public Image getImage(Object element) {
            return null;
        }
    };

    public FollowLinkFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement pe = context.getPictogramElements()[0];
        Event event = (Event)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, Event.class);
        if (event instanceof IntermediateCatchEvent) {
            for (EventDefinition ed : ((IntermediateCatchEvent)event).getEventDefinitions()) {
                if (!(ed instanceof LinkEventDefinition) || ((LinkEventDefinition)ed).getSource().isEmpty()) continue;
                this.context = context;
                return true;
            }
        } else if (event instanceof IntermediateThrowEvent) {
            for (EventDefinition ed : ((IntermediateThrowEvent)event).getEventDefinitions()) {
                if (!(ed instanceof LinkEventDefinition) || ((LinkEventDefinition)ed).getTarget() == null) continue;
                this.context = context;
                return true;
            }
        }
        this.context = null;
        return false;
    }

    public boolean isAvailable(IContext context) {
        if (context instanceof ICustomContext) {
            return this.canExecute((ICustomContext)context);
        }
        return false;
    }

    public void execute(ICustomContext context) {
        LinkEventDefinition link;
        DiagramEditor editor = (DiagramEditor)this.getFeatureProvider().getDiagramTypeProvider().getDiagramEditor();
        PictogramElement pe = context.getPictogramElements()[0];
        Event event = (Event)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, Event.class);
        LinkEventDefinition target = null;
        if (event instanceof IntermediateCatchEvent) {
            for (EventDefinition ed : ((IntermediateCatchEvent)event).getEventDefinitions()) {
                List sources;
                if (!(ed instanceof LinkEventDefinition) || (sources = (link = (LinkEventDefinition)ed).getSource()).isEmpty()) continue;
                if (sources.size() == 1) {
                    target = (LinkEventDefinition)sources.get(0);
                    continue;
                }
                PopupMenu popupMenu = new PopupMenu(sources, labelProvider);
                if (!popupMenu.show((Control)Display.getCurrent().getActiveShell())) continue;
                target = (LinkEventDefinition)popupMenu.getResult();
            }
        } else if (event instanceof IntermediateThrowEvent) {
            for (EventDefinition ed : ((IntermediateThrowEvent)event).getEventDefinitions()) {
                if (!(ed instanceof LinkEventDefinition)) continue;
                link = (LinkEventDefinition)ed;
                target = link.getTarget();
            }
        }
        if (target != null) {
            Diagram diagram = DIUtils.getDiagram((BaseElement)((Event)target.eContainer()));
            List pes = Graphiti.getLinkService().getPictogramElements(diagram, target.eContainer());
            StructuredSelection selection = new StructuredSelection(pes);
            editor.selectionChanged((IWorkbenchPart)editor, (ISelection)selection);
        }
    }

    public boolean hasDoneChanges() {
        return false;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_FOLLOW_LINK;
    }

    public String getName() {
        return Messages.FollowLinkFeature_name;
    }

    public String getDescription() {
        if (this.context != null) {
            PictogramElement pe = this.context.getPictogramElements()[0];
            Event event = (Event)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, Event.class);
            if (this.getLinks(event).size() == 0) {
                return "Create a Link";
            }
            if (event instanceof IntermediateCatchEvent) {
                return "Show Source Links";
            }
            return "Show Target Link";
        }
        return null;
    }

    private LinkEventDefinition getLinkEventDefinition(Event event) {
        block3: {
            block2: {
                if (!(event instanceof IntermediateCatchEvent)) break block2;
                for (EventDefinition ed : ((IntermediateCatchEvent)event).getEventDefinitions()) {
                    if (!(ed instanceof LinkEventDefinition)) continue;
                    return (LinkEventDefinition)ed;
                }
                break block3;
            }
            if (!(event instanceof IntermediateThrowEvent)) break block3;
            for (EventDefinition ed : ((IntermediateThrowEvent)event).getEventDefinitions()) {
                if (!(ed instanceof LinkEventDefinition)) continue;
                return (LinkEventDefinition)ed;
            }
        }
        return null;
    }

    private List<LinkEventDefinition> getLinks(Event event) {
        ArrayList<LinkEventDefinition> list;
        block3: {
            block2: {
                list = new ArrayList<LinkEventDefinition>();
                if (!(event instanceof IntermediateCatchEvent)) break block2;
                for (EventDefinition ed : ((IntermediateCatchEvent)event).getEventDefinitions()) {
                    LinkEventDefinition link;
                    if (!(ed instanceof LinkEventDefinition) || (link = (LinkEventDefinition)ed).getSource().isEmpty()) continue;
                    list.addAll(link.getSource());
                }
                break block3;
            }
            if (!(event instanceof IntermediateThrowEvent)) break block3;
            for (EventDefinition ed : ((IntermediateThrowEvent)event).getEventDefinitions()) {
                LinkEventDefinition link;
                if (!(ed instanceof LinkEventDefinition) || (link = (LinkEventDefinition)ed).getTarget() == null) continue;
                list.add(link.getTarget());
            }
        }
        return list;
    }
}

