/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.event;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.event.AbstractCreateEventFeature;
import org.eclipse.bpmn2.modeler.core.features.event.AbstractUpdateEventFeature;
import org.eclipse.bpmn2.modeler.core.features.event.AddEventFeature;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.event.AbstractEventFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.event.FollowLinkFeature;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public class IntermediateThrowEventFeatureContainer
extends AbstractEventFeatureContainer {
    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof IntermediateThrowEvent;
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateIntermediateThrowEventFeature(fp);
    }

    @Override
    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        MultiUpdateFeature multiUpdate = new MultiUpdateFeature(fp);
        multiUpdate.addFeature(super.getUpdateFeature(fp));
        multiUpdate.addFeature((IUpdateFeature)new UpdateIntermediateThrowEventFeature(fp));
        return multiUpdate;
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddIntermediateThrowEventFeature(fp);
    }

    @Override
    public ICustomFeature[] getCustomFeatures(IFeatureProvider fp) {
        ICustomFeature[] superFeatures = super.getCustomFeatures(fp);
        ICustomFeature[] thisFeatures = new ICustomFeature[1 + superFeatures.length];
        int i = 0;
        while (i < superFeatures.length) {
            thisFeatures[i] = superFeatures[i];
            ++i;
        }
        thisFeatures[i++] = new FollowLinkFeature(fp);
        return thisFeatures;
    }

    public class AddIntermediateThrowEventFeature
    extends AddEventFeature<IntermediateThrowEvent> {
        public AddIntermediateThrowEventFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected void decorateShape(IAddContext context, ContainerShape containerShape, IntermediateThrowEvent businessObject) {
            super.decorateShape(context, containerShape, (BaseElement)businessObject);
            Ellipse e = (Ellipse)AddIntermediateThrowEventFeature.getGraphicsAlgorithm((ContainerShape)containerShape);
            Ellipse circle = ShapeDecoratorUtil.createIntermediateEventCircle((Ellipse)e);
            circle.setForeground(this.manageColor(StyleUtil.CLASS_FOREGROUND));
            IPeService peService = Graphiti.getPeService();
            peService.setPropertyValue((PropertyContainer)containerShape, UpdateIntermediateThrowEventFeature.INTERMEDIATE_THROW_EVENT_MARKER, AbstractUpdateEventFeature.getEventDefinitionsValue((Event)businessObject));
        }

        public Class getBusinessObjectType() {
            return IntermediateThrowEvent.class;
        }
    }

    public static class CreateIntermediateThrowEventFeature
    extends AbstractCreateEventFeature<IntermediateThrowEvent> {
        public CreateIntermediateThrowEventFeature(IFeatureProvider fp) {
            super(fp);
        }

        public String getStencilImageId() {
            return ImageProvider.IMG_16_INTERMEDIATE_THORW_EVENT;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getIntermediateThrowEvent();
        }
    }

    public static class UpdateIntermediateThrowEventFeature
    extends AbstractUpdateEventFeature<IntermediateThrowEvent> {
        public static String INTERMEDIATE_THROW_EVENT_MARKER = "marker.intermediate.throw.event";

        public UpdateIntermediateThrowEventFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected String getPropertyKey() {
            return INTERMEDIATE_THROW_EVENT_MARKER;
        }
    }
}

