/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.flow;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.ComplexGateway;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2UpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.BaseElementConnectionFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.DefaultLayoutBPMNConnectionFeature;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractAddFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractCreateFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractReconnectFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.util.IColorConstant;

public class SequenceFlowFeatureContainer
extends BaseElementConnectionFeatureContainer {
    private static final String IS_DEFAULT_FLOW_PROPERTY = "is.default.flow";
    private static final String IS_CONDITIONAL_FLOW_PROPERTY = "is.conditional.flow";
    private static final String DEFAULT_MARKER_PROPERTY = "default.marker";
    private static final String CONDITIONAL_MARKER_PROPERTY = "conditional.marker";

    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof SequenceFlow;
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddSequenceFlowFeature(fp);
    }

    public ICreateConnectionFeature getCreateConnectionFeature(IFeatureProvider fp) {
        return new CreateSequenceFlowFeature(fp);
    }

    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return new DefaultLayoutBPMNConnectionFeature(fp);
    }

    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        MultiUpdateFeature multiUpdate = new MultiUpdateFeature(fp);
        multiUpdate.addFeature((IUpdateFeature)new UpdateDefaultSequenceFlowFeature(fp));
        multiUpdate.addFeature((IUpdateFeature)new UpdateConditionalSequenceFlowFeature(fp));
        multiUpdate.addFeature((IUpdateFeature)new UpdateLabelFeature(fp));
        return multiUpdate;
    }

    public IReconnectionFeature getReconnectionFeature(IFeatureProvider fp) {
        return new ReconnectSequenceFlowFeature(fp);
    }

    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return null;
    }

    private static Color manageColor(PictogramElement element, IColorConstant colorConstant) {
        IPeService peService = Graphiti.getPeService();
        Diagram diagram = peService.getDiagramForPictogramElement(element);
        return Graphiti.getGaService().manageColor(diagram, colorConstant);
    }

    private static void setDefaultSequenceFlow(Connection connection) {
        IPeService peService = Graphiti.getPeService();
        SequenceFlow flow = (SequenceFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, SequenceFlow.class);
        SequenceFlow defaultFlow = SequenceFlowFeatureContainer.getDefaultFlow(flow.getSourceRef());
        boolean isDefault = defaultFlow == null ? false : defaultFlow.equals(flow);
        Tuple<ConnectionDecorator, ConnectionDecorator> decorators = SequenceFlowFeatureContainer.getConnectionDecorators(connection);
        ConnectionDecorator def = (ConnectionDecorator)decorators.getFirst();
        ConnectionDecorator cond = (ConnectionDecorator)decorators.getSecond();
        if (isDefault) {
            if (cond != null) {
                peService.deletePictogramElement((PictogramElement)cond);
            }
            def = SequenceFlowFeatureContainer.createDefaultConnectionDecorator(connection);
            def.getGraphicsAlgorithm();
        } else {
            if (def != null) {
                peService.deletePictogramElement((PictogramElement)def);
            }
            if (flow.getConditionExpression() != null && flow.getSourceRef() instanceof Activity) {
                cond = SequenceFlowFeatureContainer.createConditionalConnectionDecorator(connection);
                GraphicsAlgorithm ga = cond.getGraphicsAlgorithm();
                ga.setFilled(Boolean.valueOf(true));
                ga.setBackground(SequenceFlowFeatureContainer.manageColor((PictogramElement)connection, IColorConstant.WHITE));
            }
        }
        peService.setPropertyValue((PropertyContainer)connection, IS_DEFAULT_FLOW_PROPERTY, Boolean.toString(isDefault));
    }

    private static void setConditionalSequenceFlow(Connection connection) {
        IPeService peService = Graphiti.getPeService();
        SequenceFlow flow = (SequenceFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, SequenceFlow.class);
        Tuple<ConnectionDecorator, ConnectionDecorator> decorators = SequenceFlowFeatureContainer.getConnectionDecorators(connection);
        ConnectionDecorator def = (ConnectionDecorator)decorators.getFirst();
        ConnectionDecorator cond = (ConnectionDecorator)decorators.getSecond();
        if (flow.getConditionExpression() != null && flow.getSourceRef() instanceof Activity && def == null) {
            ConnectionDecorator decorator = SequenceFlowFeatureContainer.createConditionalConnectionDecorator(connection);
            GraphicsAlgorithm ga = decorator.getGraphicsAlgorithm();
            ga.setFilled(Boolean.valueOf(true));
            ga.setBackground(SequenceFlowFeatureContainer.manageColor((PictogramElement)connection, IColorConstant.WHITE));
        } else if (cond != null) {
            peService.deletePictogramElement((PictogramElement)cond);
        }
        peService.setPropertyValue((PropertyContainer)connection, IS_CONDITIONAL_FLOW_PROPERTY, Boolean.toString(flow.getConditionExpression() != null));
    }

    private static boolean isDefaultAttributeSupported(FlowNode node) {
        if (node instanceof Activity) {
            return true;
        }
        return node instanceof ExclusiveGateway || node instanceof InclusiveGateway || node instanceof ComplexGateway;
    }

    private static SequenceFlow getDefaultFlow(FlowNode node) {
        if (SequenceFlowFeatureContainer.isDefaultAttributeSupported(node)) {
            try {
                return (SequenceFlow)node.getClass().getMethod("getDefault", new Class[0]).invoke((Object)node, new Object[0]);
            }
            catch (Exception e) {
                Activator.logError((Exception)e);
            }
        }
        return null;
    }

    private static Tuple<ConnectionDecorator, ConnectionDecorator> getConnectionDecorators(Connection connection) {
        IPeService peService = Graphiti.getPeService();
        ConnectionDecorator defaultDecorator = null;
        ConnectionDecorator conditionalDecorator = null;
        for (ConnectionDecorator connectionDecorator : connection.getConnectionDecorators()) {
            String defProp = peService.getPropertyValue((PropertyContainer)connectionDecorator, DEFAULT_MARKER_PROPERTY);
            if (defProp != null && new Boolean(defProp).booleanValue()) {
                defaultDecorator = connectionDecorator;
                continue;
            }
            String condProp = peService.getPropertyValue((PropertyContainer)connectionDecorator, CONDITIONAL_MARKER_PROPERTY);
            if (condProp == null || !new Boolean(condProp).booleanValue()) continue;
            conditionalDecorator = connectionDecorator;
        }
        return new Tuple(defaultDecorator, conditionalDecorator);
    }

    private static ConnectionDecorator createDefaultConnectionDecorator(Connection connection) {
        ConnectionDecorator marker = Graphiti.getPeService().createConnectionDecorator(connection, false, 0.0, true);
        Polyline line = Graphiti.getGaService().createPolyline((GraphicsAlgorithmContainer)marker, new int[]{-6, 6, -12, -6});
        line.setLineWidth(Integer.valueOf(2));
        Graphiti.getPeService().setPropertyValue((PropertyContainer)marker, DEFAULT_MARKER_PROPERTY, Boolean.toString(true));
        return marker;
    }

    private static ConnectionDecorator createConditionalConnectionDecorator(Connection connection) {
        ConnectionDecorator marker = Graphiti.getPeService().createConnectionDecorator(connection, false, 0.0, true);
        int[] nArray = new int[8];
        nArray[0] = -15;
        nArray[2] = -7;
        nArray[3] = 5;
        nArray[6] = -7;
        nArray[7] = -5;
        Graphiti.getGaService().createPolygon((GraphicsAlgorithmContainer)marker, nArray);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)marker, CONDITIONAL_MARKER_PROPERTY, Boolean.toString(true));
        return marker;
    }

    public static class AddSequenceFlowFeature
    extends AbstractAddFlowFeature<SequenceFlow> {
        public AddSequenceFlowFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected Polyline createConnectionLine(Connection connection) {
            IPeService peService = Graphiti.getPeService();
            IGaService gaService = Graphiti.getGaService();
            BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
            Polyline connectionLine = super.createConnectionLine(connection);
            connectionLine.setLineStyle(LineStyle.SOLID);
            connectionLine.setLineWidth(Integer.valueOf(2));
            int w = 5;
            int l = 15;
            ConnectionDecorator decorator = peService.createConnectionDecorator(connection, false, 1.0, true);
            int[] nArray = new int[8];
            nArray[0] = -l;
            nArray[1] = w;
            nArray[4] = -l;
            nArray[5] = -w;
            nArray[6] = -l;
            nArray[7] = w;
            Polygon arrowhead = gaService.createPolygon((GraphicsAlgorithmContainer)decorator, nArray);
            StyleUtil.applyStyle((GraphicsAlgorithm)arrowhead, (BaseElement)be);
            return connectionLine;
        }

        protected void decorateConnection(IAddConnectionContext context, Connection connection, SequenceFlow businessObject) {
            SequenceFlowFeatureContainer.setDefaultSequenceFlow(connection);
            SequenceFlowFeatureContainer.setConditionalSequenceFlow(connection);
        }

        public Class getBusinessObjectType() {
            return SequenceFlow.class;
        }
    }

    public static class CreateSequenceFlowFeature
    extends AbstractCreateFlowFeature<SequenceFlow, FlowNode, FlowNode> {
        public CreateSequenceFlowFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected String getStencilImageId() {
            return ImageProvider.IMG_16_SEQUENCE_FLOW;
        }

        protected Class<FlowNode> getSourceClass() {
            return FlowNode.class;
        }

        protected Class<FlowNode> getTargetClass() {
            return FlowNode.class;
        }

        public boolean canCreate(ICreateConnectionContext context) {
            if (!super.canCreate(context)) {
                return false;
            }
            FlowNode source = (FlowNode)this.getSourceBo(context);
            FlowNode target = (FlowNode)this.getTargetBo(context);
            if (source == null || target == null) {
                return false;
            }
            if (source == target) {
                return true;
            }
            if (target instanceof StartEvent) {
                return false;
            }
            EObject sourceContainer = source.eContainer();
            while (sourceContainer != null) {
                if (sourceContainer instanceof Process || sourceContainer instanceof SubProcess) break;
                sourceContainer = sourceContainer.eContainer();
            }
            EObject targetContainer = target.eContainer();
            while (targetContainer != null) {
                if (targetContainer instanceof Process || targetContainer instanceof SubProcess) break;
                targetContainer = targetContainer.eContainer();
            }
            return sourceContainer == targetContainer;
        }

        public boolean isAvailable(IContext context) {
            if (!this.isModelObjectEnabled((EObject)Bpmn2Package.eINSTANCE.getSequenceFlow())) {
                return false;
            }
            return super.isAvailable(context);
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getSequenceFlow();
        }
    }

    public static class ReconnectSequenceFlowFeature
    extends AbstractReconnectFlowFeature {
        public ReconnectSequenceFlowFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canReconnect(IReconnectionContext context) {
            EObject o;
            if (!super.canReconnect(context)) {
                return false;
            }
            return !context.getReconnectType().equals(ReconnectionContext.RECONNECT_TARGET) || !((o = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetPictogramElement())) instanceof CatchEvent);
        }

        protected Class<? extends EObject> getTargetClass() {
            return FlowNode.class;
        }

        protected Class<? extends EObject> getSourceClass() {
            return FlowNode.class;
        }
    }

    public static class UpdateConditionalSequenceFlowFeature
    extends AbstractBpmn2UpdateFeature {
        public UpdateConditionalSequenceFlowFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canUpdate(IUpdateContext context) {
            SequenceFlow flow = (SequenceFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), SequenceFlow.class);
            boolean canUpdate = flow != null && flow.getSourceRef() instanceof Activity;
            return canUpdate;
        }

        public IReason updateNeeded(IUpdateContext context) {
            IPeService peService = Graphiti.getPeService();
            PictogramElement pe = context.getPictogramElement();
            if (pe instanceof Connection) {
                Connection connection = (Connection)pe;
                SequenceFlow flow = (SequenceFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, SequenceFlow.class);
                String property = peService.getPropertyValue((PropertyContainer)connection, SequenceFlowFeatureContainer.IS_CONDITIONAL_FLOW_PROPERTY);
                if (property == null || !this.canUpdate(context)) {
                    return Reason.createFalseReason();
                }
                boolean changed = flow.getConditionExpression() != null ^ new Boolean(property);
                return changed ? Reason.createTrueReason((String)"Conditional Flow") : Reason.createFalseReason();
            }
            return Reason.createFalseReason();
        }

        public boolean update(IUpdateContext context) {
            Connection connection = (Connection)context.getPictogramElement();
            SequenceFlowFeatureContainer.setConditionalSequenceFlow(connection);
            return true;
        }
    }

    public static class UpdateDefaultSequenceFlowFeature
    extends AbstractBpmn2UpdateFeature {
        public UpdateDefaultSequenceFlowFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canUpdate(IUpdateContext context) {
            SequenceFlow flow = (SequenceFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), SequenceFlow.class);
            boolean canUpdate = flow != null && SequenceFlowFeatureContainer.isDefaultAttributeSupported(flow.getSourceRef());
            return canUpdate;
        }

        public IReason updateNeeded(IUpdateContext context) {
            IPeService peService = Graphiti.getPeService();
            String property = peService.getPropertyValue((PropertyContainer)context.getPictogramElement(), SequenceFlowFeatureContainer.IS_DEFAULT_FLOW_PROPERTY);
            if (property == null || !this.canUpdate(context)) {
                return Reason.createFalseReason();
            }
            SequenceFlow flow = (SequenceFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), SequenceFlow.class);
            SequenceFlow defaultFlow = SequenceFlowFeatureContainer.getDefaultFlow(flow.getSourceRef());
            boolean isDefault = defaultFlow == null ? false : defaultFlow.equals(flow);
            boolean changed = isDefault ^ new Boolean(property);
            return changed ? Reason.createTrueReason((String)"Default Flow") : Reason.createFalseReason();
        }

        public boolean update(IUpdateContext context) {
            Connection connection = (Connection)context.getPictogramElement();
            SequenceFlowFeatureContainer.setDefaultSequenceFlow(connection);
            return true;
        }
    }
}

