/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.gateway;

import org.eclipse.bpmn2.EventBasedGateway;
import org.eclipse.bpmn2.EventBasedGatewayType;
import org.eclipse.bpmn2.modeler.core.features.AbstractUpdateBaseElementFeature;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public class UpdateEventBasedGatewayFeature
extends AbstractUpdateBaseElementFeature<EventBasedGateway> {
    public UpdateEventBasedGatewayFeature(IFeatureProvider fp) {
        super(fp);
    }

    public IReason updateNeeded(IUpdateContext context) {
        IReason reason = super.updateNeeded(context);
        if (reason.toBoolean()) {
            return reason;
        }
        IPeService service = Graphiti.getPeService();
        boolean instantiate = Boolean.parseBoolean(service.getPropertyValue((PropertyContainer)context.getPictogramElement(), "instantiate"));
        EventBasedGatewayType gatewayType = EventBasedGatewayType.getByName((String)service.getPropertyValue((PropertyContainer)context.getPictogramElement(), "eventGatewayType"));
        EventBasedGateway gateway = (EventBasedGateway)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        boolean changed = instantiate != gateway.isInstantiate() || gatewayType != gateway.getEventGatewayType();
        return changed ? Reason.createTrueReason((String)"Is Instantiate") : Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        IPeService service = Graphiti.getPeService();
        EventBasedGateway gateway = (EventBasedGateway)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        this.clearGateway(context.getPictogramElement());
        if (gateway.isInstantiate()) {
            if (gateway.getEventGatewayType() == EventBasedGatewayType.PARALLEL) {
                this.drawParallelMultipleEventBased((ContainerShape)context.getPictogramElement());
            } else {
                this.drawExclusiveEventBased((ContainerShape)context.getPictogramElement());
            }
        } else {
            this.drawEventBased((ContainerShape)context.getPictogramElement());
        }
        service.setPropertyValue((PropertyContainer)context.getPictogramElement(), "instantiate", Boolean.toString(gateway.isInstantiate()));
        service.setPropertyValue((PropertyContainer)context.getPictogramElement(), "eventGatewayType", gateway.getEventGatewayType().getName());
        return true;
    }

    private void clearGateway(PictogramElement element) {
        ShapeDecoratorUtil.clearGateway((PictogramElement)element);
    }

    private void drawEventBased(ContainerShape container) {
        if (FeatureSupport.isLabelShape((PictogramElement)container)) {
            return;
        }
        Ellipse outer = ShapeDecoratorUtil.createGatewayOuterCircle((ContainerShape)container);
        ShapeDecoratorUtil.createGatewayInnerCircle((Ellipse)outer);
        Polygon pentagon = ShapeDecoratorUtil.createGatewayPentagon((ContainerShape)container);
        pentagon.setFilled(Boolean.valueOf(false));
    }

    private void drawExclusiveEventBased(ContainerShape container) {
        if (FeatureSupport.isLabelShape((PictogramElement)container)) {
            return;
        }
        ShapeDecoratorUtil.createGatewayOuterCircle((ContainerShape)container);
        Polygon pentagon = ShapeDecoratorUtil.createGatewayPentagon((ContainerShape)container);
        pentagon.setFilled(Boolean.valueOf(false));
    }

    private void drawParallelMultipleEventBased(ContainerShape container) {
        if (FeatureSupport.isLabelShape((PictogramElement)container)) {
            return;
        }
        ShapeDecoratorUtil.createGatewayOuterCircle((ContainerShape)container);
        ShapeDecoratorUtil.createEventGatewayParallelCross((ContainerShape)container);
    }
}

