/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.Messages;
import org.eclipse.bpmn2.modeler.ui.diagram.Bpmn2FeatureMap;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class Bpmn2EditorAppearancePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Bpmn2Preferences preferences;
    TreeViewer elementsTreeViewer;
    List<Class> allElements;
    Group colorGroup;
    Group labelGroup;
    Composite colorEditors;
    Composite container;
    Hashtable<Object, ShapeStyle> allShapeStyles;
    ShapeStyleCategoryList categories;
    ShapeStyleCategoryList shapesList = new ShapeStyleCategoryList(ShapeStyle.Category.SHAPES);
    ShapeStyleList connectionShapeStyles = new ShapeStyleList(ShapeStyle.Category.CONNECTIONS);
    ShapeStyleList eventShapeStyles = new ShapeStyleList(ShapeStyle.Category.EVENTS);
    ShapeStyleList gatewayShapeStyles = new ShapeStyleList(ShapeStyle.Category.GATEWAYS);
    ShapeStyleList taskShapeStyles = new ShapeStyleList(ShapeStyle.Category.TASKS);
    ShapeStyleList globalTaskShapeStyles = new ShapeStyleList(ShapeStyle.Category.GLOBAL_TASKS);
    ShapeStyleList subProcessShapeStyles = new ShapeStyleList(ShapeStyle.Category.SUBPROCESS);
    ShapeStyleList choreographyShapeStyles = new ShapeStyleList(ShapeStyle.Category.CHOREOGRAPHY);
    ShapeStyleList conversationShapeStyles = new ShapeStyleList(ShapeStyle.Category.CONVERSATION);
    ShapeStyleList swimLanesShapeStyles = new ShapeStyleList(ShapeStyle.Category.SWIMLANES);
    ShapeStyleList dataShapeStyles = new ShapeStyleList(ShapeStyle.Category.DATA);
    ShapeStyleList artifactShapeStyles = new ShapeStyleList(ShapeStyle.Category.ARTIFACTS);
    Object currentSelection;
    ColorShapeStyleEditor shapeBackground;
    ColorShapeStyleEditor shapePrimarySelectedColor;
    ColorShapeStyleEditor shapeSecondarySelectedColor;
    ColorShapeStyleEditor shapeForeground;
    CheckboxShapeStyleEditor useDefaultSize;
    Button applyToAllChildren;
    IntegerShapeStyleEditor defaultWidth;
    IntegerShapeStyleEditor defaultHeight;
    FontShapeStyleEditor labelFont;
    ColorShapeStyleEditor labelForeground;
    RoutingStyleShapeStyleEditor routingStyleViewer;
    LabelLocationShapeStyleEditor labelLocationViewer;
    BEListLabelProvider labelProvider;

    public Bpmn2EditorAppearancePreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.preferences = Bpmn2Preferences.getInstance();
    }

    public void init(IWorkbench workbench) {
        this.allElements = new ArrayList<Class>();
        this.allElements.addAll(Bpmn2FeatureMap.CONNECTIONS);
        this.allElements.addAll(Bpmn2FeatureMap.EVENTS);
        this.allElements.addAll(Bpmn2FeatureMap.GATEWAYS);
        this.allElements.addAll(Bpmn2FeatureMap.TASKS);
        this.allElements.addAll(Bpmn2FeatureMap.GLOBAL_TASKS);
        this.allElements.addAll(Bpmn2FeatureMap.SUBPROCESS);
        this.allElements.addAll(Bpmn2FeatureMap.CHOREOGRAPHY);
        this.allElements.addAll(Bpmn2FeatureMap.CONVERSATION);
        this.allElements.addAll(Bpmn2FeatureMap.SWIMLANES);
        this.allElements.addAll(Bpmn2FeatureMap.ALL_DATA);
        this.allElements.addAll(Bpmn2FeatureMap.ARTIFACTS);
        Collections.sort(this.allElements, new Comparator<Class>(){

            @Override
            public int compare(Class arg0, Class arg1) {
                return arg0.getSimpleName().compareTo(arg1.getSimpleName());
            }
        });
    }

    protected Control createContents(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.container.setLayout((Layout)new GridLayout(2, true));
        final Group elementsGroup = new Group(this.container, 0);
        elementsGroup.setText(Messages.Bpmn2EditorPreferencePage_GraphicalElements_Group);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        elementsGroup.setLayoutData((Object)gd);
        elementsGroup.setLayout((Layout)new GridLayout(1, false));
        this.elementsTreeViewer = new TreeViewer((Composite)elementsGroup, 2816);
        Tree elementsTree = this.elementsTreeViewer.getTree();
        gd = new GridData(4, 128, true, true, 1, 1);
        elementsTree.setLayoutData((Object)gd);
        this.elementsTreeViewer.setContentProvider((IContentProvider)new BEListContentProvider());
        this.labelProvider = new BEListLabelProvider();
        this.elementsTreeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                GridData gd = (GridData)elementsGroup.getLayoutData();
                gd.heightHint = 500;
                gd = (GridData)Bpmn2EditorAppearancePreferencePage.this.elementsTreeViewer.getTree().getLayoutData();
                gd.heightHint = 500;
                Bpmn2EditorAppearancePreferencePage.this.container.layout();
            }
        });
        Composite colorAndLabelComposite = new Composite(this.container, 0);
        colorAndLabelComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        colorAndLabelComposite.setLayout((Layout)new GridLayout(1, false));
        this.colorGroup = new Group(colorAndLabelComposite, 0);
        this.colorGroup.setText(Messages.Bpmn2EditorPreferencePage_Colors_Group);
        this.colorGroup.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.colorGroup.setLayout((Layout)new GridLayout(1, false));
        this.colorEditors = new Composite((Composite)this.colorGroup, 0);
        this.colorEditors.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        this.colorEditors.setLayout((Layout)layout);
        this.colorEditors.setFont(parent.getFont());
        this.shapeBackground = new ColorShapeStyleEditor(this.colorEditors, 1, Messages.Bpmn2EditorPreferencePage_Fill_Color_Label);
        this.shapeBackground.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IColorConstant c = Bpmn2EditorAppearancePreferencePage.this.shapeBackground.getValue();
                ShapeStyle ss = Bpmn2EditorAppearancePreferencePage.this.allShapeStyles.get(Bpmn2EditorAppearancePreferencePage.this.currentSelection);
                if (Bpmn2EditorAppearancePreferencePage.this.currentSelection instanceof Class) {
                    ss.setDefaultColors(c);
                    Bpmn2EditorAppearancePreferencePage.this.shapePrimarySelectedColor.setValue(ss.getShapePrimarySelectedColor());
                    Bpmn2EditorAppearancePreferencePage.this.shapeSecondarySelectedColor.setValue(ss.getShapeSecondarySelectedColor());
                    Bpmn2EditorAppearancePreferencePage.this.shapeForeground.setValue(ss.getShapeForeground());
                    Bpmn2EditorAppearancePreferencePage.this.labelForeground.setValue(ss.getLabelForeground());
                }
            }
        });
        this.shapeForeground = new ColorShapeStyleEditor(this.colorEditors, 2, Messages.Bpmn2EditorPreferencePage_Foreground_Color_Label);
        this.shapePrimarySelectedColor = new ColorShapeStyleEditor(this.colorEditors, 4, Messages.Bpmn2EditorPreferencePage_Selected_Color_Label);
        this.shapeSecondarySelectedColor = new ColorShapeStyleEditor(this.colorEditors, 8, Messages.Bpmn2EditorPreferencePage_MultiSelected_Color_Label);
        this.defaultWidth = new IntegerShapeStyleEditor(this.colorEditors, 512, "");
        gd = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd.horizontalIndent = 5;
        gd.verticalIndent = 10;
        this.defaultWidth.setLayoutData(gd);
        this.defaultHeight = new IntegerShapeStyleEditor(this.colorEditors, 1024, "");
        gd = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd.horizontalIndent = 5;
        gd.verticalIndent = 10;
        this.defaultHeight.setLayoutData(gd);
        this.useDefaultSize = new CheckboxShapeStyleEditor(this.colorEditors, 256, "");
        gd = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd.horizontalIndent = 5;
        gd.verticalIndent = 10;
        this.useDefaultSize.setLayoutData(gd);
        Composite routingStyleComposite = new Composite(this.colorEditors, 0);
        routingStyleComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        layout = new GridLayout(2, false);
        routingStyleComposite.setLayout((Layout)layout);
        this.routingStyleViewer = new RoutingStyleShapeStyleEditor(this.colorEditors, Messages.Bpmn2EditorPreferencePage_Routing_Style_Label);
        this.routingStyleViewer.setLayoutData(new GridData(4, 0x1000000, true, true, 1, 1));
        this.labelGroup = new Group(colorAndLabelComposite, 0);
        this.labelGroup.setText("Labels");
        this.labelGroup.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.labelGroup.setLayout((Layout)new GridLayout(1, false));
        this.labelForeground = new ColorShapeStyleEditor((Composite)this.labelGroup, 32, Messages.Bpmn2EditorPreferencePage_Label_Color_Label);
        this.showControl((Control)this.labelForeground, false);
        this.labelFont = new FontShapeStyleEditor((Composite)this.labelGroup, 16, Messages.Bpmn2EditorPreferencePage_Label_Font_Label);
        this.showControl((Control)this.labelFont, false);
        this.labelLocationViewer = new LabelLocationShapeStyleEditor((Composite)this.labelGroup, Messages.Bpmn2EditorPreferencePage_Label_Location_Label);
        this.labelLocationViewer.setLayoutData(new GridData(4, 0x1000000, true, true, 1, 1));
        this.applyToAllChildren = new Button(colorAndLabelComposite, 32);
        this.applyToAllChildren.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.applyToAllChildren.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Bpmn2EditorAppearancePreferencePage.this.configureAll();
            }
        });
        this.showControl((Control)this.applyToAllChildren, false);
        this.loadStyleEditors();
        this.configureForShapes(null);
        this.configureAll();
        this.elementsTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new BEListSelectionChangedListener());
        return this.container;
    }

    private void applyToAll(ShapeStyle theShapeStyle) {
        if (this.applyToAllChildren != null && this.applyToAllChildren.getSelection() && this.currentSelection instanceof ShapeStyle.Category) {
            ArrayList<Object> ssl = new ArrayList<Object>();
            switch ((ShapeStyle.Category)this.currentSelection) {
                case CONNECTIONS: {
                    ssl.addAll(this.connectionShapeStyles.values());
                    break;
                }
                case SHAPES: {
                    ssl.addAll(this.eventShapeStyles.values());
                    ssl.addAll(this.gatewayShapeStyles.values());
                    ssl.addAll(this.taskShapeStyles.values());
                    ssl.addAll(this.globalTaskShapeStyles.values());
                    ssl.addAll(this.subProcessShapeStyles.values());
                    ssl.addAll(this.choreographyShapeStyles.values());
                    ssl.addAll(this.conversationShapeStyles.values());
                    ssl.addAll(this.swimLanesShapeStyles.values());
                    ssl.addAll(this.dataShapeStyles.values());
                    ssl.addAll(this.artifactShapeStyles.values());
                    ssl.add(this.allShapeStyles.get(ShapeStyle.Category.EVENTS));
                    ssl.add(this.allShapeStyles.get(ShapeStyle.Category.GATEWAYS));
                    ssl.add(this.allShapeStyles.get(ShapeStyle.Category.TASKS));
                    ssl.add(this.allShapeStyles.get(ShapeStyle.Category.GLOBAL_TASKS));
                    ssl.add(this.allShapeStyles.get(ShapeStyle.Category.SUBPROCESS));
                    ssl.add(this.allShapeStyles.get(ShapeStyle.Category.CHOREOGRAPHY));
                    ssl.add(this.allShapeStyles.get(ShapeStyle.Category.CONVERSATION));
                    ssl.add(this.allShapeStyles.get(ShapeStyle.Category.SWIMLANES));
                    ssl.add(this.allShapeStyles.get(ShapeStyle.Category.DATA));
                    ssl.add(this.allShapeStyles.get(ShapeStyle.Category.ARTIFACTS));
                    break;
                }
                case CANVAS: {
                    break;
                }
                case DATA: {
                    ssl.addAll(this.dataShapeStyles.values());
                    break;
                }
                case EVENTS: {
                    ssl.addAll(this.eventShapeStyles.values());
                    break;
                }
                case GATEWAYS: {
                    ssl.addAll(this.gatewayShapeStyles.values());
                    break;
                }
                case GRID: {
                    break;
                }
                case ARTIFACTS: {
                    ssl.addAll(this.artifactShapeStyles.values());
                    break;
                }
                case TASKS: {
                    ssl.addAll(this.taskShapeStyles.values());
                    break;
                }
                case GLOBAL_TASKS: {
                    ssl.addAll(this.globalTaskShapeStyles.values());
                    break;
                }
                case SUBPROCESS: {
                    ssl.addAll(this.subProcessShapeStyles.values());
                    break;
                }
                case CHOREOGRAPHY: {
                    ssl.addAll(this.choreographyShapeStyles.values());
                    break;
                }
                case CONVERSATION: {
                    ssl.addAll(this.conversationShapeStyles.values());
                    break;
                }
                case SWIMLANES: {
                    ssl.addAll(this.swimLanesShapeStyles.values());
                    break;
                }
            }
            for (ShapeStyle shapeStyle : ssl) {
                shapeStyle.applyChanges(theShapeStyle);
            }
        }
    }

    private void loadStyleEditors() {
        if (this.allShapeStyles == null) {
            ShapeStyle ss;
            this.allShapeStyles = new Hashtable();
            this.shapesList.put(ShapeStyle.Category.EVENTS.toString(), this.eventShapeStyles);
            this.shapesList.put(ShapeStyle.Category.GATEWAYS.toString(), this.gatewayShapeStyles);
            this.shapesList.put(ShapeStyle.Category.TASKS.toString(), this.taskShapeStyles);
            this.shapesList.put(ShapeStyle.Category.GLOBAL_TASKS.toString(), this.globalTaskShapeStyles);
            this.shapesList.put(ShapeStyle.Category.SUBPROCESS.toString(), this.subProcessShapeStyles);
            this.shapesList.put(ShapeStyle.Category.CHOREOGRAPHY.toString(), this.choreographyShapeStyles);
            this.shapesList.put(ShapeStyle.Category.CONVERSATION.toString(), this.conversationShapeStyles);
            this.shapesList.put(ShapeStyle.Category.SWIMLANES.toString(), this.swimLanesShapeStyles);
            this.shapesList.put(ShapeStyle.Category.DATA.toString(), this.dataShapeStyles);
            this.shapesList.put(ShapeStyle.Category.ARTIFACTS.toString(), this.artifactShapeStyles);
            this.categories = new ShapeStyleCategoryList(ShapeStyle.Category.NONE);
            this.categories.put(ShapeStyle.Category.CONNECTIONS.toString(), this.connectionShapeStyles);
            this.categories.put(ShapeStyle.Category.SHAPES.toString(), this.shapesList);
            for (Class c : this.allElements) {
                ss = new ShapeStyle(this.preferences.getShapeStyle(c));
                this.allShapeStyles.put(c, ss);
                if (Bpmn2FeatureMap.CONNECTIONS.contains(c)) {
                    this.connectionShapeStyles.put(c, ss);
                }
                if (Bpmn2FeatureMap.EVENTS.contains(c)) {
                    this.eventShapeStyles.put(c, ss);
                }
                if (Bpmn2FeatureMap.GATEWAYS.contains(c)) {
                    this.gatewayShapeStyles.put(c, ss);
                }
                if (Bpmn2FeatureMap.TASKS.contains(c)) {
                    this.taskShapeStyles.put(c, ss);
                }
                if (Bpmn2FeatureMap.GLOBAL_TASKS.contains(c)) {
                    this.globalTaskShapeStyles.put(c, ss);
                }
                if (Bpmn2FeatureMap.SUBPROCESS.contains(c)) {
                    this.subProcessShapeStyles.put(c, ss);
                }
                if (Bpmn2FeatureMap.CHOREOGRAPHY.contains(c)) {
                    this.choreographyShapeStyles.put(c, ss);
                }
                if (Bpmn2FeatureMap.CONVERSATION.contains(c)) {
                    this.conversationShapeStyles.put(c, ss);
                }
                if (Bpmn2FeatureMap.SWIMLANES.contains(c)) {
                    this.swimLanesShapeStyles.put(c, ss);
                }
                if (Bpmn2FeatureMap.ALL_DATA.contains(c)) {
                    this.dataShapeStyles.put(c, ss);
                }
                if (Bpmn2FeatureMap.ARTIFACTS.contains(c)) {
                    this.artifactShapeStyles.put(c, ss);
                }
                if (!Activator.getDefault().isDebugging()) continue;
                System.out.println("\t\t<style object=\"" + c.getSimpleName() + "\" " + "shapeForeground" + "=\"" + ShapeStyle.colorToString((IColorConstant)ss.getShapeForeground()) + "\" " + "shapeBackground" + "=\"" + ShapeStyle.colorToString((IColorConstant)ss.getShapeBackground()) + "\" " + "labelFont" + "=\"" + ShapeStyle.fontToString((Font)ss.getLabelFont()) + "\" " + "labelForeground" + "=\"" + ShapeStyle.colorToString((IColorConstant)ss.getLabelForeground()) + "\" " + "labelBackground" + "=\"" + ShapeStyle.colorToString((IColorConstant)ss.getLabelBackground()) + "\" " + "labelPosition" + "=\"" + ss.getLabelPosition().name() + "\" " + "routingStyle" + "=\"" + ss.getRoutingStyle().name() + "\" " + "useDefaultSize" + "=\"" + ss.getUseDefaultSize() + "\" " + "defaultHeight" + "=\"" + ss.getDefaultHeight() + "\" " + "defaultWidth" + "=\"" + ss.getDefaultWidth() + "\" " + "/>");
            }
            ShapeStyle.Category[] categoryArray = ShapeStyle.Category.values();
            int n = categoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ShapeStyle.Category key = categoryArray[n2];
                ss = new ShapeStyle(this.preferences.getShapeStyle(key));
                this.allShapeStyles.put(key, ss);
                ++n2;
            }
            ss = new ShapeStyle(this.preferences.getShapeStyle(ShapeStyle.Category.CANVAS));
            this.categories.put(ShapeStyle.Category.CANVAS.toString(), ShapeStyle.Category.CANVAS);
            ss = new ShapeStyle(this.preferences.getShapeStyle(ShapeStyle.Category.GRID));
            this.categories.put(ShapeStyle.Category.GRID.toString(), ShapeStyle.Category.GRID);
            this.currentSelection = null;
            this.elementsTreeViewer.setInput((Object)this.categories);
            this.elementsTreeViewer.setSelection(null);
        }
        Object key = null;
        ShapeStyle ss = null;
        if (this.currentSelection instanceof Class) {
            key = this.currentSelection;
            ss = this.allShapeStyles.get((Class)key);
        } else if (this.currentSelection instanceof ShapeStyle.Category) {
            key = this.currentSelection;
            ss = this.allShapeStyles.get((ShapeStyle.Category)key);
        }
        if (ss != null) {
            this.shapeForeground.setValue(ss.getShapeForeground());
            this.shapeBackground.setValue(ss.getShapeBackground());
            this.shapePrimarySelectedColor.setValue(ss.getShapePrimarySelectedColor());
            this.shapeSecondarySelectedColor.setValue(ss.getShapeSecondarySelectedColor());
            this.useDefaultSize.setValue(ss.getUseDefaultSize());
            this.defaultWidth.setValue(ss.getDefaultWidth());
            this.defaultHeight.setValue(ss.getDefaultHeight());
            this.labelFont.setValue(ss.getLabelFont());
            this.labelForeground.setValue(ss.getLabelForeground());
            this.labelLocationViewer.setValue(ss.getLabelPosition());
            if (Bpmn2FeatureMap.CONNECTIONS.contains(key) || key == ShapeStyle.Category.CONNECTIONS) {
                this.configureForConnections(ss);
            } else if (key == ShapeStyle.Category.CANVAS) {
                this.configureForCanvas(ss);
            } else if (key == ShapeStyle.Category.GRID) {
                this.configureForGrid(ss);
            } else {
                this.configureForShapes(ss);
            }
            this.container.layout();
        } else {
            this.showControl((Control)this.labelFont, false);
            this.showControl((Control)this.labelForeground, false);
        }
    }

    private void configureAll() {
        boolean enabled;
        boolean bl = enabled = this.currentSelection != null;
        if (this.currentSelection instanceof ShapeStyle.Category && this.currentSelection != ShapeStyle.Category.CANVAS && this.currentSelection != ShapeStyle.Category.GRID) {
            this.showControl((Control)this.applyToAllChildren, true);
            this.applyToAllChildren.setText("Apply changes to all " + ((ShapeStyle.Category)this.currentSelection).toString());
            enabled = this.applyToAllChildren.getSelection();
        } else {
            this.showControl((Control)this.applyToAllChildren, false);
        }
        this.enableComposite((Composite)this.colorGroup, enabled);
        this.enableComposite((Composite)this.labelGroup, enabled);
        this.showControl((Control)this.labelLocationViewer, this.hasLabel());
    }

    private boolean hasLabel() {
        ShapeStyle.Category k;
        Class c;
        return !(this.currentSelection instanceof Class ? Bpmn2FeatureMap.TASKS.contains(c = (Class)this.currentSelection) || Bpmn2FeatureMap.GLOBAL_TASKS.contains(c) || Bpmn2FeatureMap.SUBPROCESS.contains(c) || Bpmn2FeatureMap.CHOREOGRAPHY.contains(c) || Bpmn2FeatureMap.SWIMLANES.contains(c) || Bpmn2FeatureMap.ARTIFACTS.contains(c) : this.currentSelection instanceof ShapeStyle.Category && ((k = (ShapeStyle.Category)this.currentSelection) == ShapeStyle.Category.TASKS || k == ShapeStyle.Category.GLOBAL_TASKS || k == ShapeStyle.Category.SUBPROCESS || k == ShapeStyle.Category.CHOREOGRAPHY || k == ShapeStyle.Category.SWIMLANES || k == ShapeStyle.Category.CANVAS || k == ShapeStyle.Category.GRID));
    }

    private void configureForConnections(ShapeStyle ss) {
        this.showControl((Control)this.shapeForeground, true);
        this.showControl((Control)this.shapeBackground, false);
        this.showControl((Control)this.shapePrimarySelectedColor, false);
        this.showControl((Control)this.shapeSecondarySelectedColor, false);
        this.showControl((Control)this.routingStyleViewer, true);
        this.routingStyleViewer.setValue(ss.getRoutingStyle());
        this.showControl((Control)this.labelGroup, true);
        this.showControl((Control)this.labelFont, true);
        this.showControl((Control)this.labelForeground, true);
        this.showControl((Control)this.useDefaultSize, false);
        this.showControl((Control)this.defaultWidth, true);
        this.showControl((Control)this.defaultHeight, false);
        this.configureAll();
    }

    private void configureForShapes(ShapeStyle ss) {
        this.showControl((Control)this.shapeForeground, true);
        this.showControl((Control)this.shapeBackground, true);
        this.showControl((Control)this.shapePrimarySelectedColor, true);
        this.showControl((Control)this.shapeSecondarySelectedColor, true);
        this.showControl((Control)this.routingStyleViewer, false);
        this.showControl((Control)this.labelGroup, true);
        this.showControl((Control)this.labelFont, true);
        this.showControl((Control)this.labelForeground, true);
        this.useDefaultSize.setText(Messages.Bpmn2EditorPreferencePage_UseDefaultSize);
        this.showControl((Control)this.useDefaultSize, true);
        this.defaultWidth.setText(Messages.Bpmn2EditorPreferencePage_DefaultWidth);
        this.showControl((Control)this.defaultWidth, true);
        this.defaultHeight.setText(Messages.Bpmn2EditorPreferencePage_DefaultHeight);
        this.showControl((Control)this.defaultHeight, true);
        this.configureAll();
    }

    private void configureForCanvas(ShapeStyle ss) {
        this.showControl((Control)this.shapeForeground, false);
        this.showControl((Control)this.shapeBackground, true);
        this.showControl((Control)this.shapePrimarySelectedColor, false);
        this.showControl((Control)this.shapeSecondarySelectedColor, false);
        this.showControl((Control)this.routingStyleViewer, false);
        this.showControl((Control)this.labelGroup, false);
        this.showControl((Control)this.labelFont, false);
        this.showControl((Control)this.labelForeground, false);
        this.showControl((Control)this.useDefaultSize, false);
        this.showControl((Control)this.defaultWidth, false);
        this.showControl((Control)this.defaultHeight, false);
        this.configureAll();
    }

    private void configureForGrid(ShapeStyle ss) {
        this.showControl((Control)this.shapeForeground, true);
        this.showControl((Control)this.shapeBackground, false);
        this.showControl((Control)this.shapePrimarySelectedColor, false);
        this.showControl((Control)this.shapeSecondarySelectedColor, false);
        this.showControl((Control)this.routingStyleViewer, false);
        this.showControl((Control)this.labelGroup, false);
        this.showControl((Control)this.labelFont, false);
        this.showControl((Control)this.labelForeground, false);
        this.useDefaultSize.setText(Messages.Bpmn2EditorPreferencePage_SnapToGrid);
        this.showControl((Control)this.useDefaultSize, true);
        this.defaultWidth.setText(Messages.Bpmn2EditorPreferencePage_GridWidth);
        this.showControl((Control)this.defaultWidth, true);
        this.defaultHeight.setText(Messages.Bpmn2EditorPreferencePage_GridHeight);
        this.showControl((Control)this.defaultHeight, true);
        this.configureAll();
    }

    private void showControl(Control control, boolean visible) {
        if (control != null && !control.isDisposed()) {
            control.setVisible(visible);
            ((GridData)control.getLayoutData()).exclude = !visible;
        }
    }

    private void enableComposite(Composite composite, boolean enabled) {
        if (composite != null && !composite.isDisposed()) {
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.setEnabled(enabled);
                if (c instanceof Composite) {
                    this.enableComposite((Composite)c, enabled);
                }
                ++n2;
            }
        }
    }

    protected void performDefaults() {
        try {
            this.preferences.setToDefault("shape.style");
            this.allShapeStyles = null;
            this.loadStyleEditors();
            this.preferences.flush();
        }
        catch (Exception exception) {}
        super.performDefaults();
    }

    public boolean performOk() {
        for (Map.Entry<Object, ShapeStyle> entry : this.allShapeStyles.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof Class) {
                key = ((Class)key).getSimpleName();
            }
            this.preferences.setShapeStyle(key.toString(), entry.getValue());
        }
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return super.performOk();
    }

    private class BEListContentProvider
    implements ITreeContentProvider {
        ShapeStyleCategoryList categories;

        private BEListContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof ShapeStyleCategoryList) {
                this.categories = (ShapeStyleCategoryList)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)inputElement;
                boolean cfr_ignored_0 = entry.getKey() instanceof ShapeStyle.Category;
            }
            if (inputElement instanceof ShapeStyleCategoryList) {
                ShapeStyleCategoryList categories = (ShapeStyleCategoryList)inputElement;
                return categories.entrySet().toArray();
            }
            if (inputElement instanceof ShapeStyleList) {
                ShapeStyleList shapeStyles = (ShapeStyleList)inputElement;
                return shapeStyles.keySet().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)parentElement;
                Object value = entry.getValue();
                if (value instanceof ShapeStyleCategoryList) {
                    return ((ShapeStyleCategoryList)value).entrySet().toArray();
                }
                if (value instanceof ShapeStyleList) {
                    return ((ShapeStyleList)value).entrySet().toArray();
                }
            } else if (parentElement instanceof ShapeStyleCategoryList) {
                return ((ShapeStyleCategoryList)parentElement).entrySet().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null;
        }
    }

    private class BEListLabelProvider
    extends LabelProvider {
        private Hashtable<Object, String> classNameMap = new Hashtable();

        private BEListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                if (entry.getKey() instanceof String) {
                    return (String)entry.getKey();
                }
                if (entry.getKey() instanceof Class) {
                    String text = this.classNameMap.get((Class)entry.getKey());
                    if (text != null) {
                        return text;
                    }
                    return ModelUtil.toCanonicalString((String)((Class)entry.getKey()).getSimpleName());
                }
            }
            return element.toString();
        }

        public void setText(Object c, String t) {
            this.classNameMap.put(c, t);
        }
    }

    private class BEListSelectionChangedListener
    implements ISelectionChangedListener {
        private BEListSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)Bpmn2EditorAppearancePreferencePage.this.elementsTreeViewer.getSelection();
            if (sel != null) {
                Object element = sel.getFirstElement();
                if (element != null) {
                    if (element instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)element;
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (value instanceof ShapeStyleCategoryList) {
                            Bpmn2EditorAppearancePreferencePage.this.colorEditors.setVisible(true);
                            Bpmn2EditorAppearancePreferencePage.this.currentSelection = ((ShapeStyleCategoryList)value).key;
                        } else if (value instanceof ShapeStyleList) {
                            Bpmn2EditorAppearancePreferencePage.this.colorEditors.setVisible(true);
                            Bpmn2EditorAppearancePreferencePage.this.currentSelection = ((ShapeStyleList)value).key;
                        } else if (value instanceof ShapeStyle.Category) {
                            Bpmn2EditorAppearancePreferencePage.this.colorEditors.setVisible(true);
                            Bpmn2EditorAppearancePreferencePage.this.currentSelection = (ShapeStyle.Category)value;
                        } else if (key instanceof Class) {
                            Bpmn2EditorAppearancePreferencePage.this.colorEditors.setVisible(true);
                            Bpmn2EditorAppearancePreferencePage.this.currentSelection = key;
                        } else {
                            Bpmn2EditorAppearancePreferencePage.this.colorEditors.setVisible(false);
                            Bpmn2EditorAppearancePreferencePage.this.currentSelection = null;
                        }
                    }
                } else {
                    Bpmn2EditorAppearancePreferencePage.this.configureAll();
                }
                Bpmn2EditorAppearancePreferencePage.this.loadStyleEditors();
            }
        }
    }

    private class CheckboxShapeStyleEditor
    extends ShapeStyleEditor {
        private Button checkbox;

        public CheckboxShapeStyleEditor(Composite parent, int ssMask, String labelText) {
            super(parent, 0, ssMask);
            this.setLayoutData(new GridData(4, 128, true, false, 1, 1));
            this.setLayout((Layout)new GridLayout(1, true));
            this.checkbox = new Button((Composite)this, 32);
            this.checkbox.setText(labelText);
            this.checkbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }

        public void setText(String labelText) {
            if (this.checkbox != null) {
                this.checkbox.setText(labelText);
            }
        }

        @Override
        public void addSelectionListener(SelectionListener listener) {
            this.checkbox.addSelectionListener(listener);
        }

        @Override
        public Boolean getValue() {
            if (this.checkbox != null) {
                return new Boolean(this.checkbox.getSelection());
            }
            return false;
        }

        public void setValue(boolean value) {
            if (this.checkbox != null) {
                this.checkbox.setSelection(value);
            }
        }
    }

    private class ColorShapeStyleEditor
    extends ShapeStyleEditor {
        private ColorSelector colorSelector;
        private Label selectorLabel;
        private List<SelectionListener> listeners;

        public ColorShapeStyleEditor(Composite parent, int ssMask, String labelText) {
            super(parent, 0, ssMask);
            this.setLayoutData(new GridData(4, 128, true, false, 1, 1));
            this.setLayout((Layout)new GridLayout(2, false));
            this.selectorLabel = new Label((Composite)this, 16384);
            this.selectorLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.selectorLabel.setFont(parent.getFont());
            this.selectorLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ColorShapeStyleEditor.this.selectorLabel = null;
                }
            });
            this.selectorLabel.setText(labelText);
            this.colorSelector = new ColorSelector((Composite)this);
            this.colorSelector.getButton().setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        }

        @Override
        public void addSelectionListener(final SelectionListener listener) {
            this.colorSelector.addListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    Event event = new Event();
                    event.widget = ColorShapeStyleEditor.this.colorSelector.getButton();
                    SelectionEvent se = new SelectionEvent(event);
                    se.data = ColorShapeStyleEditor.this.getValue();
                    listener.widgetSelected(se);
                }
            });
        }

        public IColorConstant getValue() {
            return ShapeStyle.RGBToColor((RGB)this.colorSelector.getColorValue());
        }

        public void setValue(IColorConstant c) {
            RGB rgb = ShapeStyle.colorToRGB((IColorConstant)c);
            this.colorSelector.setColorValue(rgb);
        }
    }

    private class FontShapeStyleEditor
    extends ShapeStyleEditor {
        private Button changeFontButton;
        private FontData[] selectedFont;
        private Label previewLabel;
        private Label selectorLabel;

        public FontShapeStyleEditor(Composite parent, int ssMask, String labelText) {
            super(parent, 0, ssMask);
            this.changeFontButton = null;
            this.setLayoutData(new GridData(4, 128, true, false, 1, 1));
            this.setLayout((Layout)new GridLayout(3, false));
            this.selectorLabel = new Label((Composite)this, 16384);
            this.selectorLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.selectorLabel.setFont(parent.getFont());
            this.selectorLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FontShapeStyleEditor.this.selectorLabel = null;
                }
            });
            this.selectorLabel.setText(labelText);
            this.previewLabel = new Label((Composite)this, 16384);
            this.previewLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.previewLabel.setFont(parent.getFont());
            this.previewLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FontShapeStyleEditor.this.previewLabel = null;
                }
            });
            this.changeFontButton = new Button((Composite)this, 8);
            this.changeFontButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.changeFontButton.setText(Messages.Bpmn2EditorPreferencePage_Change_Button);
            this.changeFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FontData font;
                    FontDialog fontDialog = new FontDialog(FontShapeStyleEditor.this.changeFontButton.getShell());
                    if (FontShapeStyleEditor.this.selectedFont != null) {
                        fontDialog.setFontList(FontShapeStyleEditor.this.selectedFont);
                    }
                    if ((font = fontDialog.open()) != null) {
                        FontData[] oldFont = FontShapeStyleEditor.this.selectedFont;
                        if (oldFont == null) {
                            oldFont = JFaceResources.getDefaultFont().getFontData();
                        }
                        FontShapeStyleEditor.this.setSelectedFont(font);
                    }
                }
            });
            this.changeFontButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FontShapeStyleEditor.this.changeFontButton = null;
                }
            });
            this.changeFontButton.setFont(parent.getFont());
        }

        @Override
        public void addSelectionListener(SelectionListener listener) {
            this.changeFontButton.addSelectionListener(listener);
        }

        public Font getValue() {
            if (this.selectedFont != null && this.selectedFont.length > 0) {
                return ShapeStyle.fontDataToFont((FontData)this.selectedFont[0]);
            }
            return null;
        }

        public void setValue(Font f) {
            this.setSelectedFont(ShapeStyle.fontToFontData((Font)f));
        }

        private void setSelectedFont(FontData fd) {
            FontData[] bestFont = JFaceResources.getFontRegistry().filterData(new FontData[]{fd}, this.previewLabel.getDisplay());
            if (bestFont == null) {
                bestFont = this.getDefaultFontData();
            }
            this.selectedFont = bestFont;
            if (this.previewLabel != null) {
                this.previewLabel.setText(StringConverter.asString((FontData)this.selectedFont[0]));
            }
        }

        private FontData[] getDefaultFontData() {
            return this.previewLabel.getDisplay().getSystemFont().getFontData();
        }
    }

    private class IntegerShapeStyleEditor
    extends ShapeStyleEditor {
        private Label label;
        private Text text;

        public IntegerShapeStyleEditor(Composite parent, int ssMask, String labelText) {
            super(parent, 0, ssMask);
            this.setLayoutData(new GridData(4, 128, true, false, 1, 1));
            this.setLayout((Layout)new GridLayout(2, true));
            this.label = new Label((Composite)this, 16384);
            this.label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.label.setFont(parent.getFont());
            this.label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    IntegerShapeStyleEditor.this.label = null;
                }
            });
            this.label.setText(labelText);
            this.text = new Text((Composite)this, 2048);
            this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.text.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String string = e.text;
                    char[] chars = new char[string.length()];
                    string.getChars(0, chars.length, chars, 0);
                    int i = 0;
                    while (i < chars.length) {
                        if ('0' > chars[i] || chars[i] > '9') {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
        }

        public void setText(String labelText) {
            this.label.setText(labelText);
        }

        @Override
        public void addSelectionListener(final SelectionListener listener) {
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Event event = new Event();
                    event.widget = IntegerShapeStyleEditor.this.text;
                    SelectionEvent se = new SelectionEvent(event);
                    se.data = IntegerShapeStyleEditor.this.getValue();
                    listener.widgetSelected(se);
                }
            });
        }

        @Override
        public Integer getValue() {
            if (this.text != null) {
                return Integer.parseInt(this.text.getText());
            }
            return -1;
        }

        public void setValue(int value) {
            if (this.text != null) {
                this.text.setText(Integer.toString(value, 10));
            }
        }
    }

    private class LabelLocationShapeStyleEditor
    extends LabeledComboShapeStyleEditor {
        public LabelLocationShapeStyleEditor(Composite parent, String text) {
            super(parent, 2048, text);
            ShapeStyle.LabelPosition[] labelPositionArray = ShapeStyle.LabelPosition.values();
            int n = labelPositionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ShapeStyle.LabelPosition p = labelPositionArray[n2];
                this.add(p.toString(), p);
                ++n2;
            }
        }

        public ShapeStyle.LabelPosition getValue() {
            ShapeStyle.LabelPosition value = (ShapeStyle.LabelPosition)super.getValue();
            if (value == null) {
                value = ShapeStyle.LabelPosition.SOUTH;
            }
            return value;
        }
    }

    private class LabeledComboShapeStyleEditor
    extends ShapeStyleEditor {
        protected Label label;
        protected Combo combo;

        public LabeledComboShapeStyleEditor(Composite parent, int ssMask, String text) {
            super(parent, 0, ssMask);
            this.setLayout((Layout)new GridLayout(2, false));
            this.label = new Label((Composite)this, 16384);
            this.label.setText(text);
            this.label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
            this.combo = new Combo((Composite)this, 8);
            this.combo.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        }

        public void add(String text, Object value) {
            this.combo.add(text);
            this.combo.setData(text, value);
        }

        @Override
        public void addSelectionListener(SelectionListener listener) {
            this.combo.addSelectionListener(listener);
        }

        @Override
        public Object getValue() {
            int index = this.combo.getSelectionIndex();
            if (index >= 0) {
                return this.combo.getData(this.combo.getItem(index));
            }
            return null;
        }

        public void setValue(Object value) {
            int index = 0;
            String[] stringArray = this.combo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                Object data = this.combo.getData(s);
                if (data.equals(value)) {
                    this.combo.select(index);
                    break;
                }
                ++index;
                ++n2;
            }
        }
    }

    private class RoutingStyleShapeStyleEditor
    extends LabeledComboShapeStyleEditor {
        public RoutingStyleShapeStyleEditor(Composite parent, String text) {
            super(parent, 128, text);
            ShapeStyle.RoutingStyle[] routingStyleArray = ShapeStyle.RoutingStyle.values();
            int n = routingStyleArray.length;
            int n2 = 0;
            while (n2 < n) {
                ShapeStyle.RoutingStyle p = routingStyleArray[n2];
                this.add(p.toString(), p);
                ++n2;
            }
        }

        public ShapeStyle.RoutingStyle getValue() {
            ShapeStyle.RoutingStyle value = (ShapeStyle.RoutingStyle)super.getValue();
            if (value == null) {
                value = ShapeStyle.RoutingStyle.MANHATTAN;
            }
            return value;
        }
    }

    class ShapeStyleCategoryList
    extends LinkedHashMap<String, Object> {
        public ShapeStyle.Category key;

        public ShapeStyleCategoryList(ShapeStyle.Category key) {
            this.key = key;
        }
    }

    private abstract class ShapeStyleEditor
    extends Composite {
        public ShapeStyleEditor(Composite parent, int style, final int ssMask) {
            super(parent, style);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ShapeStyleEditor.this.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (((ShapeStyleEditor)(this).ShapeStyleEditor.this).Bpmn2EditorAppearancePreferencePage.this.currentSelection != null) {
                                Object value = ShapeStyleEditor.this.getValue();
                                ShapeStyle ss = ((ShapeStyleEditor)(this).ShapeStyleEditor.this).Bpmn2EditorAppearancePreferencePage.this.allShapeStyles.get(((ShapeStyleEditor)(this).ShapeStyleEditor.this).Bpmn2EditorAppearancePreferencePage.this.currentSelection);
                                ss.setValue(ssMask, value);
                                if (((ShapeStyleEditor)(this).ShapeStyleEditor.this).Bpmn2EditorAppearancePreferencePage.this.currentSelection instanceof ShapeStyle.Category) {
                                    Bpmn2EditorAppearancePreferencePage.this.applyToAll(ss);
                                }
                            }
                        }
                    });
                }
            });
        }

        public abstract void addSelectionListener(SelectionListener var1);

        public abstract Object getValue();
    }

    class ShapeStyleList
    extends LinkedHashMap<Class, ShapeStyle> {
        public ShapeStyle.Category key;

        public ShapeStyleList(ShapeStyle.Category key) {
            this.key = key;
        }
    }
}

