/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerResourceSetImpl;
import org.eclipse.bpmn2.modeler.core.utils.ImportUtil;
import org.eclipse.bpmn2.modeler.core.utils.JavaProjectClassLoader;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.property.dialogs.Messages;
import org.eclipse.bpmn2.modeler.ui.property.dialogs.SchemaImportDialog;
import org.eclipse.bpmn2.modeler.ui.property.providers.BPMN2DefinitionsTreeContentProvider;
import org.eclipse.bpmn2.modeler.ui.property.providers.JavaTreeContentProvider;
import org.eclipse.bpmn2.modeler.ui.property.providers.ModelTreeLabelProvider;
import org.eclipse.bpmn2.modeler.ui.property.providers.ServiceTreeContentProvider;
import org.eclipse.bpmn2.modeler.ui.property.providers.TreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.VariableTypeTreeContentProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class SchemaSelectionDialog
extends SelectionStatusDialog {
    protected BPMN2Editor bpmn2Editor;
    protected EObject modelObject;
    protected Object input;
    protected org.eclipse.swt.widgets.List importList;
    protected Tree tree;
    protected TreeViewer treeViewer;
    protected ITreeContentProvider treeContentProvider;
    protected Bpmn2ModelerResourceSetImpl hackedResourceSet;
    protected String importType;
    protected String importLocation;
    protected Job loaderJob;
    private String selectionPath;

    public SchemaSelectionDialog(Shell parent, EObject object) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.modelObject = object;
        this.bpmn2Editor = BPMN2Editor.getActiveEditor();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SchemaSelectionDialog_TItle);
    }

    public void create() {
        super.create();
        this.updateOK(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 2;
        contentsGridLayout.makeColumnsEqualWidth = false;
        this.createImportList(contents);
        this.createImportStructure(contents);
        return contents;
    }

    protected Object createImportList(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.SchemaSelectionDialog_Imports);
        label.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Button addImport = new Button(parent, 8);
        addImport.setText(Messages.SchemaSelectionDialog_Add_Import);
        addImport.setLayoutData((Object)new GridData(131072, 4, true, true, 1, 1));
        addImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                SchemaImportDialog dialog = new SchemaImportDialog(SchemaSelectionDialog.this.getShell());
                if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
                    TransactionalEditingDomain domain = SchemaSelectionDialog.this.bpmn2Editor.getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            ImportUtil importer = new ImportUtil();
                            Import imp = importer.addImport((Resource)(this).SchemaSelectionDialog.this.bpmn2Editor.getModelHandler().getResource(), result[0]);
                            if (imp != null) {
                                int index = (this).SchemaSelectionDialog.this.importList.getItemCount();
                                (this).SchemaSelectionDialog.this.importList.add(imp.getLocation());
                                (this).SchemaSelectionDialog.this.importList.setData("" + index, (Object)imp);
                            }
                        }
                    });
                }
            }
        });
        this.importList = new org.eclipse.swt.widgets.List(parent, 2052);
        GridData data = new GridData(4, 4, true, true, 2, 1);
        data.minimumHeight = 100;
        data.minimumWidth = 400;
        this.importList.setLayoutData((Object)data);
        int index = 0;
        for (Import imp : this.getImports()) {
            this.importList.add(imp.getLocation());
            this.importList.setData("" + index++, (Object)imp);
        }
        this.importList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = SchemaSelectionDialog.this.importList.getSelectionIndex();
                Import imp = (Import)SchemaSelectionDialog.this.importList.getData("" + index);
                SchemaSelectionDialog.this.importType = SchemaSelectionDialog.this.getImportType(imp);
                SchemaSelectionDialog.this.importLocation = imp.getLocation();
                SchemaSelectionDialog.this.attemptLoad();
                SchemaSelectionDialog.this.updateOK(false);
            }
        });
        return this.importList;
    }

    protected Object createImportStructure(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.SchemaSelectionDialog_Structure);
        this.tree = new Tree(parent, 2052);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ModelTreeLabelProvider());
        this.treeViewer.setAutoExpandLevel(3);
        GridData data = new GridData(4, 4, true, true, 2, 1);
        data.minimumHeight = 200;
        this.tree.setLayoutData((Object)data);
        this.tree.getVerticalBar().setSelection(0);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchemaSelectionDialog.this.computeResult();
            }
        });
        return this.tree;
    }

    protected void setSelectionPath(TreeItem sel) {
        this.selectionPath = this.buildSelectionPath(sel);
    }

    public String getSelectionPath() {
        return this.selectionPath;
    }

    private String buildSelectionPath(TreeItem sel) {
        String path = "";
        TreeItem parent = sel.getParentItem();
        if (parent != null) {
            path = String.valueOf(path) + this.buildSelectionPath(parent);
            Object data = sel.getData();
            if (data instanceof TreeNode) {
                TreeNode tn = (TreeNode)data;
                path = path.isEmpty() ? tn.getLabel() : String.valueOf(path) + "/" + tn.getLabel();
            }
        } else {
            path = "";
        }
        return path;
    }

    protected void computeResult() {
        TreeItem[] sel = this.tree.getSelection();
        if (sel.length == 1) {
            Object data = sel[0].getData();
            if (data instanceof TreeNode) {
                TreeNode tn = (TreeNode)data;
                int index = this.importList.getSelectionIndex();
                Import imp = (Import)this.importList.getData("" + index);
                Object[] result = new Object[]{tn.getModelObject(), imp};
                this.setSelectionResult(result);
                this.setSelectionPath(sel[0]);
                this.updateOK(true);
            } else {
                Object[] result = new Object[]{};
                this.setSelectionResult(result);
                this.updateOK(false);
            }
        } else {
            this.updateOK(false);
        }
    }

    void attemptLoad() {
        String path = null;
        if ("xsd".equals(this.importType) || "xml".equals(this.importType)) {
            this.treeContentProvider = new VariableTypeTreeContentProvider(true, true);
            path = this.importLocation;
        } else if ("wsdl".equals(this.importType)) {
            this.treeContentProvider = new ServiceTreeContentProvider(true);
            path = this.importLocation;
        } else if ("bpmn".equals(this.importType)) {
            this.treeContentProvider = new BPMN2DefinitionsTreeContentProvider(true);
            path = this.importLocation;
        } else if ("java".equals(this.importType)) {
            this.treeContentProvider = new JavaTreeContentProvider(true);
            path = this.importLocation;
        } else {
            this.treeContentProvider = null;
            this.input = null;
        }
        if (this.loaderJob != null && this.loaderJob.getState() == 4) {
            this.loaderJob.cancel();
        }
        if (path == null || path.length() == 0) {
            return;
        }
        URI uri = URI.createURI((String)path);
        if (uri == null) {
            return;
        }
        final URI loadUri = uri;
        this.loaderJob = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Thread.sleep(500L);
                    SchemaSelectionDialog.this.tree.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).SchemaSelectionDialog.this.input = SchemaSelectionDialog.this.attemptLoad(loadUri, (this).SchemaSelectionDialog.this.importType);
                            SchemaSelectionDialog.this.loadDone();
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        this.loaderJob.schedule();
    }

    Object attemptLoad(URI uri, String kind) {
        if ("java".equals(kind)) {
            IProject[] projects;
            String fileName = uri.lastSegment();
            ArrayList results = new ArrayList();
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                try {
                    if (p.isOpen() && p.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject javaProject = JavaCore.create((IProject)p);
                        JavaProjectClassLoader cl = new JavaProjectClassLoader(javaProject);
                        results.addAll(cl.findClasses(fileName));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            return results;
        }
        Resource resource = null;
        try {
            this.hackedResourceSet = ModelUtil.slightlyHackedResourceSet((ResourceSet)this.bpmn2Editor.getResourceSet());
            resource = this.hackedResourceSet.getResource(uri, true, kind);
        }
        catch (Exception e) {
            return e;
        }
        if (resource != null && resource.getErrors().isEmpty() && resource.isLoaded()) {
            return resource.getContents().get(0);
        }
        return null;
    }

    void loadDone() {
        if (this.input == null || this.input instanceof Exception) {
            Activator.getDefault();
            this.updateStatus((IStatus)new Status(4, "org.eclipse.bpmn2.modeler.ui", 0, NLS.bind((String)Messages.SchemaSelectionDialog_Cannot_Load, (Object)this.importLocation), (Throwable)this.input));
            this.input = null;
        } else {
            this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
            this.treeViewer.setInput(this.input);
            this.tree.getVerticalBar().setSelection(0);
            Activator.getDefault();
            this.updateStatus((IStatus)new Status(0, "org.eclipse.bpmn2.modeler.ui", 0, NLS.bind((String)Messages.SchemaSelectionDialog_Loaded, (Object)this.importLocation), null));
            this.updateOK(false);
        }
    }

    public void updateOK(boolean state) {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(state);
        }
    }

    public Definitions getDefinitions() {
        return this.bpmn2Editor.getModelHandler().getDefinitions();
    }

    public List<Import> getImports() {
        return this.getDefinitions().getImports();
    }

    String getImportType(Import imp) {
        if (imp != null) {
            String type = imp.getImportType();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(type)) {
                return "wsdl";
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(type)) {
                return "xsd";
            }
            if ("http://www.omg.org/spec/BPMN/20100524/MODEL".equals(type)) {
                return "bpmn";
            }
            if ("http://www.java.com/javaTypes".equals(type)) {
                return "java";
            }
            return "xml";
        }
        return null;
    }
}

