/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.tasks;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.LoopCharacteristics;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.OutputSet;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.StandardLoopCharacteristics;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BpmnDiFactory;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.InsertionAdapter;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.PropertiesCompositeFactory;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ComboObjectEditor;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.DataInputPropertiesAdapter;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.DataOutputPropertiesAdapter;
import org.eclipse.bpmn2.modeler.ui.property.editors.ServiceImplementationObjectEditor;
import org.eclipse.bpmn2.modeler.ui.property.tasks.DataAssociationDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.tasks.Messages;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ActivityDetailComposite
extends DefaultDetailComposite {
    protected Button noneButton;
    protected Button addStandardLoopButton;
    protected Button addMultiLoopButton;
    protected AbstractDetailComposite loopCharacteristicsComposite;
    protected DataAssociationDetailComposite inputComposite;
    protected DataAssociationDetailComposite outputComposite;
    protected ServiceImplementationObjectEditor implementationEditor = null;

    public ActivityDetailComposite(Composite parent, int style) {
        super(parent, style);
    }

    public ActivityDetailComposite(AbstractBpmn2PropertySection section) {
        super(section);
    }

    public void cleanBindings() {
        super.cleanBindings();
        this.noneButton = null;
        this.addStandardLoopButton = null;
        this.addMultiLoopButton = null;
        this.loopCharacteristicsComposite = null;
        this.inputComposite = null;
        this.outputComposite = null;
    }

    public AbstractPropertiesProvider getPropertiesProvider(EObject object) {
        if (this.propertiesProvider == null) {
            this.propertiesProvider = new AbstractPropertiesProvider(object){
                String[] properties;
                {
                    this.properties = new String[]{"anyAttribute", "calledElementRef", "calledChoreographyRef", "calledCollaborationRef", "implementation", "operationRef", "messageRef", "scriptFormat", "script", "instantiate", "triggeredByEvent", "cancelRemainingInstances", "ordering", "completionCondition", "method", "protocol", "isForCompensation", "loopCharacteristics", "properties", "resources"};
                }

                public String[] getProperties() {
                    return this.properties;
                }
            };
        }
        return this.propertiesProvider;
    }

    protected void bindAttribute(Composite parent, EObject object, EAttribute attribute, String label) {
        if ("implementation".equals(attribute.getName())) {
            this.implementationEditor = new ServiceImplementationObjectEditor((AbstractDetailComposite)this, object, (EStructuralFeature)attribute);
            this.implementationEditor.createControl(parent, label);
        } else {
            super.bindAttribute(parent, object, attribute, label);
        }
    }

    protected void bindReference(Composite parent, EObject object, EReference reference) {
        if (!this.isModelObjectEnabled(object.eClass(), (EStructuralFeature)reference)) {
            return;
        }
        if ("loopCharacteristics".equals(reference.getName())) {
            final Activity activity = (Activity)this.businessObject;
            LoopCharacteristics loopCharacteristics = activity.getLoopCharacteristics();
            Composite composite = this.getAttributesParent();
            this.createLabel(composite, Messages.ActivityDetailComposite_Loop_Characteristics_Label);
            Composite buttonComposite = this.toolkit.createComposite(composite);
            buttonComposite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            FillLayout layout = new FillLayout();
            layout.marginWidth = 20;
            buttonComposite.setLayout((Layout)layout);
            this.noneButton = this.toolkit.createButton(buttonComposite, Messages.ActivityDetailComposite_None, 16);
            this.noneButton.setSelection(loopCharacteristics == null);
            this.noneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ActivityDetailComposite.this.noneButton.getSelection()) {
                        TransactionalEditingDomain domain = ActivityDetailComposite.this.getDiagramEditor().getEditingDomain();
                        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                            protected void doExecute() {
                                if (activity.getLoopCharacteristics() != null) {
                                    activity.setLoopCharacteristics(null);
                                }
                                ActivityDetailComposite.this.setBusinessObject((EObject)activity);
                            }
                        });
                    }
                }
            });
            this.addStandardLoopButton = this.toolkit.createButton(buttonComposite, Messages.ActivityDetailComposite_Standard, 16);
            this.addStandardLoopButton.setSelection(loopCharacteristics instanceof StandardLoopCharacteristics);
            this.addStandardLoopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ActivityDetailComposite.this.addStandardLoopButton.getSelection()) {
                        TransactionalEditingDomain domain = ActivityDetailComposite.this.getDiagramEditor().getEditingDomain();
                        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                            protected void doExecute() {
                                StandardLoopCharacteristics loopChar = (StandardLoopCharacteristics)ActivityDetailComposite.this.createModelObject(StandardLoopCharacteristics.class);
                                activity.setLoopCharacteristics((LoopCharacteristics)loopChar);
                                ActivityDetailComposite.this.setBusinessObject((EObject)activity);
                            }
                        });
                    }
                }
            });
            this.addMultiLoopButton = this.toolkit.createButton(buttonComposite, Messages.ActivityDetailComposite_MultiInstance, 16);
            this.addMultiLoopButton.setSelection(loopCharacteristics instanceof MultiInstanceLoopCharacteristics);
            this.addMultiLoopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ActivityDetailComposite.this.addMultiLoopButton.getSelection()) {
                        TransactionalEditingDomain domain = ActivityDetailComposite.this.getDiagramEditor().getEditingDomain();
                        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                            protected void doExecute() {
                                MultiInstanceLoopCharacteristics loopChar = (MultiInstanceLoopCharacteristics)ActivityDetailComposite.this.createModelObject(MultiInstanceLoopCharacteristics.class);
                                activity.setLoopCharacteristics((LoopCharacteristics)loopChar);
                                ActivityDetailComposite.this.setBusinessObject((EObject)activity);
                            }
                        });
                    }
                }
            });
            if (loopCharacteristics != null) {
                this.loopCharacteristicsComposite = PropertiesCompositeFactory.INSTANCE.createDetailComposite(loopCharacteristics.eClass().getInstanceClass(), composite, 0);
                this.loopCharacteristicsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
                this.loopCharacteristicsComposite.setBusinessObject((EObject)loopCharacteristics);
                this.loopCharacteristicsComposite.setTitle(loopCharacteristics instanceof StandardLoopCharacteristics ? Messages.ActivityDetailComposite_Standard_Loop_Characteristics_Label : Messages.ActivityDetailComposite_MultiInstance_Loop_Characteristics_Label);
            } else if (this.loopCharacteristicsComposite != null) {
                this.loopCharacteristicsComposite.dispose();
                this.loopCharacteristicsComposite = null;
            }
        } else if ("calledElementRef".equals(reference.getName())) {
            String displayName = this.getBusinessObjectDelegate().getLabel(object, (EStructuralFeature)reference);
            ComboObjectEditor editor = new ComboObjectEditor((AbstractDetailComposite)this, object, (EStructuralFeature)reference){

                protected EObject createObject() throws Exception {
                    CallableElement calledElement = (CallableElement)super.createObject();
                    if (calledElement instanceof Process) {
                        ActivityDetailComposite.this.createNewDiagram((BaseElement)calledElement);
                    }
                    return calledElement;
                }
            };
            editor.createControl(parent, displayName);
        } else if ("calledChoreographyRef".equals(reference.getName())) {
            String displayName = this.getBusinessObjectDelegate().getLabel(object, (EStructuralFeature)reference);
            ComboObjectEditor editor = new ComboObjectEditor((AbstractDetailComposite)this, object, (EStructuralFeature)reference){

                protected EObject createObject() throws Exception {
                    Choreography choreography = (Choreography)super.createObject();
                    ActivityDetailComposite.this.createNewDiagram((BaseElement)choreography);
                    return choreography;
                }
            };
            editor.createControl(parent, displayName);
        } else if ("calledCollaborationRef".equals(reference.getName())) {
            String displayName = this.getBusinessObjectDelegate().getLabel(object, (EStructuralFeature)reference);
            ComboObjectEditor editor = new ComboObjectEditor((AbstractDetailComposite)this, object, (EStructuralFeature)reference){

                protected EObject createObject() throws Exception {
                    Collaboration collaboration = (Collaboration)super.createObject();
                    ActivityDetailComposite.this.createNewDiagram((BaseElement)collaboration);
                    return collaboration;
                }
            };
            editor.createControl(parent, displayName);
        } else if ("operationRef".equals(reference.getName())) {
            EReference messageRef = (EReference)object.eClass().getEStructuralFeature("messageRef");
            this.bindOperationMessageRef(this.getAttributesParent(), (Activity)object, reference, messageRef);
        } else {
            if ("messageRef".equals(reference.getName())) {
                return;
            }
            if ("completionCondition".equals(reference.getName())) {
                super.bindReference(parent, object, reference);
            } else {
                super.bindReference(parent, object, reference);
            }
        }
        this.redrawPage();
    }

    private void bindOperationMessageRef(final Composite container, final Activity activity, final EReference operationRef, final EReference messageRef) {
        String operationLabel = this.getBusinessObjectDelegate().getLabel((EObject)activity, (EStructuralFeature)operationRef);
        ComboObjectEditor operationEditor = new ComboObjectEditor((AbstractDetailComposite)this, (EObject)activity, (EStructuralFeature)operationRef){

            protected boolean setValue(final Object result) {
                TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        Operation operation = null;
                        Message message = null;
                        if (result instanceof Operation) {
                            operation = (Operation)result;
                        }
                        if (messageRef != null) {
                            message = (Message)activity.eGet((EStructuralFeature)messageRef);
                        }
                        ActivityDetailComposite.this.createMessageAssociations(container, activity, operationRef, operation, messageRef, message);
                    }
                });
                return true;
            }

            protected boolean canSetNull() {
                return true;
            }
        };
        operationEditor.createControl(container, operationLabel);
        if (messageRef != null) {
            String messageLabel = this.getBusinessObjectDelegate().getLabel((EObject)activity, (EStructuralFeature)messageRef);
            ComboObjectEditor messageEditor = new ComboObjectEditor((AbstractDetailComposite)this, (EObject)activity, (EStructuralFeature)messageRef){

                protected boolean setValue(final Object result) {
                    TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            Operation operation = (Operation)activity.eGet((EStructuralFeature)operationRef);
                            Message message = (Message)activity.eGet((EStructuralFeature)messageRef);
                            if (result instanceof String && ((String)result).isEmpty()) {
                                message = null;
                            }
                            if (result instanceof Message) {
                                message = (Message)result;
                            }
                            ActivityDetailComposite.this.createMessageAssociations(container, activity, operationRef, operation, messageRef, message);
                        }
                    });
                    return true;
                }

                protected boolean canSetNull() {
                    return true;
                }
            };
            messageEditor.createControl(container, messageLabel);
        }
        Operation operation = null;
        Message message = null;
        if (operationRef != null) {
            operation = (Operation)activity.eGet((EStructuralFeature)operationRef);
        }
        if (messageRef != null) {
            message = (Message)activity.eGet((EStructuralFeature)messageRef);
        }
        this.createMessageAssociations(container, activity, operationRef, operation, messageRef, message);
    }

    protected void createMessageAssociations(Composite container, Activity activity, EReference operationRef, Operation operation, EReference messageRef, Message message) {
        TransactionalEditingDomain domain;
        ItemDefinition id;
        Operation oldOperation = (Operation)activity.eGet((EStructuralFeature)operationRef);
        boolean operationChanged = oldOperation != operation;
        boolean messageChanged = false;
        ExtendedPropertiesAdapter activityAdapter = ExtendedPropertiesAdapter.adapt((Object)activity);
        if (operationChanged) {
            activityAdapter.getFeatureDescriptor((EStructuralFeature)operationRef).setValue((Object)operation);
            if (operation != null) {
                if (activity instanceof ReceiveTask) {
                    activityAdapter.getFeatureDescriptor((EStructuralFeature)messageRef).setValue((Object)operation.getInMessageRef());
                } else if (activity instanceof SendTask) {
                    activityAdapter.getFeatureDescriptor((EStructuralFeature)messageRef).setValue((Object)operation.getOutMessageRef());
                }
            }
        }
        if (messageRef != null) {
            Message oldMessage = (Message)activity.eGet((EStructuralFeature)messageRef);
            boolean bl = messageChanged = oldMessage != message;
            if (messageChanged) {
                activityAdapter.getFeatureDescriptor((EStructuralFeature)messageRef).setValue((Object)message);
            }
        }
        if (this.inputComposite == null) {
            this.inputComposite = new DataAssociationDetailComposite(container, 0);
            this.inputComposite.setShowToGroup(false);
        }
        if (this.outputComposite == null) {
            this.outputComposite = new DataAssociationDetailComposite(container, 0);
            this.outputComposite.setShowFromGroup(false);
        }
        Resource resource = activity.eResource();
        InputOutputSpecification ioSpec = activity.getIoSpecification();
        if (ioSpec == null) {
            ioSpec = (InputOutputSpecification)Bpmn2ModelerFactory.create((Resource)resource, InputOutputSpecification.class);
            ModelUtil.setID((EObject)ioSpec, (Resource)resource);
            if (operationChanged) {
                activity.setIoSpecification(ioSpec);
            }
        }
        if (ioSpec.getInputSets().size() == 0) {
            InputSet inputSet = (InputSet)Bpmn2ModelerFactory.create((Resource)resource, InputSet.class);
            ModelUtil.setID((EObject)inputSet);
            if (operationChanged || ioSpec.eContainer() == null) {
                ioSpec.getInputSets().add(inputSet);
            } else {
                InsertionAdapter.add((EObject)ioSpec, (EStructuralFeature)Bpmn2Package.eINSTANCE.getInputOutputSpecification_InputSets(), (EObject)inputSet);
            }
        }
        if (ioSpec.getOutputSets().size() == 0) {
            OutputSet outputSet = (OutputSet)Bpmn2ModelerFactory.create((Resource)resource, OutputSet.class);
            ModelUtil.setID((EObject)outputSet);
            if (operationChanged || ioSpec.eContainer() == null) {
                ioSpec.getOutputSets().add(outputSet);
            } else {
                InsertionAdapter.add((EObject)ioSpec, (EStructuralFeature)Bpmn2Package.eINSTANCE.getInputOutputSpecification_OutputSets(), (EObject)outputSet);
            }
        }
        DataInput input = null;
        DataOutput output = null;
        Message inMessage = null;
        Message outMessage = null;
        if (operation != null) {
            inMessage = activity instanceof ServiceTask ? operation.getInMessageRef() : operation.getOutMessageRef();
            outMessage = activity instanceof ServiceTask ? operation.getOutMessageRef() : operation.getInMessageRef();
        } else if (message != null) {
            if (activity instanceof SendTask) {
                inMessage = message;
            } else if (activity instanceof ReceiveTask) {
                outMessage = message;
            }
        } else if (activity instanceof SendTask) {
            message = inMessage = ((SendTask)activity).getMessageRef();
        } else if (activity instanceof ReceiveTask) {
            message = outMessage = ((ReceiveTask)activity).getMessageRef();
        }
        if (activity instanceof SendTask) {
            outMessage = null;
        } else if (activity instanceof ReceiveTask) {
            inMessage = null;
        }
        if (inMessage != null) {
            boolean newInput = false;
            if (ioSpec.getDataInputs().size() > 0) {
                input = (DataInput)ioSpec.getDataInputs().get(0);
            } else {
                input = (DataInput)Bpmn2ModelerFactory.create((Resource)resource, DataInput.class);
                input.setName(DataInputPropertiesAdapter.generateName(ioSpec.getDataInputs()));
                newInput = true;
            }
            if ((operationChanged || messageChanged) && (id = inMessage.getItemRef()) != null && id != input.getItemSubjectRef()) {
                input.setItemSubjectRef(id);
                input.setIsCollection(id.isIsCollection());
            }
            if (newInput) {
                if (operationChanged || messageChanged || ioSpec.eContainer() == null) {
                    ioSpec.getDataInputs().add(input);
                    ((InputSet)ioSpec.getInputSets().get(0)).getDataInputRefs().add(input);
                } else {
                    InsertionAdapter.add((EObject)ioSpec, (EStructuralFeature)Bpmn2Package.eINSTANCE.getInputOutputSpecification_DataInputs(), (EObject)input);
                    InsertionAdapter.add((EObject)((EObject)ioSpec.getInputSets().get(0)), (EStructuralFeature)Bpmn2Package.eINSTANCE.getInputSet_DataInputRefs(), (EObject)input);
                }
            }
        }
        if (outMessage != null) {
            boolean newOutput = false;
            if (ioSpec.getDataOutputs().size() > 0) {
                output = (DataOutput)ioSpec.getDataOutputs().get(0);
            } else {
                output = (DataOutput)Bpmn2ModelerFactory.create((Resource)resource, DataOutput.class);
                output.setName(DataOutputPropertiesAdapter.generateName(ioSpec.getDataOutputs()));
                newOutput = true;
            }
            if ((operationChanged || messageChanged) && (id = outMessage.getItemRef()) != null && id != output.getItemSubjectRef()) {
                output.setItemSubjectRef(id);
                output.setIsCollection(id.isIsCollection());
            }
            if (newOutput) {
                if (operationChanged || messageChanged || ioSpec.eContainer() == null) {
                    ioSpec.getDataOutputs().add(output);
                    ((OutputSet)ioSpec.getOutputSets().get(0)).getDataOutputRefs().add(output);
                } else {
                    InsertionAdapter.add((EObject)ioSpec, (EStructuralFeature)Bpmn2Package.eINSTANCE.getInputOutputSpecification_DataOutputs(), (EObject)output);
                    InsertionAdapter.add((EObject)((EObject)ioSpec.getOutputSets().get(0)), (EStructuralFeature)Bpmn2Package.eINSTANCE.getOutputSet_DataOutputRefs(), (EObject)output);
                }
            }
        }
        if (ioSpec.getDataInputs().size() > 0) {
            input = (DataInput)ioSpec.getDataInputs().get(0);
            final InputSet inputSet = (InputSet)ioSpec.getInputSets().get(0);
            if (!inputSet.getDataInputRefs().contains(input)) {
                final DataInput i = input;
                domain = this.getDiagramEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        inputSet.getDataInputRefs().add(i);
                    }
                });
            }
        }
        if (ioSpec.getDataOutputs().size() > 0) {
            output = (DataOutput)ioSpec.getDataOutputs().get(0);
            final OutputSet outputSet = (OutputSet)ioSpec.getOutputSets().get(0);
            if (!outputSet.getDataOutputRefs().contains(output)) {
                final DataOutput o = output;
                domain = this.getDiagramEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        outputSet.getDataOutputRefs().add(o);
                    }
                });
            }
        }
        if (ioSpec.eContainer() == null) {
            InsertionAdapter.add((EObject)activity, (EStructuralFeature)Bpmn2Package.eINSTANCE.getActivity_IoSpecification(), (EObject)ioSpec);
        }
        if (activity instanceof ServiceTask) {
            if (inMessage != null) {
                this.inputComposite.setVisible(true);
                this.inputComposite.setBusinessObject((EObject)input);
                this.inputComposite.getFromGroup().setText(Messages.ActivityDetailComposite_Map_Request_Message);
            } else {
                this.inputComposite.setVisible(false);
            }
            if (outMessage != null) {
                this.outputComposite.setVisible(true);
                this.outputComposite.setBusinessObject((EObject)output);
                this.outputComposite.getToGroup().setText(Messages.ActivityDetailComposite_Map_Response_Message);
            } else {
                this.outputComposite.setVisible(false);
            }
        } else if (activity instanceof SendTask) {
            if (inMessage != null) {
                this.inputComposite.setVisible(true);
                this.inputComposite.setBusinessObject((EObject)input);
                this.inputComposite.getFromGroup().setText(Messages.ActivityDetailComposite_Map_Outgoing_Message);
            } else {
                this.inputComposite.setVisible(false);
            }
        } else if (activity instanceof ReceiveTask) {
            if (outMessage != null) {
                this.outputComposite.setVisible(true);
                this.outputComposite.setBusinessObject((EObject)output);
                this.outputComposite.getToGroup().setText(Messages.ActivityDetailComposite_Map_Incoming_Message);
            } else {
                this.outputComposite.setVisible(false);
            }
        }
        if (operationChanged || messageChanged) {
            this.redrawPage();
        }
    }

    private void createNewDiagram(final BaseElement bpmnElement) {
        final Definitions definitions = ModelUtil.getDefinitions((Object)bpmnElement);
        final String name = ModelUtil.getName((BaseElement)bpmnElement);
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand((TransactionalEditingDomain)this.editingDomain){

            protected void doExecute() {
                BPMNPlane plane = BpmnDiFactory.eINSTANCE.createBPMNPlane();
                plane.setBpmnElement(bpmnElement);
                BPMNDiagram diagram = BpmnDiFactory.eINSTANCE.createBPMNDiagram();
                diagram.setPlane(plane);
                diagram.setName(name);
                definitions.getDiagrams().add(diagram);
                ModelUtil.setID((EObject)plane);
                ModelUtil.setID((EObject)diagram);
            }
        });
    }
}

