/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.wsil;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.bpel.wsil.model.inspection.InspectionPackage;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterRegistry;
import org.eclipse.bpmn2.modeler.wsil.IConstants;
import org.eclipse.bpmn2.modeler.wsil.ui.adapter.Bpmn2WSILAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.bpmn2.modeler.wsil";
    private static Activator plugin;

    static {
        AdapterRegistry.INSTANCE.registerAdapterFactory((EPackage)InspectionPackage.eINSTANCE, (AdapterFactory)Bpmn2WSILAdapterFactory.getInstance());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logStatus(IStatus status) {
        Platform.getLog((Bundle)plugin.getBundle()).log(status);
    }

    public static void logError(Exception e) {
        Activator.logStatus((IStatus)Activator.createStatus(e));
    }

    private static Status createStatus(Exception e) {
        return new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e);
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry registry = super.createImageRegistry();
        URL baseURL = this.getBundle().getEntry("/");
        Field[] fields = IConstants.class.getFields();
        int i = 0;
        while (i < fields.length) {
            String name;
            Field f = fields[i];
            if (f.getType() == String.class && ((name = f.getName()).startsWith("ICON_") || name.startsWith("CURSOR_") || name.startsWith("IMAGE_"))) {
                try {
                    String value = (String)f.get(null);
                    this.createImageDescriptor(registry, value, baseURL);
                }
                catch (Exception e) {
                    Activator.logError(e);
                }
            }
            ++i;
        }
        return registry;
    }

    private void createImageDescriptor(ImageRegistry registry, String id, URL baseURL) {
        URL url = null;
        try {
            url = new URL(baseURL, "icons/" + id);
        }
        catch (MalformedURLException e) {
            Activator.logError(e);
        }
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        registry.put(id, desc);
    }

    public Image getImage(String id) {
        return this.getImageRegistry().get(id);
    }

    public ImageDescriptor getImageDescriptor(String id) {
        return this.getImageRegistry().getDescriptor(id);
    }
}

