/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.wsil.ui.dialogs;

import org.eclipse.bpel.wsil.model.inspection.Description;
import org.eclipse.bpel.wsil.model.inspection.Inspection;
import org.eclipse.bpel.wsil.model.inspection.Link;
import org.eclipse.bpel.wsil.model.inspection.Name;
import org.eclipse.bpel.wsil.model.inspection.Service;
import org.eclipse.bpel.wsil.model.inspection.TypeOfAbstract;
import org.eclipse.bpmn2.modeler.ui.property.dialogs.DefaultSchemaImportDialog;
import org.eclipse.bpmn2.modeler.ui.property.providers.ModelLabelProvider;
import org.eclipse.bpmn2.modeler.wsil.Messages;
import org.eclipse.bpmn2.modeler.wsil.ui.providers.WSILContentProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.part.DrillDownComposite;

public class SchemaImportDialogWithWSIL
extends DefaultSchemaImportDialog {
    protected static final int BID_BROWSE_WSIL = 1029;
    private Composite fWSILComposite;
    protected TreeViewer fWSILTreeViewer;
    protected Tree fWSILTree;
    protected Text filterText;
    String fBasePath;
    Button fBtnWSIL;

    public SchemaImportDialogWithWSIL() {
        super(Display.getCurrent().getActiveShell(), -1);
        this.fBasePath = this.fPrefStore.getString("wsil.url");
    }

    protected void buttonPressed(int id, boolean checked) {
        if (id == 1029) {
            if (!checked) {
                return;
            }
            if (this.fBasePath == null || this.fBasePath.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.SchemaImportDialogWithWSIL_Title, (String)Messages.SchemaImportDialogWithWSIL_Message);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SchemaImportDialogWithWSIL.this.fBtnWSIL.setSelection(false);
                        SchemaImportDialogWithWSIL.this.fBtnResource.setSelection(true);
                        SchemaImportDialogWithWSIL.this.buttonPressed(1025, true);
                    }
                });
                return;
            }
        }
        this.setVisibleControl((Control)this.fWSILComposite, this.fImportSource == 1029 && this.fImportType != 1034);
        if (this.fImportType != 1034) {
            this.setVisibleControl((Control)this.fKindButtonComposite, true);
            this.setVisibleControl((Control)this.fBrowseButton, true);
            this.fLocationLabel.setText(Messages.SchemaImportDialog_8);
            this.fBrowseButton.setText(this.fImportSource == 1027 || this.fImportSource == 1029 ? Messages.SchemaImportDialog_9 : Messages.SchemaImportDialog_26);
        }
        super.buttonPressed(id, checked);
    }

    protected void createImportLocation(Composite parent) {
        super.createImportLocation(parent);
        this.createWSILStructure((Composite)this.fKindGroup);
    }

    protected Object createWSILStructure(Composite parent) {
        this.fBtnWSIL = this.createRadioButton(this.fKindButtonComposite, Messages.SchemaImportDialog_15, 1029, this.fImportSource == 1029);
        this.fWSILComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.fWSILComposite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.minimumHeight = 220;
        this.fWSILComposite.setLayoutData((Object)data);
        Label location = new Label(this.fWSILComposite, 0);
        location.setText(Messages.SchemaImportDialog_16);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 16384;
        location.setLayoutData((Object)data);
        this.filterText = new Text(this.fWSILComposite, 2048);
        data = new GridData(768);
        this.filterText.setLayoutData((Object)data);
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                SchemaImportDialogWithWSIL.this.fFilter = SchemaImportDialogWithWSIL.this.filterText.getText().trim().toLowerCase();
                if (SchemaImportDialogWithWSIL.this.fFilter.length() > 0) {
                    SchemaImportDialogWithWSIL.this.fWSILTreeViewer.expandToLevel(3);
                }
                SchemaImportDialogWithWSIL.this.fWSILTreeViewer.refresh();
                e.doit = false;
            }
        });
        DrillDownComposite wsilTreeComposite = new DrillDownComposite(this.fWSILComposite, 2048);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        wsilTreeComposite.setLayout((Layout)layout);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        wsilTreeComposite.setLayoutData((Object)data);
        this.fWSILTree = new Tree((Composite)wsilTreeComposite, 0);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.minimumHeight = 200;
        this.fWSILTree.setLayoutData((Object)data);
        this.fWSILTreeViewer = new TreeViewer(this.fWSILTree);
        this.fWSILTreeViewer.setContentProvider((IContentProvider)new WSILContentProvider());
        this.fWSILTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelLabelProvider());
        Object wsilDoc = this.attemptLoad(URI.createURI((String)this.fBasePath), "wsil");
        this.fWSILTreeViewer.setInput(wsilDoc);
        if (wsilDoc != null) {
            boolean cfr_ignored_0 = wsilDoc instanceof Throwable;
        }
        this.fWSILTreeViewer.expandToLevel(2);
        this.fWSILTreeViewer.addFilter((ViewerFilter)new TreeFilter());
        this.fWSILTreeViewer.setComparator((ViewerComparator)new WSILViewerComparator());
        wsilTreeComposite.setChildTree(this.fWSILTreeViewer);
        this.fWSILTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.getFirstElement() instanceof Service) {
                    Service serv = (Service)sel.getFirstElement();
                    Description descr = (Description)serv.getDescription().get(0);
                    SchemaImportDialogWithWSIL.this.attemptLoad(descr.getLocation());
                } else {
                    SchemaImportDialogWithWSIL.this.markEmptySelection();
                }
            }
        });
        return this.fWSILComposite;
    }

    public class TreeFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (SchemaImportDialogWithWSIL.this.fFilter == null || SchemaImportDialogWithWSIL.this.fFilter.length() == 0) {
                return true;
            }
            if (element instanceof Service) {
                String text = "";
                Service service = (Service)element;
                if (service.getName().size() > 0) {
                    Name name = (Name)service.getName().get(0);
                    text = String.valueOf(text) + name.getValue();
                }
                if (service.getAbstract().size() > 0) {
                    TypeOfAbstract abst = (TypeOfAbstract)service.getAbstract().get(0);
                    text = String.valueOf(text) + abst.getValue();
                }
                return text.toLowerCase().indexOf(SchemaImportDialogWithWSIL.this.fFilter) > -1;
            }
            return true;
        }
    }

    public class WSILViewerComparator
    extends ViewerComparator {
        public int category(Object element) {
            if (element instanceof Inspection) {
                return 1;
            }
            if (element instanceof Link) {
                return 2;
            }
            if (element instanceof Service) {
                return 3;
            }
            return 0;
        }
    }
}

