/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.wsil.ui.providers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.bpel.wsil.model.inspection.Inspection;
import org.eclipse.bpel.wsil.model.inspection.Link;
import org.eclipse.bpel.wsil.model.inspection.WSILDocument;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerResourceSetImpl;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.wsil.ui.providers.Messages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class WSILContentProvider
implements ITreeContentProvider {
    public static final int FLATTEN = 1;
    int fMode = 0;

    public void setMode(int mode) {
        this.fMode = mode;
    }

    public Object[] getChildren(Object arg0) {
        ArrayList<Object> items = new ArrayList<Object>();
        if (arg0 instanceof WSILDocument) {
            if ((this.fMode & 1) == 1) {
                arg0 = ((WSILDocument)arg0).getInspection();
            } else {
                items.add(((WSILDocument)arg0).getInspection());
            }
        }
        if (arg0 instanceof Inspection) {
            Inspection insp = (Inspection)arg0;
            items.addAll((Collection<Object>)insp.getServices());
            items.addAll((Collection<Object>)insp.getLinks());
        }
        if (arg0 instanceof Link) {
            Link link = (Link)arg0;
            Bpmn2ModelerResourceSetImpl resourceSet = ModelUtil.slightlyHackedResourceSet((EObject)link);
            URI linkURI = null;
            try {
                linkURI = URI.createURI((String)link.getLocation());
                if (linkURI.isRelative()) {
                    URI parentURI = link.eResource().getURI();
                    linkURI = linkURI.resolve(parentURI);
                }
            }
            catch (Throwable t) {
                items.add(t);
                return items.toArray();
            }
            Resource resource = null;
            try {
                resource = resourceSet.getResource(linkURI, true, "wsil");
            }
            catch (Throwable t) {
                items.add(t);
                return items.toArray();
            }
            if (resource != null) {
                Object root = resource.getContents().get(0);
                if (root instanceof WSILDocument) {
                    WSILDocument doc = (WSILDocument)root;
                    items.addAll((Collection<Object>)doc.getInspection().getLinks());
                    items.addAll((Collection<Object>)doc.getInspection().getServices());
                } else {
                    items.add(new Exception(Messages.WSILContentProvider_Not_A_WSIL));
                }
            }
        }
        return items.toArray();
    }

    public Object getParent(Object arg0) {
        if (arg0 instanceof EObject) {
            EObject eObj = (EObject)arg0;
            return eObj.eContainer();
        }
        return null;
    }

    public boolean hasChildren(Object arg0) {
        return arg0 instanceof WSILDocument || arg0 instanceof Inspection || arg0 instanceof Link;
    }

    public Object[] getElements(Object arg0) {
        return this.getChildren(arg0);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

