/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.gdb.launching.GDBProcess;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.MulticoreVisualizerUIPlugin;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.actions.EnableLoadMetersAction;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.actions.FilterCanvasAction;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.actions.RefreshAction;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.actions.SelectAllAction;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.actions.SetLoadMeterPeriodAction;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCPU;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCore;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerExecutionState;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerLoadInfo;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerModel;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerThread;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.Messages;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerCanvas;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerEventListener;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerSelectionFinder;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DSFDebugModel;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DSFDebugModelListener;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DSFSessionState;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DebugViewUtils;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS2;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.visualizer.ui.canvas.GraphicCanvas;
import org.eclipse.cdt.visualizer.ui.canvas.GraphicCanvasVisualizer;
import org.eclipse.cdt.visualizer.ui.plugin.CDTVisualizerUIPlugin;
import org.eclipse.cdt.visualizer.ui.util.Colors;
import org.eclipse.cdt.visualizer.ui.util.GUIUtils;
import org.eclipse.cdt.visualizer.ui.util.SelectionUtils;
import org.eclipse.cdt.visualizer.ui.util.Timer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.internal.ui.commands.actions.DropToFrameCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.ResumeCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepIntoCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepOverCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepReturnCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.SuspendCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.TerminateCommandAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

public class MulticoreVisualizer
extends GraphicCanvasVisualizer
implements DSFDebugModelListener {
    public static final String ECLIPSE_ID = "org.eclipse.cdt.dsf.gdb.multicorevisualizer.visualizer";
    protected VisualizerModel fDataModel;
    protected MulticoreVisualizerCanvas m_canvas;
    protected DSFSessionState m_sessionState;
    protected MulticoreVisualizerEventListener fEventListener;
    protected TreeModelViewer m_debugViewer = null;
    protected IModelChangedListener m_modelChangedListener = null;
    protected IGDBHardwareAndOS.ICPUDMContext[] m_cpuContextsCache = null;
    protected IGDBHardwareAndOS.ICoreDMContext[] m_coreContextsCache = null;
    protected boolean m_loadMetersEnabled = false;
    protected Timer m_updateLoadMeterTimer = null;
    protected int m_loadMeterTimerPeriod = 1000;
    private static final int LOAD_METER_TIMER_MIN = 100;
    private static final int LOAD_METER_TIMER_FAST = 500;
    private static final int LOAD_METER_TIMER_MEDIUM = 1000;
    private static final int LOAD_METER_TIMER_SLOW = 5000;
    boolean m_actionsInitialized = false;
    Separator m_separatorAction = null;
    ResumeCommandAction m_resumeAction = null;
    SuspendCommandAction m_suspendAction = null;
    TerminateCommandAction m_terminateAction = null;
    StepReturnCommandAction m_stepReturnAction = null;
    StepOverCommandAction m_stepOverAction = null;
    StepIntoCommandAction m_stepIntoAction = null;
    DropToFrameCommandAction m_dropToFrameAction = null;
    SelectAllAction m_selectAllAction = null;
    RefreshAction m_refreshAction = null;
    IMenuManager m_loadMetersSubMenu = null;
    IMenuManager m_loadMetersRefreshSubSubmenu = null;
    EnableLoadMetersAction m_enableLoadMetersAction = null;
    List<SetLoadMeterPeriodAction> m_setLoadMeterPeriodActions = null;
    FilterCanvasAction m_setFilterAction = null;
    FilterCanvasAction m_clearFilterAction = null;

    public void dispose() {
        super.dispose();
        this.removeDebugViewerListener();
        this.disposeActions();
        this.disposeLoadMeterTimer();
        this.removeEventListener();
    }

    public void initializeVisualizer() {
        this.fEventListener = new MulticoreVisualizerEventListener(this);
    }

    protected void initializeLoadMeterTimer() {
        if (!this.m_loadMetersEnabled) {
            return;
        }
        this.m_updateLoadMeterTimer = DSFDebugModel.getLoadTimer(this.m_sessionState, this.m_loadMeterTimerPeriod, this);
        this.m_updateLoadMeterTimer.setRepeating(false);
    }

    protected void disposeLoadMeterTimer() {
        if (this.m_updateLoadMeterTimer != null) {
            this.m_updateLoadMeterTimer.dispose();
            this.m_updateLoadMeterTimer = null;
        }
    }

    public void disposeVisualizer() {
        this.dispose();
    }

    public String getName() {
        return "multicore";
    }

    public String getDisplayName() {
        return Messages.MulticoreVisualizer_name;
    }

    public String getDescription() {
        return Messages.MulticoreVisualizer_tooltip;
    }

    public void setLoadMeterTimerPeriod(int p) {
        assert (p > 100);
        if (this.m_loadMeterTimerPeriod == p) {
            return;
        }
        this.m_loadMeterTimerPeriod = p > 100 ? p : 100;
        this.disposeLoadMeterTimer();
        this.initializeLoadMeterTimer();
    }

    public void setLoadMetersEnabled(boolean enabled) {
        if (this.m_loadMetersEnabled == enabled) {
            return;
        }
        this.m_loadMetersEnabled = enabled;
        this.fDataModel.setLoadMetersEnabled(this.m_loadMetersEnabled);
        this.disposeLoadMeterTimer();
        this.initializeLoadMeterTimer();
    }

    public GraphicCanvas createCanvas(Composite parent) {
        this.m_canvas = new MulticoreVisualizerCanvas(parent);
        this.m_canvas.addSelectionChangedListener((ISelectionChangedListener)this);
        return this.m_canvas;
    }

    public void disposeCanvas() {
        if (this.m_canvas != null) {
            this.m_canvas.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.m_canvas.dispose();
            this.m_canvas = null;
        }
        this.disposeLoadMeterTimer();
    }

    protected void initializeCanvas(GraphicCanvas canvas) {
        CDTVisualizerUIPlugin.getResources();
        this.m_canvas.setBackground(Colors.BLACK);
        this.m_canvas.setForeground(Colors.GREEN);
    }

    public MulticoreVisualizerCanvas getMulticoreVisualizerCanvas() {
        return (MulticoreVisualizerCanvas)this.getCanvas();
    }

    public void applyCanvasFilter() {
        this.m_canvas.applyFilter();
        this.refresh();
    }

    public void clearCanvasFilter() {
        this.m_canvas.clearFilter();
        this.refresh();
    }

    public boolean isCanvasFilterActive() {
        return this.m_canvas.isFilterActive();
    }

    public VisualizerModel getModel() {
        return this.fDataModel;
    }

    protected void createActions() {
        if (this.m_actionsInitialized) {
            return;
        }
        LaunchView debugView = DebugViewUtils.getDebugView();
        this.m_separatorAction = new Separator();
        this.m_resumeAction = new ResumeCommandAction();
        if (debugView != null) {
            this.m_resumeAction.init((IWorkbenchPart)debugView);
        }
        this.m_suspendAction = new SuspendCommandAction();
        if (debugView != null) {
            this.m_suspendAction.init((IWorkbenchPart)debugView);
        }
        this.m_terminateAction = new TerminateCommandAction();
        if (debugView != null) {
            this.m_terminateAction.init((IWorkbenchPart)debugView);
        }
        this.m_stepReturnAction = new StepReturnCommandAction();
        if (debugView != null) {
            this.m_stepReturnAction.init((IWorkbenchPart)debugView);
        }
        this.m_stepOverAction = new StepOverCommandAction();
        if (debugView != null) {
            this.m_stepOverAction.init((IWorkbenchPart)debugView);
        }
        this.m_stepIntoAction = new StepIntoCommandAction();
        if (debugView != null) {
            this.m_stepIntoAction.init((IWorkbenchPart)debugView);
        }
        this.m_dropToFrameAction = new DropToFrameCommandAction();
        if (debugView != null) {
            this.m_dropToFrameAction.init((IWorkbenchPart)debugView);
        }
        this.m_selectAllAction = new SelectAllAction();
        this.m_selectAllAction.init(this);
        this.m_refreshAction = new RefreshAction();
        this.m_refreshAction.init(this);
        this.m_loadMetersSubMenu = new MenuManager(MulticoreVisualizerUIPlugin.getString("MulticoreVisualizer.actions.LoadMeterSubmenu.text"));
        this.m_loadMetersRefreshSubSubmenu = new MenuManager(MulticoreVisualizerUIPlugin.getString("MulticoreVisualizer.actions.LoadMetersRefreshSubSubmenu.text"));
        this.m_enableLoadMetersAction = new EnableLoadMetersAction(this.m_loadMetersEnabled);
        this.m_enableLoadMetersAction.init(this);
        this.m_enableLoadMetersAction.setEnabled(true);
        this.m_setLoadMeterPeriodActions = new ArrayList<SetLoadMeterPeriodAction>();
        this.m_setLoadMeterPeriodActions.add(new SetLoadMeterPeriodAction(MulticoreVisualizerUIPlugin.getString("MulticoreVisualizer.actions.SetLoadMeterPeriod.fast.text"), 500));
        SetLoadMeterPeriodAction defaultAction = new SetLoadMeterPeriodAction(MulticoreVisualizerUIPlugin.getString("MulticoreVisualizer.actions.SetLoadMeterPeriod.medium.text"), 1000);
        this.m_setLoadMeterPeriodActions.add(defaultAction);
        this.m_setLoadMeterPeriodActions.add(new SetLoadMeterPeriodAction(MulticoreVisualizerUIPlugin.getString("MulticoreVisualizer.actions.SetLoadMeterPeriod.slow.text"), 5000));
        for (SetLoadMeterPeriodAction act : this.m_setLoadMeterPeriodActions) {
            act.init(this);
            act.setEnabled(true);
        }
        defaultAction.setChecked(true);
        defaultAction.run();
        this.m_setFilterAction = new FilterCanvasAction(true);
        this.m_setFilterAction.init(this);
        this.m_setFilterAction.setEnabled(false);
        this.m_clearFilterAction = new FilterCanvasAction(false);
        this.m_clearFilterAction.init(this);
        this.m_clearFilterAction.setEnabled(false);
        this.m_actionsInitialized = debugView != null;
    }

    protected void updateActions() {
        if (!this.m_actionsInitialized) {
            return;
        }
        boolean enabled = this.hasSelection();
        this.m_selectAllAction.setEnabled(enabled);
        this.m_refreshAction.setEnabled(enabled);
        this.m_setFilterAction.setEnabled(this.m_canvas.hasSelection());
        this.m_clearFilterAction.setEnabled(this.isCanvasFilterActive());
        this.m_loadMetersRefreshSubSubmenu.setVisible(this.m_loadMetersEnabled);
    }

    protected void updateContextMenuActions(Point location) {
    }

    protected void disposeActions() {
        if (this.m_resumeAction != null) {
            this.m_resumeAction.dispose();
            this.m_resumeAction = null;
        }
        if (this.m_suspendAction != null) {
            this.m_suspendAction.dispose();
            this.m_suspendAction = null;
        }
        if (this.m_terminateAction != null) {
            this.m_terminateAction.dispose();
            this.m_terminateAction = null;
        }
        if (this.m_stepReturnAction != null) {
            this.m_stepReturnAction.dispose();
            this.m_stepReturnAction = null;
        }
        if (this.m_stepOverAction != null) {
            this.m_stepOverAction.dispose();
            this.m_stepOverAction = null;
        }
        if (this.m_stepIntoAction != null) {
            this.m_stepIntoAction.dispose();
            this.m_stepIntoAction = null;
        }
        if (this.m_dropToFrameAction != null) {
            this.m_dropToFrameAction.dispose();
            this.m_dropToFrameAction = null;
        }
        if (this.m_selectAllAction != null) {
            this.m_selectAllAction.dispose();
            this.m_selectAllAction = null;
        }
        if (this.m_refreshAction != null) {
            this.m_refreshAction.dispose();
            this.m_refreshAction = null;
        }
        if (this.m_loadMetersSubMenu != null) {
            this.m_loadMetersSubMenu.dispose();
            this.m_loadMetersSubMenu = null;
        }
        if (this.m_loadMetersRefreshSubSubmenu != null) {
            this.m_loadMetersRefreshSubSubmenu.dispose();
            this.m_loadMetersRefreshSubSubmenu = null;
        }
        if (this.m_enableLoadMetersAction != null) {
            this.m_enableLoadMetersAction.dispose();
            this.m_enableLoadMetersAction = null;
        }
        if (this.m_setLoadMeterPeriodActions != null) {
            for (SetLoadMeterPeriodAction act : this.m_setLoadMeterPeriodActions) {
                act.dispose();
            }
            this.m_setLoadMeterPeriodActions.clear();
            this.m_setLoadMeterPeriodActions = null;
        }
        if (this.m_setFilterAction != null) {
            this.m_setFilterAction.dispose();
            this.m_setFilterAction = null;
        }
        if (this.m_clearFilterAction != null) {
            this.m_clearFilterAction.dispose();
            this.m_clearFilterAction = null;
        }
        this.m_actionsInitialized = false;
    }

    public void populateToolBar(IToolBarManager toolBarManager) {
        this.createActions();
        toolBarManager.add((IAction)this.m_resumeAction);
        toolBarManager.add((IAction)this.m_suspendAction);
        toolBarManager.add((IAction)this.m_terminateAction);
        toolBarManager.add((IContributionItem)this.m_separatorAction);
        toolBarManager.add((IAction)this.m_stepReturnAction);
        toolBarManager.add((IAction)this.m_stepOverAction);
        toolBarManager.add((IAction)this.m_stepIntoAction);
        toolBarManager.add((IAction)this.m_dropToFrameAction);
        this.updateActions();
    }

    public void populateMenu(IMenuManager menuManager) {
        this.createActions();
        this.updateActions();
    }

    public void populateContextMenu(IMenuManager menuManager) {
        this.createActions();
        menuManager.add((IAction)this.m_resumeAction);
        menuManager.add((IAction)this.m_suspendAction);
        menuManager.add((IAction)this.m_terminateAction);
        menuManager.add((IContributionItem)this.m_separatorAction);
        menuManager.add((IAction)this.m_stepReturnAction);
        menuManager.add((IAction)this.m_stepOverAction);
        menuManager.add((IAction)this.m_stepIntoAction);
        menuManager.add((IAction)this.m_dropToFrameAction);
        menuManager.add((IContributionItem)this.m_separatorAction);
        menuManager.add((IAction)this.m_selectAllAction);
        menuManager.add((IAction)this.m_refreshAction);
        menuManager.add((IContributionItem)this.m_separatorAction);
        this.m_loadMetersSubMenu.removeAll();
        this.m_loadMetersRefreshSubSubmenu.removeAll();
        menuManager.add((IContributionItem)this.m_loadMetersSubMenu);
        this.m_loadMetersSubMenu.add((IAction)this.m_enableLoadMetersAction);
        this.m_loadMetersSubMenu.add((IContributionItem)this.m_loadMetersRefreshSubSubmenu);
        for (SetLoadMeterPeriodAction act : this.m_setLoadMeterPeriodActions) {
            this.m_loadMetersRefreshSubSubmenu.add((IAction)act);
        }
        menuManager.add((IContributionItem)this.m_separatorAction);
        menuManager.add((IAction)this.m_setFilterAction);
        menuManager.add((IAction)this.m_clearFilterAction);
        this.updateActions();
        Point location = this.m_viewer.getContextMenuLocation();
        this.updateContextMenuActions(location);
    }

    public void visualizerSelected() {
        this.updateActions();
    }

    public void visualizerDeselected() {
    }

    public int handlesSelection(ISelection selection) {
        int result = 0;
        Object sel = SelectionUtils.getSelectedObject((ISelection)selection);
        result = sel instanceof GdbLaunch || sel instanceof GDBProcess || sel instanceof IDMVMContext ? 1 : 0;
        this.updateDebugViewListener();
        return result;
    }

    protected void updateDebugViewListener() {
        this.attachDebugViewerListener();
    }

    protected void attachDebugViewerListener() {
        if (this.m_debugViewer == null) {
            this.m_debugViewer = DebugViewUtils.getDebugViewer();
            if (this.m_debugViewer != null) {
                this.m_modelChangedListener = new IModelChangedListener(){

                    public void modelChanged(IModelDelta delta, IModelProxy proxy) {
                        GUIUtils.exec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MulticoreVisualizer.this.updateDebugContext();
                            }
                        });
                    }
                };
                this.m_debugViewer.addModelChangedListener(this.m_modelChangedListener);
            }
        }
    }

    protected void removeDebugViewerListener() {
        if (this.m_modelChangedListener != null && this.m_debugViewer != null) {
            this.m_debugViewer.removeModelChangedListener(this.m_modelChangedListener);
            this.m_debugViewer = null;
            this.m_modelChangedListener = null;
        }
    }

    private void removeEventListener() {
        if (this.m_sessionState != null) {
            this.m_sessionState.removeServiceEventListener(this.fEventListener);
        }
    }

    public void workbenchSelectionChanged(ISelection selection) {
        boolean changed = this.updateDebugContext();
        if (changed) {
            this.update();
        } else {
            this.updateCanvasSelection();
        }
        this.updateDebugViewListener();
    }

    public void refresh() {
        this.m_canvas.requestRecache();
        this.m_canvas.requestUpdate();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection debugViewSelection = this.visualizerToDebugViewSelection(this.getSelection());
        DebugViewUtils.setDebugViewSelection(debugViewSelection);
        this.updateActions();
    }

    protected ISelection visualizerToDebugViewSelection(ISelection visualizerSelection) {
        MulticoreVisualizerSelectionFinder selectionFinder = new MulticoreVisualizerSelectionFinder();
        ISelection workbenchSelection = selectionFinder.findSelection(visualizerSelection);
        return workbenchSelection;
    }

    protected ISelection workbenchToVisualizerSelection(ISelection workbenchSelection) {
        VisualizerModel model;
        ISelection visualizerSelection = null;
        List items = SelectionUtils.getSelectedObjects((ISelection)workbenchSelection);
        if (this.m_canvas != null && (model = this.m_canvas.getModel()) != null) {
            HashSet<VisualizerThread> selected = new HashSet<VisualizerThread>();
            for (Object item : items) {
                int tid;
                if (!(item instanceof IDMVMContext)) continue;
                IDMContext context = ((IDMVMContext)item).getDMContext();
                IMIProcessDMContext processContext = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIProcessDMContext.class);
                int pid = Integer.parseInt(processContext.getProcId());
                IMIExecutionDMContext execContext = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
                int n = tid = execContext == null ? 0 : execContext.getThreadId();
                if (tid == 0) {
                    List<VisualizerThread> threads = model.getThreadsForProcess(pid);
                    if (threads == null) continue;
                    selected.addAll(threads);
                    continue;
                }
                VisualizerThread thread = model.getThread(tid);
                if (thread == null) continue;
                selected.add(thread);
            }
            visualizerSelection = SelectionUtils.toSelection(selected);
        }
        return visualizerSelection;
    }

    public boolean updateDebugContext() {
        ILaunch launch;
        String sessionId = null;
        IAdaptable debugContext = DebugUITools.getDebugContext();
        if (debugContext instanceof IDMVMContext) {
            sessionId = ((IDMVMContext)debugContext).getDMContext().getSessionId();
        } else if (debugContext instanceof GdbLaunch) {
            GdbLaunch gdbLaunch = (GdbLaunch)debugContext;
            if (!gdbLaunch.isTerminated()) {
                sessionId = gdbLaunch.getSession().getId();
            }
        } else if (debugContext instanceof GDBProcess && !(launch = ((GDBProcess)debugContext).getLaunch()).isTerminated() && launch instanceof GdbLaunch) {
            sessionId = ((GdbLaunch)launch).getSession().getId();
        }
        return this.setDebugSession(sessionId);
    }

    public boolean setDebugSession(String sessionId) {
        boolean changed = false;
        if (this.m_sessionState != null && !this.m_sessionState.getSessionID().equals(sessionId)) {
            this.disposeLoadMeterTimer();
            this.m_cpuContextsCache = null;
            this.m_coreContextsCache = null;
            this.m_sessionState.removeServiceEventListener(this.fEventListener);
            this.m_sessionState.dispose();
            this.m_sessionState = null;
            changed = true;
        }
        if (this.m_sessionState == null && sessionId != null) {
            this.m_sessionState = new DSFSessionState(sessionId);
            this.m_sessionState.addServiceEventListener(this.fEventListener);
            this.initializeLoadMeterTimer();
            changed = true;
        }
        return changed;
    }

    public void update() {
        if (this.m_sessionState == null) {
            this.setCanvasModel(null);
            return;
        }
        this.m_sessionState.execute(new DsfRunnable(){

            public void run() {
                MulticoreVisualizer.this.getVisualizerModel();
            }
        });
    }

    protected void setCanvasModel(VisualizerModel model) {
        final VisualizerModel model_f = model;
        GUIUtils.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (MulticoreVisualizer.this.m_canvas != null) {
                    MulticoreVisualizer.this.m_canvas.setModel(model_f);
                    MulticoreVisualizer.this.updateCanvasSelectionInternal();
                }
            }
        });
    }

    protected void updateCanvasSelection() {
        GUIUtils.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                MulticoreVisualizer.this.updateCanvasSelectionInternal();
            }
        });
    }

    protected void updateCanvasSelectionInternal() {
        this.updateCanvasSelectionInternal(SelectionUtils.getWorkbenchSelection());
    }

    protected void updateCanvasSelectionInternal(ISelection selection) {
        ISelection canvasSelection = this.workbenchToVisualizerSelection(selection);
        if (canvasSelection != null) {
            this.m_canvas.setSelection(canvasSelection, false);
        }
    }

    public void selectAll() {
        this.m_canvas.selectAll();
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getVisualizerModel() {
        this.fDataModel = new VisualizerModel(this.m_sessionState.getSessionID());
        DSFDebugModel.getCPUs(this.m_sessionState, this, this.fDataModel);
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getVisualizerModelDone(VisualizerModel model) {
        this.fDataModel.setLoadMetersEnabled(this.m_loadMetersEnabled);
        this.updateLoads();
        model.sort();
        this.setCanvasModel(model);
    }

    @Override
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getCPUsDone(IGDBHardwareAndOS.ICPUDMContext[] cpuContexts, Object arg) {
        this.m_cpuContextsCache = cpuContexts;
        VisualizerModel model = (VisualizerModel)arg;
        if (cpuContexts == null || cpuContexts.length == 0) {
            model.addCPU(new VisualizerCPU(0));
            model.getTodo().add(1);
            DSFDebugModel.getCores(this.m_sessionState, this, model);
        } else {
            int count = cpuContexts.length;
            model.getTodo().add(count);
            IGDBHardwareAndOS.ICPUDMContext[] iCPUDMContextArray = cpuContexts;
            int n = cpuContexts.length;
            int n2 = 0;
            while (n2 < n) {
                IGDBHardwareAndOS.ICPUDMContext cpuContext = iCPUDMContextArray[n2];
                int cpuID = Integer.parseInt(cpuContext.getId());
                model.addCPU(new VisualizerCPU(cpuID));
                DSFDebugModel.getCores(this.m_sessionState, cpuContext, this, model);
                ++n2;
            }
        }
    }

    @Override
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getCoresDone(IGDBHardwareAndOS.ICPUDMContext cpuContext, IGDBHardwareAndOS.ICoreDMContext[] coreContexts, Object arg) {
        this.m_coreContextsCache = coreContexts;
        VisualizerModel model = (VisualizerModel)arg;
        if (coreContexts != null && coreContexts.length != 0) {
            int cpuID = Integer.parseInt(cpuContext.getId());
            VisualizerCPU cpu = model.getCPU(cpuID);
            int count = coreContexts.length;
            model.getTodo().add(count);
            IGDBHardwareAndOS.ICoreDMContext[] iCoreDMContextArray = coreContexts;
            int n = coreContexts.length;
            int n2 = 0;
            while (n2 < n) {
                IGDBHardwareAndOS.ICoreDMContext coreContext = iCoreDMContextArray[n2];
                int coreID = Integer.parseInt(coreContext.getId());
                cpu.addCore(new VisualizerCore(cpu, coreID));
                DSFDebugModel.getThreads(this.m_sessionState, cpuContext, coreContext, this, model);
                ++n2;
            }
        }
        this.done(1, model);
    }

    @Override
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getThreadsDone(IGDBHardwareAndOS.ICPUDMContext cpuContext, IGDBHardwareAndOS.ICoreDMContext coreContext, IDMContext[] threadContexts, Object arg) {
        VisualizerModel model = (VisualizerModel)arg;
        if (threadContexts != null && threadContexts.length != 0) {
            int count = threadContexts.length;
            model.getTodo().add(count);
            IDMContext[] iDMContextArray = threadContexts;
            int n = threadContexts.length;
            int n2 = 0;
            while (n2 < n) {
                IDMContext threadContext = iDMContextArray[n2];
                IMIExecutionDMContext execContext = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)threadContext, IMIExecutionDMContext.class);
                DSFDebugModel.getThreadData(this.m_sessionState, cpuContext, coreContext, execContext, this, model);
                ++n2;
            }
        }
        this.done(1, model);
    }

    @Override
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getThreadDataDone(IGDBHardwareAndOS.ICPUDMContext cpuContext, IGDBHardwareAndOS.ICoreDMContext coreContext, IMIExecutionDMContext execContext, IProcesses.IThreadDMData threadData, Object arg) {
        DSFDebugModel.getThreadExecutionState(this.m_sessionState, cpuContext, coreContext, execContext, threadData, this, arg);
    }

    @Override
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getThreadExecutionStateDone(IGDBHardwareAndOS.ICPUDMContext cpuContext, IGDBHardwareAndOS.ICoreDMContext coreContext, IMIExecutionDMContext execContext, IProcesses.IThreadDMData threadData, IStack.IFrameDMData frame, VisualizerExecutionState state, Object arg) {
        VisualizerModel model = (VisualizerModel)arg;
        int cpuID = Integer.parseInt(cpuContext.getId());
        VisualizerCPU cpu = model.getCPU(cpuID);
        int coreID = Integer.parseInt(coreContext.getId());
        VisualizerCore core = cpu.getCore(coreID);
        if (state == null) {
            state = VisualizerExecutionState.RUNNING;
        }
        IMIProcessDMContext processContext = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)execContext, IMIProcessDMContext.class);
        int pid = Integer.parseInt(processContext.getProcId());
        int tid = execContext.getThreadId();
        String osTIDValue = threadData.getId();
        int osTid = osTIDValue == null ? tid : Integer.parseInt(osTIDValue);
        VisualizerThread t = model.getThread(tid);
        if (t == null) {
            model.addThread(new VisualizerThread(core, pid, osTid, tid, state, frame));
        } else {
            t.setCore(core);
            t.setTID(osTid);
            t.setState(state);
            t.setLocationInfo(frame);
        }
        this.done(1, model);
    }

    @Override
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void updateLoads() {
        if (this.m_cpuContextsCache == null || this.m_coreContextsCache == null) {
            return;
        }
        if (!this.m_loadMetersEnabled) {
            return;
        }
        VisualizerModel model = this.fDataModel;
        int count = this.m_cpuContextsCache.length + this.m_coreContextsCache.length;
        model.getLoadTodo().dispose();
        model.getLoadTodo().add(count);
        IGDBHardwareAndOS.ICPUDMContext[] iCPUDMContextArray = this.m_cpuContextsCache;
        int n = this.m_cpuContextsCache.length;
        int n2 = 0;
        while (n2 < n) {
            IGDBHardwareAndOS.ICPUDMContext cpuCtx = iCPUDMContextArray[n2];
            DSFDebugModel.getLoad(this.m_sessionState, (IDMContext)cpuCtx, this, model);
            ++n2;
        }
        iCPUDMContextArray = this.m_coreContextsCache;
        n = this.m_coreContextsCache.length;
        n2 = 0;
        while (n2 < n) {
            IGDBHardwareAndOS.ICPUDMContext coreCtx = iCPUDMContextArray[n2];
            DSFDebugModel.getLoad(this.m_sessionState, (IDMContext)coreCtx, this, model);
            ++n2;
        }
    }

    @Override
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void getLoadDone(IDMContext context, IGDBHardwareAndOS2.ILoadInfo load, Object arg) {
        VisualizerModel model = (VisualizerModel)arg;
        Integer l = null;
        if (load != null) {
            l = Integer.valueOf(load.getLoad());
        }
        if (context instanceof IGDBHardwareAndOS.ICPUDMContext) {
            IGDBHardwareAndOS.ICPUDMContext cpuContext = (IGDBHardwareAndOS.ICPUDMContext)context;
            VisualizerCPU cpu = model.getCPU(Integer.parseInt(cpuContext.getId()));
            cpu.setLoadInfo(new VisualizerLoadInfo(l));
        } else if (context instanceof IGDBHardwareAndOS.ICoreDMContext) {
            IGDBHardwareAndOS.ICoreDMContext coreContext = (IGDBHardwareAndOS.ICoreDMContext)context;
            VisualizerCore core = model.getCore(Integer.parseInt(coreContext.getId()));
            core.setLoadInfo(new VisualizerLoadInfo(l));
        }
        this.loadDone(1, model);
    }

    protected void done(int n, VisualizerModel model) {
        model.getTodo().done(n);
        if (model.getTodo().isDone()) {
            this.getVisualizerModelDone(model);
        }
    }

    protected void loadDone(int n, VisualizerModel model) {
        model.getLoadTodo().done(n);
        if (model.getLoadTodo().isDone()) {
            if (this.m_canvas != null) {
                this.m_canvas.refreshLoadMeters();
                this.m_canvas.requestUpdate();
            }
            if (this.m_updateLoadMeterTimer != null) {
                this.m_updateLoadMeterTimer.start();
            }
        }
    }
}

