/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.List;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.internal.ui.refactoring.BindingToAstNameMatcher;
import org.eclipse.cdt.internal.ui.refactoring.IndexNameToAstNameMatcher;
import org.eclipse.core.runtime.CoreException;

public class IndexToASTNameHelper {
    public static List<IASTName> findNamesIn(IASTTranslationUnit tu, IBinding binding, IIndex index) {
        BindingToAstNameMatcher visitor = new BindingToAstNameMatcher(binding, index);
        tu.accept((ASTVisitor)visitor);
        return visitor.getMatches();
    }

    public static IASTName findMatchingASTName(IASTTranslationUnit tu, IName name, IIndex index) throws CoreException {
        if (name instanceof IASTName) {
            return (IASTName)name;
        }
        if (!(name instanceof IIndexName)) {
            return null;
        }
        IndexNameToAstNameMatcher visitor = new IndexNameToAstNameMatcher(tu, (IIndexName)name, index);
        tu.accept((ASTVisitor)visitor);
        return visitor.getMatch();
    }

    static boolean shouldConsiderName(IASTName candidate) {
        return !IndexToASTNameHelper.isQualifiedName(candidate) && IndexToASTNameHelper.isLastNameInQualifiedName(candidate) && !IndexToASTNameHelper.isUnnamedName(candidate);
    }

    private static boolean isLastNameInQualifiedName(IASTName name) {
        if (name.getParent() instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qName = (ICPPASTQualifiedName)name.getParent();
            return name.equals(qName.getLastName());
        }
        return true;
    }

    private static boolean isUnnamedName(IASTName name) {
        return name.getFileLocation() == null && name.toCharArray().length == 0;
    }

    private static boolean isQualifiedName(IASTName name) {
        return name instanceof ICPPASTQualifiedName;
    }
}

