/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui;

import java.util.List;
import org.eclipse.cdt.debug.internal.ui.actions.OpenNewViewAction;
import org.eclipse.cdt.debug.internal.ui.pinclone.PinCloneUtils;
import org.eclipse.cdt.visualizer.ui.IVisualizerViewer;
import org.eclipse.cdt.visualizer.ui.VisualizerViewer;
import org.eclipse.cdt.visualizer.ui.events.IVisualizerViewerListener;
import org.eclipse.cdt.visualizer.ui.events.VisualizerViewerEvent;
import org.eclipse.cdt.visualizer.ui.util.SelectionProviderAdapter;
import org.eclipse.cdt.visualizer.ui.util.SelectionUtils;
import org.eclipse.cdt.visualizer.ui.util.WorkbenchSelectionAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;

public class VisualizerView
extends ViewPart
implements IVisualizerViewerListener,
ISelectionChangedListener {
    protected boolean m_initialized = false;
    protected Composite m_parentControl = null;
    protected IVisualizerViewer m_viewer = null;
    protected WorkbenchSelectionAdapter m_workbenchSelectionAdapter = null;
    protected MenuManager m_contextMenuManager = null;
    protected Point m_contextMenuLocation = null;
    private OpenNewViewAction m_openNewViewAction = new OpenNewViewAction();

    public VisualizerView() {
        this.m_openNewViewAction.init((IViewPart)this);
    }

    public void dispose() {
        super.dispose();
        this.setViewer(null);
        this.disposeSelectionHandling();
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public IVisualizerViewer getViewer() {
        return this.m_viewer;
    }

    public void setViewer(IVisualizerViewer viewer) {
        if (this.m_viewer != null) {
            this.m_viewer.removeSelectionChangedListener(this);
            this.m_viewer.removeVisualizerViewerListener(this);
        }
        this.m_viewer = viewer;
        if (this.m_viewer != null) {
            this.m_viewer.addVisualizerViewerListener(this);
            this.m_viewer.addSelectionChangedListener(this);
            this.updateUI();
        }
    }

    public void createPartControl(Composite parent) {
        this.m_parentControl = parent;
        this.initializeContextMenu();
        this.initializeSelectionHandling();
        this.initializeViewer();
        this.m_initialized = true;
    }

    public void setFocus() {
        if (this.m_viewer != null) {
            this.m_viewer.setFocus();
        }
    }

    protected IVisualizerViewer createViewer(Composite parent) {
        return this.m_viewer != null ? this.m_viewer : new VisualizerViewer(this, parent);
    }

    protected void initializeViewer() {
        IVisualizerViewer viewer = this.createViewer(this.m_parentControl);
        this.setViewer(viewer);
    }

    public void setTabName(String displayName) {
        this.setPartName(displayName);
    }

    public void setTabDescription(String description) {
        this.setTitleToolTip(description);
    }

    protected void initializeSelectionHandling() {
        this.m_workbenchSelectionAdapter = new WorkbenchSelectionAdapter((IViewPart)this);
        this.m_workbenchSelectionAdapter.addSelectionChangedListener(this);
    }

    protected void disposeSelectionHandling() {
        if (this.m_workbenchSelectionAdapter != null) {
            this.m_workbenchSelectionAdapter.dispose();
            this.m_workbenchSelectionAdapter = null;
        }
    }

    public ISelection getWorkbenchSelection() {
        return this.m_workbenchSelectionAdapter.getSelection();
    }

    public void setWorkbenchSelection(ISelection selection) {
        this.m_workbenchSelectionAdapter.setSelection(this, selection);
    }

    public void setWorkbenchSelection(List<?> selection) {
        ISelection iselection = SelectionUtils.toSelection(selection);
        this.m_workbenchSelectionAdapter.setSelection(this, iselection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object source = event.getSource();
        if (source instanceof SelectionProviderAdapter) {
            source = ((SelectionProviderAdapter)source).getActualSource();
        }
        if (source == this.m_viewer) {
            ISelection selection = event.getSelection();
            this.setWorkbenchSelection(selection);
            this.updateUI();
        } else if (source != this) {
            ISelection selection = event.getSelection();
            this.workbenchSelectionChanged(selection);
            this.updateUI();
        }
    }

    public void workbenchSelectionChanged(ISelection selection) {
        if (this.m_viewer != null) {
            this.m_viewer.workbenchSelectionChanged(selection);
        }
    }

    @Override
    public void visualizerEvent(IVisualizerViewer source, VisualizerViewerEvent event) {
        switch (event.getType()) {
            case 1: {
                this.updateUI();
                break;
            }
            case 2: {
                this.showContextMenu(event.x, event.y);
            }
        }
    }

    public void updateUI() {
        String name = "Visualizer View";
        String description = "Displays visualizations of launches.";
        if (this.m_viewer != null) {
            name = this.m_viewer.getVisualizerDisplayName();
            description = this.m_viewer.getVisualizerDescription();
        }
        this.setTabName(name);
        PinCloneUtils.setPartTitle((IViewPart)this);
        this.setTabDescription(description);
        if (this.m_viewer != null) {
            IActionBars actionBars = this.getViewSite().getActionBars();
            IToolBarManager toolBarManager = actionBars.getToolBarManager();
            toolBarManager.removeAll();
            this.m_viewer.populateToolBar(toolBarManager);
            toolBarManager.add((IAction)this.m_openNewViewAction);
            toolBarManager.update(true);
            IMenuManager menuManager = actionBars.getMenuManager();
            menuManager.removeAll();
            this.m_viewer.populateMenu(menuManager);
            menuManager.update(true);
            actionBars.updateActionBars();
        }
    }

    protected void initializeContextMenu() {
        this.m_contextMenuManager = new MenuManager();
        this.m_contextMenuManager.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToShow(IMenuManager m) {
                VisualizerView.this.contextMenuShow(m);
            }

            public void menuAboutToHide(IMenuManager m) {
                VisualizerView.this.contextMenuHide(m);
            }
        });
        Menu menu = this.m_contextMenuManager.createContextMenu((Control)this.m_parentControl);
        this.m_parentControl.setMenu(menu);
    }

    protected void contextMenuShow(IMenuManager m) {
        m.removeAll();
        this.m_viewer.populateContextMenu(m);
        m.update();
    }

    protected void contextMenuHide(IMenuManager m) {
    }

    public void showContextMenu(int x, int y) {
        Menu menu = this.m_parentControl.getMenu();
        if (menu != null) {
            menu.setLocation(x, y);
            this.m_contextMenuLocation = this.m_parentControl.toControl(x, y);
            menu.setVisible(true);
            this.setFocus();
        }
    }

    public Point getContextMenuLocation() {
        return this.m_contextMenuLocation;
    }
}

