/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core;

import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.sqltools.core.Messages;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;

public class PredefinedDataTypeValidator {
    public static String isValidPredefinedType(PredefinedDataType type, DatabaseDefinition dbdef) {
        Integer scale;
        Integer precision;
        EStructuralFeature f;
        Integer length;
        if (dbdef == null) {
            return Messages.PredefinedDataTypeValidator_no_db_definition;
        }
        PredefinedDataTypeDefinition typeDef = PredefinedDataTypeValidator.getPredefinedDataTypeDefinition(type, dbdef);
        if (typeDef == null) {
            return Messages.PredefinedDataTypeValidator_no_datatype_definition;
        }
        if (typeDef.isLengthSupported() && (length = (Integer)type.eGet(f = type.eClass().getEStructuralFeature("length"))) != null) {
            if (length < 0) {
                return NLS.bind((String)Messages.PredefinedDataTypeValidator_length_shouldbe_positive, (Object)type.getName());
            }
            if (length > typeDef.getMaximumLength()) {
                return NLS.bind((String)Messages.PredefinedDataTypeValidator_length_exceed_max, (Object[])new Object[]{type.getName(), new Integer(typeDef.getMaximumLength())});
            }
        }
        if (typeDef.isPrecisionSupported()) {
            f = type.eClass().getEStructuralFeature("precision");
            precision = (Integer)type.eGet(f);
            if (precision != null && precision < 0) {
                return NLS.bind((String)Messages.PredefinedDataTypeValidator_precision_positive, (Object)type.getName());
            }
            if (precision > typeDef.getMaximumPrecision()) {
                return NLS.bind((String)Messages.PredefinedDataTypeValidator_precision_exceed_max, (Object[])new Object[]{type.getName(), new Integer(typeDef.getMaximumPrecision())});
            }
        }
        if (typeDef.isScaleSupported() && (scale = (Integer)type.eGet(f = type.eClass().getEStructuralFeature("scale"))) != null) {
            if (scale < typeDef.getMinimumScale()) {
                return NLS.bind((String)Messages.PredefinedDataTypeValidator_scale_below_min, (Object[])new Object[]{type.getName(), new Integer(typeDef.getMinimumScale())});
            }
            if (scale > typeDef.getMaximumScale()) {
                return NLS.bind((String)Messages.PredefinedDataTypeValidator_precision_exceed_max, (Object[])new Object[]{type.getName(), new Integer(typeDef.getMaximumScale())});
            }
        }
        if (typeDef.isPrecisionSupported() && typeDef.isScaleSupported()) {
            f = type.eClass().getEStructuralFeature("precision");
            precision = (Integer)type.eGet(f);
            EStructuralFeature sf = type.eClass().getEStructuralFeature("scale");
            Integer scale2 = (Integer)type.eGet(sf);
            if (precision != null && scale2 != null && precision < scale2) {
                return NLS.bind((String)Messages.PredefinedDataTypeValidator_precision_lessthan_scale, (Object)type.getName());
            }
        }
        return null;
    }

    private static PredefinedDataTypeDefinition getPredefinedDataTypeDefinition(PredefinedDataType dataType, DatabaseDefinition dbdef) {
        if (dataType == null || dataType.getName() == null) {
            return null;
        }
        Iterator i = dbdef.getPredefinedDataTypes();
        while (i.hasNext()) {
            PredefinedDataTypeDefinition def = (PredefinedDataTypeDefinition)i.next();
            if (def == null || def.getName() == null || !PredefinedDataTypeValidator.matchName((List)def.getName(), dataType.getName())) continue;
            return def;
        }
        return null;
    }

    private static boolean matchName(List names, String name) {
        if (names == null || names.size() == 0 || name == null) {
            return false;
        }
        for (String n : names) {
            if (n == null || !n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

