/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.rse;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.internal.rse.DLTKRSEPlugin;
import org.eclipse.dltk.utils.LazyExtensionManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class RSEConnectionQueryManager {
    private static final long CONNECTION_TIMEOUT = 10000L;
    private static RSEConnectionQueryManager queryManager = null;
    private LazyExtensionManager<IConnector> connectors = new LazyExtensionManager("org.eclipse.dltk.rse.core.rseConnector");
    private List<ConnectionRequest> requests = new ArrayList<ConnectionRequest>();
    private boolean isConnecting = false;
    private long currentId;

    public static synchronized RSEConnectionQueryManager getInstance() {
        if (queryManager == null) {
            queryManager = new RSEConnectionQueryManager();
        }
        return queryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectingStatus(boolean status) {
        List<ConnectionRequest> list = this.requests;
        synchronized (list) {
            this.isConnecting = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        List<ConnectionRequest> list = this.requests;
        synchronized (list) {
            return this.isConnecting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markHostAsFinished(IHost host) {
        List<ConnectionRequest> list = this.requests;
        synchronized (list) {
            ArrayList<ConnectionRequest> toRemove = new ArrayList<ConnectionRequest>();
            for (ConnectionRequest request : this.requests) {
                if (!request.host.equals(host)) continue;
                toRemove.add(request);
                request.setFinished(true);
            }
            this.setConnectingStatus(false);
            if (!toRemove.isEmpty()) {
                this.requests.removeAll(toRemove);
                this.requests.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHost getNextHost(boolean wait) {
        List<ConnectionRequest> list = this.requests;
        synchronized (list) {
            if (wait) {
                while (this.isConnecting() || this.requests.isEmpty()) {
                    try {
                        this.requests.wait(100L);
                    }
                    catch (InterruptedException e) {
                        DLTKRSEPlugin.log(e);
                    }
                }
            }
            if (!this.requests.isEmpty()) {
                ConnectionRequest request = this.requests.get(0);
                this.setConnectingStatus(true);
                return request.host;
            }
            return null;
        }
    }

    public RSEConnectionQueryManager() {
        LazyExtensionManager.Descriptor[] descriptors;
        LazyExtensionManager.Descriptor[] descriptorArray = descriptors = this.connectors.getDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            LazyExtensionManager.Descriptor descriptor = descriptorArray[n2];
            IConnector connector = (IConnector)descriptor.get();
            connector.register();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean connectTo(IHost host) {
        LazyExtensionManager.Descriptor[] descriptors;
        if (this.isConnected(host)) {
            return true;
        }
        ConnectionRequest request = new ConnectionRequest(host, this.currentId++);
        List<ConnectionRequest> list = this.requests;
        // MONITORENTER : list
        this.requests.add(request);
        this.requests.notifyAll();
        // MONITOREXIT : list
        LazyExtensionManager.Descriptor[] descriptorArray = descriptors = this.connectors.getDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            LazyExtensionManager.Descriptor descriptor = descriptorArray[n2];
            IConnector connector = (IConnector)descriptor.get();
            if (connector.isDirectProcessingRequired()) {
                connector.runDisplayRunnables(10000L);
            }
            ++n2;
        }
        long endTime = System.currentTimeMillis() + 10000L;
        List<ConnectionRequest> list2 = this.requests;
        // MONITORENTER : list2
        while (true) {
            if (request.isFinished() || !Platform.isRunning()) {
                // MONITOREXIT : list2
                return this.isConnected(host);
            }
            try {
                this.requests.wait(100L);
                long currentTime = System.currentTimeMillis();
                if (currentTime <= endTime) continue;
                return this.isConnected(host);
            }
            catch (InterruptedException e) {
                DLTKRSEPlugin.log(e);
                continue;
            }
            break;
        }
    }

    private boolean isConnected(IHost host) {
        ISubSystem[] subSystems;
        ISubSystem[] iSubSystemArray = subSystems = host.getSubSystems();
        int n = subSystems.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem subsystem = iSubSystemArray[n2];
            if (subsystem instanceof IRemoteFileSubSystem) {
                return subsystem.isConnected();
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHosts() {
        List<ConnectionRequest> list = this.requests;
        synchronized (list) {
            return !this.requests.isEmpty();
        }
    }

    private static class ConnectionRequest {
        private IHost host;
        private long id;
        private boolean finished = false;

        public ConnectionRequest(IHost host, long id) {
            this.host = host;
            this.id = id;
        }

        public synchronized boolean isFinished() {
            return this.finished;
        }

        public synchronized void setFinished(boolean finished) {
            this.finished = finished;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionRequest other = (ConnectionRequest)obj;
            return !(this.host == null ? other.host != null : !this.host.equals(other.host));
        }
    }

    public static interface IConnector {
        public void register();

        public boolean isDirectProcessingRequired();

        public void runDisplayRunnables(long var1);
    }
}

