/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ruby.ast.RubyAssignment;

public class LocalVariableInfo {
    public static final int KIND_DEFAULT = 0;
    public static final int KIND_BLOCK_ARG = 1;
    public static final int KIND_METHOD_ARG = 2;
    public static final int KIND_LOOP_VAR = 3;
    private ASTNode declaringScope;
    private RubyAssignment[] conditionalAssignments;
    private RubyAssignment lastAssignment;
    private int kind;

    public LocalVariableInfo(ASTNode declaringScope, RubyAssignment[] assignments, RubyAssignment last) {
        this.declaringScope = declaringScope;
        this.conditionalAssignments = assignments;
        this.lastAssignment = last;
        this.kind = 0;
    }

    public LocalVariableInfo(ASTNode declaringScope, RubyAssignment[] assignments, RubyAssignment last, int kind) {
        this.declaringScope = declaringScope;
        this.conditionalAssignments = assignments;
        this.lastAssignment = last;
        this.kind = kind;
    }

    public LocalVariableInfo() {
    }

    public ASTNode getDeclaringScope() {
        return this.declaringScope;
    }

    public RubyAssignment[] getConditionalAssignments() {
        if (this.conditionalAssignments == null) {
            return new RubyAssignment[0];
        }
        return this.conditionalAssignments;
    }

    public RubyAssignment getLastAssignment() {
        return this.lastAssignment;
    }

    public int getKind() {
        return this.kind;
    }

    public void setDeclaringScope(ASTNode declaringScope) {
        this.declaringScope = declaringScope;
    }

    public void setConditionalAssignments(RubyAssignment[] conditionalAssignments) {
        this.conditionalAssignments = conditionalAssignments;
    }

    public void setConditionalAssignments(List conditionalAssignments) {
        this.conditionalAssignments = conditionalAssignments.toArray(new RubyAssignment[conditionalAssignments.size()]);
    }

    public void setLastAssignment(RubyAssignment lastAssignment) {
        this.lastAssignment = lastAssignment;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }
}

