/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.Date;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.util.DateUtils;

public class Repository
implements IRepositoryIdProvider,
Serializable {
    private static final long serialVersionUID = 406671816413754925L;
    private boolean fork;
    private boolean hasDownloads;
    private boolean hasIssues;
    private boolean hasWiki;
    @SerializedName(value="private")
    private boolean isPrivate;
    private Date createdAt;
    private Date pushedAt;
    private Date updatedAt;
    private int forks;
    private long id;
    private int openIssues;
    private int size;
    private int watchers;
    private Repository parent;
    private Repository source;
    private String cloneUrl;
    private String description;
    private String homepage;
    private String gitUrl;
    private String htmlUrl;
    private String language;
    private String masterBranch;
    private String mirrorUrl;
    private String name;
    private String sshUrl;
    private String svnUrl;
    private String url;
    private User owner;

    public boolean isFork() {
        return this.fork;
    }

    public Repository setFork(boolean fork) {
        this.fork = fork;
        return this;
    }

    public boolean isHasDownloads() {
        return this.hasDownloads;
    }

    public Repository setHasDownloads(boolean hasDownloads) {
        this.hasDownloads = hasDownloads;
        return this;
    }

    public boolean isHasIssues() {
        return this.hasIssues;
    }

    public Repository setHasIssues(boolean hasIssues) {
        this.hasIssues = hasIssues;
        return this;
    }

    public boolean isHasWiki() {
        return this.hasWiki;
    }

    public Repository setHasWiki(boolean hasWiki) {
        this.hasWiki = hasWiki;
        return this;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public Repository setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
        return this;
    }

    public Date getCreatedAt() {
        return DateUtils.clone(this.createdAt);
    }

    public Repository setCreatedAt(Date createdAt) {
        this.createdAt = DateUtils.clone(createdAt);
        return this;
    }

    public Date getPushedAt() {
        return DateUtils.clone(this.pushedAt);
    }

    public Repository setPushedAt(Date pushedAt) {
        this.pushedAt = DateUtils.clone(pushedAt);
        return this;
    }

    public int getForks() {
        return this.forks;
    }

    public Repository setForks(int forks) {
        this.forks = forks;
        return this;
    }

    public int getOpenIssues() {
        return this.openIssues;
    }

    public Repository setOpenIssues(int openIssues) {
        this.openIssues = openIssues;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public Repository setSize(int size) {
        this.size = size;
        return this;
    }

    public int getWatchers() {
        return this.watchers;
    }

    public Repository setWatchers(int watchers) {
        this.watchers = watchers;
        return this;
    }

    public Repository getParent() {
        return this.parent;
    }

    public Repository setParent(Repository parent) {
        this.parent = parent;
        return this;
    }

    public Repository getSource() {
        return this.source;
    }

    public Repository setSource(Repository source) {
        this.source = source;
        return this;
    }

    public String getCloneUrl() {
        return this.cloneUrl;
    }

    public Repository setCloneUrl(String cloneUrl) {
        this.cloneUrl = cloneUrl;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Repository setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public Repository setHomepage(String homepage) {
        this.homepage = homepage;
        return this;
    }

    public String getGitUrl() {
        return this.gitUrl;
    }

    public Repository setGitUrl(String gitUrl) {
        this.gitUrl = gitUrl;
        return this;
    }

    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    public Repository setHtmlUrl(String htmlUrl) {
        this.htmlUrl = htmlUrl;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public Repository setLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getMasterBranch() {
        return this.masterBranch;
    }

    public Repository setMasterBranch(String masterBranch) {
        this.masterBranch = masterBranch;
        return this;
    }

    public String getMirrorUrl() {
        return this.mirrorUrl;
    }

    public Repository setMirrorUrl(String mirrorUrl) {
        this.mirrorUrl = mirrorUrl;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Repository setName(String name) {
        this.name = name;
        return this;
    }

    public String getSshUrl() {
        return this.sshUrl;
    }

    public Repository setSshUrl(String sshUrl) {
        this.sshUrl = sshUrl;
        return this;
    }

    public String getSvnUrl() {
        return this.svnUrl;
    }

    public Repository setSvnUrl(String svnUrl) {
        this.svnUrl = svnUrl;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public Repository setUrl(String url) {
        this.url = url;
        return this;
    }

    public User getOwner() {
        return this.owner;
    }

    public Repository setOwner(User owner) {
        this.owner = owner;
        return this;
    }

    public Date getUpdatedAt() {
        return DateUtils.clone(this.updatedAt);
    }

    public Repository setUpdatedAt(Date updatedAt) {
        this.updatedAt = DateUtils.clone(updatedAt);
        return this;
    }

    public long getId() {
        return this.id;
    }

    public Repository setId(long id) {
        this.id = id;
        return this;
    }

    public String generateId() {
        User owner = this.owner;
        String name = this.name;
        if (owner == null || name == null || name.length() == 0) {
            return null;
        }
        String login = owner.getLogin();
        if (login == null || login.length() == 0) {
            return null;
        }
        return String.valueOf(login) + "/" + name;
    }
}

