/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EReferenceImpl;
import org.eclipse.net4j.util.ObjectUtil;

public class CDOContainerFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDOContainerFeatureDelta {
    private CDOID newResourceID;
    private Object newContainerID;
    private int newContainerFeatureID;

    public CDOContainerFeatureDeltaImpl(CDOID newResourceID, Object newContainerID, int newContainerFeatureID) {
        super((EStructuralFeature)CONTAINER_FEATURE);
        this.newResourceID = newResourceID;
        this.newContainerID = newContainerID;
        this.newContainerFeatureID = newContainerFeatureID;
    }

    public CDOContainerFeatureDeltaImpl(CDODataInput in, EClass eClass) throws IOException {
        super((EStructuralFeature)CONTAINER_FEATURE);
        this.newContainerFeatureID = in.readInt();
        this.newContainerID = in.readCDOID();
        this.newResourceID = in.readCDOID();
    }

    public CDOFeatureDelta.Type getType() {
        return CDOFeatureDelta.Type.CONTAINER;
    }

    public CDOFeatureDelta copy() {
        return new CDOContainerFeatureDeltaImpl(this.newResourceID, this.newContainerID, this.newContainerFeatureID);
    }

    public CDOID getResourceID() {
        return this.newResourceID;
    }

    public Object getContainerID() {
        return this.newContainerID;
    }

    public int getContainerFeatureID() {
        return this.newContainerFeatureID;
    }

    public Object applyTo(CDORevision revision) {
        InternalCDORevision internalRevision = (InternalCDORevision)revision;
        internalRevision.setResourceID(this.newResourceID);
        internalRevision.setContainerID(this.newContainerID);
        internalRevision.setContainingFeatureID(this.newContainerFeatureID);
        return null;
    }

    public boolean adjustReferences(CDOReferenceAdjuster referenceAdjuster) {
        Object id2;
        boolean changed = false;
        CDOID id1 = (CDOID)referenceAdjuster.adjustReference(this.newResourceID, (EStructuralFeature)CONTAINER_FEATURE, -1);
        if (id1 != this.newResourceID) {
            this.newResourceID = id1;
            changed = true;
        }
        if ((id2 = referenceAdjuster.adjustReference(this.newContainerID, (EStructuralFeature)CONTAINER_FEATURE, -1)) != this.newContainerID) {
            this.newContainerID = id2;
            changed = true;
        }
        return changed;
    }

    public void write(CDODataOutput out, EClass eClass) throws IOException {
        out.writeInt(this.getType().ordinal());
        out.writeInt(this.newContainerFeatureID);
        out.writeCDOID(out.getIDProvider().provideCDOID(this.newContainerID));
        out.writeCDOID(this.newResourceID);
    }

    public void accept(CDOFeatureDeltaVisitor visitor) {
        visitor.visit(this);
    }

    public boolean isStructurallyEqual(Object obj) {
        if (!super.isStructurallyEqual(obj)) {
            return false;
        }
        CDOContainerFeatureDelta that = (CDOContainerFeatureDelta)obj;
        return ObjectUtil.equals((Object)this.newResourceID, (Object)that.getResourceID()) && ObjectUtil.equals((Object)this.newContainerID, (Object)that.getContainerID()) && this.newContainerFeatureID == that.getContainerFeatureID();
    }

    protected String toStringAdditional() {
        return MessageFormat.format("resource={0}, container={1}, feature={2}", this.newResourceID, this.newContainerID, this.newContainerFeatureID);
    }

    public static final class ContainerFeature
    extends EReferenceImpl {
        public static final String NAME = "eContainer";

        public String getName() {
            return null;
        }

        public String toString() {
            return NAME;
        }
    }
}

