/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.codegen.actions;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.dawn.codegen.dawngenmodel.DawnFragmentGenerator;
import org.eclipse.emf.cdo.dawn.codegen.dawngenmodel.DawnGenerator;
import org.eclipse.emf.cdo.dawn.codegen.dawngenmodel.DawngenmodelFactory;
import org.eclipse.emf.cdo.dawn.codegen.util.ProjectCreationHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class GenerateDawnGenModelAction
implements IObjectActionDelegate {
    protected IResource selectedElement;
    public static final String dawngenmodelFileExtension = "dawngenmodel";
    protected final String generalPrefix = "Dawn";

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            window.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Generate Dawn Code", 1000);
                    IFile genFile = (IFile)GenerateDawnGenModelAction.this.selectedElement;
                    String genModelFile = genFile.getRawLocationURI().toString();
                    String path = genModelFile.replace(genFile.getName(), "");
                    ResourceSet resourceSet = GenerateDawnGenModelAction.this.createResourceSet();
                    String modelname = "default";
                    modelname = GenerateDawnGenModelAction.this.getModelName(genFile);
                    Resource dawnGenModelResource = GenerateDawnGenModelAction.this.getResource(path, modelname, resourceSet, GenerateDawnGenModelAction.dawngenmodelFileExtension);
                    Resource dawnFragmentModelResource = GenerateDawnGenModelAction.this.getDawnFragmentModelResource(path, modelname, resourceSet);
                    DawnGenerator dawnGenerator = this.getDawngenerator(dawnGenModelResource);
                    DawnFragmentGenerator fragmentGenerator = GenerateDawnGenModelAction.this.getDawnFragmentGenerator(genFile, resourceSet);
                    fragmentGenerator.setDawnGenerator(dawnGenerator);
                    dawnGenModelResource.getContents().add((Object)dawnGenerator);
                    dawnFragmentModelResource.getContents().add((Object)fragmentGenerator);
                    try {
                        dawnGenModelResource.save(Collections.EMPTY_MAP);
                        dawnFragmentModelResource.save(Collections.EMPTY_MAP);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                    ProjectCreationHelper.refreshProject(null, monitor);
                }

                private DawnGenerator getDawngenerator(Resource dawnGenModelResource) {
                    DawnGenerator dawnGenerator = dawnGenModelResource.getContents().size() != 0 ? (DawnGenerator)dawnGenModelResource.getContents().get(0) : DawngenmodelFactory.eINSTANCE.createDawnGenerator();
                    return dawnGenerator;
                }
            });
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected abstract Resource getDawnFragmentModelResource(String var1, String var2, ResourceSet var3);

    protected abstract DawnFragmentGenerator getDawnFragmentGenerator(IFile var1, ResourceSet var2);

    private String getModelName(IFile genFile) {
        int lastIndexOf = genFile.getName().lastIndexOf(".");
        return genFile.getName().substring(0, lastIndexOf);
    }

    protected Resource getResource(String path, String modelname, ResourceSet resourceSet, String extension) {
        String resourcePath = String.valueOf(path) + modelname + "." + extension;
        URI uri = URI.createURI((String)resourcePath);
        Resource resource = null;
        try {
            resource = resourceSet.getResource(uri, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resource == null) {
            resource = resourceSet.createResource(uri);
        }
        return resource;
    }

    protected ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(dawngenmodelFileExtension, new XMIResourceFactoryImpl());
        return resourceSet;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object sel;
        if (selection instanceof IStructuredSelection && (sel = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            this.selectedElement = (IResource)sel;
        }
    }
}

