/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.examples.acore.graphiti.util;

import java.io.IOException;
import org.eclipse.emf.cdo.dawn.examples.acore.AClass;
import org.eclipse.emf.cdo.dawn.examples.acore.ACoreRoot;
import org.eclipse.emf.cdo.dawn.examples.acore.AInterface;
import org.eclipse.emf.cdo.dawn.examples.acore.AcoreFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.PictogramsFactory;

public class DawnGraphitiAcoreResourceUtil {
    public static void wireDomainModel(final Diagram diagram, final ResourceSet resourceSet, EditingDomain domain) {
        domain.getCommandStack().execute((Command)new RecordingCommand((TransactionalEditingDomain)domain){

            protected void doExecute() {
                EList businessObjects;
                PictogramLink link = diagram.getLink();
                if (link == null) {
                    link = PictogramsFactory.eINSTANCE.createPictogramLink();
                    diagram.setLink(link);
                }
                if ((businessObjects = link.getBusinessObjects()).size() == 0) {
                    ACoreRoot acoreRoot = AcoreFactory.eINSTANCE.createACoreRoot();
                    Resource modelResource = (Resource)resourceSet.getResources().get(0);
                    if (modelResource.equals(diagram.eResource())) {
                        modelResource = (Resource)resourceSet.getResources().get(1);
                    }
                    modelResource.getContents().add((Object)acoreRoot);
                    link.getBusinessObjects().add((Object)acoreRoot);
                    try {
                        diagram.eResource().save(null);
                        modelResource.save(null);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        });
    }

    public static void addToModelResource(EObject element, ResourceSet resourceSet) {
        Resource resource = (Resource)resourceSet.getResources().get(0);
        if (resource.getContents().size() > 0 && resource.getContents().get(0) instanceof Diagram) {
            resource = (Resource)resourceSet.getResources().get(1);
        }
        if (resource.getContents().size() > 0) {
            ACoreRoot acoreRoot = (ACoreRoot)resource.getContents().get(0);
            DawnGraphitiAcoreResourceUtil.addElement(element, acoreRoot);
        }
    }

    private static void addElement(EObject element, ACoreRoot acoreRoot) {
        if (acoreRoot instanceof ACoreRoot) {
            if (element instanceof AClass) {
                acoreRoot.getClasses().add((Object)((AClass)element));
            } else if (element instanceof AInterface) {
                acoreRoot.getInterfaces().add((Object)((AInterface)element));
            }
        }
    }
}

