/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.internal.ui.actions.AbstractViewAction;
import org.eclipse.emf.cdo.internal.ui.dialogs.SelectBranchPointDialog;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.spi.cdo.DefaultCDOMerger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;

public class MergeBranchPointAction
extends AbstractViewAction {
    public static final String ID = "merge";
    private static final String TITLE = Messages.getString("MergeBranchPointAction.0");
    private static final String TOOL_TIP = Messages.getString("MergeBranchPointAction.1");
    private CDOBranchPoint source;

    public MergeBranchPointAction(IWorkbenchPage page, CDOView view) {
        super(page, String.valueOf(TITLE) + INTERACTIVE, TOOL_TIP, null, view);
        this.setId(ID);
    }

    protected void preRun() throws Exception {
        CDOTransaction target = (CDOTransaction)this.getView();
        SelectBranchPointDialog dialog = new SelectBranchPointDialog(this.getPage(), target.getSession(), (CDOBranchPoint)target, target.isReadOnly()){

            protected Control createDialogArea(Composite parent) {
                this.getShell().setText(TITLE);
                this.setTitle(TITLE);
                this.setTitleImage(SharedIcons.getImage((String)"wizban/BranchBanner.gif"));
                this.setMessage("Compose a valid source point or select one from commits, tags or views.");
                return super.createDialogArea(parent);
            }

            protected String getComposeTabTitle() {
                return "Source Point";
            }
        };
        if (dialog.open() == 0) {
            this.source = dialog.getBranchPoint();
            if (this.source == null) {
                this.cancel();
            }
        } else {
            this.cancel();
        }
        super.preRun();
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        DefaultCDOMerger.PerFeature.ManyValued merger = new DefaultCDOMerger.PerFeature.ManyValued();
        CDOTransaction target = (CDOTransaction)this.getView();
        target.merge(this.source, (CDOMerger)merger);
    }
}

