/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Logger;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IPresenceDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EElementRelativePresence;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.diffdata.EMergeableDifference;
import org.eclipse.emf.diffmerge.diffdata.EValuePresence;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.diffuidata.ComparisonSelection;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.ComparisonSelectionImpl;
import org.eclipse.emf.diffmerge.ui.diffuidata.impl.MatchAndFeatureImpl;
import org.eclipse.emf.diffmerge.ui.log.CompareLogEvent;
import org.eclipse.emf.diffmerge.ui.log.MergeLogEvent;
import org.eclipse.emf.diffmerge.ui.util.DelegatingLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.util.InconsistencyDialog;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonTreeViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedComparisonSideViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedComparisonTreeViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedFeaturesViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedValuesViewer;
import org.eclipse.emf.diffmerge.ui.viewers.FeaturesViewer;
import org.eclipse.emf.diffmerge.ui.viewers.HeaderViewer;
import org.eclipse.emf.diffmerge.ui.viewers.IgnoreChoiceData;
import org.eclipse.emf.diffmerge.ui.viewers.IgnoreChoicesDialog;
import org.eclipse.emf.diffmerge.ui.viewers.MergeChoiceData;
import org.eclipse.emf.diffmerge.ui.viewers.MergeChoicesDialog;
import org.eclipse.emf.diffmerge.ui.viewers.MergeImpactMessageDialog;
import org.eclipse.emf.diffmerge.ui.viewers.MergeImpactViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ValuesViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonViewer
extends AbstractComparisonViewer {
    protected static final String PROPERTY_FILTERING = "PROPERTY_FILTERING";
    protected static final String PROPERTY_DIFFERENCE_NUMBERS = "PROPERTY_DIFFERENCE_NUMBERS";
    protected static final String PROPERTY_ACTIVATION_DELETE_LEFT = "PROPERTY_ACTIVATION_DELETE_LEFT";
    protected static final String PROPERTY_ACTIVATION_DELETE_RIGHT = "PROPERTY_ACTIVATION_DELETE_RIGHT";
    protected static final String PROPERTY_ACTIVATION_MERGE_TO_LEFT = "PROPERTY_ACTIVATION_MERGE_TO_LEFT";
    protected static final String PROPERTY_ACTIVATION_MERGE_TO_RIGHT = "PROPERTY_ACTIVATION_MERGE_TO_RIGHT";
    protected static final String PROPERTY_ACTIVATION_IGNORE_LEFT = "PROPERTY_ACTIVATION_IGNORE_LEFT";
    protected static final String PROPERTY_ACTIVATION_IGNORE_RIGHT = "PROPERTY_ACTIVATION_IGNORE_RIGHT";
    protected EnhancedComparisonTreeViewer _synthesisModelTreeViewer;
    protected EnhancedComparisonSideViewer _leftModelTreeViewer;
    protected EnhancedComparisonSideViewer _rightModelTreeViewer;
    protected EnhancedFeaturesViewer _featuresViewer;
    protected EnhancedValuesViewer _leftValuesViewer;
    protected EnhancedValuesViewer _rightValuesViewer;
    private ComparisonSelection _lastUserSelection;
    protected ViewerFilter _unchangedElementsFilter;
    protected ViewerFilter _moveOriginsFilter;
    protected ViewerSorter _synthesisSorter;
    protected boolean _isLeftRightSynced;

    public ComparisonViewer(Composite parent_p) {
        this(parent_p, null);
    }

    public ComparisonViewer(Composite parent_p, IActionBars actionBars_p) {
        super(parent_p, actionBars_p);
    }

    protected void addDifferencesToMerge(List<IDifference> toMerge_p, IMatch match_p, Role destination_p, boolean incrementalMode_p) {
        for (IDifference difference : match_p.getAllDifferences()) {
            if (this.getInput().shouldBeIgnored(difference) || incrementalMode_p && (!(difference instanceof IPresenceDifference) || ((IPresenceDifference)difference).getPresenceRole() == destination_p)) continue;
            toMerge_p.add(difference);
        }
    }

    protected void addDifferencesToMergeRec(List<IDifference> toMerge_p, IMatch match_p, Role destination_p, boolean incrementalMode_p) {
        this.addDifferencesToMerge(toMerge_p, match_p, destination_p, incrementalMode_p);
        for (IMatch child : this.getInput().getChildrenForMerge(match_p)) {
            this.addDifferencesToMergeRec(toMerge_p, child, destination_p, incrementalMode_p);
        }
    }

    protected boolean canAddToTheLeft(DifferenceKind originKind_p) {
        List<DifferenceKind> allowed = Arrays.asList(DifferenceKind.CONFLICT, DifferenceKind.MODIFIED, DifferenceKind.FROM_BOTH, DifferenceKind.FROM_RIGHT, DifferenceKind.FROM_RIGHT_ADD, DifferenceKind.FROM_LEFT_DEL);
        return allowed.contains((Object)originKind_p);
    }

    protected boolean canAddToTheRight(DifferenceKind originKind_p) {
        List<DifferenceKind> allowed = Arrays.asList(DifferenceKind.CONFLICT, DifferenceKind.MODIFIED, DifferenceKind.FROM_BOTH, DifferenceKind.FROM_LEFT, DifferenceKind.FROM_LEFT_ADD, DifferenceKind.FROM_RIGHT_DEL);
        return allowed.contains((Object)originKind_p);
    }

    protected void changeCounting(final EMFDiffNode.UserDifferenceKind kind_p, final boolean newValue_p) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ComparisonViewer.this.getInput().setCount(kind_p, newValue_p);
                ComparisonViewer.this.firePropertyChangeEvent(ComparisonViewer.PROPERTY_DIFFERENCE_NUMBERS, null);
                ComparisonViewer.this.firePropertyChangeEvent(ComparisonViewer.PROPERTY_FILTERING, ComparisonViewer.this.getInput().isFiltering());
            }
        });
    }

    @Override
    protected Composite createControls(Composite parent_p) {
        this.initialize();
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if (ComparisonViewer.PROPERTY_DIFFERENCE_NUMBERS.equals(event_p.getProperty())) {
                    ComparisonViewer.this.getInput().updateDifferenceNumbers();
                    ComparisonViewer.this.refresh();
                }
            }
        });
        SashForm result = new SashForm(parent_p, 512);
        SashForm upperPart = this.createRowUpper((Composite)result);
        SashForm lowerPart = this.createRowLower((Composite)result);
        this.setupColumns(upperPart, lowerPart);
        result.setWeights(this.getDefaultRowWeights());
        this.setupSynchronizationListeners();
        this.setupToolBars();
        return result;
    }

    protected MenuItem createMenuLogEvents(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 32);
        result.setText(Messages.ComparisonViewer_LogEventsMenuItem);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    result.setSelection(input.isLogEvents());
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                boolean logEvents = result.getSelection();
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setLogEvents(logEvents);
                    if (logEvents) {
                        ComparisonViewer.this.getLogger().log((Object)new CompareLogEvent(ComparisonViewer.this.getEditingDomain(), (IComparison)ComparisonViewer.this.getComparison()));
                    }
                }
            }
        });
        return result;
    }

    protected MenuItem createMenuShowAdditions(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 32);
        result.setText(Messages.ComparisonViewer_CountAddLeftMenuItem);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.OUT_ADD_STAT));
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    result.setSelection(input.counts(EMFDiffNode.UserDifferenceKind.PRESENCE_LEFT));
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this.changeCounting(EMFDiffNode.UserDifferenceKind.PRESENCE_LEFT, result.getSelection());
            }
        });
        return result;
    }

    protected MenuItem createMenuShowAllFeatures(Menu menu_p) {
        MenuItem result = new MenuItem(menu_p, 16);
        result.setText(Messages.ComparisonViewer_ShowAllFeatures);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ((FeaturesViewer)ComparisonViewer.this._featuresViewer.getInnerViewer()).setDifferenceAgnostic(true);
                ((ValuesViewer)ComparisonViewer.this._leftValuesViewer.getInnerViewer()).setDifferenceAgnostic(true);
                ((ValuesViewer)ComparisonViewer.this._rightValuesViewer.getInnerViewer()).setDifferenceAgnostic(true);
            }
        });
        return result;
    }

    protected MenuItem createMenuShowAllValues(Menu menu_p) {
        MenuItem result = new MenuItem(menu_p, 16);
        result.setText(Messages.ComparisonViewer_ShowAllValues);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ((FeaturesViewer)ComparisonViewer.this._featuresViewer.getInnerViewer()).setDifferenceAgnostic(false);
                ((ValuesViewer)ComparisonViewer.this._leftValuesViewer.getInnerViewer()).setDifferenceAgnostic(true);
                ((ValuesViewer)ComparisonViewer.this._rightValuesViewer.getInnerViewer()).setDifferenceAgnostic(true);
            }
        });
        return result;
    }

    protected MenuItem createMenuShowDeletions(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 32);
        result.setText(Messages.ComparisonViewer_CountAddRightMenuItem);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.INC_ADD_STAT));
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    result.setSelection(input.counts(EMFDiffNode.UserDifferenceKind.PRESENCE_RIGHT));
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this.changeCounting(EMFDiffNode.UserDifferenceKind.PRESENCE_RIGHT, result.getSelection());
            }
        });
        return result;
    }

    protected MenuItem createMenuShowDiffValues(Menu menu_p) {
        MenuItem result = new MenuItem(menu_p, 16);
        result.setText(Messages.ComparisonViewer_ShowValueDiffs);
        result.setSelection(true);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ((FeaturesViewer)ComparisonViewer.this._featuresViewer.getInnerViewer()).setDifferenceAgnostic(false);
                ((ValuesViewer)ComparisonViewer.this._leftValuesViewer.getInnerViewer()).setDifferenceAgnostic(false);
                ((ValuesViewer)ComparisonViewer.this._rightValuesViewer.getInnerViewer()).setDifferenceAgnostic(false);
            }
        });
        return result;
    }

    protected MenuItem createMenuShowImpact(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 32);
        result.setText(Messages.ComparisonViewer_ImpactMenuItem);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    result.setSelection(input.isShowMergeImpact());
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                boolean showImpact = result.getSelection();
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setShowMergeImpact(showImpact);
                    input.setDefaultShowImpact(showImpact);
                }
            }
        });
        return result;
    }

    protected MenuItem createMenuShowMoves(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 32);
        result.setText(Messages.ComparisonViewer_CountMovesMenuItem);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.MODIFIED_STAT));
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    result.setSelection(input.counts(EMFDiffNode.UserDifferenceKind.MOVE));
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this.changeCounting(EMFDiffNode.UserDifferenceKind.MOVE, result.getSelection());
            }
        });
        return result;
    }

    protected MenuItem createMenuShowNonContainmentDifferences(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 32);
        result.setText(Messages.ComparisonViewer_CountProperMenuItem);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.MODIFIED_STAT));
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    result.setSelection(input.counts(EMFDiffNode.UserDifferenceKind.NO_CONTAINMENT));
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ComparisonViewer.this.changeCounting(EMFDiffNode.UserDifferenceKind.NO_CONTAINMENT, result.getSelection());
            }
        });
        return result;
    }

    protected MenuItem createMenuShowUncounted(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 32);
        result.setText(Messages.ComparisonViewer_ShowUncountedMenuItem);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                if (result.getSelection()) {
                    ((ComparisonTreeViewer)((Object)ComparisonViewer.this._synthesisModelTreeViewer.getInnerViewer())).removeFilter(ComparisonViewer.this._unchangedElementsFilter);
                } else {
                    ((ComparisonTreeViewer)((Object)ComparisonViewer.this._synthesisModelTreeViewer.getInnerViewer())).addFilter(ComparisonViewer.this._unchangedElementsFilter);
                }
            }
        });
        return result;
    }

    protected MenuItem createMenuSupportUndoRedo(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 32);
        result.setText(Messages.ComparisonViewer_SupportUndoRedoMenuItem);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    result.setSelection(input.isUndoRedoSupported());
                    result.setEnabled(input.getEditingDomain() != null);
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setUndoRedoSupported(result.getSelection());
                }
            }
        });
        return result;
    }

    protected MenuItem createMenuUseCustomIcons(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 32);
        result.setText(Messages.ComparisonViewer_IconsMenuItem);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null && !result.isDisposed()) {
                    result.setSelection(input.usesCustomIcons());
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                EMFDiffNode input = ComparisonViewer.this.getInput();
                if (input != null) {
                    input.setUseCustomIcons(result.getSelection());
                    ComparisonViewer.this._synthesisModelTreeViewer.refresh();
                    ComparisonViewer.this._featuresViewer.refresh();
                    ComparisonViewer.this._leftValuesViewer.refresh();
                    ComparisonViewer.this._rightValuesViewer.refresh();
                }
            }
        });
        return result;
    }

    protected SashForm createRowLower(Composite parent_p) {
        SashForm result = new SashForm(parent_p, 256);
        this._featuresViewer = this.createViewerFeatures((Composite)result);
        this._leftValuesViewer = this.createViewerValues((Composite)result, true);
        this._rightValuesViewer = this.createViewerValues((Composite)result, false);
        return result;
    }

    protected SashForm createRowUpper(Composite parent_p) {
        SashForm result = new SashForm(parent_p, 256);
        this._synthesisModelTreeViewer = this.createViewerSynthesis((Composite)result);
        this._leftModelTreeViewer = this.createViewerSynthesisSide((Composite)result, true);
        this._rightModelTreeViewer = this.createViewerSynthesisSide((Composite)result, false);
        return result;
    }

    protected EnhancedFeaturesViewer createViewerFeatures(Composite parent_p) {
        EnhancedFeaturesViewer result = new EnhancedFeaturesViewer(parent_p);
        return result;
    }

    protected EnhancedComparisonTreeViewer createViewerSynthesis(Composite parent_p) {
        final EnhancedComparisonTreeViewer result = new EnhancedComparisonTreeViewer(parent_p);
        ((ComparisonTreeViewer)((Object)result.getInnerViewer())).addFilter(this._unchangedElementsFilter);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Boolean filtered;
                if (ComparisonViewer.PROPERTY_FILTERING.equals(event_p.getProperty()) && (filtered = (Boolean)event_p.getNewValue()) != null) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(ComparisonViewer.this._synthesisModelTreeViewer.getDefaultHeaderText());
                    if (filtered.booleanValue()) {
                        builder.append(Messages.ComparisonViewer_Filtered);
                    }
                    result.getTextLabel().setText(builder.toString());
                }
            }
        });
        return result;
    }

    protected EnhancedComparisonSideViewer createViewerSynthesisSide(Composite parent_p, boolean isLeftSide_p) {
        return new EnhancedComparisonSideViewer(parent_p, isLeftSide_p);
    }

    protected EnhancedValuesViewer createViewerValues(Composite parent_p, boolean left_p) {
        EnhancedValuesViewer result = new EnhancedValuesViewer(parent_p, left_p);
        return result;
    }

    protected ToolItem createToolCollapse(ToolBar toolbar_p) {
        ToolItem result = new ToolItem(toolbar_p, 8);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.COLLAPSEALL));
        result.setToolTipText(Messages.ComparisonViewer_CollapseTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                BusyIndicator.showWhile((Display)ComparisonViewer.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        ((ComparisonTreeViewer)((Object)(this).ComparisonViewer.this._synthesisModelTreeViewer.getInnerViewer())).collapseAll();
                    }
                });
            }
        });
        return result;
    }

    protected ToolItem createToolDelete(ToolBar toolbar_p, final boolean onLeft_p) {
        final ToolItem result = new ToolItem(toolbar_p, 8);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.DELETE));
        result.setToolTipText(onLeft_p ? Messages.ComparisonViewer_DeleteLeftTooltip : Messages.ComparisonViewer_DeleteRightTooltip);
        result.setEnabled(false);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue;
                if ((onLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_DELETE_LEFT.equals(event_p.getProperty()) || !onLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_DELETE_RIGHT.equals(event_p.getProperty())) && (newValue = event_p.getNewValue()) instanceof Boolean) {
                    result.setEnabled(((Boolean)newValue).booleanValue());
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.merge(onLeft_p);
            }
        });
        return result;
    }

    protected ToolItem createToolExpand(ToolBar toolbar_p) {
        ToolItem result = new ToolItem(toolbar_p, 8);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.EXPANDALL));
        result.setToolTipText(Messages.ComparisonViewer_ExpandTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                BusyIndicator.showWhile((Display)ComparisonViewer.this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        ((ComparisonTreeViewer)((Object)(this).ComparisonViewer.this._synthesisModelTreeViewer.getInnerViewer())).expandAll();
                    }
                });
            }
        });
        return result;
    }

    protected ToolItem createToolIgnore(ToolBar toolbar_p, final boolean onLeft_p) {
        final ToolItem result = new ToolItem(toolbar_p, 8);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.DONE));
        result.setToolTipText(onLeft_p ? Messages.ComparisonViewer_IgnoreLeftTooltip : Messages.ComparisonViewer_IgnoreRightTooltip);
        result.setEnabled(false);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue;
                if ((onLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_IGNORE_LEFT.equals(event_p.getProperty()) || !onLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_IGNORE_RIGHT.equals(event_p.getProperty())) && (newValue = event_p.getNewValue()) instanceof Boolean) {
                    result.setEnabled(((Boolean)newValue).booleanValue());
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.ignore(onLeft_p);
            }
        });
        return result;
    }

    protected ToolItem createToolInconsistency(ToolBar toolbar_p) {
        final ToolItem result = new ToolItem(toolbar_p, 8);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.WARNING));
        result.setToolTipText(Messages.ComparisonViewer_InconsistencyTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                final Shell shell = ComparisonViewer.this.getShell();
                final EComparison comparison = ComparisonViewer.this.getComparison();
                if (shell != null && comparison != null) {
                    shell.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            InconsistencyDialog dialog = new InconsistencyDialog(shell, (IComparison)comparison);
                            dialog.open();
                        }
                    });
                }
            }
        });
        result.setEnabled(false);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty())) {
                    EComparison comparison = ComparisonViewer.this.getComparison();
                    result.setEnabled(comparison != null && !comparison.isConsistent());
                }
            }
        });
        return result;
    }

    protected ToolItem createToolLock(ToolBar toolbar_p, final boolean onLeft_p) {
        final ToolItem result = new ToolItem(toolbar_p, 32);
        Image lockImage = EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.LOCK);
        result.setImage(lockImage);
        String lockTooltip = Messages.ComparisonViewer_LockTooltip;
        result.setToolTipText(lockTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.getInput().setEditable(!result.getSelection(), onLeft_p);
                ComparisonViewer.this.refreshTools();
            }
        });
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                EMFDiffNode input;
                if ("PROPERTY_CURRENT_INPUT".equals(event_p.getProperty()) && (input = ComparisonViewer.this.getInput()) != null) {
                    result.setSelection(!input.isEditable(onLeft_p));
                    result.setEnabled(input.isEditionPossible(onLeft_p));
                }
            }
        });
        return result;
    }

    protected ToolItem createToolMerge(ToolBar toolbar_p, final boolean toLeft_p) {
        final ToolItem result = new ToolItem(toolbar_p, 8);
        EMFDiffMergeUIPlugin.ImageID imageID = toLeft_p ? EMFDiffMergeUIPlugin.ImageID.CHECKOUT_ACTION : EMFDiffMergeUIPlugin.ImageID.CHECKIN_ACTION;
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(imageID));
        result.setToolTipText(toLeft_p ? Messages.ComparisonViewer_MergeLeftTooltip : Messages.ComparisonViewer_MergeRightTooltip);
        result.setEnabled(false);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue;
                if ((toLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_MERGE_TO_LEFT.equals(event_p.getProperty()) || !toLeft_p && ComparisonViewer.PROPERTY_ACTIVATION_MERGE_TO_RIGHT.equals(event_p.getProperty())) && (newValue = event_p.getNewValue()) instanceof Boolean) {
                    result.setEnabled(((Boolean)newValue).booleanValue());
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.merge(toLeft_p);
            }
        });
        return result;
    }

    protected ToolItem createToolNavigationNext(ToolBar toolbar_p) {
        ToolItem result = new ToolItem(toolbar_p, 8);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.NEXT_DIFF_NAV));
        result.setToolTipText(Messages.ComparisonViewer_NextTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.navigate(true);
            }
        });
        return result;
    }

    protected ToolItem createToolNavigationPrevious(ToolBar toolbar_p) {
        ToolItem result = new ToolItem(toolbar_p, 8);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.PREV_DIFF_NAV));
        result.setToolTipText(Messages.ComparisonViewer_PreviousTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ComparisonViewer.this.navigate(false);
            }
        });
        return result;
    }

    protected ToolItem createToolSort(ToolBar toolbar_p) {
        final ToolItem result = new ToolItem(toolbar_p, 32);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.SORT));
        result.setToolTipText(Messages.ComparisonViewer_SortTooltip);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                if (result.getSelection()) {
                    ((ComparisonTreeViewer)((Object)ComparisonViewer.this._synthesisModelTreeViewer.getInnerViewer())).setSorter(ComparisonViewer.this._synthesisSorter);
                } else {
                    ((ComparisonTreeViewer)((Object)ComparisonViewer.this._synthesisModelTreeViewer.getInnerViewer())).setSorter(null);
                }
            }
        });
        return result;
    }

    protected ToolItem createToolSync(ToolBar toolbar_p) {
        final ToolItem result = new ToolItem(toolbar_p, 32);
        result.setImage(EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.SYNCED));
        result.setToolTipText(Messages.ComparisonViewer_LinkViewsTooltip);
        result.setSelection(this._isLeftRightSynced);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                boolean synced;
                ComparisonViewer.this._isLeftRightSynced = synced = result.getSelection();
                if (ComparisonViewer.this._isLeftRightSynced) {
                    BusyIndicator.showWhile((Display)ComparisonViewer.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            ITreeSelection selection = (this).ComparisonViewer.this._synthesisModelTreeViewer.getSelection();
                            (this).ComparisonViewer.this._leftModelTreeViewer.setSelection((ISelection)selection, true);
                            (this).ComparisonViewer.this._rightModelTreeViewer.setSelection((ISelection)selection, true);
                        }
                    });
                }
            }
        });
        return result;
    }

    protected void ignore(boolean onLeft_p) {
        List<IDifference> toIgnore;
        final ComparisonSelection selection = this.getSelection();
        if (selection == null) {
            return;
        }
        EMFDiffNode input = this.getInput();
        List<EMatch> selectedMatches = this.getSelectedMatchesForInteractions(selection);
        IgnoreChoiceData choices = new IgnoreChoiceData(input.isDefaultCoverChildren(), false);
        this.makeIgnoreChoices(choices, input, selectedMatches);
        if (!choices.isProceed()) {
            return;
        }
        List<IDifference> list = toIgnore = !selectedMatches.isEmpty() ? this.getDifferencesToMerge(selectedMatches, input.getRoleForSide(onLeft_p), choices.isCoverChildren(), choices.isSideExclusive()) : this.getInput().getNonIgnoredDifferences((Iterable<? extends IDifference>)selection.asDifferencesToMerge());
        if (!toIgnore.isEmpty()) {
            this.executeOnModel(new Runnable(){

                public void run() {
                    for (IDifference diff : toIgnore) {
                        IValuePresence symmetrical;
                        if (!(diff instanceof EElementRelativePresence)) continue;
                        EElementRelativePresence presence = (EElementRelativePresence)diff;
                        ComparisonViewer.this.getUIComparison().getDifferencesToIgnore().add((Object)presence);
                        if (!(diff instanceof EValuePresence) || !((symmetrical = ((EValuePresence)diff).getSymmetrical()) instanceof EMergeableDifference)) continue;
                        ComparisonViewer.this.getUIComparison().getDifferencesToIgnore().add((Object)((EMergeableDifference)symmetrical));
                    }
                    ComparisonViewer.this.getUIComparison().setLastActionSelection(selection);
                }
            });
            this.firePropertyChangeEvent("DIRTY_STATE", new Boolean(true));
            this.firePropertyChangeEvent(PROPERTY_DIFFERENCE_NUMBERS, null);
        }
    }

    protected int[] getDefaultColumnWeights() {
        return new int[]{3, 2, 2};
    }

    protected int[] getDefaultRowWeights() {
        return new int[]{5, 2};
    }

    protected List<IDifference> getDifferencesToMerge(final List<EMatch> selectedMatches_p, final Role destination_p, final boolean coverChildren_p, final boolean incrementalMode_p) {
        final ArrayList result = new ArrayList();
        IProgressService progress = PlatformUI.getWorkbench().getProgressService();
        try {
            progress.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                    for (EMatch selectedMatch : selectedMatches_p) {
                        if (coverChildren_p) {
                            ComparisonViewer.this.addDifferencesToMergeRec(result, (IMatch)selectedMatch, destination_p, incrementalMode_p);
                            continue;
                        }
                        ComparisonViewer.this.addDifferencesToMerge(result, (IMatch)selectedMatch, destination_p, incrementalMode_p);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.unmodifiableList(result);
    }

    public Role getDrivingRole() {
        return this.getInput() == null ? null : this.getInput().getDrivingRole();
    }

    public HeaderViewer<?> getFeaturesViewer() {
        return this._featuresViewer;
    }

    protected Logger getLogger() {
        return EMFDiffMergeUIPlugin.getDefault().getDiffMergeLogger();
    }

    public EnhancedComparisonSideViewer getModelScopeViewer(boolean left_p) {
        EnhancedComparisonSideViewer result = left_p ? this._leftModelTreeViewer : this._rightModelTreeViewer;
        return result;
    }

    protected List<EMatch> getSelectedMatchesForInteractions(ComparisonSelection selection_p) {
        EList<EMatch> treePath;
        Object selectedMatches = selection_p.getSelectedMatches();
        if (selectedMatches.isEmpty() && !(treePath = selection_p.getSelectedTreePath()).isEmpty()) {
            selectedMatches = Collections.singletonList((EMatch)treePath.get(treePath.size() - 1));
        }
        return selectedMatches;
    }

    public ComparisonSelection getSelection() {
        return this._lastUserSelection;
    }

    public EnhancedComparisonTreeViewer getSynthesisViewer() {
        return this._synthesisModelTreeViewer;
    }

    public EnhancedValuesViewer getValuesViewer(boolean left_p) {
        EnhancedValuesViewer result = left_p ? this._leftValuesViewer : this._rightValuesViewer;
        return result;
    }

    @Override
    protected void handleDispose() {
        super.handleDispose();
        this._lastUserSelection = null;
        this._leftModelTreeViewer = null;
        this._rightModelTreeViewer = null;
        this._leftValuesViewer = null;
        this._rightValuesViewer = null;
        this._synthesisModelTreeViewer = null;
        this._featuresViewer = null;
        this._synthesisSorter = null;
        this._unchangedElementsFilter = null;
        this._moveOriginsFilter = null;
    }

    protected void initialize() {
        this._isLeftRightSynced = true;
        this._lastUserSelection = null;
        this._synthesisSorter = new ViewerSorter();
        this._unchangedElementsFilter = new ViewerFilter(){

            public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
                EMatch match = (EMatch)element_p;
                return ComparisonViewer.this.getInput().getDifferenceNumber((IMatch)match) > 0;
            }
        };
        this._moveOriginsFilter = new ViewerFilter(){

            public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
                TreePath path = parentElement_p instanceof TreePath ? ((TreePath)parentElement_p).createChildPath(element_p) : new TreePath(new Object[]{element_p});
                return !ComparisonViewer.this.getInput().isMoveOrigin(path);
            }
        };
    }

    protected boolean interactionsRequiredForIgnore(IgnoreChoiceData choices_p, EMFDiffNode input_p, List<EMatch> selectedMatches) {
        boolean childrenForMerge = false;
        boolean ownDifferences = false;
        for (EMatch selectedMatch : selectedMatches) {
            boolean bl = ownDifferences = ownDifferences || !input_p.getDifferenceKind((IMatch)selectedMatch).isNeutral();
            if (childrenForMerge && ownDifferences) break;
            boolean bl2 = childrenForMerge = childrenForMerge || input_p.hasChildrenForMerge((IMatch)selectedMatch);
            if (childrenForMerge && ownDifferences) break;
        }
        if (!ownDifferences && childrenForMerge) {
            choices_p.setCoverChildren(true);
        }
        return ownDifferences && childrenForMerge;
    }

    protected boolean interactionsRequiredForMerge(MergeChoiceData choices_p, EMFDiffNode input_p, List<EMatch> selectedMatches) {
        EMatch selectedMatch;
        boolean result;
        boolean bl = result = !selectedMatches.isEmpty();
        if (result && selectedMatches.size() == 1 && !input_p.hasChildrenForMerge((IMatch)(selectedMatch = selectedMatches.get(0)))) {
            DifferenceKind kind = input_p.getDifferenceKind((IMatch)selectedMatch);
            result = !kind.isAddition() && !kind.isDeletion();
        }
        return result;
    }

    @Override
    protected void inputChanged(Object input_p, Object oldInput_p) {
        this._featuresViewer.setInput(null);
        this._leftValuesViewer.setInput(null);
        this._rightValuesViewer.setInput(null);
        this._synthesisModelTreeViewer.setInput(input_p);
        this._leftModelTreeViewer.setInput(input_p);
        this._rightModelTreeViewer.setInput(input_p);
        super.inputChanged(input_p, oldInput_p);
        if (this.getInput() != null && this.getInput().isLogEvents()) {
            this.getLogger().log((Object)new CompareLogEvent(this.getEditingDomain(), (IComparison)this.getComparison()));
        }
    }

    protected void makeIgnoreChoices(IgnoreChoiceData choices_p, EMFDiffNode input_p, List<EMatch> selectedMatches_p) {
        boolean requiresInteractions = this.interactionsRequiredForIgnore(choices_p, input_p, selectedMatches_p);
        if (requiresInteractions) {
            IgnoreChoicesDialog choicesDialog = new IgnoreChoicesDialog(this.getShell(), Messages.ComparisonViewer_IgnoreCommandName, choices_p);
            choicesDialog.open();
            if (choices_p.isProceed()) {
                this.getInput().setDefaultCoverChildren(choices_p.isCoverChildren());
            }
        }
    }

    protected void makeMergeChoices(MergeChoiceData choices_p, EMFDiffNode input_p, List<EMatch> selectedMatches_p) {
        boolean requiresInteractions = this.interactionsRequiredForMerge(choices_p, input_p, selectedMatches_p);
        if (requiresInteractions) {
            boolean mayAskAboutChildren = false;
            for (EMatch selectedMatch : selectedMatches_p) {
                if (input_p.getDifferenceKind((IMatch)selectedMatch) == DifferenceKind.COUNTED) {
                    choices_p.setCoverChildren(true);
                    break;
                }
                if (!input_p.hasChildrenForMerge((IMatch)selectedMatch)) continue;
                mayAskAboutChildren = true;
                break;
            }
            MergeChoicesDialog choicesDialog = new MergeChoicesDialog(this.getShell(), Messages.ComparisonViewer_MergeHeader, choices_p, mayAskAboutChildren);
            choicesDialog.open();
            if (choices_p.isProceed()) {
                if (mayAskAboutChildren) {
                    input_p.setDefaultCoverChildren(choices_p.isCoverChildren());
                }
                input_p.setDefaultIncrementalMode(choices_p.isIncrementalMode());
                input_p.setDefaultShowImpact(choices_p.isShowImpact());
            }
        }
    }

    protected void merge(boolean toLeft_p) {
        final ComparisonSelection selection = this.getSelection();
        if (selection == null) {
            return;
        }
        final EMFDiffNode input = this.getInput();
        List<EMatch> selectedMatches = this.getSelectedMatchesForInteractions(selection);
        MergeChoiceData choices = new MergeChoiceData(input.isDefaultCoverChildren(), input.isDefaultIncrementalMode(), input.isDefaultShowImpact());
        this.makeMergeChoices(choices, input, selectedMatches);
        if (!choices.isProceed()) {
            return;
        }
        final Role destination = input.getRoleForSide(toLeft_p);
        final List<IDifference> toMerge = !selectedMatches.isEmpty() ? this.getDifferencesToMerge(selectedMatches, destination, choices.isCoverChildren(), choices.isIncrementalMode()) : input.getNonIgnoredDifferences((Iterable<? extends IDifference>)selection.asDifferencesToMerge());
        final ArrayList merged = new ArrayList();
        boolean done = false;
        if (!toMerge.isEmpty()) {
            boolean proceed = true;
            if (choices.isShowImpact()) {
                proceed = this.showMergeImpact(toMerge, toLeft_p, input);
            }
            if (proceed) {
                try {
                    IProgressService progress = PlatformUI.getWorkbench().getProgressService();
                    progress.busyCursorWhile(new IRunnableWithProgress(){

                        public void run(final IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                            Runnable mergeRunnable = new Runnable(){

                                public void run() {
                                    merged.addAll(ComparisonViewer.this.getComparison().merge(toMerge, destination, true, monitor_p));
                                    ComparisonViewer.this.getUIComparison().setLastActionSelection(selection);
                                }
                            };
                            if (input.isUndoRedoSupported()) {
                                MiscUtil.executeOnDomain(ComparisonViewer.this.getEditingDomain(), null, mergeRunnable);
                            } else {
                                MiscUtil.executeAndForget(ComparisonViewer.this.getEditingDomain(), mergeRunnable);
                            }
                        }
                    });
                    done = true;
                }
                catch (Exception e) {
                    throw new OperationCanceledException(e.getLocalizedMessage());
                }
            }
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ComparisonViewer_MergeHeader, (String)Messages.ComparisonViewer_NoDiffsToMerge);
        }
        if (!merged.isEmpty() && done) {
            input.setModified(true, toLeft_p);
            this.firePropertyChangeEvent("DIRTY_STATE", new Boolean(true));
            this.firePropertyChangeEvent(PROPERTY_DIFFERENCE_NUMBERS, null);
            if (input.isLogEvents()) {
                this.getLogger().log((Object)new MergeLogEvent(this.getEditingDomain(), (IComparison)this.getComparison(), merged, toLeft_p));
            }
        }
    }

    protected void navigate(boolean next_p) {
        TreePath newPath;
        ITreeSelection selection = this._synthesisModelTreeViewer.getSelection();
        TreePath current = selection == null || selection.isEmpty() ? TreePath.EMPTY : selection.getPaths()[0];
        ComparisonTreeViewer treeViewer = (ComparisonTreeViewer)((Object)this._synthesisModelTreeViewer.getInnerViewer());
        TreePath treePath = newPath = next_p ? treeViewer.getNextUserDifference(current) : treeViewer.getPreviousUserDifference(current);
        if (newPath != null) {
            this.setSelection((ISelection)new ComparisonSelectionImpl(newPath, this.getDrivingRole()), true);
        }
    }

    protected boolean representAsOwnership(IDifference difference_p) {
        boolean result = false;
        if (difference_p instanceof IReferenceValuePresence) {
            IReferenceValuePresence presence = (IReferenceValuePresence)difference_p;
            EReference ref = presence.getFeature();
            result = !presence.isOrder() && ref != null && ref.isContainment();
        }
        return result;
    }

    @Override
    public void refresh() {
        this._leftModelTreeViewer.refresh();
        this._rightModelTreeViewer.refresh();
        this._leftValuesViewer.refresh();
        this._rightValuesViewer.refresh();
        this._featuresViewer.refresh();
        this._synthesisModelTreeViewer.refresh();
        super.refresh();
    }

    @Override
    protected void refreshTools() {
        ComparisonSelection selection = this.getSelection();
        EMFDiffNode input = this.getInput();
        boolean onLeft = false;
        boolean onRight = false;
        boolean allowDeletion = false;
        boolean allowIgnoring = false;
        if (selection != null && input != null) {
            EList<EMatch> matches;
            allowIgnoring = true;
            EValuePresence presence = selection.asValuePresence();
            if (presence != null && !presence.isMerged()) {
                DifferenceKind kind = input.getDifferenceKind((IDifference)presence);
                onLeft = this.canAddToTheRight(kind);
                onRight = this.canAddToTheLeft(kind);
                allowDeletion = input.isMany((IPresenceDifference)presence) && !input.isOwnershipOpposite((IDifference)presence);
            } else if (selection.asFeature() == null && !(matches = selection.asMatches()).isEmpty()) {
                if (matches.size() > 1) {
                    allowDeletion = true;
                    Iterator it = matches.iterator();
                    while (it.hasNext() && (!onLeft || !onRight || allowDeletion)) {
                        EMatch current = (EMatch)it.next();
                        DifferenceKind kind = input.getDifferenceKind((IMatch)current);
                        if (kind.isAddition()) {
                            onLeft = onLeft || kind.isLeft(true);
                            onRight = onRight || kind.isRight(true);
                            continue;
                        }
                        onLeft = true;
                        onRight = true;
                        allowDeletion = false;
                    }
                    allowDeletion = allowDeletion && onLeft != onRight;
                } else {
                    IMatch match = (IMatch)matches.get(0);
                    if (input.representAsModification(match) || input.representAsMove(match) || input.getDifferenceKind(match) == DifferenceKind.COUNTED) {
                        onLeft = true;
                        onRight = true;
                        allowDeletion = false;
                    } else {
                        DifferenceKind kind = input.getDifferenceKind(match);
                        onLeft = this.canAddToTheRight(kind);
                        onRight = this.canAddToTheLeft(kind);
                        allowDeletion = true;
                    }
                }
            }
        }
        if (input != null) {
            this.firePropertyChangeEvent(PROPERTY_ACTIVATION_MERGE_TO_RIGHT, new Boolean(input.isEditable(false) && onLeft));
            this.firePropertyChangeEvent(PROPERTY_ACTIVATION_DELETE_LEFT, new Boolean(input.isEditable(true) && onLeft && allowDeletion));
            this.firePropertyChangeEvent(PROPERTY_ACTIVATION_MERGE_TO_LEFT, new Boolean(input.isEditable(true) && onRight));
            this.firePropertyChangeEvent(PROPERTY_ACTIVATION_DELETE_RIGHT, new Boolean(input.isEditable(false) && onRight && allowDeletion));
        }
        this.firePropertyChangeEvent(PROPERTY_ACTIVATION_IGNORE_LEFT, new Boolean(onLeft && allowIgnoring));
        this.firePropertyChangeEvent(PROPERTY_ACTIVATION_IGNORE_RIGHT, new Boolean(onRight && allowIgnoring));
        super.refreshTools();
    }

    public void setDelegateLabelProvider(ILabelProvider labelProvider_p) {
        List<Viewer> viewers = Arrays.asList(new Viewer[]{this._synthesisModelTreeViewer.getInnerViewer(), this._leftModelTreeViewer.getInnerViewer(), this._rightModelTreeViewer.getInnerViewer(), this._featuresViewer, this._leftValuesViewer, this._rightValuesViewer});
        for (Viewer viewer : viewers) {
            IBaseLabelProvider rawLP;
            if (!(viewer instanceof ContentViewer) || !((rawLP = ((ContentViewer)viewer).getLabelProvider()) instanceof DelegatingLabelProvider)) continue;
            DelegatingLabelProvider delegatingLP = (DelegatingLabelProvider)rawLP;
            delegatingLP.setDelegate(labelProvider_p);
        }
    }

    public void setSelection(ISelection selection_p, boolean reveal_p) {
        StructuredSelection emptySelection;
        StructuredSelection synthesisSelection = emptySelection = new StructuredSelection();
        StructuredSelection leftModelSelection = emptySelection;
        StructuredSelection rightModelSelection = emptySelection;
        StructuredSelection featureSelection = emptySelection;
        StructuredSelection leftValueSelection = emptySelection;
        StructuredSelection rightValueSelection = emptySelection;
        if (selection_p instanceof ComparisonSelection) {
            ValuesViewer.ValuesInput valuesInput;
            EStructuralFeature feature;
            EMatch match;
            ComparisonSelection selection = (ComparisonSelection)selection_p;
            boolean representAsOwnership = this.representAsOwnership((IDifference)selection.asValuePresence());
            EList<EMatch> matches = selection.asMatches();
            if (!matches.isEmpty()) {
                synthesisSelection = representAsOwnership && matches.size() == 1 ? new StructuredSelection(selection.asValuePresence().getValue()) : new StructuredSelection(matches);
                leftModelSelection = synthesisSelection;
                rightModelSelection = synthesisSelection;
            }
            EMatch eMatch = match = matches.size() == 1 ? (EMatch)matches.get(0) : null;
            if (match != null) {
                if (this.representAsOwnership((IDifference)selection.asValuePresence())) {
                    match = (EMatch)selection.asValuePresence().getValue();
                }
                if (this._featuresViewer.getInput() == null || this._featuresViewer.getInput().getMatch() != match) {
                    this._featuresViewer.setInput(new FeaturesViewer.FeaturesInput(this.getInput(), (IMatch)match));
                }
            } else if (!matches.isEmpty()) {
                this._featuresViewer.setInput(null);
            }
            Object object = feature = !representAsOwnership ? selection.asFeature() : EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature();
            if (feature == null && matches.size() == 1) {
                feature = (EStructuralFeature)((FeaturesViewer)this._featuresViewer.getInnerViewer()).getElementAt(0);
            }
            ValuesViewer.ValuesInput valuesInput2 = valuesInput = feature == null ? null : new ValuesViewer.ValuesInput(this.getInput(), new MatchAndFeatureImpl(match, feature));
            if (valuesInput == null || !valuesInput.equals(this._leftValuesViewer.getInput())) {
                this._leftValuesViewer.setInput(valuesInput);
            }
            if (valuesInput == null || !valuesInput.equals(this._rightValuesViewer.getInput())) {
                this._rightValuesViewer.setInput(valuesInput);
            }
            if (feature != null) {
                IValuePresence presence;
                featureSelection = new StructuredSelection((Object)feature);
                EList<EValuePresence> presences = selection.asValuePresences();
                rightValueSelection = leftValueSelection = new StructuredSelection(presences);
                if (presences.size() == 1 && (presence = (IValuePresence)presences.get(0)) instanceof IReferenceValuePresence) {
                    IReferenceValuePresence rvp = (IReferenceValuePresence)presence;
                    IMatch value = this.representAsOwnership((IDifference)rvp) ? rvp.getElementMatch() : rvp.getValue();
                    StructuredSelection rvpSelection = new StructuredSelection((Object)value);
                    if (rvp.getPresenceRole() == this.getInput().getRoleForSide(true)) {
                        leftModelSelection = rvpSelection;
                    } else {
                        rightModelSelection = rvpSelection;
                    }
                }
            }
        }
        this._synthesisModelTreeViewer.setSelection((ISelection)synthesisSelection, reveal_p);
        if (this._isLeftRightSynced) {
            this._leftModelTreeViewer.setSelection((ISelection)leftModelSelection, reveal_p);
            this._rightModelTreeViewer.setSelection((ISelection)rightModelSelection, reveal_p);
        }
        this._featuresViewer.setSelection((ISelection)featureSelection, reveal_p);
        this._leftValuesViewer.setSelection((ISelection)leftValueSelection, reveal_p);
        this._rightValuesViewer.setSelection((ISelection)rightValueSelection, reveal_p);
        this._lastUserSelection = selection_p instanceof ComparisonSelection ? (ComparisonSelection)selection_p : new ComparisonSelectionImpl(null, null);
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.getSelection()));
    }

    protected void setupColumns(final SashForm upperRow_p, final SashForm lowerRow_p) {
        int[] horizontalWeights = this.getDefaultColumnWeights();
        upperRow_p.setWeights(horizontalWeights);
        lowerRow_p.setWeights(horizontalWeights);
        Control upperMiddleControl = upperRow_p.getChildren()[1];
        upperMiddleControl.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e_p) {
                int[] weights = upperRow_p.getWeights();
                lowerRow_p.setWeights(weights);
            }

            public void controlMoved(ControlEvent e_p) {
            }
        });
        Control lowerMiddleControl = lowerRow_p.getChildren()[1];
        lowerMiddleControl.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e_p) {
                int[] weights = lowerRow_p.getWeights();
                upperRow_p.setWeights(weights);
            }

            public void controlMoved(ControlEvent e_p) {
            }
        });
    }

    protected Menu setupMenuDetails(ToolBar toolbar_p) {
        new ToolItem(toolbar_p, 2);
        Menu result = UIUtil.createMenuTool(this._featuresViewer.getToolbar());
        this.createMenuShowDiffValues(result);
        this.createMenuShowAllValues(result);
        this.createMenuShowAllFeatures(result);
        return result;
    }

    protected Menu setupMenuSynthesis(ToolBar toolbar_p) {
        Menu synthesisMenu = UIUtil.createMenuTool(toolbar_p);
        this.createMenuShowUncounted(synthesisMenu);
        new MenuItem(synthesisMenu, 2);
        this.createMenuShowAdditions(synthesisMenu);
        this.createMenuShowDeletions(synthesisMenu);
        this.createMenuShowMoves(synthesisMenu);
        this.createMenuShowNonContainmentDifferences(synthesisMenu);
        new MenuItem(synthesisMenu, 2);
        this.createMenuUseCustomIcons(synthesisMenu);
        this.createMenuShowImpact(synthesisMenu);
        this.createMenuSupportUndoRedo(synthesisMenu);
        this.createMenuLogEvents(synthesisMenu);
        return synthesisMenu;
    }

    protected void setupSynchronizationListeners() {
        this._synthesisModelTreeViewer.addSWTSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                ITreeSelection selection = ComparisonViewer.this._synthesisModelTreeViewer.getSelection();
                if (!selection.isEmpty()) {
                    ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(selection.toList(), ComparisonViewer.this.getDrivingRole()), true);
                }
            }
        });
        this._leftModelTreeViewer.addSWTSelectionListener((SelectionListener)new ComparisonSideSelectionListener(true));
        this._rightModelTreeViewer.addSWTSelectionListener((SelectionListener)new ComparisonSideSelectionListener(false));
        this._leftValuesViewer.addSWTSelectionListener((SelectionListener)new ValuesSelectionListener(true));
        this._rightValuesViewer.addSWTSelectionListener((SelectionListener)new ValuesSelectionListener(false));
        this._featuresViewer.addSWTSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                IStructuredSelection selection = ComparisonViewer.this._featuresViewer.getSelection();
                if (selection.size() == 1) {
                    IMatch match;
                    IMatch iMatch = match = ComparisonViewer.this._featuresViewer.getInput() == null ? null : ComparisonViewer.this._featuresViewer.getInput().getMatch();
                    if (match instanceof EMatch) {
                        EStructuralFeature feature = (EStructuralFeature)selection.getFirstElement();
                        MatchAndFeatureImpl newInputDetails = new MatchAndFeatureImpl((EMatch)match, feature);
                        ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(newInputDetails, ComparisonViewer.this.getDrivingRole()), true);
                    }
                }
            }
        });
    }

    protected void setupToolBars() {
        this.setupToolsSynthesis(this._synthesisModelTreeViewer.getToolbar());
        this.setupToolsSynthesisSide(this._leftModelTreeViewer.getToolbar(), true);
        this.setupToolsSynthesisSide(this._rightModelTreeViewer.getToolbar(), false);
        this.setupToolsDetails(this._featuresViewer.getToolbar());
        this.setupToolsDetailsSide(this._leftValuesViewer.getToolbar(), true);
        this.setupToolsDetailsSide(this._rightValuesViewer.getToolbar(), false);
        this.setupMenuSynthesis(this._synthesisModelTreeViewer.getToolbar());
        this.setupMenuDetails(this._featuresViewer.getToolbar());
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ComparisonViewer.this.refreshTools();
            }
        });
        this.refreshTools();
    }

    protected void setupToolsDetails(ToolBar toolbar_p) {
        this.createToolNavigationNext(toolbar_p);
        this.createToolNavigationPrevious(toolbar_p);
    }

    protected void setupToolsDetailsSide(ToolBar toolbar_p, boolean onLeft_p) {
        this.createToolMerge(toolbar_p, !onLeft_p);
        this.createToolIgnore(toolbar_p, onLeft_p);
        this.createToolDelete(toolbar_p, onLeft_p);
    }

    protected void setupToolsSynthesis(ToolBar toolbar_p) {
        new ToolItem(toolbar_p, 2);
        this.createToolInconsistency(toolbar_p);
        this.createToolExpand(toolbar_p);
        this.createToolCollapse(toolbar_p);
        this.createToolSort(toolbar_p);
        this.createToolSync(toolbar_p);
        new ToolItem(toolbar_p, 2);
    }

    protected void setupToolsSynthesisSide(ToolBar toolbar_p, boolean onLeft_p) {
        this.createToolLock(toolbar_p, onLeft_p);
    }

    protected boolean showMergeImpact(Collection<IDifference> toMerge_p, boolean toLeft_p, EMFDiffNode input_p) {
        boolean result = true;
        final MergeImpactViewer.ImpactInput mergeInput = new MergeImpactViewer.ImpactInput(toMerge_p, toLeft_p, input_p);
        IProgressService progress = PlatformUI.getWorkbench().getProgressService();
        try {
            progress.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                    mergeInput.compute(monitor_p);
                }
            });
            MergeImpactMessageDialog dialog = new MergeImpactMessageDialog(this.getShell(), mergeInput, this.getResourceManager(), ((ComparisonTreeViewer)((Object)this._synthesisModelTreeViewer.getInnerViewer())).getLabelProvider());
            result = dialog.openAndConfirm();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected void undoRedoPerformed(boolean undo_p) {
        super.undoRedoPerformed(undo_p);
        this.firePropertyChangeEvent(PROPERTY_DIFFERENCE_NUMBERS, null);
    }

    protected class ComparisonSideSelectionListener
    extends SelectionAdapter {
        private final boolean _sideIsLeft;

        public ComparisonSideSelectionListener(boolean sideIsLeft_p) {
            this._sideIsLeft = sideIsLeft_p;
        }

        public void widgetSelected(SelectionEvent event_p) {
            EnhancedComparisonSideViewer modelViewer;
            ITreeSelection selection;
            if (ComparisonViewer.this._isLeftRightSynced && !(selection = (modelViewer = this._sideIsLeft ? ComparisonViewer.this._leftModelTreeViewer : ComparisonViewer.this._rightModelTreeViewer).getSelection()).isEmpty()) {
                ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(selection.toList(), ComparisonViewer.this.getInput().getRoleForSide(this._sideIsLeft)), true);
            }
        }
    }

    protected class ValuesSelectionListener
    extends SelectionAdapter {
        private final boolean _sideIsLeft;

        public ValuesSelectionListener(boolean sideIsLeft_p) {
            this._sideIsLeft = sideIsLeft_p;
        }

        public void widgetSelected(SelectionEvent event_p) {
            EnhancedValuesViewer valuesViewer = this._sideIsLeft ? ComparisonViewer.this._leftValuesViewer : ComparisonViewer.this._rightValuesViewer;
            IStructuredSelection selection = valuesViewer.getSelection();
            if (!selection.isEmpty() && selection.getFirstElement() instanceof EObject) {
                ComparisonViewer.this.setSelection((ISelection)new ComparisonSelectionImpl(selection.toList(), ComparisonViewer.this.getInput().getRoleForSide(this._sideIsLeft)), true);
            }
        }
    }
}

