/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.resource;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xcore.XDataType;
import org.eclipse.emf.ecore.xcore.XModelElement;
import org.eclipse.emf.ecore.xcore.XNamedElement;
import org.eclipse.emf.ecore.xcore.XOperation;
import org.eclipse.emf.ecore.xcore.XPackage;
import org.eclipse.emf.ecore.xcore.XStructuralFeature;
import org.eclipse.emf.ecore.xcore.XcorePackage;
import org.eclipse.emf.ecore.xcore.mappings.ToXcoreMapping;
import org.eclipse.emf.ecore.xcore.mappings.XDataTypeMapping;
import org.eclipse.emf.ecore.xcore.mappings.XFeatureMapping;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.emf.ecore.xcore.util.XcoreEcoreBuilder;
import org.eclipse.emf.ecore.xcore.util.XcoreGenModelBuilder;
import org.eclipse.emf.ecore.xcore.util.XcoreGenModelInitializer;
import org.eclipse.emf.ecore.xcore.util.XcoreJvmInferrer;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IDerivedStateComputer;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class XcoreModelAssociator
implements IJvmModelAssociations,
ILogicalContainerProvider,
IDerivedStateComputer {
    @Inject
    private OnChangeEvictingCache cache;
    @Inject
    protected XcoreJvmInferrer jvmInferrer;
    @Inject
    protected XcoreGenModelBuilder genModelBuilder;
    @Inject
    private Provider<XcoreEcoreBuilder> xcoreEcoreBuilderProvider;
    @Inject
    protected XcoreMapper mapper;
    @Inject
    private IReferableElementsUnloader unloader;
    @Inject
    protected XcoreGenModelInitializer genModelInitializer;

    public void installDerivedState(DerivedStateAwareResource resource, boolean preLinkingPhase) {
        if (resource.getParseResult() != null && resource.getParseResult().getRootASTElement() instanceof XPackage) {
            XPackage model = (XPackage)resource.getParseResult().getRootASTElement();
            final XcoreEcoreBuilder xcoreEcoreBuilder = (XcoreEcoreBuilder)this.xcoreEcoreBuilderProvider.get();
            EPackage ePackage = xcoreEcoreBuilder.getEPackage(model);
            resource.getContents().add((Object)ePackage);
            final GenModel genModel = this.genModelBuilder.getGenModel(model);
            genModel.setCanGenerate(true);
            Collection<? extends Runnable> runnables = this.genModelInitializer.initialize(genModel, true);
            if (!preLinkingPhase) {
                this.cache.execWithoutCacheClear((Resource)resource, (IUnitOfWork)new IUnitOfWork.Void<Resource>(){

                    public void process(Resource state) throws Exception {
                        xcoreEcoreBuilder.link();
                    }
                });
                this.genModelBuilder.initializeUsedGenPackages(genModel);
                for (Runnable runnable : runnables) {
                    runnable.run();
                }
                if (genModel.hasEditSupport()) {
                    for (GenPackage genPackage : genModel.getUsedGenPackages()) {
                        if (!"http://www.eclipse.org/emf/2002/Ecore".equals(genPackage.getNSURI())) continue;
                        boolean needsEcoreEditSupport = false;
                        EPackage ecorePackage = genPackage.getEcorePackage();
                        block2: for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                            if (!(eClassifier instanceof EClass)) continue;
                            EClass eClass = (EClass)eClassifier;
                            for (EClass eSuperType : eClass.getEAllSuperTypes()) {
                                if (eSuperType.getEPackage() != ecorePackage || "EObject".equals(eSuperType.getName())) continue;
                                needsEcoreEditSupport = true;
                                break block2;
                            }
                            for (EReference eReference : eClass.getEAllReferences()) {
                                EClass eReferenceType = eReference.getEReferenceType();
                                if (eReferenceType == null || eReferenceType.getEPackage() != ecorePackage || "EObject".equals(eReferenceType.getName())) continue;
                                needsEcoreEditSupport = true;
                                break block2;
                            }
                        }
                        GenModel ecoreGenModel = genPackage.getGenModel();
                        ecoreGenModel.eSetDeliver(false);
                        ecoreGenModel.setEditDirectory(needsEcoreEditSupport ? "/org.eclipse.emf.edit.ecore/src" : "");
                        ecoreGenModel.eSetDeliver(true);
                        break;
                    }
                }
            }
            resource.getContents().addAll(this.jvmInferrer.inferElements(genModel));
            if (!preLinkingPhase) {
                this.cache.execWithoutCacheClear((Resource)resource, (IUnitOfWork)new IUnitOfWork.Void<Resource>(){

                    public void process(Resource state) throws Exception {
                        xcoreEcoreBuilder.linkInstanceTypes();
                        XcoreModelAssociator.this.jvmInferrer.inferDeepStructure(genModel);
                    }
                });
            }
            resource.getCache().clear((Resource)resource);
        }
    }

    public void discardDerivedState(DerivedStateAwareResource resource) {
        EList contents = resource.getContents();
        int size = contents.size();
        if (size > 1) {
            ArrayList toBeRemoved = Lists.newArrayList();
            for (EObject eObject : contents) {
                if (eObject instanceof XPackage) {
                    this.mapper.unsetMapping((XPackage)eObject);
                    continue;
                }
                this.unloader.unloadRoot(eObject);
                toBeRemoved.add(eObject);
            }
            contents.removeAll((Collection)toBeRemoved);
        }
    }

    public XExpression getAssociatedExpression(JvmIdentifiableElement element) {
        ToXcoreMapping mapping = this.mapper.getToXcoreMapping((EObject)element);
        XNamedElement xcoreElement = mapping.getXcoreElement();
        if (xcoreElement instanceof XOperation) {
            XOperation xOperation = (XOperation)xcoreElement;
            if (element == this.mapper.getMapping(xOperation).getJvmOperation()) {
                return xOperation.getBody();
            }
        } else if (xcoreElement instanceof XDataType) {
            XDataType xDataType = (XDataType)xcoreElement;
            XDataTypeMapping typeMapping = this.mapper.getMapping(xDataType);
            if (element == typeMapping.getConverter()) {
                return xDataType.getConvertBody();
            }
            if (element == typeMapping.getCreator()) {
                return xDataType.getCreateBody();
            }
        } else if (xcoreElement instanceof XStructuralFeature) {
            XStructuralFeature feature = (XStructuralFeature)xcoreElement;
            XFeatureMapping featureMapping = this.mapper.getMapping(feature);
            if (element == featureMapping.getGetter()) {
                return feature.getGetBody();
            }
            if (element == featureMapping.getSetter()) {
                return feature.getSetBody();
            }
            if (element == featureMapping.getIsSetter()) {
                return feature.getIsSetBody();
            }
            if (element == featureMapping.getUnsetter()) {
                return feature.getUnsetBody();
            }
        }
        return null;
    }

    public Set<EObject> getJvmElements(EObject eObject) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        if (eObject instanceof XNamedElement) {
            GenBase genBase = this.mapper.getGen((XNamedElement)eObject);
            if (genBase != null) {
                result.addAll(XcoreJvmInferrer.getInferredElements(genBase));
            }
        } else if (eObject instanceof GenBase) {
            result.addAll(XcoreJvmInferrer.getInferredElements((GenBase)eObject));
        } else if (eObject.eClass().getEPackage() == TypesPackage.eINSTANCE) {
            result.add(eObject);
        }
        return result;
    }

    public Set<EObject> getSourceElements(EObject eObject) {
        EObject xcoreElement = this.mapper.getXcoreElement(eObject);
        return xcoreElement == null || xcoreElement == eObject ? Collections.emptySet() : Collections.singleton(eObject);
    }

    public EObject getPrimarySourceElement(EObject eObject) {
        EObject xcoreElement = this.mapper.getXcoreElement(eObject);
        return xcoreElement;
    }

    public JvmIdentifiableElement getLogicalContainer(XExpression xExpression) {
        if (xExpression instanceof XBlockExpression) {
            EObject eContainer = xExpression.eContainer();
            EReference eContainmentFeature = xExpression.eContainmentFeature();
            if (eContainmentFeature == XcorePackage.Literals.XOPERATION__BODY) {
                return this.mapper.getMapping((XOperation)eContainer).getJvmOperation();
            }
            if (eContainmentFeature == XcorePackage.Literals.XDATA_TYPE__CREATE_BODY) {
                return this.mapper.getMapping((XDataType)eContainer).getCreator();
            }
            if (eContainmentFeature == XcorePackage.Literals.XDATA_TYPE__CONVERT_BODY) {
                return this.mapper.getMapping((XDataType)eContainer).getConverter();
            }
            if (eContainmentFeature == XcorePackage.Literals.XSTRUCTURAL_FEATURE__GET_BODY) {
                return this.mapper.getMapping((XStructuralFeature)eContainer).getGetter();
            }
            if (eContainmentFeature == XcorePackage.Literals.XSTRUCTURAL_FEATURE__SET_BODY) {
                return this.mapper.getMapping((XStructuralFeature)eContainer).getSetter();
            }
            if (eContainmentFeature == XcorePackage.Literals.XSTRUCTURAL_FEATURE__IS_SET_BODY) {
                return this.mapper.getMapping((XStructuralFeature)eContainer).getIsSetter();
            }
            if (eContainmentFeature == XcorePackage.Literals.XSTRUCTURAL_FEATURE__UNSET_BODY) {
                return this.mapper.getMapping((XStructuralFeature)eContainer).getUnsetter();
            }
            return null;
        }
        return null;
    }

    public JvmIdentifiableElement getNearestLogicalContainer(EObject eObject) {
        EObject eContainer = eObject;
        while (eContainer != null) {
            if (eContainer instanceof XExpression && eContainer.eContainer() instanceof XModelElement) {
                return this.getLogicalContainer((XExpression)eContainer);
            }
            eContainer = eContainer.eContainer();
        }
        return null;
    }

    public EObject getPrimaryJvmElement(EObject sourceElement) {
        return (EObject)Iterables.getFirst(this.getJvmElements(sourceElement), null);
    }

    public boolean isPrimaryJvmElement(EObject jvmElement) {
        return this.getPrimaryJvmElement(this.getPrimarySourceElement(jvmElement)) == jvmElement;
    }
}

