/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.scoping.types;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xcore.scoping.types.AbstractXcoreScope;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScope;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeScopeWithWildcardImports
extends AbstractXcoreScope {
    private final ImportNormalizer[][] imports;
    private final AbstractTypeScope typeScope;
    private final AbstractXcoreScope parent;

    public TypeScopeWithWildcardImports(ImportNormalizer[][] imports, AbstractTypeScope typeScope) {
        this.imports = imports;
        this.typeScope = typeScope;
        this.parent = null;
    }

    public TypeScopeWithWildcardImports(List<ImportNormalizer> imports, AbstractTypeScope typeScope, AbstractXcoreScope parent) {
        this.imports = new ImportNormalizer[][]{imports.toArray(new ImportNormalizer[imports.size()])};
        this.typeScope = typeScope;
        this.parent = parent;
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        int i = 0;
        while (i < this.imports.length) {
            ImportNormalizer[] chunk = this.imports[i];
            IEObjectDescription result = null;
            int j = 0;
            while (j < chunk.length) {
                IEObjectDescription candidate;
                ImportNormalizer normalizer = chunk[j];
                QualifiedName resolvedName = normalizer.resolve(name);
                if (resolvedName != null && (candidate = this.typeScope.getSingleElement(resolvedName, true)) != null) {
                    if (result == null) {
                        result = candidate;
                    } else {
                        return null;
                    }
                }
                ++j;
            }
            if (result != null) {
                return result;
            }
            ++i;
        }
        return this.getSingleElementFromParent(name);
    }

    protected IEObjectDescription getSingleElementFromParent(QualifiedName name) {
        return this.parent != null ? this.parent.getSingleElement(name) : this.typeScope.getSingleElement(name);
    }

    @Override
    protected void doGetElements(JvmType type, List<IEObjectDescription> result) {
        if (type instanceof JvmDeclaredType) {
            JvmDeclaredType declaredType = (JvmDeclaredType)type;
            String packageName = declaredType.getPackageName();
            if (!Strings.isEmpty((String)packageName)) {
                int packageNameEnd = packageName.length() + 1;
                QualifiedName qualifiedPackageName = QualifiedName.create((List)Strings.split((String)packageName, (char)'.'));
                int qualifiedPackageNameSegmentCount = qualifiedPackageName.getSegmentCount();
                QualifiedName withDot = null;
                String withDollar = null;
                int i = 0;
                while (i < this.imports.length) {
                    ImportNormalizer[] chunk = this.imports[i];
                    int j = 0;
                    while (j < chunk.length) {
                        ImportNormalizer normalizer = chunk[j];
                        QualifiedName namespacePrefix = normalizer.getImportedNamespacePrefix();
                        if (namespacePrefix.equals((Object)qualifiedPackageName)) {
                            if (withDot == null) {
                                withDot = QualifiedName.create((List)Strings.split((String)type.getQualifiedName('.'), (char)'.'));
                                withDollar = type.eContainer() instanceof JvmType ? type.getQualifiedName('$').substring(packageNameEnd) : null;
                            }
                            result.add(EObjectDescription.create((QualifiedName)withDot.skipFirst(qualifiedPackageNameSegmentCount), (EObject)type));
                            if (withDollar != null) {
                                result.add(EObjectDescription.create(withDollar, (EObject)type));
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (this.parent != null) {
                this.parent.doGetElements(type, result);
            } else {
                Iterables.addAll(result, (Iterable)this.typeScope.getElements((EObject)type));
            }
        }
    }
}

