/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.scoping.types;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xcore.XImportDirective;
import org.eclipse.emf.ecore.xcore.XPackage;
import org.eclipse.emf.ecore.xcore.scoping.types.AbstractXcoreScope;
import org.eclipse.emf.ecore.xcore.scoping.types.CachingTypeScope;
import org.eclipse.emf.ecore.xcore.scoping.types.KnownTypesScope;
import org.eclipse.emf.ecore.xcore.scoping.types.PrimitiveAwareScope;
import org.eclipse.emf.ecore.xcore.scoping.types.TypeScopeWithWildcardImports;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScope;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScopeProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.scoping.AbstractNestedTypeAwareImportNormalizer;
import org.eclipse.xtext.xbase.scoping.XImportSectionNamespaceScopeProvider;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcoreJvmTypeScopeProvider
extends XImportSectionNamespaceScopeProvider {
    private static final ImportNormalizer JAVA_LANG_IMPORT_NORMALIZER = AbstractNestedTypeAwareImportNormalizer.createNestedTypeAwareImportNormalizer((QualifiedName)JAVA_LANG, (boolean)true, (boolean)false);
    @Inject
    private IResourceScopeCache cache;
    @Inject
    private AbstractTypeScopeProvider typeScopeProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IImportsConfiguration importsConfiguration;

    public IScope getScope(final EObject context, EReference reference) {
        if (context instanceof XImportDirective) {
            return (IScope)this.cache.get((Object)"import.type.scope", context.eResource(), (Provider)new Provider<IScope>(){

                public IScope get() {
                    Resource resource = context.eResource();
                    IJvmTypeProvider typeProvider = XcoreJvmTypeScopeProvider.this.typeScopeProvider.getTypeProvider(resource.getResourceSet());
                    return XcoreJvmTypeScopeProvider.this.typeScopeProvider.createTypeScope(typeProvider, null);
                }
            });
        }
        final XPackage xPackage = (XPackage)context;
        return (IScope)this.cache.get((Object)"type.scope", context.eResource(), (Provider)new Provider<IScope>(){

            public IScope get() {
                IJvmTypeProvider typeProvider = XcoreJvmTypeScopeProvider.this.typeScopeProvider.getTypeProvider(xPackage.eResource().getResourceSet());
                AbstractTypeScope typeScope = XcoreJvmTypeScopeProvider.this.typeScopeProvider.createTypeScope(typeProvider, null);
                AbstractXcoreScope rootTypeScope = XcoreJvmTypeScopeProvider.this.getRootTypeScope(xPackage, typeScope);
                AbstractXcoreScope importScope = XcoreJvmTypeScopeProvider.this.getImportScope(xPackage, rootTypeScope, typeScope);
                AbstractXcoreScope localTypes = XcoreJvmTypeScopeProvider.this.getResourceTypeScope(xPackage.eResource(), xPackage.getName(), importScope);
                PrimitiveAwareScope primitiveAware = new PrimitiveAwareScope(localTypes, typeScope);
                CachingTypeScope caching = new CachingTypeScope(primitiveAware);
                return caching;
            }
        });
    }

    protected AbstractXcoreScope getRootTypeScope(XPackage rootContainer, AbstractTypeScope typeScope) {
        ImportNormalizer[][] implicitImports;
        String packageName = rootContainer.getName();
        ImportNormalizer[] alwaysImported = new ImportNormalizer[]{JAVA_LANG_IMPORT_NORMALIZER};
        if (Strings.isEmpty((String)packageName)) {
            implicitImports = new ImportNormalizer[][]{alwaysImported};
        } else {
            QualifiedName packageQualifiedName = this.qualifiedNameConverter.toQualifiedName(packageName);
            implicitImports = new ImportNormalizer[][]{{AbstractNestedTypeAwareImportNormalizer.createNestedTypeAwareImportNormalizer((QualifiedName)packageQualifiedName, (boolean)true, (boolean)false)}, alwaysImported};
        }
        return new TypeScopeWithWildcardImports(implicitImports, typeScope);
    }

    private AbstractXcoreScope getImportScope(XPackage xPackage, AbstractXcoreScope parent, AbstractTypeScope typeScope) {
        XImportSection importSection = this.importsConfiguration.getImportSection((XtextResource)xPackage.eResource());
        EList importDeclarations = importSection.getImportDeclarations();
        if (importDeclarations.isEmpty()) {
            return parent;
        }
        ArrayList wildcardImports = Lists.newArrayList();
        ArrayList concreteImports = Lists.newArrayList();
        for (XImportDeclaration importDeclaration : importDeclarations) {
            if (importDeclaration.getImportedNamespace().endsWith(this.getWildcard())) {
                String importedNamespace = importDeclaration.getImportedNamespace();
                importedNamespace = importedNamespace.substring(0, importedNamespace.length() - 2);
                QualifiedName qualifiedImportedNamespace = this.qualifiedNameConverter.toQualifiedName(importedNamespace);
                wildcardImports.add(AbstractNestedTypeAwareImportNormalizer.createNestedTypeAwareImportNormalizer((QualifiedName)qualifiedImportedNamespace, (boolean)true, (boolean)false));
                continue;
            }
            JvmDeclaredType importedType = importDeclaration.getImportedType();
            if (importedType == null || importedType.eIsProxy()) continue;
            concreteImports.add(importedType);
        }
        return this.getImportScope(wildcardImports, concreteImports, parent, typeScope);
    }

    private AbstractXcoreScope getImportScope(List<ImportNormalizer> wildcardImports, List<JvmType> concreteImports, AbstractXcoreScope parent, AbstractTypeScope typeScope) {
        AbstractXcoreScope result = parent;
        if (!wildcardImports.isEmpty()) {
            result = new TypeScopeWithWildcardImports(wildcardImports, typeScope, result);
        }
        if (!concreteImports.isEmpty()) {
            result = new KnownTypesScope(concreteImports, result);
        }
        return result;
    }

    private AbstractXcoreScope getResourceTypeScope(Resource resource, String packageName, AbstractXcoreScope parent) {
        ArrayList knownTypes = Lists.newArrayList((Iterable)this.importsConfiguration.getLocallyDefinedTypes((XtextResource)resource));
        return knownTypes.isEmpty() ? parent : new KnownTypesScope(knownTypes, parent);
    }
}

